/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl;

import com.solacesystems.common.util.DestinationUtil;
import com.solacesystems.jcsmp.Browser;
import com.solacesystems.jcsmp.BrowserProperties;
import com.solacesystems.jcsmp.CacheSession;
import com.solacesystems.jcsmp.CacheSessionProperties;
import com.solacesystems.jcsmp.CapabilityType;
import com.solacesystems.jcsmp.ClientName;
import com.solacesystems.jcsmp.ClosedFacilityException;
import com.solacesystems.jcsmp.Consumer;
import com.solacesystems.jcsmp.ConsumerFlowProperties;
import com.solacesystems.jcsmp.Destination;
import com.solacesystems.jcsmp.DestinationConsumer;
import com.solacesystems.jcsmp.DestinationListener;
import com.solacesystems.jcsmp.DestinationProducer;
import com.solacesystems.jcsmp.DestinationSubscriptionStateProvider;
import com.solacesystems.jcsmp.DurableTopicEndpoint;
import com.solacesystems.jcsmp.Endpoint;
import com.solacesystems.jcsmp.EndpointProperties;
import com.solacesystems.jcsmp.FlowEventHandler;
import com.solacesystems.jcsmp.FlowReceiver;
import com.solacesystems.jcsmp.InvalidOperationException;
import com.solacesystems.jcsmp.InvalidPropertiesException;
import com.solacesystems.jcsmp.JCSMPChannelProperties;
import com.solacesystems.jcsmp.JCSMPDestinationSession;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPLogLevel;
import com.solacesystems.jcsmp.JCSMPProducerEventHandler;
import com.solacesystems.jcsmp.JCSMPProperties;
import com.solacesystems.jcsmp.JCSMPReconnectEventHandler;
import com.solacesystems.jcsmp.JCSMPSession;
import com.solacesystems.jcsmp.JCSMPSessionStats;
import com.solacesystems.jcsmp.JCSMPStreamingPublishEventHandler;
import com.solacesystems.jcsmp.JndiMessage;
import com.solacesystems.jcsmp.ProducerFlowProperties;
import com.solacesystems.jcsmp.Queue;
import com.solacesystems.jcsmp.Requestor;
import com.solacesystems.jcsmp.SessionEventArgs;
import com.solacesystems.jcsmp.SessionEventHandler;
import com.solacesystems.jcsmp.Subscription;
import com.solacesystems.jcsmp.SubscriptionStateProvider;
import com.solacesystems.jcsmp.Topic;
import com.solacesystems.jcsmp.TopicEndpoint;
import com.solacesystems.jcsmp.XMLMessageConsumer;
import com.solacesystems.jcsmp.XMLMessageListener;
import com.solacesystems.jcsmp.XMLMessageProducer;
import com.solacesystems.jcsmp.i18n.JCSMPRB;
import com.solacesystems.jcsmp.impl.BrowserImpl;
import com.solacesystems.jcsmp.impl.ContextBlockingOpCheck;
import com.solacesystems.jcsmp.impl.ContextImpl;
import com.solacesystems.jcsmp.impl.JCSMPGenericXMLMessage;
import com.solacesystems.jcsmp.impl.JCSMPXMLMessageConsumer;
import com.solacesystems.jcsmp.impl.JCSMPXMLMessageProducer;
import com.solacesystems.jcsmp.impl.LogLevelAdapter;
import com.solacesystems.jcsmp.impl.NonDurableTopicEndpointImpl;
import com.solacesystems.jcsmp.impl.PubADManager;
import com.solacesystems.jcsmp.impl.QueueImpl;
import com.solacesystems.jcsmp.impl.SessionModeSupport;
import com.solacesystems.jcsmp.impl.SessionModeSupportClient;
import com.solacesystems.jcsmp.impl.SessionSubscriptionEvent;
import com.solacesystems.jcsmp.impl.SessionSubscriptionEventListener;
import com.solacesystems.jcsmp.impl.SubscriptionCache;
import com.solacesystems.jcsmp.impl.TargetRouterMode;
import com.solacesystems.jcsmp.impl.TopicImpl;
import com.solacesystems.jcsmp.impl.client.ClientInfoProvider;
import com.solacesystems.jcsmp.impl.client.ClientInfoUtil;
import com.solacesystems.jcsmp.impl.flow.PubFlowManager;
import com.solacesystems.jcsmp.impl.flow.SubFlowManagerImpl;
import com.solacesystems.jcsmp.impl.solcache.CacheSessionImpl;
import com.solacesystems.jcsmp.impl.transaction.BaseTransactedSessionImpl;
import com.solacesystems.jcsmp.impl.transaction.TransactedSessionManager;
import com.solacesystems.jcsmp.impl.transaction.xa.XASessionManager;
import com.solacesystems.jcsmp.management.SolJmxSupport;
import com.solacesystems.jcsmp.protocol.CSMPControllerChannel;
import com.solacesystems.jcsmp.protocol.CSMPPublisherChannel;
import com.solacesystems.jcsmp.protocol.CSMPSubscriberChannel;
import com.solacesystems.jcsmp.protocol.impl.TcpClientChannel;
import com.solacesystems.jcsmp.protocol.nio.impl.ConsumerNotificationDispatcherFactory;
import com.solacesystems.jcsmp.protocol.smf.impl.AssuredCtrlFactory;
import com.solacesystems.jcsmp.secure.SecureProperties;
import com.solacesystems.jcsmp.transaction.TransactedSession;
import com.solacesystems.jcsmp.transaction.xa.XASession;
import com.solacesystems.jcsmpx.impl.MessageListenerAdapter;
import com.solacesystems.jcsmpx.impl.TopicConsumerImpl;
import com.solacesystems.jcsmpx.impl.TopicProducerImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCSMPBasicSession
implements JCSMPSession,
JCSMPDestinationSession,
SessionSubscriptionEventListener {
    private static final Log Trace = LogFactory.getLog(JCSMPBasicSession.class);
    private static AtomicInteger _global_session_counter = new AtomicInteger(0);
    private String sessionID;
    private String sessionName;
    private String username;
    private String routerHost;
    private CSMPControllerChannel controlChannel;
    private CSMPPublisherChannel publisherChannel;
    private CSMPSubscriberChannel subscriberChannel;
    private TcpClientChannel clientChannel;
    private SubFlowManagerImpl flowMgr;
    private TransactedSessionManager txsessionMgr = null;
    private XASessionManager xasessionMgr = null;
    private JCSMPSessionStats sessionStats;
    private JCSMPProperties props;
    private SecureProperties secureProps;
    private String messageAckMode;
    private boolean isClosed;
    private volatile SessionModeSupport sessionModeSup;
    private TargetRouterMode routerMode;
    protected PubFlowManager pubFlowManager;
    protected ContextImpl context;
    protected final int sessionCounterId;
    protected final SessionEventHandler appSessionEventHandler;
    protected final Object appSessionEventHandlerLock;
    protected SubscriptionCache subscriptionCache;
    protected SessionSubscriptionEventListener subscriptionEventListener;
    private boolean rtr_sniffed = false;
    protected EnumMap<TransientData, Object> transientData = new EnumMap(TransientData.class);
    protected ClientInfoProvider clientInfoProvider;
    private volatile String p2pTopicDescriptionBase;
    private final ContextBlockingOpCheck contextOpCheck;
    private volatile AssuredCtrlFactory assuredCtrlFactory;
    private final int sdkMinSupportedXAVersion = 1;
    private final int sdkMaxSupportedXAVersion = 1;
    private int negotiatedMinXAVersion = 0;
    private int negotiatedMaxXAVersion = 0;
    private final int sdkMinSupportedADCtrlVersion = 1;
    private final int sdkMaxSupportedADCtrlVersion = 3;
    private int negotiatedMinADCtrlVersion = 0;
    private int negotiatedMaxADCtrlVersion = 0;

    public JCSMPBasicSession(JCSMPProperties properties, SecureProperties secureProps, ContextImpl parentCtx, SessionEventHandler eventHandler) {
        this.context = parentCtx;
        this.context.addSession(this);
        this.contextOpCheck = new ContextBlockingOpCheck(parentCtx, properties);
        this.appSessionEventHandler = eventHandler;
        this.appSessionEventHandlerLock = new Object();
        this.props = (JCSMPProperties)properties.clone();
        if (Trace.isDebugEnabled()) {
            Trace.debug((Object)this.props);
        }
        this.secureProps = secureProps;
        JCSMPBasicSession.initChannelProperties(this.props);
        this.isClosed = false;
        this.sessionName = this.props.getStringProperty("session_name");
        this.username = this.props.getStringProperty("username");
        this.routerHost = this.props.getStringProperty("host");
        if (this.sessionName == null || this.sessionName.trim().length() == 0) {
            this.sessionName = "JCSMPSession";
        }
        this.sessionID = this.sessionName + "[" + this.username + "@" + this.routerHost + "] " + String.format("(%04x)", _global_session_counter.incrementAndGet());
        this.sessionStats = new JCSMPSessionStats(this);
        this.messageAckMode = this.props.getStringProperty("message_ack_mode");
        this.sessionCounterId = ClientInfoUtil.onlyInstance().getGlobalSessionCounter().incrementAndGet();
        this.pubFlowManager = new PubFlowManager(this);
        this.flowMgr = new SubFlowManagerImpl(this);
        this.txsessionMgr = new TransactedSessionManager(this, this.context);
        String connectionType = (String)this.props.getProperty("connection_type");
        if (connectionType != null && connectionType.equals("CONNECTION_TYPE_XA")) {
            this.xasessionMgr = new XASessionManager(this, this.context);
        }
        this.clientInfoProvider = this.props.getProperty("client_info_provider") instanceof ClientInfoProvider ? (ClientInfoProvider)this.props.getProperty("client_info_provider") : new ClientInfoProvider();
        String clientName = this.props.getStringProperty("client_name");
        if (clientName == null || "".equals(clientName)) {
            clientName = ClientInfoUtil.constructClientName(String.format("%04x%04x", this.context.getIOReactor().getServiceThreadId(), this.sessionCounterId), this.clientInfoProvider.getHostname(), this.clientInfoProvider.getPid());
            this.props.setProperty("client_name", clientName);
        }
        if (this.props.getBooleanProperty("reapply_subscriptions").booleanValue()) {
            this.subscriptionCache = new SubscriptionCache();
        }
        this.p2pTopicDescriptionBase = (String)this.getProperty("P2PTOPICDESCRIPTION");
        this.assuredCtrlFactory = new AssuredCtrlFactory(2);
        SolJmxSupport.instance().register(this);
        if (Trace.isDebugEnabled()) {
            Trace.debug((Object)(this.sessionID + "created"));
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        SolJmxSupport.instance().deregister(this);
    }

    private static void initChannelProperties(JCSMPProperties properties) {
        JCSMPChannelProperties clientChProperties = (JCSMPChannelProperties)properties.getProperty("client_channel");
        JCSMPChannelProperties defaultChProperties = new JCSMPChannelProperties();
        if (clientChProperties != null && !clientChProperties.equals(defaultChProperties)) {
            for (String k : new String[]{"control_channel", "publisher_data_channel", "subscriber_data_channel"}) {
                properties.setProperty(k, clientChProperties.clone());
            }
        }
    }

    private void createChannelsTrb() {
        JCSMPChannelProperties channelProperties = (JCSMPChannelProperties)this.props.getProperty("client_channel");
        if (channelProperties != null) {
            this.clientChannel = new TcpClientChannel(this.props, this.secureProps, this.sessionStats, this.sessionID, this, this.context, TcpClientChannel.ChannelMode.CLIENT);
            this.pubFlowManager.setChannel(this.clientChannel);
            this.flowMgr.setSubChannel(this.clientChannel);
            this.txsessionMgr.setSubChannel(this.clientChannel);
            if (this.xasessionMgr != null) {
                this.xasessionMgr.setSubChannel(this.clientChannel);
            }
        }
    }

    private synchronized void sniffRouter() throws JCSMPException {
        this.checkClosed();
        this.contextOpCheck.check();
        if (this.rtr_sniffed) {
            return;
        }
        this.createChannelsTrb();
        this.clientChannel.open(false);
        this.sessionModeSup = new SessionModeSupportClient(null, null, null, this.clientChannel, this.flowMgr, this);
        this.routerMode = TargetRouterMode.TRB;
        this.getADCtrlVersion();
        String connectionType = this.props.getStringProperty("connection_type");
        if (connectionType != null && connectionType.equals("CONNECTION_TYPE_XA")) {
            this.checkXAVersion();
        }
        if (this.props.getBooleanProperty("reapply_subscriptions").booleanValue()) {
            this.subscriptionEventListener = this.sessionModeSup;
        }
        this.rtr_sniffed = true;
    }

    public int getNegotiatedMinXAVersion() {
        return this.negotiatedMinXAVersion;
    }

    public void notifyVridChange() {
        if (this.txsessionMgr != null) {
            this.txsessionMgr.notifyVridChange();
        }
        if (this.xasessionMgr != null) {
            this.xasessionMgr.notifyVridChange();
        }
        if (this.flowMgr != null) {
            this.flowMgr.notifyVridChange();
        }
    }

    public int getNegotiatedMaxXAVersion() {
        return this.negotiatedMaxXAVersion;
    }

    public PubFlowManager getPubFlowManager() {
        return this.pubFlowManager;
    }

    public void xaSessionMessageIdRenumbering(PubADManager adMgr) {
        if (this.xasessionMgr != null) {
            this.xasessionMgr.messageIdRenumbering(adMgr);
        }
    }

    private void checkXAVersion() throws InvalidOperationException {
        int rtrMinSupportedXAVersion = 0;
        int rtrMaxSupportedXAVersion = 0;
        Map caps = (Map)this.transientData.get((Object)TransientData.CAP);
        ArrayList rtrSupportedXAVersions = (ArrayList)caps.get((Object)CapabilityType.SUPPORTED_XACTRL_VERSIONS);
        if (rtrSupportedXAVersions != null) {
            rtrMinSupportedXAVersion = (Integer)rtrSupportedXAVersions.get(0);
            rtrMaxSupportedXAVersion = (Integer)rtrSupportedXAVersions.get(1);
        }
        if (rtrMinSupportedXAVersion > 1 || rtrMaxSupportedXAVersion < 1) {
            StringBuilder bldr = new StringBuilder(String.format("Error creating XA connection: appliance supported protocol version range [%d,%d] outside supported range of [%d,%d]", rtrMinSupportedXAVersion, rtrMaxSupportedXAVersion, 1, 1));
            String message = bldr.toString();
            InvalidOperationException ex = new InvalidOperationException(message);
            if (Trace.isErrorEnabled()) {
                Trace.error((Object)message);
            }
            throw ex;
        }
        this.negotiatedMinXAVersion = Math.max(1, rtrMinSupportedXAVersion);
        this.negotiatedMaxXAVersion = Math.min(1, rtrMaxSupportedXAVersion);
    }

    public int getNegotiatedMinADCtrlVersion() {
        return this.negotiatedMinADCtrlVersion;
    }

    public int getNegotiatedMaxADCtrlVersion() {
        return this.negotiatedMaxADCtrlVersion;
    }

    public String getGdReconnectFailAction() {
        return this.props.getStringProperty("gd_reconnect_fail_action");
    }

    private void getADCtrlVersion() throws InvalidOperationException {
        int rtrMinSupportedADCtrlVersion = 1;
        int rtrMaxSupportedADCtrlVersion = 2;
        Map caps = (Map)this.transientData.get((Object)TransientData.CAP);
        ArrayList rtrSupportedADCtrlVersions = (ArrayList)caps.get((Object)CapabilityType.SUPPORTED_ADCTRL_VERSIONS);
        if (rtrSupportedADCtrlVersions != null) {
            rtrMinSupportedADCtrlVersion = (Integer)rtrSupportedADCtrlVersions.get(0);
            rtrMaxSupportedADCtrlVersion = (Integer)rtrSupportedADCtrlVersions.get(1);
        }
        if (rtrMinSupportedADCtrlVersion > 3 || rtrMaxSupportedADCtrlVersion < 1) {
            StringBuilder bldr = new StringBuilder(String.format("Error negotiating AD Ctrl version: appliance supported protocol version range [%d,%d] outside supported range of [%d,%d]", rtrMinSupportedADCtrlVersion, rtrMaxSupportedADCtrlVersion, 1, 3));
            String message = bldr.toString();
            InvalidOperationException ex = new InvalidOperationException(message);
            if (Trace.isErrorEnabled()) {
                Trace.error((Object)message);
            }
            throw ex;
        }
        this.negotiatedMinADCtrlVersion = Math.max(1, rtrMinSupportedADCtrlVersion);
        this.negotiatedMaxADCtrlVersion = Math.min(3, rtrMaxSupportedADCtrlVersion);
        this.assuredCtrlFactory = new AssuredCtrlFactory(this.negotiatedMaxADCtrlVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getTransientData(TransientData key) {
        EnumMap<TransientData, Object> enumMap = this.transientData;
        synchronized (enumMap) {
            return this.transientData.get((Object)key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putTransientData(TransientData key, Object value, boolean noreplace) {
        EnumMap<TransientData, Object> enumMap = this.transientData;
        synchronized (enumMap) {
            if (this.transientData.containsKey((Object)key) && noreplace) {
                return;
            }
            this.transientData.put(key, value);
        }
    }

    public ContextImpl getContext() {
        return this.context;
    }

    @Override
    public String getSessionName() {
        return this.sessionName;
    }

    public TargetRouterMode getRouterMode() {
        return this.routerMode;
    }

    public static JCSMPGenericXMLMessage createGenericXMLMessage(int contentSize, boolean useDirectBuffers, boolean isPub) {
        return new JCSMPGenericXMLMessage(contentSize, useDirectBuffers, isPub);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void closeSession() {
        Object object = this.appSessionEventHandlerLock;
        synchronized (object) {
            this.isClosed = true;
            if (this.sessionModeSup != null) {
                JCSMPXMLMessageProducer producer = this.sessionModeSup.getProducer();
                JCSMPXMLMessageConsumer consumer = this.sessionModeSup.getConsumer();
                if (producer != null) {
                    producer.close();
                    producer = null;
                }
                if (consumer != null) {
                    consumer.close();
                    Object var3_3 = null;
                }
            }
            if (this.txsessionMgr != null) {
                this.txsessionMgr.close();
            }
            if (this.xasessionMgr != null) {
                this.xasessionMgr.close();
            }
            this.pubFlowManager.closeAllFlows(true);
            if (this.controlChannel != null) {
                this.controlChannel.close();
                this.controlChannel.cleanupBuffers();
                this.controlChannel = null;
            }
            if (this.publisherChannel != null) {
                this.publisherChannel.close();
                this.publisherChannel.cleanupBuffers();
                this.publisherChannel = null;
            }
            if (this.subscriberChannel != null) {
                this.subscriberChannel.close();
                this.subscriberChannel.cleanupBuffers();
                this.subscriberChannel = null;
                this.flowMgr.close();
            }
            if (this.clientChannel != null) {
                this.flowMgr.close();
                this.clientChannel.close();
                this.clientChannel.cleanupBuffers();
                this.clientChannel = null;
            }
            if (this.context != null) {
                this.context.removeSession(this);
                this.context = null;
            }
            if (this.sessionModeSup != null) {
                this.sessionModeSup.closeSession();
            }
        }
        if (Trace.isDebugEnabled()) {
            Trace.debug((Object)(this.sessionID + "closed"));
        }
        SolJmxSupport.instance().deregister(this);
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public JCSMPSessionStats getSessionStats() {
        return this.sessionStats;
    }

    @Override
    public void logSessionStats(JCSMPLogLevel level) {
        String logmessage = String.format("Stats for session [%s]\n %s\n", this.getSessionID(), this.getSessionStats().toString());
        LogLevelAdapter.log(level, Trace, logmessage);
    }

    @Override
    public void logFlowInfo(JCSMPLogLevel level) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Flow info for session [%s]\n", this.getSessionID()));
        if (this.flowMgr != null) {
            sb.append(this.flowMgr.getLogFlowInfoString());
        }
        LogLevelAdapter.log(level, Trace, sb.toString());
    }

    @Override
    @Deprecated
    public synchronized void addSubscriber() throws JCSMPException {
        this.sniffRouter();
        this.sessionModeSup.addSubscriber();
    }

    @Override
    @Deprecated
    public synchronized void removeSubscriber() throws JCSMPException {
        this.sniffRouter();
        this.clearSubscriber();
    }

    @Override
    public synchronized void clearSubscriber() throws JCSMPException {
        this.sniffRouter();
        this.sessionModeSup.clearSubscriber();
    }

    @Override
    public synchronized void deleteSubscriber() throws JCSMPException {
        this.sniffRouter();
        this.sessionModeSup.deleteSubscriber();
    }

    private boolean isStreamingCallback(JCSMPStreamingPublishEventHandler callback) {
        return callback != null;
    }

    @Override
    public synchronized XMLMessageProducer createProducer(ProducerFlowProperties fprop, JCSMPStreamingPublishEventHandler callback) throws JCSMPException {
        return this.createProducer(fprop, callback, null, null);
    }

    @Override
    public synchronized XMLMessageProducer createProducer(ProducerFlowProperties fprop, JCSMPStreamingPublishEventHandler callback, JCSMPProducerEventHandler eventCallback) throws JCSMPException {
        return this.createProducer(fprop, callback, eventCallback, null);
    }

    public synchronized XMLMessageProducer createProducer(ProducerFlowProperties fprop, JCSMPStreamingPublishEventHandler streamCallback, JCSMPProducerEventHandler eventCallback, InternalBindProperties internalBindProperties) throws JCSMPException {
        this.sniffRouter();
        if (!this.isStreamingCallback(streamCallback)) {
            throw new IllegalArgumentException(JCSMPRB.BUNDLE.getStringSafely("JCSMPBasicSession.callbackMandatory"));
        }
        if (this.sessionModeSup.getProducer() == null) {
            throw new InvalidOperationException(JCSMPRB.BUNDLE.getStringSafely("JCSMPBasicSession.defaultProducerNotCreated"));
        }
        if (!this.isCapable(CapabilityType.PUB_FLOW_GUARANTEED) || !this.isCapable(CapabilityType.PUB_GUARANTEED)) {
            throw new InvalidOperationException(JCSMPRB.BUNDLE.getStringSafely("JCSMPBasicSession.capabilityNoPubFlow"));
        }
        JCSMPXMLMessageProducer prodflow = this.pubFlowManager.createProducerFlow(streamCallback, eventCallback, fprop, internalBindProperties);
        return prodflow;
    }

    @Override
    public synchronized XMLMessageProducer getMessageProducer() throws JCSMPException {
        return this.getMessageProducer(null);
    }

    @Override
    public synchronized XMLMessageProducer getMessageProducer(JCSMPStreamingPublishEventHandler callback) throws JCSMPException {
        this.sniffRouter();
        return this.sessionModeSup.getMessageProducer(callback, null);
    }

    @Override
    public synchronized XMLMessageProducer getMessageProducer(JCSMPStreamingPublishEventHandler callback, JCSMPProducerEventHandler eventCallback) throws JCSMPException {
        this.sniffRouter();
        return this.sessionModeSup.getMessageProducer(callback, eventCallback);
    }

    @Override
    @Deprecated
    public synchronized XMLMessageConsumer getMessageConsumer() throws JCSMPException {
        return this.getMessageConsumer((XMLMessageListener)null);
    }

    @Override
    public synchronized XMLMessageConsumer getMessageConsumer(XMLMessageListener listener) throws JCSMPException {
        return this.doGetConsumer(null, null, listener);
    }

    @Override
    @Deprecated
    public synchronized XMLMessageConsumer getMessageConsumer(SubscriptionStateProvider subscriptionStateProvider) throws JCSMPException {
        return this.getMessageConsumer(subscriptionStateProvider, (XMLMessageListener)null);
    }

    @Override
    @Deprecated
    public synchronized XMLMessageConsumer getMessageConsumer(SubscriptionStateProvider subscriptionStateProvider, XMLMessageListener listener) throws JCSMPException {
        return this.doGetConsumer(subscriptionStateProvider, null, listener);
    }

    @Override
    @Deprecated
    public synchronized XMLMessageConsumer getMessageConsumer(JCSMPReconnectEventHandler reconnectHandler) throws JCSMPException {
        return this.getMessageConsumer(reconnectHandler, (XMLMessageListener)null);
    }

    @Override
    public synchronized XMLMessageConsumer getMessageConsumer(JCSMPReconnectEventHandler reconnectHandler, XMLMessageListener listener) throws JCSMPException {
        return this.doGetConsumer(null, reconnectHandler, listener);
    }

    @Override
    @Deprecated
    public synchronized XMLMessageConsumer getMessageConsumer(SubscriptionStateProvider subscriptionStateProvider, JCSMPReconnectEventHandler reconnectHandler) throws JCSMPException {
        return this.getMessageConsumer(subscriptionStateProvider, reconnectHandler, (XMLMessageListener)null);
    }

    @Override
    @Deprecated
    public synchronized XMLMessageConsumer getMessageConsumer(SubscriptionStateProvider subscriptionStateProvider, JCSMPReconnectEventHandler reconnectHandler, XMLMessageListener listener) throws JCSMPException {
        return this.doGetConsumer(subscriptionStateProvider, reconnectHandler, listener);
    }

    private XMLMessageConsumer doGetConsumer(SubscriptionStateProvider subStateProvider, JCSMPReconnectEventHandler reconHandler, XMLMessageListener listener) throws JCSMPException {
        this.checkClosed();
        this.sniffRouter();
        return this.sessionModeSup.doGetConsumer(subStateProvider, reconHandler, listener);
    }

    @Override
    public synchronized void applySubscriptions(Set<Subscription> subscriptions) throws JCSMPException {
        this.checkClosed();
        this.sniffRouter();
        this.sessionModeSup.applySubscriptions(subscriptions);
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public TcpClientChannel getClientChannel() {
        return this.clientChannel;
    }

    protected CSMPControllerChannel getControlChannel() {
        return this.controlChannel;
    }

    protected CSMPPublisherChannel getPublisherChannel() {
        return this.publisherChannel;
    }

    protected CSMPSubscriberChannel getSubscriberChannel() {
        return this.subscriberChannel;
    }

    protected String getMessageAckMode() {
        return this.messageAckMode;
    }

    public JCSMPProperties getJCSMPProperties() {
        return this.props;
    }

    public SecureProperties getSecureProperties() {
        return this.secureProps;
    }

    @Override
    public synchronized void addSubscription(Subscription subscription) throws JCSMPException {
        this.sniffRouter();
        this.openSubChannel();
        this.sessionModeSup.addSubscription(subscription);
    }

    @Override
    public synchronized void addSubscription(Subscription subscription, boolean waitForConfirm) throws JCSMPException {
        this.sniffRouter();
        this.openSubChannel();
        this.sessionModeSup.addSubscription(subscription, waitForConfirm);
    }

    @Override
    public Consumer addSubscription(Subscription subscription, XMLMessageListener listener, ConsumerNotificationDispatcherFactory dispatcherFactory) throws JCSMPException {
        this.sniffRouter();
        this.openSubChannel();
        return this.sessionModeSup.addSubscription(subscription, listener, dispatcherFactory);
    }

    @Override
    public synchronized void removeSubscription(Subscription subscription) throws JCSMPException {
        this.sniffRouter();
        this.openSubChannel();
        this.sessionModeSup.removeSubscription(subscription);
    }

    @Override
    public synchronized void removeSubscription(Subscription subscription, boolean waitForConfirm) throws JCSMPException {
        this.sniffRouter();
        this.openSubChannel();
        this.sessionModeSup.removeSubscription(subscription, waitForConfirm);
    }

    @Override
    public synchronized void addSubscription(Endpoint endpoint, Subscription subscription, int subscribeFlags) throws JCSMPException {
        this.sniffRouter();
        this.openSubChannel();
        if (endpoint == null) {
            boolean waitConfirm = (subscribeFlags & 4) != 0;
            this.addSubscription(subscription, waitConfirm);
        } else {
            if (endpoint instanceof Queue && !this.isCapable(CapabilityType.QUEUE_SUBSCRIPTIONS)) {
                throw new InvalidOperationException(JCSMPRB.BUNDLE.getStringSafely("JCSMPBasicSession.capabilityNoQueueSubscriptions"));
            }
            if (endpoint instanceof ClientName && !this.isCapable(CapabilityType.SUBSCRIPTION_MANAGER)) {
                throw new InvalidOperationException(JCSMPRB.BUNDLE.getStringSafely("JCSMPBasicSession.capabilityNoSubscriptionManager"));
            }
            if (!(endpoint instanceof Queue) && !(endpoint instanceof ClientName)) {
                throw new IllegalArgumentException("Endpoint must be a Queue or ClientName");
            }
            this.isValidEndpoint(endpoint);
            if (!(subscription instanceof Topic)) {
                throw new IllegalArgumentException("Subscription must be a Topic");
            }
            if (subscribeFlags != 0 && subscribeFlags != 4) {
                throw new IllegalArgumentException("Invalid subscribe flags");
            }
            this.sessionModeSup.addSubscription(endpoint, subscription, subscribeFlags);
        }
    }

    @Override
    public synchronized void removeSubscription(Endpoint endpoint, Subscription subscription, int unsubscribeFlags) throws JCSMPException {
        this.sniffRouter();
        this.openSubChannel();
        if (endpoint == null) {
            boolean waitConfirm = (unsubscribeFlags & 4) != 0;
            this.removeSubscription(subscription, waitConfirm);
        } else {
            if (endpoint instanceof Queue && !this.isCapable(CapabilityType.QUEUE_SUBSCRIPTIONS)) {
                throw new InvalidOperationException(JCSMPRB.BUNDLE.getStringSafely("JCSMPBasicSession.capabilityNoQueueSubscriptions"));
            }
            if (endpoint instanceof ClientName && !this.isCapable(CapabilityType.SUBSCRIPTION_MANAGER)) {
                throw new InvalidOperationException(JCSMPRB.BUNDLE.getStringSafely("JCSMPBasicSession.capabilityNoSubscriptionManager"));
            }
            if (!(endpoint instanceof Queue) && !(endpoint instanceof ClientName)) {
                throw new IllegalArgumentException("Endpoint must be a Queue or ClientName");
            }
            this.isValidEndpoint(endpoint);
            if (!(subscription instanceof Topic)) {
                throw new IllegalArgumentException("Subscription must be a Topic");
            }
            this.sessionModeSup.removeSubscription(endpoint, subscription, unsubscribeFlags);
        }
    }

    @Override
    public synchronized DestinationConsumer getMessageConsumer(DestinationListener listener) throws JCSMPException {
        return this.getMessageConsumer(null, null, listener);
    }

    @Override
    public synchronized DestinationConsumer getMessageConsumer(JCSMPReconnectEventHandler reconnectHandler, DestinationListener listener) throws JCSMPException {
        return this.getMessageConsumer(null, reconnectHandler, listener);
    }

    @Override
    public synchronized DestinationConsumer getMessageConsumer(DestinationSubscriptionStateProvider destinationSubscriptionStateProvider, DestinationListener listener) throws JCSMPException {
        return this.getMessageConsumer(destinationSubscriptionStateProvider, null, listener);
    }

    @Override
    public synchronized DestinationConsumer getMessageConsumer(DestinationSubscriptionStateProvider destinationSubscriptionStateProvider, JCSMPReconnectEventHandler reconnectHandler, DestinationListener listener) throws JCSMPException {
        this.checkClosed();
        MessageListenerAdapter listenerWrapper = null;
        if (listener != null) {
            listenerWrapper = new MessageListenerAdapter(listener);
        }
        XMLMessageConsumer consumer = null;
        consumer = reconnectHandler != null ? this.getMessageConsumer(reconnectHandler, (XMLMessageListener)listenerWrapper) : this.getMessageConsumer(listenerWrapper);
        return new TopicConsumerImpl(consumer);
    }

    @Override
    public synchronized void unsubscribeDurableTopicEndpoint(DurableTopicEndpoint endpoint) throws JCSMPException {
        this.sniffRouter();
        this.openSubChannel();
        this.sessionModeSup.unsubscribeDurableTopicEndpoint(endpoint);
    }

    @Override
    public synchronized FlowReceiver createFlow(Endpoint endpoint, Subscription newSubscription, XMLMessageListener listener) throws JCSMPException {
        this.sniffRouter();
        this.openSubChannel();
        this.isValidEndpoint(endpoint);
        return this.sessionModeSup.createFlow(endpoint, newSubscription, listener);
    }

    @Override
    public synchronized FlowReceiver createFlow(XMLMessageListener listener, ConsumerFlowProperties flowProperties) throws JCSMPException {
        this.sniffRouter();
        this.openSubChannel();
        this.isValidEndpoint(flowProperties.getEndpoint());
        return this.sessionModeSup.createFlow(listener, flowProperties);
    }

    @Override
    public synchronized FlowReceiver createFlow(XMLMessageListener listener, ConsumerFlowProperties flowProperties, EndpointProperties endpointProps) throws JCSMPException {
        this.sniffRouter();
        this.openSubChannel();
        this.isValidEndpoint(flowProperties.getEndpoint());
        return this.sessionModeSup.createFlow(listener, flowProperties, endpointProps);
    }

    @Override
    public synchronized FlowReceiver createFlow(XMLMessageListener listener, ConsumerFlowProperties flowProperties, EndpointProperties endpointProps, FlowEventHandler flowEventHandler) throws JCSMPException {
        this.sniffRouter();
        this.openSubChannel();
        this.isValidEndpoint(flowProperties.getEndpoint());
        return this.sessionModeSup.createFlow(listener, flowProperties, endpointProps, flowEventHandler);
    }

    public synchronized FlowReceiver createFlow(XMLMessageListener listener, ConsumerFlowProperties flowProperties, EndpointProperties endpointProps, InternalBindProperties int_bind_prop) throws JCSMPException {
        this.sniffRouter();
        this.openSubChannel();
        this.isValidEndpoint(flowProperties.getEndpoint());
        return this.sessionModeSup.createFlow(listener, flowProperties, endpointProps, int_bind_prop, null);
    }

    public synchronized FlowReceiver createFlow(XMLMessageListener listener, ConsumerFlowProperties flowProperties, EndpointProperties endpointProps, InternalBindProperties int_bind_prop, FlowEventHandler flowEventHandler) throws JCSMPException {
        this.sniffRouter();
        this.openSubChannel();
        this.isValidEndpoint(flowProperties.getEndpoint());
        return this.sessionModeSup.createFlow(listener, flowProperties, endpointProps, int_bind_prop, flowEventHandler);
    }

    @Override
    public synchronized DestinationProducer getMessageProducer(JCSMPStreamingPublishEventHandler callback, Destination defaultTopic) throws JCSMPException {
        this.checkClosed();
        XMLMessageProducer producer = this.getMessageProducer(callback);
        return new TopicProducerImpl(producer, defaultTopic);
    }

    @Override
    public synchronized JndiMessage executeJndiQuery(JndiMessage request) throws JCSMPException {
        this.sniffRouter();
        return this.sessionModeSup.executeJndiQuery(request);
    }

    @Override
    public synchronized void setProperty(String property, Object value) throws JCSMPException {
        this.sniffRouter();
        this.sessionModeSup.setProperty(property, value);
    }

    @Override
    public synchronized Object getProperty(String property) {
        return this.props.getProperty(property);
    }

    public String getP2pTopicDescriptionBase() {
        return this.p2pTopicDescriptionBase;
    }

    public void setP2pTopicDescriptionBase(String p2pTopicDescriptionBase) {
        this.p2pTopicDescriptionBase = p2pTopicDescriptionBase;
        this.props.setProperty("P2PTOPICDESCRIPTION", p2pTopicDescriptionBase);
    }

    public JCSMPXMLMessageProducer getProducer() {
        return this.sessionModeSup != null ? this.sessionModeSup.getProducer() : null;
    }

    public JCSMPXMLMessageConsumer getConsumer() {
        return this.sessionModeSup != null ? this.sessionModeSup.getConsumer() : null;
    }

    @Override
    public CacheSession createCacheSession(CacheSessionProperties properties) throws JCSMPException {
        this.sniffRouter();
        CacheSessionImpl session = (CacheSessionImpl)this.sessionModeSup.createCacheSession(properties);
        session.setJCSMPSession(this);
        return session;
    }

    @Override
    public Requestor createRequestor() throws JCSMPException {
        this.sniffRouter();
        return this.sessionModeSup.createRequestor();
    }

    public boolean hasSessionEventHandler() {
        return this.appSessionEventHandler != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleSessionEvent(SessionEventArgs event) {
        if (this.appSessionEventHandler != null) {
            try {
                Object object = this.appSessionEventHandlerLock;
                synchronized (object) {
                    if (!this.isClosed()) {
                        this.appSessionEventHandler.handleEvent(event);
                    }
                }
            }
            catch (Throwable t) {
                Trace.info((Object)("Caught throwable from SessionEventHandler.handleEvent(): " + t.toString()));
            }
        } else {
            Trace.warn((Object)("Unexpected event on JCSMPSession with no SessionEventHandler: " + event.toString()));
        }
    }

    @Override
    public Queue createTemporaryQueue() throws JCSMPException {
        this.checkClosed();
        this.getCapability(CapabilityType.TEMP_ENDPOINT);
        String vrid_str_id = this.props.getStringProperty("VIRTUAL_ROUTER_NAME");
        return QueueImpl.createWithInit(DestinationUtil.createNonDurQueueTrbTopic(vrid_str_id, null), false, this.getVirtualRouterName());
    }

    @Override
    public Queue createTemporaryQueue(String name) throws JCSMPException {
        this.checkClosed();
        this.getCapability(CapabilityType.TEMP_ENDPOINT);
        String vrid_str_id = this.props.getStringProperty("VIRTUAL_ROUTER_NAME");
        return QueueImpl.createWithInit(DestinationUtil.createNonDurQueueTrbTopic(vrid_str_id, name), false, this.getVirtualRouterName());
    }

    @Override
    public Topic createTemporaryTopic() throws JCSMPException {
        this.checkClosed();
        this.getCapability(CapabilityType.TEMP_ENDPOINT);
        String vrid_str_id = this.props.getStringProperty("VIRTUAL_ROUTER_NAME");
        return TopicImpl.createWithInit(DestinationUtil.createNonDurTopicTrbTopic(vrid_str_id, null), false, true);
    }

    @Override
    public TopicEndpoint createNonDurableTopicEndpoint() throws JCSMPException {
        this.checkClosed();
        if (!this.isCapable(CapabilityType.TEMP_ENDPOINT)) {
            throw new InvalidOperationException(JCSMPRB.BUNDLE.getStringSafely("JCSMPBasicSession.capabilityNoTempEndpoint"));
        }
        return new NonDurableTopicEndpointImpl();
    }

    @Override
    public TopicEndpoint createNonDurableTopicEndpoint(String name) throws JCSMPException {
        this.checkClosed();
        if (!this.isCapable(CapabilityType.TEMP_ENDPOINT)) {
            throw new InvalidOperationException(JCSMPRB.BUNDLE.getStringSafely("JCSMPBasicSession.capabilityNoTempEndpoint"));
        }
        return new NonDurableTopicEndpointImpl(name);
    }

    @Override
    public Object getCapability(CapabilityType type) throws JCSMPException {
        Map caps = (Map)this.transientData.get((Object)TransientData.CAP);
        if (caps == null) {
            throw new InvalidOperationException(JCSMPRB.BUNDLE.getStringSafely("JCSMPBasicSession.operationNotSupportedDisconnected"));
        }
        return caps.get((Object)type);
    }

    @Override
    public boolean isCapable(CapabilityType ctype) {
        Map caps = (Map)this.transientData.get((Object)TransientData.CAP);
        if (ctype.getValueType() != Boolean.class) {
            throw new IllegalArgumentException(JCSMPRB.BUNDLE.getStringSafely("JCSMPBasicSession.operationNotSupportedCannotConvertToBoolean"));
        }
        if (caps == null) {
            return false;
        }
        Boolean retVal = (Boolean)caps.get((Object)ctype);
        return Boolean.TRUE.equals(retVal);
    }

    protected void isValidEndpoint(Endpoint endpoint) throws JCSMPException {
        assert (this.rtr_sniffed);
        if (endpoint.getVirtualRouterName() != null && !endpoint.getVirtualRouterName().equals(this.getVirtualRouterName())) {
            throw new InvalidOperationException(JCSMPRB.BUNDLE.getStringSafely("JCSMPBasicSession.operationNotSupportedHostIdMismatch"));
        }
    }

    @Override
    public synchronized void connect() throws JCSMPException {
        this.sniffRouter();
        if (this.clientChannel != null) {
            this.clientChannel.open();
        } else {
            this.subscriberChannel.open();
            this.publisherChannel.open();
        }
    }

    private synchronized void openSubChannel() throws JCSMPException {
        this.sniffRouter();
        if (this.clientChannel != null) {
            this.clientChannel.open(false);
        }
        if (this.subscriberChannel != null) {
            this.subscriberChannel.open();
        }
    }

    public void reestablishSubCache() throws JCSMPException {
        if (this.subscriptionCache == null || this.sessionModeSup == null) {
            return;
        }
        this.sessionModeSup.reestablishSubCache();
    }

    @Override
    public void notifySubscriptionEvent(SessionSubscriptionEvent ev) {
        if (this.subscriptionEventListener != null) {
            this.subscriptionEventListener.notifySubscriptionEvent(ev);
        }
    }

    public ClientInfoProvider getClientInfoProvider() {
        return this.clientInfoProvider;
    }

    @Override
    public Set<Subscription> getSubscriptionCache() {
        Set<Object> locSubscriptionCache = this.subscriptionCache == null ? new HashSet() : this.subscriptionCache.getSubscriptionShallowCopy();
        return Collections.unmodifiableSet(locSubscriptionCache);
    }

    public String getVirtualRouterName() {
        return this.props.getStringProperty("VIRTUAL_ROUTER_NAME");
    }

    @Override
    public synchronized void deprovision(Endpoint endpoint, long deprovisionFlags) throws JCSMPException {
        this.sniffRouter();
        if (!endpoint.isDurable()) {
            throw new IllegalArgumentException("Non-durable endpoints are not allowed as an argument to deprovision");
        }
        this.openSubChannel();
        this.isValidEndpoint(endpoint);
        if (!this.isCapable(CapabilityType.ENDPOINT_MANAGEMENT)) {
            throw new InvalidOperationException(JCSMPRB.BUNDLE.getStringSafely("JCSMPBasicSession.capabilityNoEndpointMgmt"));
        }
        this.sessionModeSup.deprovision(endpoint, deprovisionFlags);
    }

    @Override
    public synchronized void provision(Endpoint endpoint, EndpointProperties props, long provisionFlags) throws JCSMPException {
        this.sniffRouter();
        if (!endpoint.isDurable()) {
            throw new IllegalArgumentException("Non-durable endpoints are not allowed as an argument to provision");
        }
        if (props != null && props.getAccessType() != null && props.getAccessType() == 0 && endpoint instanceof TopicEndpoint) {
            throw new IllegalArgumentException("non-exclusive durable topic endpoint not allowed");
        }
        this.openSubChannel();
        this.isValidEndpoint(endpoint);
        if (!this.isCapable(CapabilityType.ENDPOINT_MANAGEMENT)) {
            throw new InvalidOperationException(JCSMPRB.BUNDLE.getStringSafely("JCSMPBasicSession.capabilityNoEndpointMgmt"));
        }
        if (props != null && props.isRespectsMsgTTL() != null && props.isRespectsMsgTTL().booleanValue() && !this.isCapable(CapabilityType.ENDPOINT_MESSAGE_TTL)) {
            throw new InvalidOperationException(JCSMPRB.BUNDLE.getStringSafely("JCSMPBasicSession.capabilityNoEndpointTTL"));
        }
        this.sessionModeSup.provision(endpoint, props, provisionFlags);
    }

    @Override
    public synchronized Browser createBrowser(BrowserProperties properties) throws JCSMPException {
        this.sniffRouter();
        if (!(properties.getEndpoint() instanceof Queue)) {
            throw new IllegalArgumentException("Can only browse queues");
        }
        this.openSubChannel();
        if (!this.isCapable(CapabilityType.BROWSER)) {
            throw new InvalidOperationException(JCSMPRB.BUNDLE.getStringSafely("JCSMPBasicSession.capabilityNoBrowser"));
        }
        this.isValidEndpoint(properties.getEndpoint());
        FlowReceiver receiver = this.sessionModeSup.createFlow(properties);
        return new BrowserImpl(properties, receiver);
    }

    @Override
    public synchronized TransactedSession createTransactedSession() throws JCSMPException {
        this.validateLargeMessaging();
        return this.createTransactedSessionInternal();
    }

    public synchronized TransactedSession createTransactedSessionInternal() throws JCSMPException {
        this.sniffRouter();
        this.connect();
        if (!this.isCapable(CapabilityType.TRANSACTED_SESSIONS)) {
            throw new InvalidOperationException(JCSMPRB.BUNDLE.getStringSafely("JCSMPBasicSession.capabilityNoTransactedSessions"));
        }
        return this.txsessionMgr.createTransactedSession();
    }

    @Override
    public synchronized XASession createXASession() throws JCSMPException {
        if (this.xasessionMgr == null) {
            throw new InvalidOperationException(JCSMPRB.BUNDLE.getStringSafely("JCSMPBasicSession.xaSessionsNotEnabled"));
        }
        this.validateLargeMessaging();
        this.sniffRouter();
        this.connect();
        if (!this.isCapable(CapabilityType.TRANSACTED_SESSIONS)) {
            throw new InvalidOperationException(JCSMPRB.BUNDLE.getStringSafely("JCSMPBasicSession.capabilityNoTransactedSessions"));
        }
        return this.xasessionMgr.createXASession();
    }

    protected void checkClosed() throws InvalidOperationException {
        if (this.isClosed()) {
            throw new ClosedFacilityException("Session is closed.");
        }
    }

    public AssuredCtrlFactory getAssuredCtrlFactory() {
        return this.assuredCtrlFactory;
    }

    private void validateLargeMessaging() throws InvalidPropertiesException {
        if (this.props.getBooleanProperty("large_messaging").booleanValue()) {
            throw new InvalidPropertiesException("Large messaging is not supported for transacted sessions");
        }
    }

    public static class InternalBindProperties {
        public BaseTransactedSessionImpl transactedSession = null;
        public Integer connCounterTag = null;

        private InternalBindProperties() {
        }

        public static InternalBindProperties create() {
            return new InternalBindProperties();
        }

        public InternalBindProperties with(BaseTransactedSessionImpl transactedSession) {
            this.transactedSession = transactedSession;
            return this;
        }

        public InternalBindProperties with(BaseTransactedSessionImpl transactedSession, Integer connCounterTag) {
            this.transactedSession = transactedSession;
            this.connCounterTag = connCounterTag;
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TransientData {
        CAP,
        INTERNAL_CAP;

    }
}

