/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.impl;

import com.solacesystems.jcsmp.CapabilityType;
import com.solacesystems.jcsmp.Destination;
import com.solacesystems.jcsmp.InvalidMessageReceivedException;
import com.solacesystems.jcsmp.InvalidOperationException;
import com.solacesystems.jcsmp.JCSMPErrorResponseException;
import com.solacesystems.jcsmp.JCSMPErrorResponseSubcode;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPLoginFailureException;
import com.solacesystems.jcsmp.JCSMPTransportException;
import com.solacesystems.jcsmp.Pair;
import com.solacesystems.jcsmp.Subscription;
import com.solacesystems.jcsmp.Topic;
import com.solacesystems.jcsmp.VersionNotSupportException;
import com.solacesystems.jcsmp.i18n.JCSMPRB;
import com.solacesystems.jcsmp.impl.InternalCapabilityType;
import com.solacesystems.jcsmp.impl.JCSMPBasicSession;
import com.solacesystems.jcsmp.impl.JCSMPXMLMessage;
import com.solacesystems.jcsmp.impl.P2pUtil;
import com.solacesystems.jcsmp.protocol.CSMPResponseParser;
import com.solacesystems.jcsmp.protocol.WireMessage;
import com.solacesystems.jcsmp.protocol.csmp.CSMPMessageFactory;
import com.solacesystems.jcsmp.protocol.impl.ChannelOpStrategy;
import com.solacesystems.jcsmp.protocol.impl.RouterCapabilityParser;
import com.solacesystems.jcsmp.protocol.impl.TcpClientChannel;
import com.solacesystems.jcsmp.protocol.nio.impl.SubscriberMessageReader;
import com.solacesystems.jcsmp.protocol.smf.AbstractTLVParameter;
import com.solacesystems.jcsmp.protocol.smf.SMFHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.SubCtrlHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.impl.TlvCoderUtil;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ChannelOpStrategySubdata
extends ChannelOpStrategy {
    private static final Log Trace = LogFactory.getLog(ChannelOpStrategySubdata.class);

    public ChannelOpStrategySubdata(TcpClientChannel channel) {
        super(channel);
    }

    @Override
    public void performOpen(boolean isReconn) throws JCSMPException {
        CSMPResponseParser.SUSubscriberCtrlBean bean = this.performOpen();
        assert (bean != null);
        SocketChannel sc = this.c_refs.smfClient.getSocket().getChannel();
        try {
            sc.configureBlocking(false);
        }
        catch (IOException e) {
            throw new JCSMPTransportException("Transport error.", e);
        }
        boolean enableRxTimestamps = this.c_refs.sessionProperties.getBooleanProperty("generate_rcv_timestamps");
        SubscriberMessageReader messageReader = new SubscriberMessageReader(sc, this.channel, enableRxTimestamps, this.c_refs.sessionStats);
        this.c_refs.smfClient.setSubscriberMessageReader(messageReader);
        this.channel.start();
    }

    private CSMPResponseParser.SUSubscriberCtrlBean performOpen() throws JCSMPException {
        WireMessage subctrlRespMsg;
        if (Trace.isDebugEnabled()) {
            Trace.debug((Object)"About to open TcpSubscriberChannel");
        }
        String clientUsername = this.c_refs.sessionProperties.getStringProperty("username");
        SubCtrlHeaderBean subctrlHeader = null;
        SMFHeaderBean smfHeader = new SMFHeaderBean();
        smfHeader.setProtocol(7).setTtl(1);
        subctrlHeader = CSMPMessageFactory.onlyInstance().buildSubscriberControlPacketHeaderBean();
        WireMessage subctrlReq = new WireMessage();
        subctrlReq.setSmfHeader(smfHeader);
        subctrlReq.addHeaderBean(subctrlHeader);
        try {
            subctrlRespMsg = this.channel.executePostOnce(subctrlReq, true);
        }
        catch (JCSMPErrorResponseException err) {
            throw new JCSMPLoginFailureException(0, clientUsername, err.getResponseCode(), err.getResponsePhrase());
        }
        if (!(subctrlRespMsg.getHeaderBean() instanceof SubCtrlHeaderBean)) {
            throw new InvalidMessageReceivedException(JCSMPRB.BUNDLE.getStringSafely("TcpSubscriberChannel.expectedSubCtrlResponseBlockNotFound"));
        }
        SubCtrlHeaderBean subctrlResponseHeader = (SubCtrlHeaderBean)subctrlRespMsg.getHeaderBean();
        if (subctrlResponseHeader.getProtocolVersion() != 3) {
            throw new VersionNotSupportException(JCSMPRB.BUNDLE.getStringSafely("TcpSubscriberChannel.routerVersionNotSupported"));
        }
        CSMPResponseParser.SUSubscriberCtrlBean responseBean = CSMPResponseParser.onlyInstance().parseSUSubscriberCtrlResponse(subctrlResponseHeader);
        AbstractTLVParameter param_cap = subctrlResponseHeader.findFirstParameter(9);
        AbstractTLVParameter param_sversion = subctrlResponseHeader.findFirstParameter(10);
        AbstractTLVParameter param_sdate = subctrlResponseHeader.findFirstParameter(11);
        AbstractTLVParameter param_platform = subctrlResponseHeader.findFirstParameter(12);
        Pair<Map<CapabilityType, Object>, Map<InternalCapabilityType, Boolean>> caps_pair = RouterCapabilityParser.parseCapabilitiesFromHeader(param_cap, null, param_sversion, param_sdate, param_platform, null, false);
        this.c_refs.session.putTransientData(JCSMPBasicSession.TransientData.CAP, caps_pair.getFirst(), false);
        this.c_refs.session.putTransientData(JCSMPBasicSession.TransientData.INTERNAL_CAP, caps_pair.getSecond(), false);
        AbstractTLVParameter param_csmpvrid = subctrlResponseHeader.findFirstParameter(13);
        if (param_csmpvrid != null) {
            String csmpvrid = TlvCoderUtil.nullTermAsciiToString(param_csmpvrid.value);
            String existVridName = this.c_refs.sessionProperties.getStringProperty("VIRTUAL_ROUTER_NAME");
            this.c_refs.sessionProperties.setProperty("VIRTUAL_ROUTER_NAME", csmpvrid);
            this.checkVridChangeOnLogin(existVridName, csmpvrid);
        } else {
            this.c_refs.sessionProperties.setProperty("VIRTUAL_ROUTER_NAME", "501ACE00");
        }
        this.updateP2pInboxInUse(subctrlResponseHeader);
        if (Trace.isDebugEnabled()) {
            Trace.debug((Object)"Done open SubscriberChannel");
        }
        return responseBean;
    }

    @Override
    public void updateClientDescription(String clientDesc) throws JCSMPException {
    }

    @Override
    public void updateClientName(String uniqueName, String defaultName) throws JCSMPException {
    }

    private void updateP2pInboxInUse(SubCtrlHeaderBean subctrlResponseHeader) {
        String clientUsername = this.c_refs.sessionProperties.getStringProperty("username");
        AbstractTLVParameter param_csmpvrid = subctrlResponseHeader.findFirstParameter(13);
        String csmpvrid = null;
        if (param_csmpvrid != null) {
            csmpvrid = TlvCoderUtil.nullTermAsciiToString(param_csmpvrid.value);
        }
        String p2pTopicBase = P2pUtil.getGeneratedP2pTopicBase(clientUsername, this.c_refs.smfClient.getRemoteHost(), csmpvrid);
        Topic newP2pTopic = P2pUtil.getP2pInboxTopic(p2pTopicBase);
        Trace.debug((Object)String.format("** Updating P2PINBOX to [%s]", newP2pTopic));
        this.c_refs.sessionProperties.setProperty("p2pinbox_in_use", newP2pTopic);
        this.c_refs.session.setP2pTopicDescriptionBase(p2pTopicBase);
    }

    @Override
    public void establishP2pSub() throws JCSMPException {
        String base = this.c_refs.sessionProperties.getStringProperty("P2PTOPICDESCRIPTION");
        if (base != null && this.c_refs.sessionModeSup != null) {
            Topic p2pSubscription = P2pUtil.getP2pTopicSubscription(base);
            try {
                this.c_refs.sessionModeSup.addSubscription((Subscription)p2pSubscription, true, false);
                Trace.debug((Object)("Successfully added P2PINBOX subscription: " + p2pSubscription));
            }
            catch (JCSMPErrorResponseException respEx) {
                if (respEx.getSubcode() == JCSMPErrorResponseSubcode.SUBSCRIPTION_ALREADY_PRESENT) {
                    Trace.debug((Object)String.format("P2PINBOX subscription (%s) already present on router, ignoring.", p2pSubscription));
                }
                throw respEx;
            }
        }
    }

    @Override
    public void buildSendMsgHeader(JCSMPXMLMessage message, Destination destination, long msgId_64bit, long flowId, long publisherId, boolean newMsg) throws InvalidOperationException {
    }
}

