/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms;

import com.solacesystems.jms.SolMessageProducer;
import com.solacesystems.jms.SolSessionIF;
import com.solacesystems.jms.impl.Validator;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueSender;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SolQueueSender
extends SolMessageProducer
implements QueueSender {
    private static final Log log = LogFactory.getLog(SolQueueSender.class);
    private static final String Component = "QueueSender";

    SolQueueSender(SolSessionIF session, Queue queue) throws JMSException {
        super(session, (Destination)queue);
        if (log.isDebugEnabled()) {
            log.debug((Object)("SolQueueSender created.  Queue: " + (queue == null ? "null" : queue.getQueueName())));
        }
    }

    public synchronized Queue getQueue() throws JMSException {
        Validator.checkClosed(this.mState, Component);
        return (Queue)this.mDestination;
    }

    @Override
    public void send(Message message) throws JMSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entering send()");
        }
        Validator.checkClosed(this.mState, Component);
        Validator.checkSendDestination(this.mSessionProps.getConnectionProperties().getRouterCapabilities().crMode(), this.mDestination, null);
        Validator.checkMessage(message);
        this.sendMessage(this.mDestination, message, this.mDeliveryMode, this.mPriority, this.mTimeToLive);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Leaving send()");
        }
    }

    @Override
    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entering send()");
        }
        Validator.checkClosed(this.mState, Component);
        Validator.checkSendDestination(this.mSessionProps.getConnectionProperties().getRouterCapabilities().crMode(), this.mDestination, null);
        Validator.checkMessage(message);
        Validator.checkDeliveryMode(deliveryMode);
        Validator.checkPriority(priority);
        Validator.checkTimeToLive(timeToLive);
        this.sendMessage(this.mDestination, message, deliveryMode, priority, timeToLive);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Leaving send()");
        }
    }

    public void send(Queue queue, Message message) throws JMSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entering send()");
        }
        Validator.checkClosed(this.mState, Component);
        Destination destination = Validator.checkSendDestination(this.mSessionProps.getConnectionProperties().getRouterCapabilities().crMode(), this.mDestination, (Destination)queue);
        Validator.checkMessage(message);
        this.sendMessage(destination, message, this.mDeliveryMode, this.mPriority, this.mTimeToLive);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Leaving send()");
        }
    }

    public void send(Queue queue, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entering send()");
        }
        Validator.checkClosed(this.mState, Component);
        Destination destination = Validator.checkSendDestination(this.mSessionProps.getConnectionProperties().getRouterCapabilities().crMode(), this.mDestination, (Destination)queue);
        Validator.checkMessage(message);
        Validator.checkDeliveryMode(deliveryMode);
        Validator.checkPriority(priority);
        Validator.checkTimeToLive(timeToLive);
        this.sendMessage(destination, message, deliveryMode, priority, timeToLive);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Leaving send()");
        }
    }
}

