/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.transaction;

import com.solacesystems.jcsmp.ConsumerFlowProperties;
import com.solacesystems.jcsmp.EndpointProperties;
import com.solacesystems.jcsmp.FlowEventHandler;
import com.solacesystems.jcsmp.FlowReceiver;
import com.solacesystems.jcsmp.InvalidOperationException;
import com.solacesystems.jcsmp.JCSMPChannelProperties;
import com.solacesystems.jcsmp.JCSMPErrorResponseException;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPFatalErrorException;
import com.solacesystems.jcsmp.JCSMPInterruptedException;
import com.solacesystems.jcsmp.JCSMPProducerEventHandler;
import com.solacesystems.jcsmp.JCSMPStreamingPublishEventHandler;
import com.solacesystems.jcsmp.JCSMPTransportException;
import com.solacesystems.jcsmp.ProducerFlowProperties;
import com.solacesystems.jcsmp.XMLMessageListener;
import com.solacesystems.jcsmp.XMLMessageProducer;
import com.solacesystems.jcsmp.impl.Closeable;
import com.solacesystems.jcsmp.impl.ContextBlockingOpCheck;
import com.solacesystems.jcsmp.impl.ContextImpl;
import com.solacesystems.jcsmp.impl.JCSMPBasicSession;
import com.solacesystems.jcsmp.impl.JCSMPXMLMessageProducer;
import com.solacesystems.jcsmp.impl.flow.FlowHandleImpl;
import com.solacesystems.jcsmp.impl.timers.JCSMPTimeoutHandler;
import com.solacesystems.jcsmp.impl.transaction.BaseTransactedSessionImpl;
import com.solacesystems.jcsmp.impl.transaction.TSState;
import com.solacesystems.jcsmp.impl.transaction.TimerSetter;
import com.solacesystems.jcsmp.impl.transaction.TransactedSessionManager;
import com.solacesystems.jcsmp.impl.transaction.TransactionIdGen;
import com.solacesystems.jcsmp.impl.transaction.TransactionSteps;
import com.solacesystems.jcsmp.management.SolJmxSupport;
import com.solacesystems.jcsmp.protocol.impl.TcpChannel;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlEnums;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlHeaderParameters;
import com.solacesystems.jcsmp.transaction.RollbackException;
import com.solacesystems.jcsmp.transaction.TransactedSession;
import com.solacesystems.jcsmp.transaction.TransactionStatus;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransactedSessionImpl
extends BaseTransactedSessionImpl
implements TransactedSession {
    private static final AtomicLong _uidGen = new AtomicLong();
    private final Log Trace;
    final TransactedSessionManager _parentSessionMgr;
    final long private_uid;
    Set<FlowHandleImpl> inputFlows;
    Set<JCSMPXMLMessageProducer> outputFlows;
    Set<Closeable> flowsToClose;
    volatile TSState sessionState;
    TSState.TSStorage sessionStateStorage;
    TransactionIdGen transactionIds;
    ContextImpl context;
    final int max_post_tries;
    private final ContextBlockingOpCheck contextOpCheck;
    private volatile Integer connTag;
    AtomicInteger cur_post_tries;
    private volatile boolean upgrade_in_progress;
    volatile JCSMPException marked_close_exception;
    private ArrayBlockingQueue<ResponseQueueObjectWrapper> responseQueue;
    TimerSetter responseTimerSetter;
    final int responseTimeout;
    final RetransmissionTracking retransmission;
    final SwitchToV4Request switchToV4;

    public TransactedSessionImpl(TransactedSessionManager mgr, JCSMPChannelProperties channelProperties) {
        block2: {
            this.Trace = LogFactory.getLog(TransactedSessionImpl.class);
            this.inputFlows = null;
            this.outputFlows = null;
            this.flowsToClose = null;
            this.sessionState = null;
            this.sessionStateStorage = null;
            this.transactionIds = null;
            this.cur_post_tries = new AtomicInteger(0);
            this.upgrade_in_progress = false;
            this.marked_close_exception = null;
            this.responseQueue = new ArrayBlockingQueue(10);
            this.retransmission = new RetransmissionTracking();
            this.switchToV4 = new SwitchToV4Request();
            this._parentSessionMgr = mgr;
            this.context = mgr.context;
            this.contextOpCheck = new ContextBlockingOpCheck(this.context, mgr.getSession().getJCSMPProperties());
            this.private_uid = _uidGen.incrementAndGet();
            this.transactionIds = new TransactionIdGen();
            this.inputFlows = new LinkedHashSet<FlowHandleImpl>();
            this.outputFlows = new LinkedHashSet<JCSMPXMLMessageProducer>();
            this.flowsToClose = new LinkedHashSet<Closeable>();
            this.sessionStateStorage = new TSState.TSStorage(this);
            this.responseTimeout = channelProperties.getReadTimeoutInMillis();
            this.max_post_tries = channelProperties.getReconnectRetries() == -1 ? Integer.MAX_VALUE : Math.max(channelProperties.getReconnectRetries() + 1, 1);
            this.responseTimerSetter = new TimerSetter(this.context.getIOReactor(), this.responseTimeout, new JCSMPTimeoutHandler(){

                @Override
                public void handleTimeout() {
                    TransactedSessionImpl.this.sessionState.handleResponseTimeout();
                }
            });
            this.connTag = null;
            try {
                this.switchState(this.sessionStateStorage.STATE_NEW);
            }
            catch (JCSMPException e) {
                if (!this.Trace.isDebugEnabled()) break block2;
                this.Trace.debug((Object)("got exception: " + e.getMessage()));
            }
        }
        SolJmxSupport.instance().register(this, mgr._session);
    }

    protected void enqueueResponse(Object o) {
        this.responseQueueAdd(new ResponseQueueObjectWrapper("Response", o));
    }

    protected boolean responseQueueAdd(ResponseQueueObjectWrapper o) {
        try {
            if (this.Trace.isDebugEnabled()) {
                this.Trace.debug((Object)("responseQueueAdd: obj=(" + o.getLabel() + "," + o.getObject().toString() + ")"));
            }
            if (!this.responseQueue.contains(o)) {
                this.responseQueue.add(o);
            }
            return true;
        }
        catch (IllegalStateException e) {
            if (this.Trace.isErrorEnabled()) {
                this.Trace.error((Object)("Queue Full: " + this.responseQueue.toString() + "; obj=(" + o.getLabel() + "," + o.getObject().toString() + ")"));
            }
            return false;
        }
    }

    protected Object responseQueueTake() throws InterruptedException {
        ResponseQueueObjectWrapper o = this.responseQueue.take();
        if (o != null) {
            if (this.Trace.isDebugEnabled()) {
                this.Trace.debug((Object)("responseQueueTake: obj=(" + o.getLabel() + "," + o.getObject().toString() + ")"));
            }
            return o.getObject();
        }
        return o;
    }

    protected void responseQueueClear() {
        this.responseQueue.clear();
    }

    protected void handleV3ResponseTimeout() {
        this.sessionState.handleResponseTimeout();
    }

    protected void startResponseTimer() {
        this.responseTimerSetter.enableStartTimer();
        this.responseTimerSetter.startTimer();
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug((Object)("Response timer scheduled in " + this.responseTimerSetter.getTimeoutInMillis()));
        }
    }

    protected void stopResponseTimer() {
        this.responseTimerSetter.stopTimer();
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug((Object)"Response timer stopped ");
        }
    }

    public JCSMPBasicSession getParentSession() {
        return this._parentSessionMgr.getSession();
    }

    public TransactedSessionManager getTransactedSessionManager() {
        return this._parentSessionMgr;
    }

    protected void setResponseTimer(TimerSetter timer) {
        this.responseTimerSetter = timer;
    }

    protected int getResponseTimeout() {
        return this.responseTimeout;
    }

    protected Boolean sessionHasPubFlow() {
        return this.outputFlows.size() > 0;
    }

    @Override
    public void allowOperation(BaseTransactedSessionImpl.AllowedOperation op) throws InvalidOperationException {
        this.sessionState.allowOperation(op);
    }

    @Override
    public void notifyVridChange() {
        this.setName(null);
    }

    protected void setUpgradeInProgressStatus(boolean v) {
        this.upgrade_in_progress = v;
    }

    protected boolean isUpgradeInProgress() {
        return this.upgrade_in_progress;
    }

    public void notifyAdCtrlVersionChange(boolean downgrade) {
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug((Object)("notifyAdCtrlVersionChange (upgrade): sessionId=" + this.getTransactedSessionId() + " transaction=" + (Object)((Object)this.sessionState.getStatusEnum())));
        }
        this.sessionState.notifyAdCtrlVersionChange(downgrade);
    }

    @Override
    public void notifyUnknownName() {
    }

    public synchronized void setConnTag(Integer connTag) {
        this.connTag = connTag;
    }

    public synchronized Integer getConnTag() {
        return this.connTag;
    }

    @Override
    public TransactionStatus getStatus() {
        return this.sessionState.getStatusEnum();
    }

    protected void contextBlockingCheck() throws InvalidOperationException {
        this.contextOpCheck.check();
    }

    @Override
    public void commit() throws RollbackException, JCSMPException {
        block3: {
            try {
                JCSMPBasicSession session = this._parentSessionMgr.getSession();
                if (session != null) {
                    session.waitUntilSessionReconnectDone("commit");
                }
                this.commit_v3();
            }
            catch (SwitchToV4Request e) {
                if (!this.Trace.isErrorEnabled()) break block3;
                this.Trace.error((Object)"got unexpected SwitchToV4Request");
            }
        }
    }

    public boolean isDowngradeEnabled() {
        return this.getParentSession().getAssuredCtrlFactory().getVersion() < 4;
    }

    public void commit_v3() throws RollbackException, JCSMPException, SwitchToV4Request {
        block7: {
            this.contextBlockingCheck();
            this.sessionState.allowOperation(BaseTransactedSessionImpl.AllowedOperation.COMMIT);
            AssuredCtrlHeaderParameters.ParamTransactionId txids = null;
            txids = this.transactionIds.getCurrentAndNext();
            this.setConnTag(this._parentSessionMgr.subChannel.getConnCounterTag());
            this.sessionState.doCommit();
            try {
                Object response;
                while ((response = this.responseQueueTake()) instanceof AssuredCtrlHeaderParameters.ParamTransactionId) {
                    AssuredCtrlHeaderParameters.ParamTransactionId responseTxid = (AssuredCtrlHeaderParameters.ParamTransactionId)response;
                    if (txids.a != responseTxid.a) {
                        if (!this.Trace.isInfoEnabled()) continue;
                        this.Trace.info((Object)("commit response discarded: " + txids.a + "," + txids.b + " / " + responseTxid.a + "," + responseTxid.b));
                        continue;
                    }
                    break block7;
                }
                if (response instanceof JCSMPException) {
                    throw (JCSMPException)((Object)response);
                }
                if (response instanceof SwitchToV4Request) {
                    throw (SwitchToV4Request)response;
                }
                if (this.Trace.isErrorEnabled()) {
                    this.Trace.error((Object)("No commit response, not exception, instead got " + response.toString()));
                }
            }
            catch (InterruptedException e) {
                this.Trace.warn((Object)"Thread interrupted unexpectedly in waiting for a commit response");
                JCSMPInterruptedException ex = new JCSMPInterruptedException("wait for commit response interrupted", e);
                this.handleInterruptedException(ex);
                throw ex;
            }
        }
    }

    @Override
    public void rollback() throws JCSMPException {
        block3: {
            try {
                JCSMPBasicSession session = this._parentSessionMgr.getSession();
                if (session != null) {
                    session.waitUntilSessionReconnectDone("commit");
                }
                this.rollback_v3();
            }
            catch (SwitchToV4Request e) {
                if (!this.Trace.isErrorEnabled()) break block3;
                this.Trace.error((Object)"got unexpected SwitchToV4Request");
            }
        }
    }

    public void rollback_v3() throws JCSMPException, SwitchToV4Request {
        block8: {
            this.contextBlockingCheck();
            this.sessionState.allowOperation(BaseTransactedSessionImpl.AllowedOperation.ROLLBACK);
            AssuredCtrlHeaderParameters.ParamTransactionId txids = null;
            txids = this.transactionIds.getCurrentAndNext();
            this.setConnTag(this._parentSessionMgr.subChannel.getConnCounterTag());
            this.sessionState.doRollback();
            try {
                Object response;
                while ((response = this.responseQueueTake()) instanceof AssuredCtrlHeaderParameters.ParamTransactionId) {
                    AssuredCtrlHeaderParameters.ParamTransactionId responseTxid = (AssuredCtrlHeaderParameters.ParamTransactionId)response;
                    if (txids.a != responseTxid.a) {
                        if (!this.Trace.isInfoEnabled()) continue;
                        this.Trace.info((Object)("rollback response discarded: " + txids.a + "," + txids.b + " / " + responseTxid.a + "," + responseTxid.b));
                        continue;
                    }
                    break block8;
                }
                if (response instanceof JCSMPException) {
                    if (this.Trace.isDebugEnabled()) {
                        this.Trace.debug((Object)("Got exception: " + ((JCSMPException)((Object)response)).getMessage()));
                    }
                    throw (JCSMPException)((Object)response);
                }
                if (response instanceof SwitchToV4Request) {
                    throw (SwitchToV4Request)response;
                }
                if (this.Trace.isErrorEnabled()) {
                    this.Trace.error((Object)("No commit response, not exception, instead got " + response.toString()));
                }
            }
            catch (InterruptedException e) {
                this.Trace.warn((Object)"Thread interrupted unexpectedly in waiting for rollback response");
                JCSMPInterruptedException ex = new JCSMPInterruptedException("wait for rollback response interrupted", e);
                this.handleInterruptedException(ex);
                throw ex;
            }
        }
    }

    public boolean reconnectInProgress() {
        return this._parentSessionMgr.reconnectInProgress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasUnboundSubFlows() {
        Map<FlowHandleImpl, TransactionSteps.InputFlowInfo> m;
        Map<FlowHandleImpl, TransactionSteps.InputFlowInfo> map = m = this.getTransactionInputSteps();
        synchronized (map) {
            if (m.size() == 0) {
                return false;
            }
            for (Map.Entry<FlowHandleImpl, TransactionSteps.InputFlowInfo> e : m.entrySet()) {
                FlowHandleImpl fh = e.getKey();
                if (fh.isBoundToResource()) continue;
                if (this.Trace.isDebugEnabled()) {
                    this.Trace.debug((Object)String.format("hasUnboundSubFlows: FlowId %d, TransactedSession(id:%s)", fh.getFlowId(), this.getTransactedSessionId()));
                }
                return this._parentSessionMgr.checkUnboundFlows();
            }
        }
        return false;
    }

    public void enqueueSwitchToV4Request() {
        this.responseQueueAdd(new ResponseQueueObjectWrapper("SwitchToV4", this.switchToV4));
    }

    void sendCommitRequest(boolean blockOnAppThread, Integer connIdx) throws JCSMPException {
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug((Object)String.format("sendCommitRequest: TransactedSession(id:%s), transaction(id:%d", this.getTransactedSessionId(), this.getTransactionId().a));
        }
        this._parentSessionMgr.sendCommitRequest(this.getTransactedSessionId(), this.getTransactionId(), this.getParamPubNotify(), this.getParamSubAck(), blockOnAppThread, connIdx);
    }

    void sendRollbackRequest(boolean blockOnAppThread, Integer connIdx) throws JCSMPException {
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug((Object)String.format("sendRollbackRequest: TransactedSession(id:%s), transaction(id:%d", this.getTransactedSessionId(), this.getTransactionId().a));
        }
        this._parentSessionMgr.sendRollbackRequest(this.getTransactedSessionId(), this.getTransactionId(), null, null, blockOnAppThread, connIdx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AssuredCtrlHeaderParameters.ParamTransactionFDSubAck getParamSubAck() {
        Map<FlowHandleImpl, TransactionSteps.InputFlowInfo> m;
        Map<FlowHandleImpl, TransactionSteps.InputFlowInfo> map = m = this.getTransactionInputSteps();
        synchronized (map) {
            if (m.size() == 0) {
                return null;
            }
            AssuredCtrlHeaderParameters.ParamTransactionFDSubAck p = new AssuredCtrlHeaderParameters.ParamTransactionFDSubAck();
            for (Map.Entry<FlowHandleImpl, TransactionSteps.InputFlowInfo> e : m.entrySet()) {
                FlowHandleImpl fh = e.getKey();
                TransactionSteps.InputFlowInfo fi = e.getValue();
                if (this.Trace.isDebugEnabled()) {
                    this.Trace.debug((Object)String.format("getParamSubAck (RollbackOnly=%s): TransactedSession(id:%s), FlowId %d, minAck:maxAck:count:lastTpMsg:winSz (%d:%d:%d:%d:%d)", fi.isRollbackOnly(), this.getTransactedSessionId(), fh.getFlowId(), fi.minAck, fi.maxAck, fi.messageCount, fh.getLastInOrderTpMsg(), fh.getWindowSize()));
                }
                if (fi.isRollbackOnly()) {
                    p.addTuple(AssuredCtrlHeaderParameters.ParamTransactionFDSubAck.SubAckTuple.newTuple(-1L, 0L, 0L, 1, 0L, 0));
                } else {
                    p.addTuple(AssuredCtrlHeaderParameters.ParamTransactionFDSubAck.SubAckTuple.newTuple(fh.getFlowId(), fi.minAck, fi.maxAck, fi.messageCount, fh.getLastInOrderTpMsg(), fh.getWindowSize()));
                }
                fh.setNumUnackedTpMsgs(0);
            }
            return p;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AssuredCtrlHeaderParameters.ParamTransactionFDPubNotify getParamPubNotify() {
        Map<JCSMPXMLMessageProducer, TransactionSteps.OutputFlowInfo> m;
        Map<JCSMPXMLMessageProducer, TransactionSteps.OutputFlowInfo> map = m = this.getTransactionOutputSteps();
        synchronized (map) {
            if (m.size() == 0) {
                return null;
            }
            AssuredCtrlHeaderParameters.ParamTransactionFDPubNotify p = new AssuredCtrlHeaderParameters.ParamTransactionFDPubNotify();
            for (Map.Entry<JCSMPXMLMessageProducer, TransactionSteps.OutputFlowInfo> e : m.entrySet()) {
                JCSMPXMLMessageProducer prod = e.getKey();
                TransactionSteps.OutputFlowInfo fi = e.getValue();
                if (this.Trace.isDebugEnabled()) {
                    this.Trace.debug((Object)String.format("getParamPubNotify (RollbackOnly=%s): TransactedSession(id:%s), FlowId %d, count:lastMsgId (%d:%d)", fi.isRollbackOnly(), this.getTransactedSessionId(), prod.getPubADManager().flow_Id, fi.messageCount, fi.lastMsgId));
                }
                if (fi.isRollbackOnly()) {
                    p.addTuple(AssuredCtrlHeaderParameters.ParamTransactionFDPubNotify.PubNotifyTuple.newTuple(-1L, 1, 0L));
                    continue;
                }
                p.addTuple(AssuredCtrlHeaderParameters.ParamTransactionFDPubNotify.PubNotifyTuple.newTuple(prod.getPubADManager().flow_Id, fi.messageCount, fi.lastMsgId));
            }
            return p;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FlowReceiver createFlow(XMLMessageListener listener, ConsumerFlowProperties flowProps, EndpointProperties endpointProps) throws JCSMPException {
        this.contextOpCheck.check();
        this.allowOperation(BaseTransactedSessionImpl.AllowedOperation.CREATEFLOW);
        JCSMPBasicSession.InternalBindProperties bindprops = JCSMPBasicSession.InternalBindProperties.create().with(this);
        FlowReceiver fr = this._parentSessionMgr.getSession().createFlow(listener, flowProps, endpointProps, bindprops);
        Set<FlowHandleImpl> set = this.inputFlows;
        synchronized (set) {
            this.inputFlows.add((FlowHandleImpl)fr);
        }
        return fr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FlowReceiver createFlow(XMLMessageListener listener, ConsumerFlowProperties flowProps, EndpointProperties endpointProps, FlowEventHandler flowEventHander) throws JCSMPException {
        this.contextOpCheck.check();
        this.allowOperation(BaseTransactedSessionImpl.AllowedOperation.CREATEFLOW);
        JCSMPBasicSession.InternalBindProperties bindprops = JCSMPBasicSession.InternalBindProperties.create().with(this);
        FlowReceiver fr = this._parentSessionMgr.getSession().createFlow(listener, flowProps, endpointProps, bindprops, flowEventHander);
        Set<FlowHandleImpl> set = this.inputFlows;
        synchronized (set) {
            this.inputFlows.add((FlowHandleImpl)fr);
        }
        return fr;
    }

    @Override
    public XMLMessageProducer createProducer(ProducerFlowProperties fprop, JCSMPStreamingPublishEventHandler callback) throws JCSMPException {
        return this.createProducer(fprop, callback, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XMLMessageProducer createProducer(ProducerFlowProperties fprop, JCSMPStreamingPublishEventHandler callback, JCSMPProducerEventHandler eventCallback) throws JCSMPException {
        this.contextOpCheck.check();
        this.allowOperation(BaseTransactedSessionImpl.AllowedOperation.CREATEFLOW);
        JCSMPBasicSession.InternalBindProperties bindprops = JCSMPBasicSession.InternalBindProperties.create().with(this, this._parentSessionMgr.subChannel.getConnCounterTag());
        if (fprop == null) {
            fprop = new ProducerFlowProperties();
            fprop.setWindowSize(255);
        }
        JCSMPXMLMessageProducer prod = (JCSMPXMLMessageProducer)this._parentSessionMgr.getSession().createProducer(fprop, callback, eventCallback, bindprops);
        Set<JCSMPXMLMessageProducer> set = this.outputFlows;
        synchronized (set) {
            this.outputFlows.add(prod);
        }
        return prod;
    }

    @Override
    public void close() {
        try {
            JCSMPBasicSession session = this._parentSessionMgr.getSession();
            if (session != null) {
                session.waitUntilSessionReconnectDone("close");
            }
            this.switchStateIfNotIn(this.sessionStateStorage.STATE_CLOSED);
        }
        catch (JCSMPException e) {
            this.Trace.debug((Object)("got exception: " + e.getMessage()));
        }
        SolJmxSupport.instance().deregister(this);
    }

    private void close(JCSMPException e) {
        this.marked_close_exception = e;
        this.close();
    }

    public void handleTransportException(JCSMPTransportException e) {
        this._parentSessionMgr.subChannel.handleException((Exception)((Object)e));
    }

    public void handleInterruptedException(JCSMPInterruptedException e) {
        this._parentSessionMgr.subChannel.startReconnect(e, false);
    }

    public void handleUnrecoverableException(JCSMPException e) {
        this.Trace.info((Object)String.format("TransactedSession (%s) handling unrecoverable exception: %s", new Object[]{this.toString(), e}), (Throwable)((Object)e));
        this.close(e);
    }

    public AssuredCtrlHeaderParameters.ParamTransactionId getTransactionId() {
        return this.sessionState.getTransactionId();
    }

    public void notifyBound(String txSessionName, long txSessionId, AssuredCtrlEnums.TransactedSessionState routerState, AssuredCtrlHeaderParameters.ParamTransactionId routerTid) throws JCSMPException {
        this.setName(txSessionName);
        this.setTransactedSessionId(txSessionId);
        this.sessionState.notifyBound(routerState, routerTid);
    }

    public void notifyFlowRebindFinished() throws JCSMPException {
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug((Object)("notifyFlowRebindFinished(v3): state=" + (Object)((Object)this.sessionState.getStatusEnum())));
        }
        this.sessionState.notifyFlowRebindFinished();
    }

    public void notifyPreReconnect() {
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug((Object)("notifyPreReconnect(v3): state=" + (Object)((Object)this.sessionState.getStatusEnum())));
        }
        this.responseTimerSetter.stopTimer();
    }

    @Override
    public void notifyPreRetransmit() {
        this.responseTimerSetter.stopTimer();
    }

    @Override
    public void notifyPostRetransmit() {
        this.retransmission.taskCompleted();
        this.sessionState.notifyRetransmitsComplete();
    }

    public void notifyFinishedAdRetransmissions() {
        this.sessionState.notifyRetransmitsComplete();
    }

    protected TSState.TSStorage getV3SessionStateStorage() {
        return this.sessionStateStorage;
    }

    public void setTransactionID(long txid) {
        this.transactionIds.set(txid);
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug((Object)("setTransactionID: " + this.toString()));
        }
    }

    private void switchState(TSState newstate) throws JCSMPException {
        if (this.Trace.isInfoEnabled()) {
            String cur_status = this.sessionState != null ? String.valueOf((Object)this.sessionState.getStatusEnum()) : "null";
            String next_status = String.valueOf((Object)newstate.getStatusEnum());
            if (this.Trace.isDebugEnabled()) {
                this.Trace.debug((Object)String.format("TransactedSession(id:%s)  State SwitchTo: %s -> %s", this.getTransactedSessionId(), cur_status, next_status));
            }
        }
        this.sessionState = newstate;
        newstate.enter();
    }

    protected void updateTransactionState(TransactionStatus newstate) {
        block12: {
            try {
                if (newstate.equals((Object)TransactionStatus.ACTIVE)) {
                    this.switchStateIfNotIn(this.sessionStateStorage.STATE_ACTIVE);
                } else if (newstate.equals((Object)TransactionStatus.ROLLING_BACK)) {
                    this.switchStateIfNotIn(this.sessionStateStorage.STATE_ROLLINGBACK);
                } else if (newstate.equals((Object)TransactionStatus.COMMITTING)) {
                    this.switchStateIfNotIn(this.sessionStateStorage.STATE_COMMITTING);
                } else if (newstate.equals((Object)TransactionStatus.COMMIT_ROLLING_BACK)) {
                    this.switchStateIfNotIn(this.sessionStateStorage.STATE_COMMIT_ROLLINGBACK);
                } else if (newstate.equals((Object)TransactionStatus.MARKED_ROLLBACK)) {
                    this.switchStateIfNotIn(this.sessionStateStorage.STATE_MARKEDROLLBACK);
                } else {
                    this.switchStateIfNotIn(this.sessionStateStorage.STATE_CLOSED);
                }
            }
            catch (JCSMPException e) {
                if (!this.Trace.isDebugEnabled()) break block12;
                this.Trace.debug((Object)("updateTransactionState got exception: " + e.getMessage()));
            }
        }
    }

    protected void setTransactionState(TSState newstate) {
        this.sessionState = newstate;
    }

    public boolean switchStateIfNotIn(TSState newstate) throws JCSMPException {
        if (this.sessionState == null) {
            this.sessionState = newstate;
        }
        if (this.sessionState == newstate) {
            return false;
        }
        this.switchState(newstate);
        return true;
    }

    public TSState getCurrentSessionState() {
        return this.sessionState;
    }

    public void handleControlMessage(AssuredCtrlEnums.TransactionCtrlMessageType mtype, AssuredCtrlHeaderBean adctrl, JCSMPErrorResponseException err_resp) {
        try {
            this.sessionState.handleAsyncAdCtrl(mtype, adctrl, err_resp);
        }
        catch (Exception e) {
            this.Trace.warn((Object)"Unexpected error occurred during handleAsyncAdCtrl. ", (Throwable)e);
            this.handleUnrecoverableException(TransactedSessionImpl.wrapInJCSMPException(e));
        }
    }

    public int hashCode() {
        return Long.valueOf(this.private_uid).hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TransactedSessionImpl)) {
            return false;
        }
        return ((TransactedSessionImpl)obj).private_uid == this.private_uid;
    }

    public String toString() {
        return String.format("(TransactedSessionId:%s, Name:%s, Status:%s, TransactionId:%s)", new Object[]{this.getTransactedSessionId(), this.getName(), this.getStatus(), this.getTransactionId().a});
    }

    @Override
    public boolean getExpectsAcks() {
        return false;
    }

    @Override
    public boolean isTransportAckExpected() {
        return this.getParentSession().getAssuredCtrlFactory().getVersion() > 3;
    }

    @Override
    public void closeFlow(Closeable c) {
        boolean closeflownow = false;
        if (c instanceof FlowHandleImpl) {
            Map<FlowHandleImpl, TransactionSteps.InputFlowInfo> inpsteps = this.getTransactionInputSteps();
            closeflownow = !inpsteps.containsKey(c) || inpsteps.get((Object)c).messageCount == 0;
        } else if (c instanceof JCSMPXMLMessageProducer) {
            Map<JCSMPXMLMessageProducer, TransactionSteps.OutputFlowInfo> outsteps = this.getTransactionOutputSteps();
            boolean bl = closeflownow = !outsteps.containsKey(c) || outsteps.get((Object)c).messageCount == 0;
        }
        if (closeflownow) {
            this.Trace.debug((Object)"Destroying flow which has not consumed any messages without waiting for a commit or rollback operation");
            this.closeFlowNow(c);
        } else {
            this.enqueueFlowToClose(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueFlowToClose(Closeable flow) {
        Set<Closeable> set = this.flowsToClose;
        synchronized (set) {
            this.flowsToClose.add(flow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFlowsToClose() {
        LinkedHashSet<Closeable> tmp_toClose;
        Set<Closeable> set = this.flowsToClose;
        synchronized (set) {
            if (this.flowsToClose.size() == 0) {
                return;
            }
            tmp_toClose = new LinkedHashSet<Closeable>(this.flowsToClose);
            this.flowsToClose.clear();
        }
        for (Closeable c : tmp_toClose) {
            this.closeFlowNow(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeFlowNow(Closeable c) {
        if (c instanceof FlowHandleImpl) {
            this.Trace.debug((Object)("closeFlowNow, flowId=" + ((FlowHandleImpl)c).getFlowId()));
            ((FlowHandleImpl)c).closeImpl(true, false, TcpChannel.WriteBlockPolicy.DROP_AND_IGNORE);
            Set<FlowHandleImpl> set = this.inputFlows;
            synchronized (set) {
                this.inputFlows.remove(c);
            }
        }
        if (c instanceof JCSMPXMLMessageProducer) {
            ((JCSMPXMLMessageProducer)c).closeImpl(false);
            Set<JCSMPXMLMessageProducer> set = this.outputFlows;
            synchronized (set) {
                this.outputFlows.remove(c);
            }
        }
    }

    public boolean startAdRetransmission() {
        return this.sessionHasPubFlow();
    }

    protected static JCSMPException wrapInJCSMPException(Exception e) {
        if (e instanceof JCSMPException) {
            return (JCSMPException)((Object)e);
        }
        return new JCSMPFatalErrorException("Exception occurred.", e);
    }

    @Override
    public boolean isXA() {
        return false;
    }

    public void handlePostAbortedReconnect(JCSMPException e) {
        this.responseQueueAdd(new ResponseQueueObjectWrapper("ReconnectAborted", (Object)e));
        this.Trace.debug((Object)("handlePostAbortedReconnect: " + this.toString()));
    }

    static class RetransmissionTracking {
        int _tasks_started = 0;
        int _tasks_completed = 0;
        final Lock lock = new ReentrantLock();
        final Condition notDone = this.lock.newCondition();

        RetransmissionTracking() {
        }

        public void reset() {
            this.lock.lock();
            try {
                this._tasks_started = 0;
                this._tasks_completed = 0;
            }
            finally {
                this.lock.unlock();
            }
        }

        public void taskStarted() {
            this.lock.lock();
            try {
                ++this._tasks_started;
            }
            finally {
                this.lock.unlock();
            }
        }

        public void taskCompleted() {
            this.lock.lock();
            try {
                ++this._tasks_completed;
                if (this.isAllFinished()) {
                    this.notDone.signal();
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        public boolean isAllFinished() {
            this.lock.lock();
            try {
                boolean bl = this._tasks_completed >= this._tasks_started;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        public String toString() {
            return String.format("TasksStarted:%s, TasksCompleted:%s", this._tasks_started, this._tasks_completed);
        }

        public void waitCompletion() throws InterruptedException {
            this.lock.lock();
            try {
                while (!this.isAllFinished()) {
                    this.notDone.await();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    protected static class ResponseQueueObjectWrapper {
        private Object obj;
        private String lable;

        public ResponseQueueObjectWrapper(String id, Object o) {
            this.lable = id;
            this.obj = o;
        }

        protected String getLabel() {
            return this.lable;
        }

        protected Object getObject() {
            return this.obj;
        }

        public boolean equals(Object o) {
            if (o != null && o instanceof ResponseQueueObjectWrapper) {
                return ((ResponseQueueObjectWrapper)o).getLabel().equalsIgnoreCase(this.lable);
            }
            return false;
        }
    }

    protected static class SwitchToV4Request
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

