/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.transaction.xa;

import java.util.HashMap;
import java.util.Map;

public class XAResponseCodes {
    public static final int FATAL = -1;
    public static final int EMERGENCY = 0;
    public static final int ALERT = 1;
    public static final int CRITICAL = 2;
    public static final int ERROR = 3;
    public static final int WARNING = 4;
    public static final int NOTICE = 5;
    public static final int INFO = 6;
    public static final int DEBUG = 7;
    public static final int NONE = 8;
    public static final Map<Integer, Object[]> LogLevelData = XAResponseCodes.createLogLevelData();
    public static final int RETURN_ACTION = 0;
    public static final int DISCARD_ACTION = 1;
    public static final Map<Integer, String[]> ActionData = XAResponseCodes.createActionData();
    public static final int INVALID = 0;
    public static final int OK = 1;
    public static final int FAIL = 2;
    public static final int ROLLBACK = 3;
    public static final int IN_PROGRESS = 4;
    public static final int AD_NOT_READY = 5;
    public static final int EXCEEDED_MAX_SESSIONS = 6;
    public static final int XA_SESSION_ALREADY_EXISTS = 7;
    public static final int XA_SESSION_NOT_FOUND = 8;
    public static final int XA_SESSION_IS_LOCAL = 9;
    public static final int XA_SESSION_IS_ASSOCIATED = 10;
    public static final int XA_SESSION_IS_PROCESSING_REQUEST = 11;
    public static final int XA_TXN_ALREADY_EXISTS = 12;
    public static final int XA_TXN_NOT_FOUND = 13;
    public static final int XA_TXN_NOT_ASSOCIATED_TO_SESSION = 14;
    public static final int XA_TXN_NOT_ASSOCIATION_SUSPENDED = 15;
    public static final int XA_TXN_NOT_IDLE = 16;
    public static final int XA_TXN_NOT_PREPARED = 17;
    public static final int XA_TXN_NOT_HEURISTICALLY_COMPLETED = 18;
    public static final int XA_TXN_IDLE_TIMEOUT = 19;
    public static final int PUBLISHER_LAST_MSG_ID_MISMATCH = 20;
    public static final int SYSTEM_EXCEEDED_MAX_TXNS = 21;
    public static final int VPN_EXCEEDED_MAX_TXNS = 22;
    public static final int CLIENT_EXCEEDED_MAX_TXNS = 23;
    public static final int EXCEEDED_MAX_TXN_SIZE = 24;
    public static final int OUT_OF_TXN_RESOURCES = 25;
    public static final int ENDPOINT_MODIFIED_OR_DELETED = 26;
    public static final int ENDPOINT_QUOTA_EXCEEDED = 27;
    public static final int NO_PUB_ID_FOR_MSG = 28;
    public static final int XA_TXN_IS_ACTIVE = 29;
    public static final int XA_TXN_IS_HEURISTICALLY_COMMITED = 30;
    public static final int XA_TXN_IS_HEURISTICALLY_ROLLED_BACK = 31;
    public static final int XA_TXN_IS_PROCESSING_REQUEST = 32;
    public static final int EXCEEDED_MAX_SPOOL_UTILIZATION = 33;
    public static final int PUBLISHER_MSG_COUNT_MISMATCH = 34;
    public static final int NO_PUBLISHER_FLOW = 35;
    public static final int SUBSCRIBER_MSG_REASSIGNED = 36;
    public static final int XA_TXN_IS_ROLLBACK_ONLY = 37;
    public static final int SPOOL_QUOTA_EXCEEDED = 38;
    public static final int VPN_QUOTA_EXCEEDED = 39;
    public static final int QUEUE_NOT_FOUND = 40;
    public static final int NO_LOCAL_DISCARD = 41;
    public static final int NOT_COMPATIBLE_WITH_FORWARDING_MODE = 42;
    public static final int DOCUMENT_TOO_LARGE = 43;
    public static final int QUEUE_SHUTDOWN = 44;
    public static final int DTE_SHUTDOWN = 45;
    public static final int SMF_TTL_EXCEEDED = 46;
    public static final int REJECT_LOW_PRIORITY_MSG = 47;
    public static final int SPOOL_TO_DISK_FAIL = 48;
    public static final int SPOOL_FILE_LIMIT_EXCEEDED = 49;
    public static final int REPLICATION_IS_STANDBY = 50;
    public static final int SYNC_REPLICATION_INELIGIBLE = 51;
    public static final int ENDPOINT_OUT_OF_RESOURCES_ROLLBACK = 52;
    public static final int ENDPOINT_OUT_OF_RESOURCES_RETRY = 53;
    public static final int XA_JOIN_IS_NOT_SUPPORTED = 54;
    public static final int SUBSCRIBER_MSG_NOT_FOUND = 55;
    public static final int MISSING_PUBLISHER_MSGS = 56;
    public static final int EXTRA_PUBLISHER_MSGS = 57;
    public static final int INVALID_PUBLISHER_FLOW = 58;
    public static final int MISSING_PUBLISHER_MSGS_RETRY = 59;
    public static final int REPLICATION_TIMEOUT = 60;
    public static final int ACTIVE_XID_DURING_DR_FAILOVER = 61;
    public static final int UNBOUND_CONSUMER_FLOW = 62;
    public static final int REPLICATION_FAIL = 63;
    private static final Object[][] SubcodeDataArray = new Object[][]{{0, "INVALID"}, {1, "OK"}, {2, "FAIL"}, {3, "ROLLBACK"}, {4, "IN_PROGRESS"}, {5, "AD_NOT_READY"}, {6, "EXCEEDED_MAX_SESSIONS"}, {7, "XA_SESSION_ALREADY_EXISTS"}, {8, "XA_SESSION_NOT_FOUND"}, {9, "XA_SESSION_IS_LOCAL"}, {10, "XA_SESSION_IS_ASSOCIATED"}, {11, "XA_SESSION_IS_PROCESSING_REQUEST"}, {12, "XA_TXN_ALREADY_EXISTS"}, {13, "XA_TXN_NOT_FOUND"}, {14, "XA_TXN_NOT_ASSOCIATED_TO_SESSION"}, {15, "XA_TXN_NOT_ASSOCIATION_SUSPENDED"}, {16, "XA_TXN_NOT_IDLE"}, {17, "XA_TXN_NOT_PREPARED"}, {18, "XA_TXN_NOT_HEURISTICALLY_COMPLETED"}, {19, "XA_TXN_IDLE_TIMEOUT"}, {20, "PUBLISHER_LAST_MSG_ID_MISMATCH"}, {21, "SYSTEM_EXCEEDED_MAX_TXNS"}, {22, "VPN_EXCEEDED_MAX_TXNS"}, {23, "CLIENT_EXCEEDED_MAX_TXNS"}, {24, "EXCEEDED_MAX_TXN_SIZE"}, {25, "OUT_OF_TXN_RESOURCES"}, {26, "ENDPOINT_MODIFIED_OR_DELETED"}, {27, "ENDPOINT_QUOTA_EXCEEDED"}, {28, "NO_PUB_ID_FOR_MSG"}, {29, "XA_TXN_IS_ACTIVE"}, {30, "XA_TXN_IS_HEURISTICALLY_COMMITED"}, {31, "XA_TXN_IS_HEURISTICALLY_ROLLED_BACK"}, {32, "XA_TXN_IS_PROCESSING_REQUEST"}, {33, "EXCEEDED_MAX_SPOOL_UTILIZATION"}, {34, "PUBLISHER_MSG_COUNT_MISMATCH"}, {35, "NO_PUBLISHER_FLOW"}, {36, "SUBSCRIBER_MSG_REASSIGNED"}, {37, "XA_TXN_IS_ROLLBACK_ONLY"}, {38, "SPOOL_QUOTA_EXCEEDED"}, {39, "VPN_QUOTA_EXCEEDED"}, {40, "QUEUE_NOT_FOUND"}, {41, "NO_LOCAL_DISCARD"}, {42, "NOT_COMPATIBLE_WITH_FORWARDING_MODE"}, {43, "DOCUMENT_TOO_LARGE"}, {44, "QUEUE_SHUTDOWN"}, {45, "DTE_SHUTDOWN"}, {46, "SMF_TTL_EXCEEDED"}, {47, "REJECT_LOW_PRIORITY_MSG"}, {48, "SPOOL_TO_DISK_FAIL"}, {49, "SPOOL_FILE_LIMIT_EXCEEDED"}, {50, "REPLICATION_IS_STANDBY"}, {51, "SYNC_REPLICATION_INELIGIBLE"}, {52, "ENDPOINT_OUT_OF_RESOURCES_ROLLBACK"}, {53, "ENDPOINT_OUT_OF_RESOURCES_RETRY"}, {54, "XA_JOIN_IS_NOT_SUPPORTED"}, {55, "SUBSCRIBER_MSG_NOT_FOUND"}, {56, "MISSING_PUBLISHER_MSGS"}, {57, "EXTRA_PUBLISHER_MSGS"}, {58, "INVALID_PUBLISHER_FLOW"}, {59, "MISSING_PUBLISHER_MSGS_RETRY"}, {60, "REPLICATION_TIMEOUT"}, {61, "ACTIVE_XID_DURING_DR_FAILOVER"}, {62, "UNBOUND_CONSUMER_FLOW"}, {63, "REPLICATION_FAIL"}};
    public static final Map<Integer, String> SubcodeData = XAResponseCodes.createSubcodeData();
    private static final Object[][] ResponseCodeDataArray = new Object[][]{{100, "XA_RBROLLBACK", "The rollback was caused by an unspecified reason."}, {101, "XA_RBCOMMFAIL", "The rollback was caused by a communication failure."}, {102, "XA_RBDEADLOCK", "A deadlock was detected."}, {103, "XA_RBINTEGRITY", "A condition that violates the integrity of the resources was detected."}, {104, "XA_RBOTHER", "The resource manager rolled back the transaction branch for a reason not on this list."}, {105, "XA_RBPROTO", "A protocol error occurred in the resource manager."}, {106, "XA_RBTIMEOUT", "A transaction branch took too long."}, {107, "XA_RBTRANSIENT", "May retry the transaction branch."}, {9, "XA_NOMIGRATE", "Resumption must occur where suspension occurred."}, {8, "XA_HEURHAZ", "The transaction branch may have been heuristically completed."}, {7, "XA_HEURCOM", "The transaction branch has been heuristically committed."}, {6, "XA_HEURRB", "The transaction branch has been heuristically rolled back."}, {5, "XA_HEURMIX", "The transaction branch has been heuristically committed and rolled back."}, {4, "XA_RETRY", "Routine returned with no effect and may be reissued."}, {3, "XA_RDONLY", "The transaction branch was read-only and has been committed."}, {0, "XA_OK", "The transaction operation has been processed normally."}, {-3, "XAER_RMERR", "A resource manager error occurred in the transaction branch."}, {-4, "XAER_NOTA", "The XID is not valid."}, {-5, "XAER_INVAL", "Invalid arguments were given."}, {-6, "XAER_PROTO", "Routine invoked in an improper context."}, {-7, "XAER_RMFAIL", "Resource manager unavailable."}, {-8, "XAER_DUPID", "The XID already exists."}, {-9, "XAER_OUTSIDE", "Resource manager doing work outside global transaction."}};
    public static final Map<Integer, String[]> ResponseCodeData = XAResponseCodes.createResponseCodeData();

    private static Map<Integer, Object[]> createLogLevelData() {
        HashMap<Integer, Object[]> retMap = new HashMap<Integer, Object[]>();
        retMap.put(-1, new Object[]{null, "FATAL", ""});
        retMap.put(0, new Object[]{-1, "EMERGENCY", ""});
        retMap.put(1, new Object[]{-1, "ALERT", ""});
        retMap.put(2, new Object[]{-1, "CRITICAL", ""});
        retMap.put(3, new Object[]{null, "ERROR", ""});
        retMap.put(4, new Object[]{null, "WARNING", ""});
        retMap.put(5, new Object[]{6, "NOTICE", ""});
        retMap.put(6, new Object[]{null, "INFO", ""});
        retMap.put(7, new Object[]{null, "DEBUG", ""});
        retMap.put(8, new Object[]{null, "NONE", ""});
        return retMap;
    }

    public static String getLogLevelString(int logLevel) {
        Object[] params = LogLevelData.get(logLevel);
        if (params == null) {
            return String.valueOf(logLevel);
        }
        return (String)params[1];
    }

    public static String getMappedLogLevelString(int logLevel) {
        Object[] params = LogLevelData.get(logLevel);
        if (params == null) {
            return String.valueOf(logLevel);
        }
        if (params[0] == null) {
            return (String)params[1];
        }
        return XAResponseCodes.getLogLevelString((Integer)params[0]);
    }

    public static int getMappedLogLevel(int logLevel) {
        Object[] params = LogLevelData.get(logLevel);
        if (params == null) {
            return logLevel;
        }
        if (params[0] == null) {
            return logLevel;
        }
        return (Integer)params[0];
    }

    private static Map<Integer, String[]> createActionData() {
        HashMap<Integer, String[]> retMap = new HashMap<Integer, String[]>();
        retMap.put(0, new String[]{"RETURN", ""});
        retMap.put(1, new String[]{"DISCARD", ""});
        return retMap;
    }

    public static String getActionString(int action) {
        String[] params = ActionData.get(action);
        if (params == null) {
            return String.valueOf(action);
        }
        return params[0];
    }

    private static Map<Integer, String> createSubcodeData() {
        HashMap<Integer, String> retMap = new HashMap<Integer, String>();
        for (int i = 0; i < SubcodeDataArray.length; ++i) {
            Integer key = (Integer)SubcodeDataArray[i][0];
            String value = (String)SubcodeDataArray[i][1];
            retMap.put(key, value);
        }
        return retMap;
    }

    public static String getSubcodeString(int subcode) {
        String subCodeStr = SubcodeData.get(subcode);
        if (subCodeStr == null) {
            return String.valueOf(subcode);
        }
        return subCodeStr;
    }

    private static Map<Integer, String[]> createResponseCodeData() {
        HashMap<Integer, String[]> retMap = new HashMap<Integer, String[]>();
        for (int i = 0; i < ResponseCodeDataArray.length; ++i) {
            Integer key = (Integer)ResponseCodeDataArray[i][0];
            String[] value = new String[]{(String)ResponseCodeDataArray[i][1], (String)ResponseCodeDataArray[i][2]};
            retMap.put(key, value);
        }
        return retMap;
    }

    public static String getResponseCodeString(int respCode) {
        String[] params = ResponseCodeData.get(respCode);
        if (params == null) {
            return String.valueOf(respCode);
        }
        return params[0];
    }
}

