/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.smf.impl;

import com.solacesystems.common.util.BitTwiddleUtil;
import com.solacesystems.common.util.NetworkByteOrderNumberUtil;
import com.solacesystems.jcsmp.protocol.HeaderDescriptionBean;
import com.solacesystems.jcsmp.protocol.WireEncoder;
import com.solacesystems.jcsmp.protocol.smf.PubSubCtrlHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.SmfTLVParameter;
import com.solacesystems.jcsmp.protocol.smf.impl.GrowableByteBuffer;
import com.solacesystems.jcsmp.protocol.smf.impl.SMFNumericConstants;
import com.solacesystems.jcsmp.protocol.smf.impl.TlvCoderUtil;
import java.io.IOException;
import java.io.OutputStream;

public class PubSubCtrlHeaderEncoder
implements WireEncoder,
SMFNumericConstants {
    @Override
    public void encodeHeader(OutputStream out, HeaderDescriptionBean headerBean) throws IOException {
        if (!(headerBean instanceof PubSubCtrlHeaderBean)) {
            throw new IllegalArgumentException();
        }
        PubSubCtrlHeaderBean h = (PubSubCtrlHeaderBean)headerBean;
        GrowableByteBuffer buf = GrowableByteBuffer.allocate(h.getSmfEncodedLength() + 1);
        buf.clear();
        SmfTLVParameter[] paramArray = h.getParams();
        for (int i = 0; i < paramArray.length; ++i) {
            SmfTLVParameter param = paramArray[i];
            TlvCoderUtil.writeTlvParamAssuredCtrl(buf, param);
        }
        int position = buf.position();
        if ((position + 3) % 4 > 0) {
            for (int i = 0; i < 4 - (position + 3) % 4; ++i) {
                buf.put((byte)0);
            }
        }
        long onebyte = 0L;
        long twobytes = 0L;
        int lenBytes = 3 + buf.position();
        onebyte = BitTwiddleUtil.setBits(onebyte, h.getProtocolVersion(), 6, 0);
        twobytes = BitTwiddleUtil.setBits(twobytes, 0L, 4, 12);
        twobytes = BitTwiddleUtil.setBits(twobytes, lenBytes / 4, 12, 0);
        buf.flip();
        byte[] paramData = new byte[buf.limit()];
        buf.get(paramData);
        out.write(NetworkByteOrderNumberUtil.intToOneByte((int)onebyte));
        out.write(NetworkByteOrderNumberUtil.intToTwoByte((int)twobytes));
        if (paramData.length > 0) {
            out.write(paramData);
        }
        out.flush();
    }
}

