/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms;

import com.solacesystems.common.util.LogWrapper;
import com.solacesystems.jms.SolConnection;
import com.solacesystems.jms.SolXASession;
import com.solacesystems.jms.impl.SessionTransactionType;
import com.solacesystems.jms.impl.Validator;
import com.solacesystems.jms.property.JMSProperties;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.jms.XASession;

public class SolXAConnection
extends SolConnection
implements XAConnection {
    private static final LogWrapper log = new LogWrapper(SolXAConnection.class);

    SolXAConnection(JMSProperties properties) throws JMSException {
        super(properties, true);
        log.setContextInfo(this.getLogContextInfo());
    }

    SolXAConnection(JMSProperties properties, String username, String password) throws JMSException {
        super(properties, true, username, password);
        log.setContextInfo(this.getLogContextInfo());
    }

    public synchronized XASession createXASession() throws JMSException {
        if (log.isDebugEnabled()) {
            log.debug("Entering createXASession()");
        }
        this.checkClosed();
        Validator.checkTransactedAndAckMode(SessionTransactionType.XATransaction, 0, this.mConnectionProps.getPropertyBean().getDirectTransport());
        Validator.checkTransactedAndLargeMessaging(SessionTransactionType.XATransaction, this.mJCSMPProperties.getBooleanProperty("large_messaging"));
        this.mHasBeenAccessed = true;
        SolXASession newSession = new SolXASession(this, this.mState);
        this.mSessions.add(newSession);
        if (log.isDebugEnabled()) {
            log.debug("Leaving createXASession()");
        }
        return newSession;
    }
}

