/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.client;

import com.solacesystems.common.util.ThreadUtil;
import com.solacesystems.jcsmp.AccessDeniedException;
import com.solacesystems.jcsmp.Endpoint;
import com.solacesystems.jcsmp.JCSMPErrorResponseException;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPInterruptedException;
import com.solacesystems.jcsmp.JCSMPResponseListener;
import com.solacesystems.jcsmp.JCSMPResponseTimeoutException;
import com.solacesystems.jcsmp.impl.ContextImpl;
import com.solacesystems.jcsmp.impl.timers.JCSMPTimeoutHandler;
import com.solacesystems.jcsmp.impl.timers.JCSMPTimer;
import com.solacesystems.jcsmp.impl.timers.JCSMPTimerQueue;
import com.solacesystems.jcsmp.protocol.WireMessage;
import com.solacesystems.jcsmp.protocol.impl.TcpClientChannel;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClientRequestResponse
implements JCSMPTimeoutHandler {
    private WireMessage _request;
    private WireMessage _response;
    private final JCSMPTimerQueue _timerQueue;
    private CountDownLatch _responseLatch;
    private JCSMPException _opex;
    private volatile int _lastCorrelationTag;
    private volatile JCSMPTimer _timeoutTimer;
    private JCSMPResponseListener _listener;
    private Object _listenerCorrelationKey;
    private TcpClientChannel _channel;
    private Endpoint _endpoint;
    private static final Log Trace = LogFactory.getLog(ClientRequestResponse.class);

    public ClientRequestResponse(WireMessage request, ContextImpl ctx) {
        this._request = request;
        this._timerQueue = ctx.getIOReactor();
        this._responseLatch = new CountDownLatch(1);
        this._listener = null;
        this._listenerCorrelationKey = null;
        this._channel = null;
        this._endpoint = null;
        this._lastCorrelationTag = 0;
    }

    public ClientRequestResponse(WireMessage request, ContextImpl ctx, JCSMPResponseListener listener, Object listenerCorrelationKey, TcpClientChannel channel, Endpoint endpoint) {
        this._request = request;
        this._timerQueue = ctx.getIOReactor();
        this._responseLatch = new CountDownLatch(1);
        this._listener = listener;
        this._listenerCorrelationKey = listenerCorrelationKey;
        this._channel = channel;
        this._endpoint = endpoint;
        this._lastCorrelationTag = 0;
    }

    public WireMessage getRequest() {
        return this._request;
    }

    public void setRequest(WireMessage msg) {
        this._request = msg;
    }

    public Boolean isSynchRequest() {
        return this._listener == null;
    }

    public void execute(WireMessage response) {
        this.stopTimer();
        if (this.isSynchRequest().booleanValue()) {
            this._response = response;
            this._responseLatch.countDown();
        } else {
            try {
                if (this._channel != null) {
                    this._channel.checkSmpResponseOK(response);
                    this._listener.handleSuccess(this._listenerCorrelationKey);
                }
            }
            catch (JCSMPErrorResponseException e) {
                if (this._endpoint != null && e.getResponseCode() == 403 && e.getSubcodeEx() == 36) {
                    this._listener.handleError(this._listenerCorrelationKey, new AccessDeniedException(e.getResponsePhrase(), (Throwable)((Object)e)));
                    return;
                }
                this._listener.handleError(this._listenerCorrelationKey, (Exception)((Object)e));
            }
        }
    }

    public WireMessage getResponse() throws JCSMPException {
        block3: {
            try {
                this._responseLatch.await();
            }
            catch (InterruptedException e) {
                if (this._opex != null) break block3;
                this._opex = new JCSMPInterruptedException("GetReponse interrupted.", e);
            }
        }
        if (this._opex != null) {
            throw this._opex;
        }
        return this._response;
    }

    @Override
    public void handleTimeout() {
        if (this.isSynchRequest().booleanValue() && this._responseLatch.getCount() == 0L) {
            Trace.debug((Object)String.format("ClientRequestResponse:handleTimeout (%s) ignored (task inactive)", this.getLogDesc()));
            return;
        }
        String timeoutStr = "ClientRequestResponse Timeout " + this.getLogDesc();
        this.cancel(new JCSMPResponseTimeoutException(timeoutStr));
    }

    public void cancel(JCSMPException e) {
        Trace.debug((Object)String.format("ClientRequestResponse.cancel() (%s), msg=%s, stack=%s", this._request.getFriendlyName(), e.getMessage(), ThreadUtil.getMyStackTrace()));
        this.stopTimer();
        if (this.isSynchRequest().booleanValue()) {
            this._opex = e;
            this._responseLatch.countDown();
        } else {
            this._listener.handleError(this._listenerCorrelationKey, (Exception)((Object)e));
        }
    }

    public void startTimer(int timeout) {
        if (this._responseLatch.getCount() == 0L) {
            Trace.debug((Object)String.format("Starting request timer %s (%s ms) IGNORED (inactive)", this.getLogDesc(), timeout));
            return;
        }
        Trace.debug((Object)String.format("Starting request timer %s (%s ms)", this.getLogDesc(), timeout));
        if (this._timeoutTimer == null) {
            this._timeoutTimer = this._timerQueue.schedule_relative(timeout, this);
        }
    }

    public void stopTimer() {
        if (this._timeoutTimer != null) {
            Trace.debug((Object)String.format("Stopping request timer %s", this.getLogDesc()));
            this._timerQueue.cancelTimer(this._timeoutTimer);
            this._timeoutTimer = null;
        }
    }

    public int getLastCorrelationTag() {
        return this._lastCorrelationTag;
    }

    public void setLastCorrelationTag(int correlationTag) {
        this._lastCorrelationTag = correlationTag;
    }

    String getLogDesc() {
        if (this._request != null && this._request.getFriendlyName().length() > 0) {
            return String.format("(%s)", this._request.getFriendlyName());
        }
        return "()";
    }
}

