/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.transaction;

import com.solacesystems.common.util.LogWrapper;
import com.solacesystems.jcsmp.ClosedFacilityException;
import com.solacesystems.jcsmp.InvalidOperationException;
import com.solacesystems.jcsmp.JCSMPChannelProperties;
import com.solacesystems.jcsmp.JCSMPErrorResponseException;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPInterruptedException;
import com.solacesystems.jcsmp.StaleSessionException;
import com.solacesystems.jcsmp.impl.Closeable;
import com.solacesystems.jcsmp.impl.JCSMPBasicSession;
import com.solacesystems.jcsmp.impl.JCSMPXMLMessageProducer;
import com.solacesystems.jcsmp.impl.flow.FlowHandleImpl;
import com.solacesystems.jcsmp.impl.timers.JCSMPTimeoutHandler;
import com.solacesystems.jcsmp.impl.transaction.AdCtrlV4TSState;
import com.solacesystems.jcsmp.impl.transaction.BaseTransactedSessionImpl;
import com.solacesystems.jcsmp.impl.transaction.TimerSetter;
import com.solacesystems.jcsmp.impl.transaction.TransactedSessionImpl;
import com.solacesystems.jcsmp.impl.transaction.TransactedSessionManager;
import com.solacesystems.jcsmp.impl.transaction.TransactionSteps;
import com.solacesystems.jcsmp.management.SolJmxSupport;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlEnums;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlHeaderParameters;
import com.solacesystems.jcsmp.transaction.RollbackException;
import java.util.LinkedList;

public class AdCtrlV4TransactedSessionImpl
extends TransactedSessionImpl {
    private volatile long transactionTag = 0L;
    private final long sessionTag;
    private AdCtrlV4TSState.AdCtrlV4TSStorage session_state_storage = null;
    private volatile AdCtrlV4TSState transaction_state = null;
    private final LogWrapper Trace = new LogWrapper(AdCtrlV4TransactedSessionImpl.class);
    private volatile SessionState session_state = null;
    private final RefireRequestRequired refireRequest = new RefireRequestRequired();
    public final SessionState STATE_SESSION_DOWN;
    public final SessionState STATE_FLOW_UP;
    public final SessionState STATE_RETRANSMIT_DONE;
    public final SessionState STATE_SESSION_UP;
    public final SessionState STATE_CLOSED;
    public final SessionState STATE_ABORTED;

    public AdCtrlV4TransactedSessionImpl(TransactedSessionManager mgr, JCSMPChannelProperties channelProperties) {
        super(mgr, channelProperties);
        this.sessionTag = this.getTransactedSessionManager().getNextSessionTag();
        this.STATE_SESSION_DOWN = new StateDown(this);
        this.STATE_FLOW_UP = new StateFlowUp(this);
        this.STATE_RETRANSMIT_DONE = new StateRetransmitDone(this);
        this.STATE_SESSION_UP = new StateUp(this);
        this.STATE_CLOSED = new StateClosed(this);
        this.STATE_ABORTED = new StateAborted(this);
        this.session_state_storage = new AdCtrlV4TSState.AdCtrlV4TSStorage(this);
        this.Trace.setContextInfo(this.getLogContextInfo());
    }

    public LogWrapper getLogWrapper() {
        return this.Trace;
    }

    public String getLogContextInfo() {
        return this.getParentSession().getLogContextInfo() + ":session-" + this.sessionTag;
    }

    public AdCtrlV4TSState.AdCtrlV4TSStorage getSessionStateStorage() {
        return this.session_state_storage;
    }

    public long getCorrelationTag() {
        return this.transactionTag;
    }

    public long getNextCorrelationTag() {
        long oldTag = this.transactionTag;
        this.transactionTag = this.getTransactedSessionManager().getSubChannel().getGeneralSeqAllocator().getNext24b();
        if (this.transactionTag == oldTag) {
            this.transactionTag = this.getTransactedSessionManager().getSubChannel().getGeneralSeqAllocator().getNext24b();
        }
        return this.transactionTag;
    }

    public long getSessionTag() {
        return this.sessionTag;
    }

    @Override
    public void notifyVridChange() {
        if (!this.isUpgradeInProgress()) {
            super.notifyVridChange();
            if (!this.isDowngradeEnabled()) {
                this.transaction_state.notifyVridChange();
            }
        }
    }

    protected void updateTransactionState(AdCtrlV4TSState newstate) {
        if (this.isDowngradeEnabled()) {
            super.updateTransactionState(newstate.getStatusEnum());
        } else {
            if (this.transaction_state == null || this.transaction_state == newstate) {
                return;
            }
            this.Trace.debug("transaction state update " + this.toString() + (Object)((Object)this.transaction_state.getStatusEnum()) + "->" + (Object)((Object)newstate.getStatusEnum()));
            this.transaction_state = newstate;
            try {
                this.transaction_state.enter();
            }
            catch (JCSMPException e) {
                this.Trace.debug("updateTransactionState got exception: ", e);
            }
        }
    }

    protected void setV4TransactionState(AdCtrlV4TSState newstate) {
        this.Trace.debug("set transaction state: " + (Object)((Object)newstate.getStatusEnum()));
        this.transaction_state = newstate;
    }

    protected synchronized void updateSessionState(SessionState newstate) {
        if (this.session_state == newstate) {
            return;
        }
        this.Trace.debug("session state update " + this.toString() + this.session_state.toString() + "->" + newstate.toString());
        this.session_state = newstate;
        this.session_state.enter();
    }

    public AdCtrlV4TSState getTransactionState() {
        return this.transaction_state;
    }

    @Override
    public String toString() {
        if (this.isDowngradeEnabled()) {
            return super.toString();
        }
        return String.format("(TransactedSessionId:%s, Name:%s, CorrelationId:%s, downgrade:%s)", this.getTransactedSessionId(), this.getName(), this.getCorrelationTag(), this.isDowngradeEnabled());
    }

    public void notifySessionUp() {
        try {
            if (this.Trace.isDebugEnabled()) {
                this.Trace.debug("notifySessionUp(v4): transaction=" + (Object)((Object)this.transaction_state.getStatusEnum()));
            }
            this.transaction_state.notifySessionUp();
        }
        catch (JCSMPException e) {
            this.Trace.debug("notifySessionUp got exception: ", e);
        }
    }

    @Override
    public void notifyAdCtrlVersionChange(boolean downgrade) {
        if (downgrade) {
            if (this.Trace.isDebugEnabled()) {
                this.Trace.debug("notifyAdCtrlVersionChange (downgrade): sessionId=" + this.getTransactedSessionId() + "; " + (Object)((Object)this.transaction_state.getStatusEnum()));
            }
            this.transaction_state.notifyAdCtrlVersionChange(downgrade);
        } else {
            super.notifyAdCtrlVersionChange(downgrade);
            if (this.Trace.isDebugEnabled()) {
                this.Trace.debug("notifyAdCtrlVersionChange (upgrade): sessionId=" + this.getTransactedSessionId() + "; state=" + this.session_state.toString() + "; transaction=" + (Object)((Object)this.transaction_state.getStatusEnum()));
            }
        }
    }

    @Override
    public void notifyFlowRebindFinished() throws JCSMPException {
        if (this.isDowngradeEnabled()) {
            super.notifyFlowRebindFinished();
        } else {
            if (this.Trace.isDebugEnabled()) {
                this.Trace.debug("notifyFlowRebindFinished(v4): state=" + this.session_state.toString() + "; transaction=" + (Object)((Object)this.transaction_state.getStatusEnum()));
            }
            this.session_state.notifyFlowRebindFinished();
        }
    }

    @Override
    public void notifyPreReconnect() {
        if (this.isDowngradeEnabled()) {
            super.notifyPreReconnect();
        } else {
            if (this.Trace.isDebugEnabled()) {
                this.Trace.debug("notifyPreReconnect(v4): state=" + this.session_state.toString());
            }
            this.session_state.notifyPreReconnect();
        }
    }

    @Override
    public void notifyPreRetransmit() {
        if (this.isDowngradeEnabled()) {
            super.notifyPreRetransmit();
        } else {
            if (this.Trace.isDebugEnabled()) {
                this.Trace.debug("notifyPreRetransmit(v4): state=" + this.session_state.toString() + "; transaction=" + (Object)((Object)this.transaction_state.getStatusEnum()));
            }
            this.session_state.notifyPreRetransmit();
        }
    }

    @Override
    public void notifyPostRetransmit() {
        if (this.isDowngradeEnabled()) {
            super.notifyPostRetransmit();
        } else {
            if (this.Trace.isDebugEnabled()) {
                this.Trace.debug("notifyPostRetransmit(v4): state=" + this.session_state.toString());
            }
            this.session_state.notifyPostRetransmit();
        }
    }

    @Override
    public synchronized Integer getConnTag() {
        if (!this.isDowngradeEnabled()) {
            this.setConnTag(this._parentSessionMgr.subChannel.getConnCounterTag());
        }
        return super.getConnTag();
    }

    public void handleAdCtrlMessage(AssuredCtrlEnums.TransactionCtrlMessageType mtype, AssuredCtrlHeaderBean adctrl, long correlationId, int respCode, JCSMPErrorResponseException err_resp) {
        try {
            this.getTransactionState().handleAdCtrlResponse(mtype, adctrl, correlationId, respCode, err_resp);
        }
        catch (Exception e) {
            this.Trace.warn("Unexpected error occurred during handleAsyncAdCtrl. ", e);
            this.handleUnrecoverableException(AdCtrlV4TransactedSessionImpl.wrapInJCSMPException(e));
        }
    }

    @Override
    public void setRollbackOnly(FlowHandleImpl fh) {
        if (this.isDowngradeEnabled()) {
            return;
        }
        if (fh != null) {
            TransactionSteps.InputFlowInfo flowInfo = this.getTransactionInputSteps().get(fh);
            if (flowInfo != null) {
                if (this.Trace.isDebugEnabled()) {
                    this.Trace.debug("setRollbackOnly: sub flowId " + fh.getFlowId());
                }
                flowInfo.setRollbackOnly(true);
            } else if (this.Trace.isDebugEnabled()) {
                this.Trace.debug("setRollbackOnly fails as flow's InputFlowInfo is empty: flowId " + fh.getFlowId());
            }
        }
    }

    @Override
    public void setRollbackOnly(JCSMPXMLMessageProducer prod) {
        if (this.isDowngradeEnabled()) {
            return;
        }
        if (prod != null) {
            TransactionSteps.OutputFlowInfo prodInfo = this.getTransactionOutputSteps().get(prod);
            if (prodInfo != null) {
                if (this.Trace.isDebugEnabled()) {
                    this.Trace.debug("setRollbackOnly: pub flowId " + prod.getPubADManager().getFlowId());
                }
                prodInfo.setRollbackOnly(true);
            } else if (this.Trace.isDebugEnabled()) {
                this.Trace.debug("setRollbackOnly fails as producer's OutputFlowInfo is empty:  pub flowId " + prod.getPubADManager().getFlowId());
            }
        }
    }

    @Override
    public boolean isRollbackOnlySet(JCSMPXMLMessageProducer prod) {
        TransactionSteps.OutputFlowInfo prodInfo;
        if (!this.isDowngradeEnabled() && (prodInfo = this.getTransactionOutputSteps().get(prod)) != null) {
            if (this.Trace.isDebugEnabled()) {
                this.Trace.debug("isRollbackOnlySet:  " + prodInfo.isRollbackOnly() + "; flow=" + prod.getLogContextInfo());
            }
            return prodInfo.isRollbackOnly();
        }
        return false;
    }

    public void notifyCreatedOrResumed(String txSessionName, long txSessionId) {
        this.setName(txSessionName);
        this.setTransactedSessionId(txSessionId);
        if (this.session_state == null) {
            this.session_state = this.STATE_SESSION_UP;
            this.transaction_state = this.getSessionStateStorage().STATE_ACTIVE;
        }
        TimerSetter responseTimer = new TimerSetter(this.context.getIOReactor(), this.getResponseTimeout(), new JCSMPTimeoutHandler(){

            @Override
            public void handleTimeout() {
                try {
                    if (AdCtrlV4TransactedSessionImpl.this.isDowngradeEnabled()) {
                        if (AdCtrlV4TransactedSessionImpl.this.Trace.isDebugEnabled()) {
                            AdCtrlV4TransactedSessionImpl.this.Trace.debug("v3 request timeout");
                        }
                        AdCtrlV4TransactedSessionImpl.this.handleV3ResponseTimeout();
                    } else {
                        if (AdCtrlV4TransactedSessionImpl.this.Trace.isDebugEnabled()) {
                            AdCtrlV4TransactedSessionImpl.this.Trace.debug("v4 request timeout" + AdCtrlV4TransactedSessionImpl.this.transaction_state.toString());
                        }
                        AdCtrlV4TransactedSessionImpl.this.transaction_state.handleResponseTimeout();
                    }
                }
                catch (JCSMPException e) {
                    AdCtrlV4TransactedSessionImpl.this.Trace.debug("got exception: ", e);
                }
            }
        });
        this.setResponseTimer(responseTimer);
    }

    public void notifySessionResumed(long txSessionId, boolean isNewSession) throws JCSMPException {
        this.setTransactedSessionId(txSessionId);
        if (isNewSession) {
            this.transaction_state.notifyNewSessionCreated();
        }
        this.setUpgradeInProgressStatus(false);
    }

    @Override
    public void rollbackCurrentTransaction() {
        if (!this.isDowngradeEnabled()) {
            this.transaction_state.rollbackCommittingTransaction();
        }
    }

    public void notifyV3SessionResumed(long txSessionId, AssuredCtrlEnums.TransactedSessionState state, AssuredCtrlHeaderParameters.ParamTransactionId tid) throws JCSMPException {
        this.notifyPreReconnect();
        this.setTransactedSessionId(txSessionId);
        this.transaction_state.notifyV3SessionResumed(state, tid);
        this.setUpgradeInProgressStatus(false);
    }

    public void enqueueRefireRequest() {
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug("enqueueRefireRequest");
        }
        if (!this.responseQueueAdd(new TransactedSessionImpl.ResponseQueueObjectWrapper("RefireRequest", this.refireRequest))) {
            this.startResponseTimer();
        }
    }

    public void sendCommitRequest(boolean blockOnAppThread, Integer connId, long correlationId) throws JCSMPException {
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug(String.format("sendCommitRequest %s", this.toString()));
        }
        if (this.isDowngradeEnabled()) {
            this.sendCommitRequest(blockOnAppThread, connId);
        } else {
            this._parentSessionMgr.sendAdCtrlV4CommitRequest(this.getTransactedSessionId(), correlationId, this.getParamPubNotify(), this.getParamSubAck(), blockOnAppThread, connId);
        }
    }

    public void sendRollbackRequest(boolean blockOnAppThread, Integer connId, long correlationId) throws JCSMPException {
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug(String.format("sendRollbackRequest %s", this.toString()));
        }
        if (this.isDowngradeEnabled()) {
            this.sendRollbackRequest(blockOnAppThread, connId);
        } else {
            this._parentSessionMgr.sendAdCtrlV4RollbackRequest(this.getTransactedSessionId(), correlationId, blockOnAppThread, connId);
        }
    }

    @Override
    public void allowOperation(BaseTransactedSessionImpl.AllowedOperation op) throws InvalidOperationException {
        if (this.isDowngradeEnabled()) {
            super.allowOperation(op);
        } else {
            this.transaction_state.allowOperation(op);
        }
    }

    public void updateConnTag() {
        this.setConnTag(this._parentSessionMgr.subChannel.getConnCounterTag());
    }

    @Override
    public JCSMPBasicSession getParentSession() {
        return this._parentSessionMgr.getSession();
    }

    private void waitForTransactionResponse(String response_name) throws RollbackException, JCSMPException {
        try {
            Object response = null;
            while (response == null) {
                response = this.responseQueueTake();
                if (response instanceof RefireRequestRequired) {
                    try {
                        this.transaction_state.refireRequest();
                    }
                    catch (JCSMPException e1) {
                        this.Trace.debug("got exception: ", e1);
                    }
                    response = null;
                    continue;
                }
                if (!(response instanceof TransactedSessionImpl.SwitchToV4Request)) continue;
                this.Trace.debug("waitForTransactionResponse: SwitchToV4Request");
                response = null;
            }
            if (response instanceof JCSMPException) {
                throw (JCSMPException)response;
            }
            if (this.Trace.isDebugEnabled()) {
                this.Trace.debug(response_name + ": " + response.toString());
            }
        }
        catch (InterruptedException e) {
            this.Trace.warn("Thread interrupted unexpectedly in waiting for a " + response_name);
            JCSMPInterruptedException ex = new JCSMPInterruptedException("wait for commit response interrupted", e);
            this.handleInterruptedException(ex);
            throw ex;
        }
    }

    @Override
    public boolean isMarkedAsRollback() {
        if (this.isDowngradeEnabled()) {
            return false;
        }
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug("isMarkedAsRollback: " + this.transaction_state.toString());
        }
        return this.transaction_state.isMarkedAsRollback();
    }

    @Override
    public void commit() throws RollbackException, JCSMPException {
        JCSMPBasicSession session = this._parentSessionMgr.getSession();
        if (session != null) {
            session.waitUntilSessionReconnectDone("commit");
        }
        if (this.isDowngradeEnabled()) {
            try {
                this.commit_v3();
            }
            catch (TransactedSessionImpl.SwitchToV4Request e2) {
                this.waitForTransactionResponse("commit response");
            }
            return;
        }
        this.contextBlockingCheck();
        this.session_state.allowOperation();
        this.transaction_state.allowOperation(BaseTransactedSessionImpl.AllowedOperation.COMMIT);
        this.responseQueueClear();
        this.setConnTag(this._parentSessionMgr.subChannel.getConnCounterTag());
        this.transaction_state.doCommit();
        this.waitForTransactionResponse("commit response");
    }

    @Override
    public void rollback() throws JCSMPException {
        JCSMPBasicSession session = this._parentSessionMgr.getSession();
        if (session != null) {
            session.waitUntilSessionReconnectDone("rollback");
        }
        if (this.isDowngradeEnabled()) {
            try {
                this.rollback_v3();
            }
            catch (TransactedSessionImpl.SwitchToV4Request e2) {
                this.waitForTransactionResponse("rollback response");
            }
            return;
        }
        this.contextBlockingCheck();
        this.session_state.allowOperation();
        this.transaction_state.allowOperation(BaseTransactedSessionImpl.AllowedOperation.ROLLBACK);
        this.responseQueueClear();
        this.setConnTag(this._parentSessionMgr.subChannel.getConnCounterTag());
        this.transaction_state.doRollback();
        this.waitForTransactionResponse("rollback response");
    }

    @Override
    public void close() {
        try {
            JCSMPBasicSession session = this._parentSessionMgr.getSession();
            if (session != null) {
                session.waitUntilSessionReconnectDone("close");
            }
            if (this.isDowngradeEnabled()) {
                super.close();
                return;
            }
            this.transaction_state.notifySessionClosed();
        }
        catch (JCSMPException e) {
            this.Trace.debug("got exception: ", e);
        }
        SolJmxSupport.instance().deregister(this);
    }

    @Override
    public void handlePostAbortedReconnect(JCSMPException e) {
        if (this.isDowngradeEnabled()) {
            super.handlePostAbortedReconnect(e);
        } else {
            this.responseQueueAdd(new TransactedSessionImpl.ResponseQueueObjectWrapper("ReconnectAborted", e));
            this.updateSessionState(this.STATE_ABORTED);
            this.Trace.debug("handlePostAbortedReconnect: " + this.toString());
        }
    }

    protected class StateUp
    extends SessionState {
        public StateUp(AdCtrlV4TransactedSessionImpl parent) {
            super(parent);
        }

        @Override
        public void enter() {
            this.getTransactedSession().notifySessionUp();
        }

        @Override
        protected void notifySessionClosed() throws JCSMPException {
            this.getTransactedSession().updateSessionState(AdCtrlV4TransactedSessionImpl.this.STATE_CLOSED);
        }

        @Override
        protected void notifyPreReconnect() {
            if (this.getTransactedSession().sessionHasPubFlow().booleanValue()) {
                this.getTransactedSession().updateSessionState(AdCtrlV4TransactedSessionImpl.this.STATE_SESSION_DOWN);
            } else {
                this.getTransactedSession().updateSessionState(AdCtrlV4TransactedSessionImpl.this.STATE_RETRANSMIT_DONE);
            }
        }

        @Override
        protected void notifyPreRetransmit() {
            if (this.getTransactedSession().sessionHasPubFlow().booleanValue()) {
                this.getTransactedSession().updateSessionState(AdCtrlV4TransactedSessionImpl.this.STATE_FLOW_UP);
            }
        }

        public String toString() {
            return "Up";
        }
    }

    protected class StateClosed
    extends SessionState {
        public StateClosed(AdCtrlV4TransactedSessionImpl parent) {
            super(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void enter() {
            AdCtrlV4TransactedSessionImpl tsession = this.getTransactedSession();
            AdCtrlV4TransactedSessionImpl.this.Trace.debug(String.format("Closing TransactedSession (%s).", tsession.toString()));
            try {
                tsession.getTransactionState().notifySessionClosed();
            }
            catch (JCSMPException e) {
                AdCtrlV4TransactedSessionImpl.this.Trace.debug("got exception: ", e);
            }
            LinkedList to_close = new LinkedList();
            Object object = tsession.inputFlows;
            synchronized (object) {
                to_close.addAll(tsession.inputFlows);
            }
            object = tsession.outputFlows;
            synchronized (object) {
                to_close.addAll(tsession.outputFlows);
            }
            AdCtrlV4TransactedSessionImpl.this.Trace.debug(String.format("Transacted session (%s) closing; closing %s managed guaranteed delivery flows.", tsession.toString(), to_close.size()));
            for (Closeable obj : to_close) {
                try {
                    obj.close();
                }
                catch (Throwable t) {
                    AdCtrlV4TransactedSessionImpl.this.Trace.info("Error closing GD flow", t);
                }
            }
            tsession.processFlowsToClose();
            tsession.resetTransactionSteps();
            tsession._parentSessionMgr.closeAdCtrlV4TransactedSession(tsession);
            tsession._parentSessionMgr.removeManagedTransactedSession(tsession);
        }

        @Override
        protected void allowOperation() throws JCSMPException {
            AdCtrlV4TransactedSessionImpl tsession = this.getTransactedSession();
            if (tsession.marked_close_exception != null) {
                throw new StaleSessionException("Session is closed", tsession.marked_close_exception);
            }
            throw new ClosedFacilityException("Session is closed");
        }

        public String toString() {
            return "Closed";
        }
    }

    protected class StateAborted
    extends SessionState {
        public StateAborted(AdCtrlV4TransactedSessionImpl parent) {
            super(parent);
        }

        @Override
        public void enter() {
            AdCtrlV4TransactedSessionImpl tsession = this.getTransactedSession();
            AdCtrlV4TransactedSessionImpl.this.Trace.debug(String.format("Reconnect aborted (%s).", tsession.toString()));
            tsession._parentSessionMgr.removeManagedTransactedSession(tsession);
        }

        public String toString() {
            return "ReconnectAborted";
        }

        @Override
        protected void allowOperation() throws JCSMPException {
            throw this.getTransactedSession()._parentSessionMgr.getSession().getSessionAbortException();
        }
    }

    protected class StateRetransmitDone
    extends SessionState {
        public StateRetransmitDone(AdCtrlV4TransactedSessionImpl parent) {
            super(parent);
        }

        @Override
        protected void notifySessionClosed() throws JCSMPException {
            this.getTransactedSession().updateSessionState(AdCtrlV4TransactedSessionImpl.this.STATE_CLOSED);
        }

        @Override
        protected void notifyPreReconnect() {
            if (this.getTransactedSession().sessionHasPubFlow().booleanValue()) {
                this.getTransactedSession().updateSessionState(AdCtrlV4TransactedSessionImpl.this.STATE_SESSION_DOWN);
            }
        }

        @Override
        protected void notifyFlowRebindFinished() {
            this.getTransactedSession().updateSessionState(AdCtrlV4TransactedSessionImpl.this.STATE_SESSION_UP);
        }

        public String toString() {
            return "RetransmitDone";
        }
    }

    protected class StateFlowUp
    extends SessionState {
        public StateFlowUp(AdCtrlV4TransactedSessionImpl parent) {
            super(parent);
        }

        @Override
        protected void notifySessionClosed() throws JCSMPException {
            this.getTransactedSession().updateSessionState(AdCtrlV4TransactedSessionImpl.this.STATE_CLOSED);
        }

        @Override
        protected void notifyPreReconnect() {
            if (this.getTransactedSession().sessionHasPubFlow().booleanValue()) {
                this.getTransactedSession().updateSessionState(AdCtrlV4TransactedSessionImpl.this.STATE_SESSION_DOWN);
            } else {
                this.getTransactedSession().updateSessionState(AdCtrlV4TransactedSessionImpl.this.STATE_RETRANSMIT_DONE);
            }
        }

        @Override
        protected void notifyPostRetransmit() {
            this.getTransactedSession().updateSessionState(AdCtrlV4TransactedSessionImpl.this.STATE_SESSION_UP);
        }

        public String toString() {
            return "FlowUp";
        }
    }

    protected class StateDown
    extends SessionState {
        public StateDown(AdCtrlV4TransactedSessionImpl parent) {
            super(parent);
        }

        @Override
        protected void notifySessionClosed() throws JCSMPException {
            this.getTransactedSession().updateSessionState(AdCtrlV4TransactedSessionImpl.this.STATE_CLOSED);
        }

        @Override
        protected void notifyFlowRebindFinished() {
            this.getTransactedSession().updateSessionState(AdCtrlV4TransactedSessionImpl.this.STATE_FLOW_UP);
        }

        @Override
        protected void notifyPostRetransmit() {
            this.getTransactedSession().updateSessionState(AdCtrlV4TransactedSessionImpl.this.STATE_RETRANSMIT_DONE);
        }

        public String toString() {
            return "Down";
        }
    }

    protected abstract class SessionState {
        private AdCtrlV4TransactedSessionImpl parentSession;

        protected SessionState(AdCtrlV4TransactedSessionImpl parent) {
            this.parentSession = parent;
        }

        protected AdCtrlV4TransactedSessionImpl getTransactedSession() {
            return this.parentSession;
        }

        protected void enter() {
        }

        protected void notifyPreReconnect() {
        }

        protected void notifyFlowRebindFinished() {
        }

        protected void notifyPreRetransmit() {
        }

        protected void notifyPostRetransmit() {
        }

        protected void notifySessionClosed() throws JCSMPException {
        }

        protected void allowOperation() throws JCSMPException {
        }
    }

    private static class RefireRequestRequired
    extends Exception {
        private static final long serialVersionUID = 1L;

        @Override
        public String toString() {
            return "RefireRequestRequired";
        }
    }
}

