/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.flow;

import com.solacesystems.common.util.LogWrapper;
import com.solacesystems.jcsmp.JCSMPErrorResponseException;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPInterruptedException;
import com.solacesystems.jcsmp.impl.JCSMPErrorResponseSubcodeMapper;
import com.solacesystems.jcsmp.impl.flow.FlowTask;
import com.solacesystems.jcsmp.impl.flow.TaskSessionRefs;
import com.solacesystems.jcsmp.protocol.WireMessage;
import com.solacesystems.jcsmp.protocol.impl.TcpChannel;
import com.solacesystems.jcsmp.protocol.smf.SMFHeaderBean;

public class UnsubscribeRequestTask
extends FlowTask {
    private final LogWrapper Trace = new LogWrapper(UnsubscribeRequestTask.class);
    private final String dteName;

    public UnsubscribeRequestTask(String dteName, TaskSessionRefs t_refs) {
        super(null, t_refs);
        this.dteName = dteName;
        if (t_refs.getChannel() != null) {
            this.Trace.setContextInfo(t_refs.getChannel().getLogContextInfo());
        }
    }

    @Override
    public Object execute(Object obj) {
        this.Trace.debug("Executing response handler.");
        this.cancelTimer();
        assert (obj instanceof WireMessage);
        WireMessage respMsg = (WireMessage)obj;
        SMFHeaderBean smfHeader = respMsg.getSmfHeader();
        assert (smfHeader.getProtocol() == 9);
        if (smfHeader.getPm_respcode() != 200) {
            String networkInfoString = "";
            if (this.subFlowMgr != null && this.subFlowMgr.subChannel != null) {
                networkInfoString = this.subFlowMgr.subChannel.getNetworkInfoString();
            }
            this.opEx = new JCSMPErrorResponseException(smfHeader.getPm_respcode(), smfHeader.getPm_respstr(), "", networkInfoString, JCSMPErrorResponseSubcodeMapper.ErrorContext.CONTROL);
            if (this.Trace.isInfoEnabled()) {
                this.Trace.info("Error Response (" + smfHeader.getPm_respcode() + ") - " + smfHeader.getPm_respstr());
            }
            this.Trace.debug("Got unsubscribe exception. ", this.opEx);
        } else {
            this.Trace.debug("Got OK UnsubscribeResponse");
        }
        this.responseLatch.countDown();
        return null;
    }

    @Override
    public boolean submit(int corrTag, boolean allowOnStateSub, TcpChannel.WriteBlockPolicy wpolicy) throws JCSMPException {
        this.initTimerFlag();
        this.taskRefs.getChannel().sendUnsubscribeRequest(this.dteName, corrTag, allowOnStateSub, wpolicy);
        this.startTimer();
        return true;
    }

    public void waitResponse() throws JCSMPException {
        block3: {
            try {
                this.responseLatch.await();
            }
            catch (InterruptedException e) {
                if (this.opEx != null) break block3;
                this.opEx = new JCSMPInterruptedException("waitResponse interrupted.", e);
            }
        }
        if (this.opEx != null) {
            throw this.opEx;
        }
    }
}

