/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.secure;

import com.solacesystems.common.HostInfo;
import com.solacesystems.jcsmp.InvalidPropertiesException;
import com.solacesystems.jcsmp.JCSMPProperties;
import com.solacesystems.jcsmp.secure.AuthSSLX509TrustManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertPathParameters;
import java.security.cert.CertSelector;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SecureProperties {
    private static final Log Trace = LogFactory.getLog(SecureProperties.class);
    public static final String[] SupportedProtocols = new String[]{"SSLv3", "TLSv1", "TLSv1.1", "TLSv1.2"};
    public static final String[] SupportedJSSECipherNamesArray = new String[]{"TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_AES_256_CBC_SHA256", "TLS_RSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA256", "TLS_RSA_WITH_AES_128_CBC_SHA", "SSL_RSA_WITH_RC4_128_SHA", "SSL_RSA_WITH_RC4_128_MD5", "TLS_RSA_WITH_AES_128_GCM_SHA256", "TLS_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384"};
    public static final String SupportedJSSECipherNamesString = SecureProperties.initializeJSSECipherNamesString();
    public static final ArrayList<String> SupportedJSSECipherNamesList = SecureProperties.initializeJSSECipherNamesList();
    public static final String[][] SupportedCipherAliases = new String[][]{{"ECDHE-RSA-AES256-SHA384", "SSL_ECDHE_RSA_WITH_AES_256_CBC_SHA384"}, {"ECDHE-RSA-AES256-SHA", "SSL_ECDHE_RSA_WITH_AES_256_CBC_SHA"}, {"AES256-SHA256", "SSL_RSA_WITH_AES_256_CBC_SHA256"}, {"AES256-SHA", "SSL_RSA_WITH_AES_256_CBC_SHA"}, {"ECDHE-RSA-DES-CBC3-SHA", "SSL_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA"}, {"DES-CBC3-SHA"}, {"ECDHE-RSA-AES128-SHA256", "SSL_ECDHE_RSA_WITH_AES_128_CBC_SHA256"}, {"ECDHE-RSA-AES128-SHA", "SSL_ECDHE_RSA_WITH_AES_128_CBC_SHA"}, {"AES128-SHA256", "SSL_RSA_WITH_AES_128_CBC_SHA256"}, {"AES128-SHA", "SSL_RSA_WITH_AES_128_CBC_SHA"}, {"RC4-SHA"}, {"RC4-MD5"}, {"AES128-GCM-SHA256", "SSL_RSA_WITH_AES_128_GCM_SHA256"}, {"AES256-GCM-SHA384", "SSL_RSA_WITH_AES_256_GCM_SHA384"}, {"ECDHE-RSA-AES128-GCM-SHA256", "SSL_ECDHE_RSA_WITH_AES_128_GCM_SHA256"}, {"ECDHE-RSA-AES256-GCM-SHA384", "SSL_ECDHE_RSA_WITH_AES_256_GCM_SHA384"}};
    public static final HashMap<String, String> CipherMap = SecureProperties.initializeCipherMap();
    public static final HashMap<String, String[]> CipherAliasesMap = SecureProperties.initializeCipherAliasesMap();
    private boolean mNonSecureInHostList = false;
    private boolean mUsingSecure = false;
    private String mProtocolsStr = null;
    private String[] mProtocols = null;
    private String mTrustStoreName = null;
    private String mTrustStoreFmt = null;
    private String mTrustStorePwd = null;
    private String mCipherSuitesStr = null;
    private String[] mCipherSuites = null;
    private ArrayList<String> mCipherSuitesList = null;
    private String mCommonNamesStr = null;
    private String[] mCommonNames = null;
    private boolean mValidateCert = false;
    private boolean mValidateCertDate = false;
    private KeyStore mTrustStore = null;
    private TrustManager[] mTrustManagers = null;
    private CertPathParameters mCertPathParameters = null;
    private String mKeyStoreFmt = null;
    private String mKeyStoreNormalizedFmt = null;
    private KeyStore mKeyStore = null;
    private String mKeyStoreName = null;
    private String mKeyStorePwd = null;
    private String mPrivateKeyAlias = null;
    private String mPrivateKeyPwd = null;
    private KeyManager[] mKeyManagers = null;
    private String mAuthenticationScheme = null;
    private boolean mFoundAtLeastOnePrivateKey = false;
    private String mSslDowngradeProto = null;

    private static String initializeJSSECipherNamesString() {
        StringBuilder bldr = new StringBuilder();
        for (int i = 0; i < SupportedJSSECipherNamesArray.length; ++i) {
            if (i > 0) {
                bldr.append(',');
            }
            bldr.append(SupportedJSSECipherNamesArray[i]);
        }
        return bldr.toString();
    }

    private static ArrayList<String> initializeJSSECipherNamesList() {
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 0; i < SupportedJSSECipherNamesArray.length; ++i) {
            l.add(SupportedJSSECipherNamesArray[i]);
        }
        return l;
    }

    private static HashMap<String, String> initializeCipherMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < SupportedJSSECipherNamesArray.length; ++i) {
            String cipher = SupportedJSSECipherNamesArray[i];
            map.put(cipher, cipher);
            String[] aliases = SupportedCipherAliases[i];
            if (aliases == null) continue;
            for (int j = 0; j < aliases.length; ++j) {
                map.put(aliases[j], cipher);
            }
        }
        return map;
    }

    private static HashMap<String, String[]> initializeCipherAliasesMap() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        for (int i = 0; i < SupportedJSSECipherNamesArray.length; ++i) {
            String cipher = SupportedJSSECipherNamesArray[i];
            String[] aliases = SupportedCipherAliases[i];
            if (aliases == null) continue;
            map.put(cipher, aliases);
        }
        return map;
    }

    public SecureProperties(JCSMPProperties props) throws InvalidPropertiesException {
        List<HostInfo> hostInfoList;
        String host = props.getStringProperty("host");
        this.mSslDowngradeProto = props.getStringProperty("SSL_CONNECTION_DOWNGRADE_TO");
        try {
            hostInfoList = HostInfo.toHostInfoList(host);
        }
        catch (Exception e) {
            throw new InvalidPropertiesException(e.getMessage(), e);
        }
        for (HostInfo info : hostInfoList) {
            if (info.isSecure()) {
                this.mUsingSecure = true;
            }
            if (info.isSecure()) continue;
            this.mNonSecureInHostList = true;
        }
        this.mAuthenticationScheme = props.getStringProperty("AUTHENTICATION_SCHEME");
        this.mProtocolsStr = props.getStringProperty("SSL_PROTOCOL");
        this.initProtocols(this.mProtocolsStr, props.getStringProperty("SSL_EXCLUDED_PROTOCOLS"));
        if (props.isTrustStoreSet()) {
            this.initTrustStore(props.getStringProperty("SSL_TRUST_STORE"));
        }
        this.initTrustStoreFormat(props.getStringProperty("SSL_TRUST_STORE_FORMAT"));
        this.initTrustStorePassword(props.getStringProperty("SSL_TRUST_STORE_PASSWORD"));
        this.initKeyStore(props.getStringProperty("SSL_KEY_STORE"));
        this.initKeyStoreFormat(props.getStringProperty("SSL_KEY_STORE_FORMAT"));
        this.initKeyStoreNormalizedFormat(props.getStringProperty("SSL_KEY_STORE_NORMALIZED_FORMAT"));
        this.initKeyStorePassword(props.getStringProperty("SSL_KEY_STORE_PASSWORD"));
        this.initPrivateKeyAlias(props.getStringProperty("SSL_PRIVATE_KEY_ALIAS"));
        this.initPrivateKeyPassword(props.getStringProperty("SSL_PRIVATE_KEY_PASSWORD"));
        this.mCipherSuitesStr = props.getStringProperty("SSL_CIPHER_SUITES");
        this.initCipherList(this.mCipherSuitesStr);
        this.mCommonNamesStr = props.getStringProperty("SSL_TRUSTED_COMMON_NAME_LIST");
        this.initCommonNames(this.mCommonNamesStr);
        this.initValidateCerts(props.getBooleanProperty("SSL_VALIDATE_CERTIFICATE"));
        this.initValidateCertsDate(props.getBooleanProperty("SSL_VALIDATE_CERTIFICATE_DATE"));
        if (this.usingSecure() && this.mValidateCert && (this.getTrustStoreName() == null || this.getTrustStoreName().trim().length() == 0)) {
            throw new InvalidPropertiesException("Trust Store must be specified when validating certificates");
        }
        if (this.nonSecureInHostList() && this.mAuthenticationScheme != null) {
            if (this.mAuthenticationScheme.equals("AUTHENTICATION_SCHEME_CLIENT_CERTIFICATE")) {
                throw new InvalidPropertiesException("Client Certificate Authenticate is supported only for SSL secured schemes");
            }
            if (this.mAuthenticationScheme.equals("AUTHENTICATION_SCHEME_OAUTH2")) {
                throw new InvalidPropertiesException("OAuth 2.0 based Authentication is supported only for SSL secured schemes");
            }
        }
        if ("AUTHENTICATION_SCHEME_CLIENT_CERTIFICATE".equals(this.mAuthenticationScheme) && (this.mKeyStoreName == null || this.mKeyStoreName.trim().length() == 0)) {
            throw new InvalidPropertiesException("Key Store must be specified when client certificate authentication scheme is used");
        }
    }

    public boolean nonSecureInHostList() {
        return this.mNonSecureInHostList;
    }

    public boolean usingSecure() {
        return this.mUsingSecure;
    }

    public String getSslDowngradeProtocol() {
        return this.mSslDowngradeProto;
    }

    public boolean isSslDowngradeEnabled() {
        return this.mSslDowngradeProto.equals("PLAIN_TEXT");
    }

    public String[] getProtocols() {
        return this.mProtocols;
    }

    public String getTrustStoreName() {
        if (this.mTrustStoreName == null) {
            String separator = File.separator;
            String javaHome = System.getProperty("java.home");
            this.mTrustStoreName = javaHome + separator + "lib" + separator + "security" + separator + "cacerts";
            String jssecacerts = javaHome + separator + "lib" + separator + "security" + separator + "jssecacerts";
            File file = new File(jssecacerts);
            try {
                if (file.exists()) {
                    this.mTrustStoreName = jssecacerts;
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return this.mTrustStoreName;
    }

    public String getTrustStoreFmt() {
        return this.mTrustStoreFmt;
    }

    public String getTrustStorePwd() {
        return this.mTrustStorePwd;
    }

    public String getKeyStoreFmt() {
        return this.mKeyStoreFmt;
    }

    public String getKeyStoreNormalizedFmt() {
        return this.mKeyStoreNormalizedFmt;
    }

    public KeyStore getKeyStore() {
        return this.mKeyStore;
    }

    public String getKeyStoreName() {
        return this.mKeyStoreName;
    }

    public String getKeyStorePwd() {
        return this.mKeyStorePwd;
    }

    public String getPrivateKeyAlias() {
        return this.mPrivateKeyAlias;
    }

    public String getPrivateKeyPwd() {
        return this.mPrivateKeyPwd;
    }

    public String[] getCipherSuites() {
        return this.mCipherSuites;
    }

    public List<String> getCipherSuitesList() {
        return this.mCipherSuitesList;
    }

    public String[] getCommonNames() {
        return this.mCommonNames;
    }

    public boolean validateCertificate() {
        return this.mValidateCert;
    }

    public boolean validateCertificateDate() {
        return this.mValidateCertDate;
    }

    public KeyStore getTrustStore() {
        return this.mTrustStore;
    }

    public TrustManager[] getTrustManagers() {
        return this.mTrustManagers;
    }

    public KeyManager[] getKeyManagers() {
        return this.mKeyManagers;
    }

    public CertPathParameters getCertPathParameters() {
        return this.mCertPathParameters;
    }

    public void loadTrustStore() throws InvalidPropertiesException {
        if (this.mValidateCert) {
            try {
                this.mTrustStore = this.createKeyStore(this.getTrustStoreName(), this.mTrustStorePwd, this.mTrustStoreFmt, null, null);
            }
            catch (Exception e) {
                throw new InvalidPropertiesException("Unable to load trust store: " + this.mTrustStoreName, e);
            }
        }
        try {
            this.mTrustManagers = this.createTrustManagers(this.mTrustStore);
        }
        catch (Exception e) {
            throw new InvalidPropertiesException("Unable to create trust manager", e);
        }
    }

    public void loadKeyStore() throws InvalidPropertiesException {
        if (this.mKeyStoreName != null) {
            if (this.mPrivateKeyPwd == null && this.mKeyStorePwd == null) {
                throw new InvalidPropertiesException("At least one of the private key password or key store password properties must be specified.");
            }
            try {
                this.mFoundAtLeastOnePrivateKey = false;
                this.mKeyStore = this.createKeyStore(this.mKeyStoreName, this.mKeyStorePwd, this.mKeyStoreFmt, this.mPrivateKeyAlias, this.mPrivateKeyPwd);
            }
            catch (InvalidPropertiesException e) {
                throw e;
            }
            catch (Exception e) {
                throw new InvalidPropertiesException("Unable to load key store", e);
            }
            this.checkKeyStore(this.mKeyStore, this.mKeyStorePwd != null ? this.mKeyStorePwd : this.mPrivateKeyPwd);
            try {
                this.mKeyManagers = this.createKeyManagers(this.mKeyStore, this.mKeyStorePwd != null ? this.mKeyStorePwd : this.mPrivateKeyPwd);
            }
            catch (Exception e) {
                throw new InvalidPropertiesException("Unable to create key manager", e);
            }
        }
    }

    public void initCertPathParameters() throws InvalidPropertiesException {
        if (this.mValidateCert) {
            try {
                PKIXBuilderParameters params = new PKIXBuilderParameters(this.mTrustStore, (CertSelector)new X509CertSelector());
                params.setRevocationEnabled(false);
                this.mCertPathParameters = params;
            }
            catch (InvalidAlgorithmParameterException e) {
                if (this.mValidateCert) {
                    throw new InvalidPropertiesException("Unable to initialize certificate path parameters from trust store", e);
                }
            }
            catch (Exception e) {
                throw new InvalidPropertiesException("Unable to initialize certificate path parameters from trust store", e);
            }
        }
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        if (this.usingSecure()) {
            bldr.append("secure=true");
            bldr.append(",protocols=[");
            bldr.append(this.mProtocolsStr);
            bldr.append("],trustStore=");
            bldr.append(this.getTrustStoreName());
            bldr.append(",trustStoreFmt=");
            bldr.append(this.mTrustStoreFmt);
            bldr.append(",keyStoreName=");
            bldr.append(this.mKeyStoreName);
            bldr.append(",keyStoreFmt=");
            bldr.append(this.mKeyStoreFmt);
            bldr.append(",cipherSuite=[");
            bldr.append(this.mCipherSuitesStr);
            bldr.append("],commonNames=[");
            bldr.append(this.mCommonNamesStr);
            bldr.append("],validateCertificates=");
            bldr.append(this.mValidateCert);
            bldr.append(",validateCertificateDates=");
            bldr.append(this.mValidateCertDate);
        } else {
            bldr.append("secure=false");
        }
        return bldr.toString();
    }

    private void initProtocols(String protocols, String exclProtocols) throws InvalidPropertiesException {
        int i;
        String[] tmpExclProtocols;
        String[] emptyExclProtocols = new String[]{};
        String[] tmpProtocols = null;
        if (protocols == null || protocols.length() == 0) {
            tmpProtocols = SupportedProtocols;
        } else {
            if (protocols.startsWith(",") || protocols.endsWith(",")) {
                throw new InvalidPropertiesException(String.format("Unknown or unsupported protocol name \"\" in protocols \"%s\"", protocols));
            }
            tmpProtocols = protocols.split(",");
            if (tmpProtocols.length == 0) {
                throw new InvalidPropertiesException("Unknown or unsupported protocol name \"" + protocols + "\"");
            }
        }
        if (exclProtocols == null || exclProtocols.trim().length() == 0) {
            tmpExclProtocols = emptyExclProtocols;
        } else {
            if (exclProtocols.trim().startsWith(",") || exclProtocols.trim().endsWith(",")) {
                throw new InvalidPropertiesException(String.format("Unknown or unsupported protocol name \"\" in excluded protocols \"%s\"", exclProtocols));
            }
            tmpExclProtocols = exclProtocols.split(",");
        }
        boolean[] protocolPresent = new boolean[SupportedProtocols.length];
        int numProtocolsPresent = 0;
        for (i = 0; i < SupportedProtocols.length; ++i) {
            protocolPresent[i] = false;
        }
        for (i = 0; i < tmpProtocols.length; ++i) {
            String protocol = tmpProtocols[i].trim().toUpperCase();
            boolean found = false;
            for (int j = 0; j < SupportedProtocols.length; ++j) {
                if (!SupportedProtocols[j].toUpperCase().equals(protocol)) continue;
                if (!protocolPresent[j]) {
                    protocolPresent[j] = true;
                    ++numProtocolsPresent;
                }
                found = true;
                break;
            }
            if (found) continue;
            this.mProtocols = null;
            throw new InvalidPropertiesException("Unknown or unsupported protocol name \"" + tmpProtocols[i] + "\"");
        }
        boolean isProtocolDefaultValue = numProtocolsPresent == SupportedProtocols.length;
        for (int i2 = 0; i2 < tmpExclProtocols.length; ++i2) {
            String protocol = tmpExclProtocols[i2].trim().toUpperCase();
            boolean found = false;
            for (int j = 0; j < SupportedProtocols.length; ++j) {
                if (!SupportedProtocols[j].toUpperCase().equals(protocol)) continue;
                if (protocolPresent[j]) {
                    protocolPresent[j] = false;
                    --numProtocolsPresent;
                }
                found = true;
                break;
            }
            if (found) {
                if (isProtocolDefaultValue) continue;
                throw new InvalidPropertiesException("Only one of the properties SSL_PROTOCOL and SSL_EXCLUDED_PROTOCOLS can be specified");
            }
            this.mProtocols = null;
            throw new InvalidPropertiesException("Unknown or unsupported protocol name \"" + tmpExclProtocols[i2] + "\"");
        }
        if (numProtocolsPresent == 0) {
            throw new InvalidPropertiesException("All protocol names excluded");
        }
        int idx = 0;
        this.mProtocols = new String[numProtocolsPresent];
        for (int i3 = 0; i3 < SupportedProtocols.length; ++i3) {
            if (!protocolPresent[i3]) continue;
            this.mProtocols[idx] = SupportedProtocols[i3];
            ++idx;
        }
    }

    private void initTrustStore(String trustStore) {
        this.mTrustStoreName = trustStore;
    }

    private void initTrustStoreFormat(String trustStoreFmt) {
        this.mTrustStoreFmt = trustStoreFmt;
    }

    private void initTrustStorePassword(String trustStorePwd) {
        this.mTrustStorePwd = trustStorePwd;
    }

    private void initKeyStore(String keyStore) {
        this.mKeyStoreName = keyStore;
    }

    private void initKeyStoreFormat(String keyStoreFmt) {
        this.mKeyStoreFmt = keyStoreFmt;
    }

    private void initKeyStoreNormalizedFormat(String keyStoreNormalizedFormat) {
        this.mKeyStoreNormalizedFmt = keyStoreNormalizedFormat.trim().length() > 0 ? keyStoreNormalizedFormat.trim() : keyStoreNormalizedFormat;
    }

    private void initKeyStorePassword(String trustStorePwd) {
        this.mKeyStorePwd = trustStorePwd;
    }

    private void initPrivateKeyAlias(String alias) {
        this.mPrivateKeyAlias = alias;
    }

    private void initPrivateKeyPassword(String password) {
        this.mPrivateKeyPwd = password;
    }

    private void initCipherList(String ciphers) throws InvalidPropertiesException {
        this.mCipherSuitesList = new ArrayList();
        if (ciphers == null || ciphers.length() == 0) {
            this.mCipherSuites = SupportedJSSECipherNamesArray;
            this.mCipherSuitesList = SupportedJSSECipherNamesList;
            return;
        }
        if (ciphers.startsWith(",") || ciphers.endsWith(",")) {
            throw new InvalidPropertiesException("Unknown or unsupported cipher name \"\"");
        }
        String[] tmpCiphers = ciphers.split(",");
        if (tmpCiphers.length == 0) {
            throw new InvalidPropertiesException("Unknown or unsupported cipher name \"" + ciphers + "\"");
        }
        this.mCipherSuitesList = new ArrayList(tmpCiphers.length);
        HashSet<String> cipherSet = new HashSet<String>();
        for (int i = 0; i < tmpCiphers.length; ++i) {
            String cipher = CipherMap.get(tmpCiphers[i].trim().toUpperCase());
            if (cipher == null) {
                this.mCipherSuites = null;
                this.mCipherSuitesList = null;
                throw new InvalidPropertiesException("Unknown or unsupported cipher name \"" + tmpCiphers[i] + "\"");
            }
            if (cipherSet.contains(cipher)) continue;
            this.mCipherSuitesList.add(cipher);
            cipherSet.add(cipher);
        }
        this.mCipherSuites = new String[this.mCipherSuitesList.size()];
        this.mCipherSuites = this.mCipherSuitesList.toArray(this.mCipherSuites);
    }

    private void initCommonNames(String commonNames) throws InvalidPropertiesException {
        if (commonNames == null || commonNames.length() == 0) {
            this.mCommonNames = null;
            return;
        }
        if (commonNames.startsWith(",") || commonNames.endsWith(",")) {
            throw new InvalidPropertiesException("Empty Common Name provided");
        }
        this.mCommonNames = commonNames.split(",");
        if (this.mCommonNames.length == 0) {
            throw new InvalidPropertiesException("Empty Common Name provided");
        }
        if (this.mCommonNames.length > 16) {
            throw new InvalidPropertiesException("A maximum of 16 common names can be given");
        }
        for (int i = 0; i < this.mCommonNames.length; ++i) {
            if (this.mCommonNames[i].length() != 0) continue;
            throw new InvalidPropertiesException("Empty Common Name provided");
        }
    }

    private void initValidateCerts(Boolean validate) {
        this.mValidateCert = validate == null ? true : validate;
    }

    private void initValidateCertsDate(Boolean validate) {
        this.mValidateCertDate = validate == null ? true : validate;
    }

    public boolean isClientCertificateAuthenticationEnabled() {
        return this.mAuthenticationScheme.equals("AUTHENTICATION_SCHEME_CLIENT_CERTIFICATE");
    }

    private KeyManager[] createKeyManagers(KeyStore keystore, String password) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        if (Trace.isDebugEnabled()) {
            Trace.debug((Object)"Initializing key manager");
        }
        KeyManagerFactory kmfactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmfactory.init(keystore, password != null ? password.toCharArray() : null);
        return kmfactory.getKeyManagers();
    }

    private TrustManager[] createTrustManagers(KeyStore keystore) throws KeyStoreException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        if (Trace.isDebugEnabled()) {
            Trace.debug((Object)"Initializing trust manager");
        }
        TrustManagerFactory tmfactory = TrustManagerFactory.getInstance("PKIX");
        tmfactory.init(keystore);
        TrustManager[] trustmanagers = tmfactory.getTrustManagers();
        for (int i = 0; i < trustmanagers.length; ++i) {
            if (!(trustmanagers[i] instanceof X509TrustManager)) continue;
            trustmanagers[i] = new AuthSSLX509TrustManager((X509TrustManager)trustmanagers[i], this);
        }
        return trustmanagers;
    }

    void checkKeyStore(KeyStore keystore, String password) throws InvalidPropertiesException {
        if (password == null) {
            throw new InvalidPropertiesException("At least one of the private key password or key store password properties must be specified.");
        }
        try {
            Enumeration<String> aliases = keystore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                try {
                    if (keystore.getKey(alias, password.toCharArray()) == null) continue;
                    return;
                }
                catch (UnrecoverableKeyException unrecoverableKeyException) {
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                }
                catch (KeyStoreException keyStoreException) {
                }
            }
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        if (!this.mFoundAtLeastOnePrivateKey) {
            throw new InvalidPropertiesException("The specified keystore contains no private key.");
        }
        throw new InvalidPropertiesException("Unable to load key store", new UnrecoverableKeyException());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore createKeyStore(String keyStoreName, String password, String _keyStoreFmt, String privateKeyAlias, String privateKeyPwd) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException, InvalidPropertiesException {
        KeyStore keyStoreWithOneClientCert;
        block33: {
            Certificate[] chain;
            String alias;
            Enumeration<String> aliases3;
            KeyStore keystore;
            block34: {
                block32: {
                    String keyStoreFmt = _keyStoreFmt.trim();
                    if (Trace.isDebugEnabled()) {
                        Trace.debug((Object)("Initializing key store: " + keyStoreName));
                    }
                    keystore = null;
                    try {
                        keystore = KeyStore.getInstance(keyStoreFmt);
                    }
                    catch (KeyStoreException e) {
                        throw new InvalidPropertiesException("Unknown or unsupported key or trust store format \"" + _keyStoreFmt + "\"");
                    }
                    if (keyStoreName != null && keyStoreName.trim().length() > 0) {
                        try (InputStream keystoreInputStream = null;){
                            URL url = new URL(keyStoreName);
                            keystoreInputStream = url.openStream();
                            keystore.load(keystoreInputStream, password != null ? password.toCharArray() : null);
                        }
                    } else {
                        keystore.load(null, null);
                    }
                    String keyPassword = privateKeyPwd;
                    if (keyPassword == null) {
                        keyPassword = password;
                    }
                    if (Trace.isDebugEnabled()) {
                        Enumeration<String> aliases2 = keystore.aliases();
                        while (aliases2.hasMoreElements()) {
                            String alias2 = aliases2.nextElement();
                            Certificate[] certs = keystore.getCertificateChain(alias2);
                            if (certs == null) continue;
                            Trace.debug((Object)("Certificate chain '" + alias2 + "':"));
                            for (int c = 0; c < certs.length; ++c) {
                                if (!(certs[c] instanceof X509Certificate)) continue;
                                X509Certificate cert = (X509Certificate)certs[c];
                                Trace.debug((Object)(" Certificate " + (c + 1) + ":"));
                                Trace.debug((Object)("  Subject DN: " + cert.getSubjectDN()));
                                Trace.debug((Object)("  Signature Algorithm: " + cert.getSigAlgName()));
                                Trace.debug((Object)("  Valid from: " + cert.getNotBefore()));
                                Trace.debug((Object)("  Valid until: " + cert.getNotAfter()));
                                Trace.debug((Object)("  Issuer: " + cert.getIssuerDN()));
                            }
                        }
                    }
                    if (this.mKeyStoreNormalizedFmt.equals("")) {
                        keyStoreWithOneClientCert = KeyStore.getInstance(keyStoreFmt);
                    } else {
                        try {
                            keyStoreWithOneClientCert = KeyStore.getInstance(this.mKeyStoreNormalizedFmt);
                            Trace.debug((Object)("Using a specified internal normalized store format: " + this.mKeyStoreNormalizedFmt));
                        }
                        catch (KeyStoreException e) {
                            throw new InvalidPropertiesException("Unknown or unsupported Normalized key store format \"" + this.mKeyStoreNormalizedFmt + "\"");
                        }
                    }
                    keyStoreWithOneClientCert.load(null);
                    try {
                        aliases3 = keystore.aliases();
                        while (aliases3.hasMoreElements()) {
                            alias = aliases3.nextElement();
                            if (!keystore.isCertificateEntry(alias)) continue;
                            Certificate cert = keystore.getCertificate(alias);
                            keyStoreWithOneClientCert.setCertificateEntry(alias, cert);
                        }
                    }
                    catch (KeyStoreException aliases3) {
                        // empty catch block
                    }
                    if (privateKeyAlias == null) break block32;
                    Key privateKey = keystore.getKey(privateKeyAlias, keyPassword != null ? keyPassword.toCharArray() : null);
                    if (privateKey == null) {
                        throw new InvalidPropertiesException("No private key is associated to alias '" + privateKeyAlias + "'");
                    }
                    Certificate[] chain2 = keystore.getCertificateChain(privateKeyAlias);
                    if (password != null) {
                        keyStoreWithOneClientCert.setKeyEntry(privateKeyAlias, privateKey, password.toCharArray(), chain2);
                    } else {
                        keyStoreWithOneClientCert.setKeyEntry(privateKeyAlias, privateKey, privateKeyPwd.toCharArray(), chain2);
                    }
                    break block33;
                }
                if (privateKeyPwd == null) break block34;
                aliases3 = keystore.aliases();
                while (aliases3.hasMoreElements()) {
                    Key privateKey;
                    alias = aliases3.nextElement();
                    try {
                        privateKey = keystore.getKey(alias, privateKeyPwd.toCharArray());
                    }
                    catch (UnrecoverableKeyException e) {
                        this.mFoundAtLeastOnePrivateKey = true;
                        continue;
                    }
                    if (privateKey == null) continue;
                    chain = keystore.getCertificateChain(alias);
                    if (password != null) {
                        keyStoreWithOneClientCert.setKeyEntry(alias, privateKey, password.toCharArray(), chain);
                        continue;
                    }
                    keyStoreWithOneClientCert.setKeyEntry(alias, privateKey, privateKeyPwd.toCharArray(), chain);
                }
                break block33;
            }
            if (password == null) break block33;
            aliases3 = keystore.aliases();
            while (aliases3.hasMoreElements()) {
                Key privateKey;
                alias = aliases3.nextElement();
                try {
                    privateKey = keystore.getKey(alias, password.toCharArray());
                }
                catch (UnrecoverableKeyException e) {
                    this.mFoundAtLeastOnePrivateKey = true;
                    continue;
                }
                if (privateKey == null) continue;
                chain = keystore.getCertificateChain(alias);
                keyStoreWithOneClientCert.setKeyEntry(alias, privateKey, password.toCharArray(), chain);
            }
        }
        return keyStoreWithOneClientCert;
    }
}

