/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.transaction;

import com.solacesystems.common.util.LogWrapper;
import com.solacesystems.jcsmp.ClosedFacilityException;
import com.solacesystems.jcsmp.InvalidOperationException;
import com.solacesystems.jcsmp.JCSMPErrorResponseException;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPTransportException;
import com.solacesystems.jcsmp.StaleSessionException;
import com.solacesystems.jcsmp.impl.Closeable;
import com.solacesystems.jcsmp.impl.JCSMPXMLMessageProducer;
import com.solacesystems.jcsmp.impl.flow.FlowHandleImpl;
import com.solacesystems.jcsmp.impl.transaction.AdCtrlV4TransactedSessionImpl;
import com.solacesystems.jcsmp.impl.transaction.BaseTransactedSessionImpl;
import com.solacesystems.jcsmp.impl.transaction.TransactedSessionImpl;
import com.solacesystems.jcsmp.protocol.smf.AbstractTLVParameter;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlEnums;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlHeaderParameters;
import com.solacesystems.jcsmp.transaction.RollbackException;
import com.solacesystems.jcsmp.transaction.TransactionResultUnknownException;
import com.solacesystems.jcsmp.transaction.TransactionStatus;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;

public abstract class AdCtrlV4TSState {
    protected final AdCtrlV4TransactedSessionImpl tsession;
    protected final LogWrapper Trace;

    public AdCtrlV4TSState(AdCtrlV4TransactedSessionImpl parentSession) {
        this.tsession = parentSession;
        this.Trace = parentSession.getLogWrapper();
    }

    public void refireRequest() throws JCSMPException {
    }

    public AdCtrlV4TSStorage getStateCache() {
        return this.tsession.getSessionStateStorage();
    }

    protected void setState(AdCtrlV4TSState next) throws JCSMPException {
        this.tsession.updateTransactionState(next);
    }

    protected long getCorrelationTag() {
        return this.tsession.getCorrelationTag();
    }

    protected long getNextCorrelationTag() {
        return this.tsession.getNextCorrelationTag();
    }

    protected abstract TransactionStatus getStatusEnum();

    protected void notifySessionUp() throws JCSMPException {
    }

    protected void notifyNewSessionCreated() throws JCSMPException {
    }

    protected void notifyV3SessionResumed(AssuredCtrlEnums.TransactedSessionState state, AssuredCtrlHeaderParameters.ParamTransactionId tid) throws JCSMPException {
    }

    protected void notifySessionClosed() throws JCSMPException {
        this.setState(this.tsession.getSessionStateStorage().STATE_CLOSED);
    }

    protected void enter() throws JCSMPException {
    }

    protected boolean isMarkedAsRollback() {
        return false;
    }

    protected void rollbackCommittingTransaction() {
    }

    protected void handleAdCtrlResponse(AssuredCtrlEnums.TransactionCtrlMessageType mtype, AssuredCtrlHeaderBean adctrl, long correlationId, int respCode, JCSMPErrorResponseException err_resp) {
    }

    protected void handleResponseTimeout() throws JCSMPException {
    }

    protected void notifyAdCtrlVersionDowngrade() {
        this.resetMessageRetransmitQueue();
    }

    protected void notifyVridChange() {
    }

    public void allowOperation(BaseTransactedSessionImpl.AllowedOperation op) throws InvalidOperationException {
        this.throwDisallowedOp(op);
    }

    protected void throwDisallowedOp(BaseTransactedSessionImpl.AllowedOperation op) throws InvalidOperationException {
        throw new InvalidOperationException(String.format("Operation %s disallowed in state %s.", new Object[]{op, this.getStatusEnum()}));
    }

    public void doCommit() throws JCSMPException {
        throw new InvalidOperationException(String.format("Invalid call to commit in state '%s'.", new Object[]{this.getStatusEnum()}));
    }

    public void doRollback() throws JCSMPException {
        throw new InvalidOperationException(String.format("Invalid call to rollback in state '%s'.", new Object[]{this.getStatusEnum()}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ackEverythingSent() {
        try {
            Set set = this.tsession.outputFlows;
            synchronized (set) {
                for (JCSMPXMLMessageProducer prodflow : this.tsession.outputFlows) {
                    long last_sent = prodflow.getPubADManager().getLastMessageIdSent();
                    prodflow.getPubADManager().handleClientAck(last_sent, null, false, false);
                }
            }
        }
        catch (JCSMPException e) {
            this.tsession.handleUnrecoverableException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handlePubAcks(AssuredCtrlHeaderParameters.ParamTransactionFDPubAck param_pubacks, JCSMPErrorResponseException err) {
        try {
            for (AssuredCtrlHeaderParameters.ParamTransactionFDPubAck.PubAckTuple pubAck : param_pubacks.getTuples()) {
                Set set = this.tsession.outputFlows;
                synchronized (set) {
                    for (JCSMPXMLMessageProducer prodflow : this.tsession.outputFlows) {
                        if (prodflow.getPubADManager().flow_Id != (long)pubAck.flowId) continue;
                        prodflow.handleCommitResponse(pubAck.lastMessageId, err);
                        break;
                    }
                }
            }
            return;
        }
        catch (JCSMPException e) {
            this.tsession.handleUnrecoverableException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopRetransmit() {
        Set set = this.tsession.outputFlows;
        synchronized (set) {
            for (JCSMPXMLMessageProducer prodflow : this.tsession.outputFlows) {
                prodflow.cancelPendingResendTask();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rollbackFlows() {
        LinkedHashSet toRollback = null;
        Set set = this.tsession.inputFlows;
        synchronized (set) {
            toRollback = new LinkedHashSet(this.tsession.inputFlows);
        }
        for (FlowHandleImpl fh : toRollback) {
            fh.rollback();
            fh.openWindow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetMessageRetransmitQueue() {
        Set set = this.tsession.outputFlows;
        synchronized (set) {
            for (JCSMPXMLMessageProducer prodflow : this.tsession.outputFlows) {
                prodflow.resetMessageRetransmitQueue();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleRollbackOkResp(AssuredCtrlHeaderParameters.ParamTransactionFDPubAck param_pubacks) {
        for (AssuredCtrlHeaderParameters.ParamTransactionFDPubAck.PubAckTuple pubAck : param_pubacks.getTuples()) {
            Set set = this.tsession.outputFlows;
            synchronized (set) {
                for (JCSMPXMLMessageProducer prodflow : this.tsession.outputFlows) {
                    if (prodflow.getPubADManager().flow_Id != (long)pubAck.flowId) continue;
                    prodflow.getPubADManager().handleRollback(pubAck.lastMessageId);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rollbackPubFlows() {
        Set set = this.tsession.outputFlows;
        synchronized (set) {
            for (JCSMPXMLMessageProducer prodflow : this.tsession.outputFlows) {
                prodflow.getPubADManager().handleRollback(prodflow.getPubADManager().getLastMessageIdSent());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postCommit() {
        LinkedHashSet flows = null;
        Set set = this.tsession.inputFlows;
        synchronized (set) {
            flows = new LinkedHashSet(this.tsession.inputFlows);
        }
        for (FlowHandleImpl fh : flows) {
            fh.handleUnackedMsgSegments();
        }
    }

    protected void checkMaxPostTries(int thisTry) throws JCSMPException {
        if (thisTry > this.tsession.max_post_tries) {
            JCSMPTransportException err = new JCSMPTransportException(String.format("Transacted Session exceeded maximum configured request attempts (%s) in state %s.", new Object[]{this.tsession.max_post_tries, this.getStatusEnum()}));
            throw err;
        }
    }

    public static class StateMarkedRollback
    extends AdCtrlV4TSState {
        public StateMarkedRollback(AdCtrlV4TransactedSessionImpl parentSession) {
            super(parentSession);
        }

        @Override
        public TransactionStatus getStatusEnum() {
            return TransactionStatus.MARKED_ROLLBACK;
        }

        @Override
        public void allowOperation(BaseTransactedSessionImpl.AllowedOperation op) throws InvalidOperationException {
            switch (op) {
                case CREATEFLOW: 
                case COMMIT: 
                case ROLLBACK: 
                case RECEIVE: 
                case SEND: {
                    break;
                }
                default: {
                    this.throwDisallowedOp(op);
                }
            }
        }

        @Override
        protected boolean isMarkedAsRollback() {
            return true;
        }

        @Override
        protected void enter() throws JCSMPException {
        }

        @Override
        protected void notifyAdCtrlVersionDowngrade() {
            super.notifyAdCtrlVersionDowngrade();
            this.tsession.setTransactionState(this.tsession.getV3SessionStateStorage().STATE_MARKEDROLLBACK);
        }

        @Override
        public void doCommit() throws JCSMPException {
            this.setState(this.tsession.getSessionStateStorage().STATE_COMMIT_ROLLINGBACK);
        }

        @Override
        public void doRollback() throws JCSMPException {
            this.setState(this.tsession.getSessionStateStorage().STATE_ROLLINGBACK);
        }
    }

    public static class StateCommitRollingBack
    extends AdCtrlV4TSState {
        public StateCommitRollingBack(AdCtrlV4TransactedSessionImpl parentSession) {
            super(parentSession);
        }

        @Override
        protected void enter() throws JCSMPException {
            this.rollbackFlows();
            this.rollbackPubFlows();
            if (!this.tsession.reconnectInProgress()) {
                try {
                    this.tsession.sendRollbackRequest(true, this.tsession.getConnTag(), this.getCorrelationTag());
                }
                catch (JCSMPTransportException jCSMPTransportException) {
                }
                finally {
                    this.tsession.startResponseTimer();
                }
            }
        }

        @Override
        protected void notifyAdCtrlVersionDowngrade() {
            super.notifyAdCtrlVersionDowngrade();
            this.tsession.setTransactionState(this.tsession.getV3SessionStateStorage().STATE_COMMIT_ROLLINGBACK);
        }

        @Override
        protected void handleResponseTimeout() throws JCSMPException {
            this.tsession.enqueueRefireRequest();
        }

        @Override
        public void refireRequest() throws JCSMPException {
            this.tsession.updateConnTag();
            this.tsession.stopResponseTimer();
            try {
                this.tsession.sendRollbackRequest(false, this.tsession.getConnTag(), this.getCorrelationTag());
            }
            catch (JCSMPTransportException e) {
                if (this.Trace.isDebugEnabled()) {
                    this.Trace.debug("got exception: " + e.getMessage());
                }
            }
            finally {
                this.tsession.startResponseTimer();
            }
        }

        @Override
        protected void notifySessionUp() throws JCSMPException {
            this.tsession.enqueueRefireRequest();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void handleAdCtrlResponse(AssuredCtrlEnums.TransactionCtrlMessageType mtype, AssuredCtrlHeaderBean adctrl, long correlationId, int respCode, JCSMPErrorResponseException err_resp) {
            if (mtype != AssuredCtrlEnums.TransactionCtrlMessageType.ROLLBACK_TRANSACTION_RESPONSE) {
                if (this.Trace.isInfoEnabled()) {
                    this.Trace.info("Skip response with unexpectedtype=" + mtype.name() + " in state " + String.valueOf((Object)this.getStatusEnum()));
                }
                return;
            }
            if (correlationId != this.getCorrelationTag()) {
                if (this.Trace.isInfoEnabled()) {
                    this.Trace.info("Skip response with unexpected corrId=" + correlationId + "; type=" + mtype.name() + " session=" + this.tsession.toString());
                }
                return;
            }
            if (this.Trace.isDebugEnabled()) {
                this.Trace.debug(String.format("%s Transaction roolback", this.tsession.toString()));
            }
            this.tsession.stopResponseTimer();
            String err_rollback = String.format("Transaction %s unexpectedly rolled back", this.tsession.toString());
            if (err_resp == null) {
                this.rollbackFlows();
                AbstractTLVParameter pub_ack_param = adctrl.findFirstParameter(29);
                if (pub_ack_param != null) {
                    AssuredCtrlHeaderParameters.ParamTransactionFDPubAck pubackParam = AssuredCtrlHeaderParameters.ParamTransactionFDPubAck.fromValueBytes(pub_ack_param.value, 0, pub_ack_param.value.length);
                    this.handleRollbackOkResp(pubackParam);
                }
                JCSMPErrorResponseException err_resp1 = new JCSMPErrorResponseException(503, "Message Publish Failure", "", null);
                Object object = this.tsession.getStateQueueLock();
                synchronized (object) {
                    try {
                        this.setState(this.tsession.getSessionStateStorage().STATE_ACTIVE);
                    }
                    catch (JCSMPException e) {
                        this.Trace.debug("got exception: " + e.getMessage());
                    }
                    this.tsession.enqueueResponse(new RollbackException(err_rollback, err_resp1));
                }
            }
            if (err_resp.getSubcodeEx() == 54) {
                this.tsession.startResponseTimer();
                return;
            }
            if (this.Trace.isWarnEnabled()) {
                this.Trace.warn(err_resp);
            }
            this.rollbackFlows();
            this.resetMessageRetransmitQueue();
            Object object = this.tsession.getStateQueueLock();
            synchronized (object) {
                try {
                    this.setState(this.tsession.getSessionStateStorage().STATE_ACTIVE);
                }
                catch (JCSMPException e) {
                    this.Trace.debug("got exception: ", e);
                }
                this.tsession.enqueueResponse(new RollbackException(err_rollback, err_resp));
            }
            return;
        }

        @Override
        protected void notifyNewSessionCreated() throws JCSMPException {
            this.handleNewSession();
        }

        @Override
        protected void notifyVridChange() {
            this.handleNewSession();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleNewSession() {
            this.rollbackFlows();
            this.rollbackPubFlows();
            String err_rollback = String.format("Transaction %s unexpectedly rolled back due to UNBOUND transacted consumer flows", this.tsession.toString());
            Object object = this.tsession.getStateQueueLock();
            synchronized (object) {
                block6: {
                    try {
                        this.setState(this.tsession.getSessionStateStorage().STATE_ACTIVE);
                    }
                    catch (JCSMPException e) {
                        if (!this.Trace.isDebugEnabled()) break block6;
                        this.Trace.debug("gor exception: " + e.getMessage());
                    }
                }
                this.tsession.enqueueResponse(new TransactionResultUnknownException(err_rollback));
            }
            if (this.Trace.isInfoEnabled()) {
                this.Trace.info(String.format("Commit failure: %s", err_rollback));
            }
        }

        @Override
        public TransactionStatus getStatusEnum() {
            return TransactionStatus.COMMIT_ROLLING_BACK;
        }
    }

    public static class StateRollingBackInterrupted
    extends StateRollingBack {
        public StateRollingBackInterrupted(AdCtrlV4TransactedSessionImpl parentSession) {
            super(parentSession);
        }

        @Override
        protected void enter() throws JCSMPException {
            this.tsession.createInterruptionHandlingThread("rollback response");
        }

        @Override
        protected void notifyAdCtrlVersionDowngrade() {
            this.tsession.enqueueDowngradeRequest();
            super.notifyAdCtrlVersionDowngrade();
        }

        @Override
        public TransactionStatus getStatusEnum() {
            return TransactionStatus.ROLLING_BACK_INTERRUPTED;
        }
    }

    public static class StateRollingBack
    extends AdCtrlV4TSState {
        public StateRollingBack(AdCtrlV4TransactedSessionImpl parentSession) {
            super(parentSession);
        }

        @Override
        protected void enter() throws JCSMPException {
            this.stopRetransmit();
            this.rollbackFlows();
            if (!this.tsession.reconnectInProgress()) {
                try {
                    this.tsession.sendRollbackRequest(true, this.tsession.getConnTag(), this.getCorrelationTag());
                }
                catch (JCSMPTransportException jCSMPTransportException) {
                }
                finally {
                    this.tsession.startResponseTimer();
                }
            }
        }

        @Override
        protected void notifyAdCtrlVersionDowngrade() {
            super.notifyAdCtrlVersionDowngrade();
            this.tsession.setTransactionState(this.tsession.getV3SessionStateStorage().STATE_ROLLINGBACK);
        }

        @Override
        protected void handleResponseTimeout() throws JCSMPException {
            this.tsession.enqueueRefireRequest();
        }

        @Override
        public void refireRequest() throws JCSMPException {
            this.tsession.updateConnTag();
            this.tsession.stopResponseTimer();
            try {
                this.tsession.sendRollbackRequest(false, this.tsession.getConnTag(), this.getCorrelationTag());
            }
            catch (JCSMPTransportException e) {
                if (this.Trace.isDebugEnabled()) {
                    this.Trace.debug("got exception: ", e);
                }
            }
            finally {
                this.tsession.startResponseTimer();
            }
        }

        @Override
        protected void notifySessionUp() throws JCSMPException {
            this.tsession.enqueueRefireRequest();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void handleAdCtrlResponse(AssuredCtrlEnums.TransactionCtrlMessageType mtype, AssuredCtrlHeaderBean adctrl, long correlationId, int respCode, JCSMPErrorResponseException err_resp) {
            Object object;
            if (mtype != AssuredCtrlEnums.TransactionCtrlMessageType.ROLLBACK_TRANSACTION_RESPONSE) {
                if (this.Trace.isInfoEnabled()) {
                    this.Trace.info("Skip response with unexpected type= " + mtype.name() + " in state " + String.valueOf((Object)this.getStatusEnum()));
                }
                return;
            }
            if (correlationId != this.getCorrelationTag()) {
                if (this.Trace.isInfoEnabled()) {
                    this.Trace.info("Skip response with unexpected corrId=" + correlationId + "; type=" + mtype.name() + " session=" + this.tsession.toString());
                }
                return;
            }
            if (this.Trace.isDebugEnabled()) {
                this.Trace.debug(String.format("%s got transaction rollback request", this.tsession.toString()));
            }
            this.tsession.stopResponseTimer();
            AbstractTLVParameter pub_ack_param = adctrl.findFirstParameter(29);
            if (pub_ack_param != null) {
                AssuredCtrlHeaderParameters.ParamTransactionFDPubAck pubackParam = AssuredCtrlHeaderParameters.ParamTransactionFDPubAck.fromValueBytes(pub_ack_param.value, 0, pub_ack_param.value.length);
                this.handleRollbackOkResp(pubackParam);
            }
            if (err_resp == null) {
                this.rollbackFlows();
                object = this.tsession.getStateQueueLock();
                synchronized (object) {
                    block19: {
                        try {
                            this.setState(this.tsession.getSessionStateStorage().STATE_ACTIVE);
                        }
                        catch (JCSMPException e) {
                            if (!this.Trace.isDebugEnabled()) break block19;
                            this.Trace.debug("got exception: ", e);
                        }
                    }
                    this.tsession.enqueueResponse(correlationId);
                }
            }
            if (err_resp != null && err_resp.getSubcodeEx() == 54) {
                this.tsession.startResponseTimer();
                return;
            }
            if (this.Trace.isWarnEnabled()) {
                this.Trace.warn(err_resp);
            }
            this.rollbackFlows();
            this.resetMessageRetransmitQueue();
            object = this.tsession.getStateQueueLock();
            synchronized (object) {
                block20: {
                    try {
                        this.setState(this.tsession.getSessionStateStorage().STATE_ACTIVE);
                    }
                    catch (JCSMPException e) {
                        if (!this.Trace.isDebugEnabled()) break block20;
                        this.Trace.debug("got exception: ", e);
                    }
                }
                this.tsession.enqueueResponse(err_resp);
            }
            return;
        }

        @Override
        protected void notifyNewSessionCreated() throws JCSMPException {
            this.handleNewSession();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void notifyV3SessionResumed(AssuredCtrlEnums.TransactedSessionState routerState, AssuredCtrlHeaderParameters.ParamTransactionId routerTid) throws JCSMPException {
            boolean isContinuation;
            long tid_rtr_in_progress = routerTid.b;
            long tid_local_in_progress = this.tsession.getTransactionId().a;
            boolean bl = isContinuation = tid_rtr_in_progress == tid_local_in_progress;
            if (this.Trace.isInfoEnabled()) {
                this.Trace.info(String.format("%s notifyV3SessionResumed in state COMMIT_ROLLINGBACK, local_in_progress=%s, router_in_progress=%s, router_session_status=%s", new Object[]{this.tsession, tid_local_in_progress, tid_rtr_in_progress, routerState}));
            }
            if (isContinuation) {
                this.tsession.enqueueSwitchToV4Request();
            } else {
                switch (routerState) {
                    case ROLLEDBACK: 
                    case NEW: {
                        this.rollbackFlows();
                        Object object = this.tsession.getStateQueueLock();
                        synchronized (object) {
                            this.setState(this.tsession.getSessionStateStorage().STATE_ACTIVE);
                            this.tsession.enqueueResponse(this.tsession.getTransactionId());
                            break;
                        }
                    }
                    default: {
                        this.tsession.handleUnrecoverableException(new InvalidOperationException("Lost transaction sync in ROLLINGBACK: router state should not be " + routerState.toString()));
                    }
                }
            }
        }

        @Override
        protected void notifyVridChange() {
            this.handleNewSession();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleNewSession() {
            this.rollbackFlows();
            this.rollbackPubFlows();
            Object object = this.tsession.getStateQueueLock();
            synchronized (object) {
                block7: {
                    try {
                        this.setState(this.tsession.getSessionStateStorage().STATE_ACTIVE);
                    }
                    catch (JCSMPException e) {
                        if (!this.Trace.isDebugEnabled()) break block7;
                        this.Trace.debug("gor exception: " + e.getMessage());
                    }
                }
                if (this.tsession.isUpgradeInProgress()) {
                    this.tsession.enqueueResponse(this.tsession.getTransactionId());
                    this.tsession.setUpgradeInProgressStatus(false);
                } else {
                    this.tsession.enqueueResponse(this.tsession.getCorrelationTag());
                }
            }
        }

        @Override
        public TransactionStatus getStatusEnum() {
            return TransactionStatus.ROLLING_BACK;
        }
    }

    public static class StateCommittingInterrupted
    extends StateCommitting {
        public StateCommittingInterrupted(AdCtrlV4TransactedSessionImpl parentSession) {
            super(parentSession);
        }

        @Override
        public TransactionStatus getStatusEnum() {
            return TransactionStatus.COMMITTING_INTERRUPTED;
        }

        @Override
        protected void enter() throws JCSMPException {
            this.tsession.createInterruptionHandlingThread("commit response");
        }

        @Override
        protected void notifyAdCtrlVersionDowngrade() {
            this.tsession.enqueueDowngradeRequest();
            super.notifyAdCtrlVersionDowngrade();
        }

        @Override
        protected void rollbackCommittingTransaction() {
            block2: {
                try {
                    this.setState(this.tsession.getSessionStateStorage().STATE_ROLLINGBACK_INTERRUPTED);
                }
                catch (JCSMPException e) {
                    if (!this.Trace.isDebugEnabled()) break block2;
                    this.Trace.debug("got exception: ", e);
                }
            }
        }
    }

    public static class StateCommitting
    extends AdCtrlV4TSState {
        public StateCommitting(AdCtrlV4TransactedSessionImpl parentSession) {
            super(parentSession);
        }

        @Override
        public TransactionStatus getStatusEnum() {
            return TransactionStatus.COMMITTING;
        }

        @Override
        protected void enter() throws JCSMPException {
            this.stopRetransmit();
            try {
                this.tsession.sendCommitRequest(true, this.tsession.getConnTag(), this.getCorrelationTag());
            }
            catch (JCSMPTransportException jCSMPTransportException) {
            }
            finally {
                this.tsession.startResponseTimer();
            }
        }

        @Override
        protected void notifyAdCtrlVersionDowngrade() {
            super.notifyAdCtrlVersionDowngrade();
            this.tsession.setTransactionState(this.tsession.getV3SessionStateStorage().STATE_COMMITTING);
        }

        @Override
        protected void rollbackCommittingTransaction() {
            block2: {
                try {
                    this.setState(this.tsession.getSessionStateStorage().STATE_COMMIT_ROLLINGBACK);
                }
                catch (JCSMPException e) {
                    if (!this.Trace.isDebugEnabled()) break block2;
                    this.Trace.debug("gor exception: ", e);
                }
            }
        }

        @Override
        public void refireRequest() throws JCSMPException {
            this.tsession.updateConnTag();
            this.tsession.stopResponseTimer();
            try {
                this.tsession.sendCommitRequest(false, this.tsession.getConnTag(), this.getCorrelationTag());
            }
            catch (JCSMPTransportException e) {
                if (this.Trace.isDebugEnabled()) {
                    this.Trace.debug("got exception: ", e);
                }
            }
            finally {
                this.tsession.startResponseTimer();
            }
        }

        @Override
        protected void notifySessionUp() throws JCSMPException {
            this.tsession.enqueueRefireRequest();
        }

        @Override
        protected void handleResponseTimeout() throws JCSMPException {
            this.tsession.enqueueRefireRequest();
        }

        @Override
        protected void notifyNewSessionCreated() throws JCSMPException {
            this.handleNewSession();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void notifyV3SessionResumed(AssuredCtrlEnums.TransactedSessionState routerState, AssuredCtrlHeaderParameters.ParamTransactionId routerTid) throws JCSMPException {
            boolean isContinuation;
            long tid_rtr_in_progress = routerTid.b;
            long tid_local_in_progress = this.tsession.getTransactionId().a;
            boolean bl = isContinuation = tid_rtr_in_progress == tid_local_in_progress;
            if (this.Trace.isInfoEnabled()) {
                this.Trace.debug(String.format("%s notifyV3SessionResumed in state COMMITTING, local_in_progress=%s, router_in_progress=%s, router_session_status=%s", new Object[]{this.tsession, tid_local_in_progress, tid_rtr_in_progress, routerState}));
            }
            if (isContinuation) {
                this.tsession.enqueueSwitchToV4Request();
            } else {
                switch (routerState) {
                    case COMMITTED: {
                        this.postCommit();
                        Object object = this.tsession.getStateQueueLock();
                        synchronized (object) {
                            this.setState(this.tsession.getSessionStateStorage().STATE_ACTIVE);
                            this.tsession.enqueueResponse(routerTid);
                            break;
                        }
                    }
                    case ROLLEDBACK: {
                        String err_rollback = String.format("%s Transaction '%s' unexpectedly rolled back during commit attempt.", this.tsession, tid_local_in_progress);
                        this.rollbackFlows();
                        Object object = this.tsession.getStateQueueLock();
                        synchronized (object) {
                            this.setState(this.tsession.getSessionStateStorage().STATE_ACTIVE);
                            this.tsession.enqueueResponse(new RollbackException(err_rollback));
                            break;
                        }
                    }
                    case NEW: {
                        String err_unknown = String.format("%s Commit Error on transaction '%s' due to the transacted session failed to resume. The transaction may or may not be committed on the router.", this.tsession, tid_local_in_progress);
                        this.rollbackFlows();
                        Object object = this.tsession.getStateQueueLock();
                        synchronized (object) {
                            this.setState(this.tsession.getSessionStateStorage().STATE_ACTIVE);
                            this.tsession.enqueueResponse(new TransactionResultUnknownException(err_unknown));
                            break;
                        }
                    }
                    default: {
                        this.tsession.handleUnrecoverableException(new InvalidOperationException("Lost transaction sync in COMMITTING: router state should not be " + routerState.toString()));
                    }
                }
            }
        }

        @Override
        protected void notifyVridChange() {
            this.handleNewSession();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleNewSession() {
            this.rollbackFlows();
            this.rollbackPubFlows();
            String err_unknown = String.format("Commit Error on transaction '%s' due to the transacted session failed to resume. The transaction may or may not be committed on the router.", this.tsession.toString());
            if (this.tsession.isUpgradeInProgress()) {
                this.tsession.setUpgradeInProgressStatus(false);
            }
            Object object = this.tsession.getStateQueueLock();
            synchronized (object) {
                block7: {
                    try {
                        this.setState(this.tsession.getSessionStateStorage().STATE_ACTIVE);
                    }
                    catch (JCSMPException e) {
                        if (!this.Trace.isDebugEnabled()) break block7;
                        this.Trace.debug("gor exception: ", e);
                    }
                }
                this.tsession.enqueueResponse(new TransactionResultUnknownException(err_unknown));
            }
            if (this.Trace.isInfoEnabled()) {
                this.Trace.info(String.format("Commit failure: %s", err_unknown));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void handleAdCtrlResponse(AssuredCtrlEnums.TransactionCtrlMessageType mtype, AssuredCtrlHeaderBean adctrl, long correlationId, int respCode, JCSMPErrorResponseException err_resp) {
            Object pubackParam;
            if (mtype != AssuredCtrlEnums.TransactionCtrlMessageType.COMMIT_TRANSACTION_RESPONSE) {
                if (this.Trace.isInfoEnabled()) {
                    this.Trace.info("Skip response with unexpected type:  type=" + mtype.name() + " session=" + this.tsession.toString());
                }
                return;
            }
            if (correlationId != this.getCorrelationTag()) {
                if (this.Trace.isInfoEnabled()) {
                    this.Trace.info("Skip response with unexpected corrId=" + correlationId + "; type=" + mtype.name() + " session=" + this.tsession.toString());
                }
                return;
            }
            this.tsession.stopResponseTimer();
            AbstractTLVParameter pub_ack_param = adctrl.findFirstParameter(29);
            if (pub_ack_param != null) {
                pubackParam = AssuredCtrlHeaderParameters.ParamTransactionFDPubAck.fromValueBytes(pub_ack_param.value, 0, pub_ack_param.value.length);
                this.handlePubAcks((AssuredCtrlHeaderParameters.ParamTransactionFDPubAck)pubackParam, err_resp);
            }
            if (err_resp == null) {
                this.postCommit();
                pubackParam = this.tsession.getStateQueueLock();
                synchronized (pubackParam) {
                    block18: {
                        try {
                            this.setState(this.tsession.getSessionStateStorage().STATE_ACTIVE);
                        }
                        catch (JCSMPException e) {
                            if (!this.Trace.isDebugEnabled()) break block18;
                            this.Trace.debug("got exception: ", e);
                        }
                    }
                    this.tsession.enqueueResponse(correlationId);
                }
            }
            if (err_resp.getSubcodeEx() == 54) {
                this.tsession.startResponseTimer();
                return;
            }
            String err_rollback = String.format("Transaction commit failed: %s", this.tsession.toString());
            err_rollback = err_rollback + String.format(" (%s)", err_resp);
            this.rollbackFlows();
            Object object = this.tsession.getStateQueueLock();
            synchronized (object) {
                block19: {
                    try {
                        this.setState(this.tsession.getSessionStateStorage().STATE_ACTIVE);
                    }
                    catch (JCSMPException e) {
                        if (!this.Trace.isDebugEnabled()) break block19;
                        this.Trace.debug("got exception: ", e);
                    }
                }
                this.tsession.enqueueResponse(new RollbackException(err_rollback, err_resp));
            }
            if (this.Trace.isWarnEnabled()) {
                this.Trace.warn(err_rollback);
            }
        }
    }

    public static class StateActive
    extends AdCtrlV4TSState {
        public StateActive(AdCtrlV4TransactedSessionImpl parentSession) {
            super(parentSession);
        }

        @Override
        public TransactionStatus getStatusEnum() {
            return TransactionStatus.ACTIVE;
        }

        @Override
        protected void notifyAdCtrlVersionDowngrade() {
            super.notifyAdCtrlVersionDowngrade();
            this.tsession.setTransactionState(this.tsession.getV3SessionStateStorage().STATE_ACTIVE);
        }

        @Override
        public void allowOperation(BaseTransactedSessionImpl.AllowedOperation op) throws InvalidOperationException {
            switch (op) {
                case CREATEFLOW: 
                case COMMIT: 
                case ROLLBACK: 
                case RECEIVE: 
                case SEND: {
                    break;
                }
                default: {
                    this.throwDisallowedOp(op);
                }
            }
        }

        @Override
        protected void enter() throws JCSMPException {
            super.enter();
            this.getNextCorrelationTag();
            this.tsession.resetTransactionSteps();
            this.tsession.processFlowsToClose();
            this.tsession.retransmission.reset();
            this.tsession.cur_post_tries.set(0);
            this.ackEverythingSent();
            if (this.tsession.isTransactionInterrupted()) {
                this.tsession.notifyInterruptionResolved();
            }
        }

        @Override
        protected void rollbackCommittingTransaction() {
            block2: {
                try {
                    this.setState(this.tsession.getSessionStateStorage().STATE_MARKED_ROLLBACK);
                }
                catch (JCSMPException e) {
                    if (!this.Trace.isDebugEnabled()) break block2;
                    this.Trace.debug("gor exception: ", e);
                }
            }
        }

        @Override
        public void doCommit() throws JCSMPException {
            this.setState(this.tsession.getSessionStateStorage().STATE_COMMITTING);
        }

        @Override
        public void doRollback() throws JCSMPException {
            this.setState(this.tsession.getSessionStateStorage().STATE_ROLLINGBACK);
        }
    }

    public static class StateClosed
    extends AdCtrlV4TSState {
        public StateClosed(AdCtrlV4TransactedSessionImpl parentSession) {
            super(parentSession);
        }

        @Override
        public TransactionStatus getStatusEnum() {
            return TransactionStatus.CLOSED;
        }

        @Override
        protected void notifyAdCtrlVersionDowngrade() {
            super.notifyAdCtrlVersionDowngrade();
            this.tsession.setTransactionState(this.tsession.getV3SessionStateStorage().STATE_CLOSED);
        }

        @Override
        protected void throwDisallowedOp(BaseTransactedSessionImpl.AllowedOperation op) throws InvalidOperationException {
            if (this.tsession.marked_close_exception != null) {
                throw new StaleSessionException(String.format("Operation %s disallowed in state %s.", new Object[]{op, this.getStatusEnum()}), this.tsession.marked_close_exception);
            }
            throw new ClosedFacilityException(String.format("Operation %s disallowed in state %s.", new Object[]{op, this.getStatusEnum()}));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void enter() throws JCSMPException {
            super.enter();
            this.Trace.debug(String.format("Closing TransactedSession (%s).", this.tsession.toString()));
            if (this.tsession.marked_close_exception != null) {
                this.tsession.responseQueueAdd(new TransactedSessionImpl.ResponseQueueObjectWrapper("SessionClose", this.tsession.marked_close_exception));
            } else {
                this.tsession.responseQueueAdd(new TransactedSessionImpl.ResponseQueueObjectWrapper("SessionClose", new String("SessionClose")));
            }
            this.resetMessageRetransmitQueue();
            LinkedList to_close = new LinkedList();
            Object object = this.tsession.inputFlows;
            synchronized (object) {
                to_close.addAll(this.tsession.inputFlows);
            }
            object = this.tsession.outputFlows;
            synchronized (object) {
                to_close.addAll(this.tsession.outputFlows);
            }
            this.Trace.debug(String.format("Transacted session (%s) closing; closing %s managed guaranteed delivery flows.", this.tsession.getName(), to_close.size()));
            for (Closeable obj : to_close) {
                try {
                    obj.close();
                }
                catch (Throwable t) {
                    this.Trace.info("Error closing GD flow", t);
                }
            }
            this.tsession.processFlowsToClose();
            this.tsession.resetTransactionSteps();
            if (!this.tsession.getParentSession().isReactorOrReconnectRelatedThread()) {
                this.tsession._parentSessionMgr.closeAdCtrlV4TransactedSession(this.tsession);
            }
            this.tsession._parentSessionMgr.removeManagedTransactedSession(this.tsession);
        }
    }

    public static class AdCtrlV4TSStorage {
        public final AdCtrlV4TSState STATE_ACTIVE;
        public final AdCtrlV4TSState STATE_ROLLINGBACK;
        public final AdCtrlV4TSState STATE_COMMITTING;
        public final AdCtrlV4TSState STATE_CLOSED;
        public final AdCtrlV4TSState STATE_COMMIT_ROLLINGBACK;
        public final AdCtrlV4TSState STATE_MARKED_ROLLBACK;
        public final AdCtrlV4TSState STATE_ROLLINGBACK_INTERRUPTED;
        public final AdCtrlV4TSState STATE_COMMITTING_INTERRUPTED;

        public AdCtrlV4TSStorage(AdCtrlV4TransactedSessionImpl parentSession) {
            this.STATE_ACTIVE = new StateActive(parentSession);
            this.STATE_ROLLINGBACK = new StateRollingBack(parentSession);
            this.STATE_COMMITTING = new StateCommitting(parentSession);
            this.STATE_CLOSED = new StateClosed(parentSession);
            this.STATE_COMMIT_ROLLINGBACK = new StateCommitRollingBack(parentSession);
            this.STATE_MARKED_ROLLBACK = new StateMarkedRollback(parentSession);
            this.STATE_ROLLINGBACK_INTERRUPTED = new StateRollingBackInterrupted(parentSession);
            this.STATE_COMMITTING_INTERRUPTED = new StateCommittingInterrupted(parentSession);
        }
    }
}

