/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.transaction;

import com.solacesystems.jcsmp.InvalidOperationException;
import com.solacesystems.jcsmp.JCSMPInterruptedException;
import com.solacesystems.jcsmp.XMLMessage;
import com.solacesystems.jcsmp.impl.Closeable;
import com.solacesystems.jcsmp.impl.JCSMPXMLMessage;
import com.solacesystems.jcsmp.impl.JCSMPXMLMessageProducer;
import com.solacesystems.jcsmp.impl.flow.FlowHandleImpl;
import com.solacesystems.jcsmp.impl.transaction.TransactionSteps;
import java.util.Map;

public abstract class BaseTransactedSessionImpl {
    protected final TransactionSteps _transactionSteps;
    private long _transactedSessionId = 0L;
    private String _transactedSessionName;

    protected BaseTransactedSessionImpl() {
        this(false);
    }

    protected BaseTransactedSessionImpl(boolean extendedTransactionSteps) {
        this._transactionSteps = new TransactionSteps(extendedTransactionSteps);
    }

    public abstract boolean isXA();

    public abstract void notifyVridChange();

    public abstract void notifyUnknownName();

    public final long getTransactedSessionId() {
        return this._transactedSessionId;
    }

    protected final void setTransactedSessionId(long id) {
        this._transactedSessionId = id;
    }

    public void addInputStep(FlowHandleImpl fh, long msgId, long ackMsgId) {
        this._transactionSteps.addInputStep(fh, msgId, ackMsgId);
    }

    public void addOutputStep(JCSMPXMLMessageProducer prod, JCSMPXMLMessage msg) {
        this._transactionSteps.addOutputStep(prod, msg);
    }

    protected Map<FlowHandleImpl, TransactionSteps.InputFlowInfo> getTransactionInputSteps() {
        return this._transactionSteps.getInputSteps();
    }

    public long getLastMessageIdDeliveredToApp(FlowHandleImpl fh) {
        return this._transactionSteps.getMaxAck(fh);
    }

    protected Map<JCSMPXMLMessageProducer, TransactionSteps.OutputFlowInfo> getTransactionOutputSteps() {
        return this._transactionSteps.getOutputSteps();
    }

    protected Map<JCSMPXMLMessageProducer, TransactionSteps.OutputFlowInfo> getTransactionOutputStepsCopy() {
        return this._transactionSteps.getOutputStepsCopy();
    }

    public TransactionSteps getTransactionSteps() {
        return this._transactionSteps;
    }

    protected void resetTransactionSteps() {
        this._transactionSteps.reset();
    }

    protected void resetTransactionSteps(TransactionSteps subset) {
        this.getTransactionSteps().reset(subset);
    }

    public final String getName() {
        return this._transactedSessionName;
    }

    public final void setName(String name) {
        this._transactedSessionName = name;
    }

    public abstract void closeFlow(Closeable var1);

    public abstract boolean getExpectsAcks();

    public abstract boolean isTransportAckExpected();

    public boolean isMarkedAsRollback() {
        return false;
    }

    public abstract void notifyPreRetransmit();

    public abstract void notifyPostRetransmit();

    public boolean beforeEnqueue(FlowHandleImpl fh, XMLMessage deliver) {
        return true;
    }

    public void notifyPostReconnect(FlowHandleImpl flowHandleImpl) {
    }

    public void allowOperation(AllowedOperation op) throws InvalidOperationException {
    }

    public void waitForActiveStateAfterInterruption() throws JCSMPInterruptedException {
    }

    public void setRollbackOnly(FlowHandleImpl fh) {
    }

    public void setRollbackOnly(JCSMPXMLMessageProducer prod) {
    }

    public boolean isRollbackOnlySet(JCSMPXMLMessageProducer prod) {
        return false;
    }

    public void rollbackCurrentTransaction() {
    }

    public static enum AllowedOperation {
        CREATEFLOW,
        COMMIT,
        ROLLBACK,
        RECEIVE,
        SEND;

    }
}

