/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.smf.impl;

import com.solacesystems.common.util.BitTwiddleUtil;
import com.solacesystems.common.util.NetworkByteOrderNumberUtil;
import com.solacesystems.jcsmp.DeliveryMode;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlEnums;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlHeaderParameters;
import com.solacesystems.jcsmp.protocol.smf.SmfTLVParameter;
import com.solacesystems.jcsmp.protocol.smf.impl.MessageElementDescription;
import com.solacesystems.jcsmp.protocol.smf.impl.TlvCoderUtil;
import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class TlvParameterParser {
    private static final Log Trace = LogFactory.getLog(TlvParameterParser.class);

    private TlvParameterParser() {
    }

    public static int getSmfCorrelationId(byte[] buf, int off) {
        return (int)NetworkByteOrderNumberUtil.threeByteToUInt(buf, off);
    }

    public static int[] getTopicQueueNameOffset(byte[] buf, int off) {
        int[] result = new int[]{(int)NetworkByteOrderNumberUtil.oneByteToUInt(buf[off]), (int)NetworkByteOrderNumberUtil.oneByteToUInt(buf[off + 1])};
        return result;
    }

    public static DeliveryMode getSmfDeliveryMode(byte[] buf, int off) {
        int delMode = (int)NetworkByteOrderNumberUtil.oneByteToUInt(buf[off]);
        switch (delMode) {
            case 1: {
                return DeliveryMode.PERSISTENT;
            }
            case 0: {
                return DeliveryMode.NON_PERSISTENT;
            }
            case 2: {
                return DeliveryMode.DIRECT;
            }
        }
        return null;
    }

    public static int getAssuredTtl(byte[] buf, int off) {
        return (int)NetworkByteOrderNumberUtil.fourByteToUInt(buf, off);
    }

    public static long getAssuredTtlTime(byte[] buf, int off) {
        return NetworkByteOrderNumberUtil.eightByteToUInt(buf, off);
    }

    public static long getTopicSeqNum(byte[] buf, int off) {
        return NetworkByteOrderNumberUtil.eightByteToUInt(buf, off);
    }

    public static MessageElementDescription[] getMessageContentSummary(byte[] val) {
        int med_len;
        MessageElementDescription[] med_array = new MessageElementDescription[5];
        int med_cnt = 0;
        MessageElementDescription med_obj = null;
        for (int i = 0; i < val.length; i += med_len) {
            byte med_byte = val[i];
            int med_type = (int)BitTwiddleUtil.extractBits(med_byte, 4L, 4L);
            med_len = (int)BitTwiddleUtil.extractBits(med_byte, 4L, 0L);
            med_obj = MessageElementDescription.getDecodedMessageElementDescription(med_type, val, med_len - 1, i + 1);
            med_array[med_cnt++] = med_obj;
        }
        return med_array;
    }

    public static int[][] parseMessageContentSummary(MessageElementDescription[] summ) {
        int[][] msg_elem;
        for (int[] elem : msg_elem = new int[5][2]) {
            elem[1] = -1;
        }
        int msgPos = 0;
        for (MessageElementDescription d : summ) {
            if (d == null) break;
            int type = d.getType();
            int len = (int)d.getSizeInBytes();
            int pos = msgPos;
            msgPos += len;
            if (type == 3 || type == 0 || type == 1 || type == 2 || type == 4) {
                msg_elem[type][0] = pos;
                msg_elem[type][1] = len;
                continue;
            }
            if (!Trace.isWarnEnabled()) continue;
            Trace.warn((Object)String.format("Got unknown message element: type=%s", type));
        }
        return msg_elem;
    }

    public static long getSmfAssuredMsgId(SmfTLVParameter p) {
        return NetworkByteOrderNumberUtil.eightByteToUInt(p.value);
    }

    public static long getSmfAssuredMsgId(byte[] buf, int off) {
        return NetworkByteOrderNumberUtil.eightByteToUInt(buf, off);
    }

    public static long getSmfAssuredFlowId(byte[] buf, int off) {
        return NetworkByteOrderNumberUtil.fourByteToUInt(buf, off);
    }

    public static long getResponseCode(byte[] buf, int off) {
        return NetworkByteOrderNumberUtil.fourByteToUInt(buf, off);
    }

    public static String getResponseString(byte[] buf, int off, int len) {
        int strLength = len - 4;
        if (strLength > 0) {
            return new String(buf, off + 4, strLength);
        }
        return "";
    }

    public static int getMessagePriority(byte[] buf, int off) {
        return (int)NetworkByteOrderNumberUtil.oneByteToUInt(buf[off]);
    }

    public static String getTrTopicName(byte[] buf, int off, int len) {
        byte[] topicData = new byte[len - 1];
        System.arraycopy(buf, off, topicData, 0, len - 1);
        String ret_str = "";
        try {
            ret_str = new String(topicData, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            ret_str = new String(topicData);
        }
        return ret_str;
    }

    public static byte[] getTrTopicNameBytes(byte[] buf, int off, int len) {
        byte[] topicData = new byte[len - 1];
        System.arraycopy(buf, off, topicData, 0, len - 1);
        return topicData;
    }

    public static String getSubCtrlUdpMcastAddress(SmfTLVParameter p) {
        assert (p.value.length == 8);
        byte[] addrBytes = new byte[4];
        System.arraycopy(p.value, 0, addrBytes, 0, 4);
        String straddr = "";
        try {
            straddr = Inet4Address.getByAddress(addrBytes).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return straddr;
    }

    public static int getSubCtrlUdpMcastPort(SmfTLVParameter p) {
        assert (p.value.length == 8);
        byte[] portBytes = new byte[2];
        System.arraycopy(p.value, 4, portBytes, 0, 2);
        return (int)NetworkByteOrderNumberUtil.twoByteToUInt(portBytes);
    }

    public static int getSubCtrlUdpMcastSubscriberId(SmfTLVParameter p) {
        assert (p.value.length == 8);
        byte[] subidBytes = new byte[2];
        System.arraycopy(p.value, 6, subidBytes, 0, 2);
        return (int)NetworkByteOrderNumberUtil.twoByteToUInt(subidBytes);
    }

    public static long getAssuredLastMsgIdSent(SmfTLVParameter p) {
        return NetworkByteOrderNumberUtil.eightByteToUInt(p.value);
    }

    public static long getAssuredLastMsgIdAcked(SmfTLVParameter p) {
        return NetworkByteOrderNumberUtil.eightByteToUInt(p.value);
    }

    public static int getAssuredWindowSize(SmfTLVParameter p) {
        switch (p.value.length) {
            case 1: {
                return (int)NetworkByteOrderNumberUtil.oneByteToUInt(p.value[0]);
            }
            case 4: {
                return (int)NetworkByteOrderNumberUtil.fourByteToUInt(p.value);
            }
        }
        throw new IllegalArgumentException("Parameter length must be 1 or 4 bytes");
    }

    public static int getMaxDeliveredUnackedMsgs(SmfTLVParameter p) {
        return (int)NetworkByteOrderNumberUtil.fourByteToUInt(p.value);
    }

    public static long getAssuredFlowId(SmfTLVParameter p) {
        return NetworkByteOrderNumberUtil.fourByteToUInt(p.value);
    }

    public static long getEndpointId(SmfTLVParameter p) {
        return NetworkByteOrderNumberUtil.fourByteToUInt(p.value);
    }

    public static String getAssuredFlowName(SmfTLVParameter p) {
        return TlvCoderUtil.nullTermUtf8ToString(p.value);
    }

    public static boolean getAssuredActiveFlowIndication(SmfTLVParameter p) {
        int iType = (int)NetworkByteOrderNumberUtil.oneByteToUInt(p.value[0]);
        return iType == 1;
    }

    public static AssuredCtrlEnums.QueueAccessType getAssuredQueueAccessType(SmfTLVParameter p) {
        int iType = (int)NetworkByteOrderNumberUtil.oneByteToUInt(p.value[0]);
        return AssuredCtrlEnums.QueueAccessType.fromSmfEnc(iType);
    }

    public static AssuredCtrlEnums.FlowType getAssuredFlowType(SmfTLVParameter p) {
        int iType = (int)NetworkByteOrderNumberUtil.oneByteToUInt(p.value[0]);
        return AssuredCtrlEnums.FlowType.fromSmfEnc(iType);
    }

    public static AssuredCtrlEnums.TransactionCtrlMessageType getAssuredTransactionCtrlMessageType(SmfTLVParameter p) {
        int iType = (int)NetworkByteOrderNumberUtil.oneByteToUInt(p.value[0]);
        return AssuredCtrlEnums.TransactionCtrlMessageType.fromSmfEnc(iType);
    }

    public static long getAssuredTransactedSessionId(SmfTLVParameter p) {
        return NetworkByteOrderNumberUtil.fourByteToUInt(p.value);
    }

    public static String getAssuredTransactedSessionName(SmfTLVParameter p) {
        return TlvCoderUtil.nullTermUtf8ToString(p.value);
    }

    public static AssuredCtrlHeaderParameters.ParamTransactionId getAssuredTransactionId(SmfTLVParameter p) {
        return AssuredCtrlHeaderParameters.ParamTransactionId.fromValueBytes(p.value, 0);
    }

    public static AssuredCtrlEnums.TransactedSessionState getAssuredTransactedSessionState(SmfTLVParameter p) {
        int iType = (int)NetworkByteOrderNumberUtil.oneByteToUInt(p.value[0]);
        return AssuredCtrlEnums.TransactedSessionState.fromSmfEnc(iType);
    }

    public static AssuredCtrlHeaderParameters.ParamTransactionFDPubAck getAssuredTransactionDFPubAck(SmfTLVParameter p) {
        return AssuredCtrlHeaderParameters.ParamTransactionFDPubAck.fromValueBytes(p.value, 0, p.value.length);
    }

    public static long getAssuredPublisherId(SmfTLVParameter p) {
        return NetworkByteOrderNumberUtil.fourByteToUInt(p.value);
    }

    public static AssuredCtrlEnums.XACtrlMessageType getAssuredXACtrlMessageType(SmfTLVParameter p) {
        int iType = (int)NetworkByteOrderNumberUtil.oneByteToUInt(p.value[0]);
        return AssuredCtrlEnums.XACtrlMessageType.fromSmfEnc(iType);
    }
}

