/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.transaction;

import com.solacesystems.jcsmp.impl.transaction.TransactedSessionImpl;
import com.solacesystems.jcsmp.impl.transaction.TransactedSessionManager;
import com.solacesystems.jcsmp.impl.transaction.xa.XASessionImpl;
import com.solacesystems.jcsmp.impl.transaction.xa.XASessionManager;
import com.solacesystems.jcsmp.protocol.SeqNumAllocator;
import com.solacesystems.jcsmp.protocol.impl.SeqNum63bAllocator;

public class TransactedSessionTagAllocator {
    private SeqNumAllocator sessionTagAlloc = null;
    private boolean allocRollover = false;
    private XASessionManager xaTxMgr = null;
    private TransactedSessionManager localTxMgr = null;

    public TransactedSessionTagAllocator(TransactedSessionManager local, XASessionManager xa) {
        this.localTxMgr = local;
        this.xaTxMgr = xa;
        this.sessionTagAlloc = new SeqNum63bAllocator("TransactedSessionCorrelationTagSeqAllocator");
        this.sessionTagAlloc.getNext63b();
    }

    public synchronized int getNextSessionTag() {
        int tag = this.sessionTagAlloc.getNext24b();
        if (tag == 0) {
            this.allocRollover = true;
            tag = this.sessionTagAlloc.getNext24b();
        }
        if (this.allocRollover) {
            boolean used = false;
            while (true) {
                for (TransactedSessionImpl transactedSessionImpl : this.localTxMgr.getManagedSessions()) {
                    if (transactedSessionImpl.getSessionTag() != (long)tag) continue;
                    used = true;
                    break;
                }
                if (!used && this.xaTxMgr != null) {
                    for (XASessionImpl xASessionImpl : this.xaTxMgr.getManagedSessions()) {
                        if (xASessionImpl.getSessionTag() != (long)tag) continue;
                        used = true;
                        break;
                    }
                }
                if (!used) {
                    return tag;
                }
                ++tag;
                used = false;
            }
        }
        return tag;
    }
}

