/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.common.util;

import java.security.InvalidParameterException;

public class Base85 {
    public static String encode_ascii85_solace(byte[] inputBytes, int start, int end) {
        if (inputBytes == null) {
            throw new InvalidParameterException("Invalid input, input not be null");
        }
        if (inputBytes.length < end || inputBytes.length <= start) {
            throw new InvalidParameterException("Invalid input, required end <= length and start < length");
        }
        if (start >= end) {
            throw new InvalidParameterException("Invalid input, start > end");
        }
        if ((end - start) % 4 != 0) {
            throw new InvalidParameterException("Invalid input, end-start must be divisable by 4");
        }
        StringBuilder strBuilder = new StringBuilder();
        for (int i = start; i < inputBytes.length && i < end; i += 4) {
            long x;
            long s = x = (long)(inputBytes[i] << 24) & 0xFF000000L | (long)(inputBytes[i + 1] << 16) & 0xFF0000L | (long)(inputBytes[i + 2] << 8) & 0xFF00L | (long)inputBytes[i + 3] & 0xFFL;
            int B0 = (int)(s / 52200625L) % 85;
            int c0 = B0 + 33;
            int B1 = (int)((s %= 52200625L) / 614125L) % 85;
            int c1 = B1 + 33;
            int B2 = (int)((s %= 614125L) / 7225L) % 85;
            int c2 = B2 + 33;
            int B3 = (int)((s %= 7225L) / 85L) % 85;
            int c3 = B3 + 33;
            int B4 = (int)s % 85;
            int c4 = B4 + 33;
            strBuilder.append(Character.toChars(c0));
            strBuilder.append(Character.toChars(c1));
            strBuilder.append(Character.toChars(c2));
            strBuilder.append(Character.toChars(c3));
            strBuilder.append(Character.toChars(c4));
        }
        return strBuilder.toString();
    }

    public static String encode_ascii85(byte[] inputBytes, boolean wrapped) {
        byte[] paddedInput = inputBytes;
        int paddingLength = 0;
        int remainder = inputBytes.length % 4;
        if (remainder != 0) {
            paddingLength = 4 - remainder;
            byte[] zeroPaddingBytes = new byte[paddingLength];
            paddedInput = new byte[inputBytes.length + paddingLength];
            System.arraycopy(inputBytes, 0, paddedInput, 0, inputBytes.length);
            System.arraycopy(zeroPaddingBytes, 0, paddedInput, inputBytes.length, paddingLength);
        }
        StringBuilder strBuilder = new StringBuilder();
        if (wrapped) {
            strBuilder.append("<~");
        }
        for (int i = 0; i < paddedInput.length; i += 4) {
            long x;
            long s = x = (long)(paddedInput[i] << 24) & 0xFF000000L | (long)(paddedInput[i + 1] << 16) & 0xFF0000L | (long)(paddedInput[i + 2] << 8) & 0xFF00L | (long)paddedInput[i + 3] & 0xFFL;
            int B0 = (int)(s / 52200625L) % 85;
            int c0 = B0 + 33;
            int B1 = (int)((s %= 52200625L) / 614125L) % 85;
            int c1 = B1 + 33;
            int B2 = (int)((s %= 614125L) / 7225L) % 85;
            int c2 = B2 + 33;
            int B3 = (int)((s %= 7225L) / 85L) % 85;
            int c3 = B3 + 33;
            int B4 = (int)s % 85;
            int c4 = B4 + 33;
            if (remainder != 0 && i + 4 == paddedInput.length) {
                strBuilder.append(Character.toChars(c0));
                strBuilder.append(Character.toChars(c1));
                if (remainder == 1) break;
                strBuilder.append(Character.toChars(c2));
                if (remainder == 2) break;
                strBuilder.append(Character.toChars(c3));
                if (remainder == 3) break;
                strBuilder.append(Character.toChars(c4));
                continue;
            }
            if (B0 == 0 && B1 == 0 && B2 == 0 && B3 == 0 && B4 == 0) {
                strBuilder.append('z');
                continue;
            }
            strBuilder.append(Character.toChars(c0));
            strBuilder.append(Character.toChars(c1));
            strBuilder.append(Character.toChars(c2));
            strBuilder.append(Character.toChars(c3));
            strBuilder.append(Character.toChars(c4));
        }
        if (wrapped) {
            strBuilder.append("~>");
        }
        return strBuilder.toString();
    }

    public static String encode_ascii85(byte[] inputBytes) {
        return Base85.encode_ascii85(inputBytes, true);
    }

    private static void test(String input, String expected, boolean wrapped) {
        Base85.testb(input.getBytes(), expected, wrapped);
    }

    private static void testb(byte[] input, String expected, boolean wrapped) {
        String r = Base85.encode_ascii85(input, wrapped);
        if (!r.equals(expected)) {
            System.out.println("Failed result [" + r + "] / expected [" + expected + "]");
        }
    }

    private static void testb_solace(byte[] input, String expected, int start, int end) {
        String r = Base85.encode_ascii85_solace(input, start, end);
        if (!r.equals(expected)) {
            System.out.println("Failed result [" + r + "] / expected [" + expected + "]");
        }
    }

    public static void main(String[] args) {
        String t1 = "Man sure.";
        String e1 = "9jqo^F*2M7/c";
        Base85.test(t1, e1, false);
        String t2 = "Man is distinguished, not only by his reason, but by this singular passion from other animals, which is a lust of the mind, that by a perseverance of delight in the continued and indefatigable generation of knowledge, exceeds the short vehemence of any carnal pleasure.";
        String e2 = "<~9jqo^BlbD-BleB1DJ+*+F(f,q/0JhKF<GL>Cj@.4Gp$d7F!,L7@<6@)/0JDEF<G%<+EV:2F!,O<DJ+*.@<*K0@<6L(Df-\\0Ec5e;DffZ(EZee.Bl.9pF\"AGXBPCsi+DGm>@3BB/F*&OCAfu2/AKYi(DIb:@FD,*)+C]U=@3BN#EcYf8ATD3s@q?d$AftVqCh[NqF<G:8+EV:.+Cf>-FD5W8ARlolDIal(DId<j@<?3r@:F%a+D58'ATD4$Bl@l3De:,-DJs`8ARoFb/0JMK@qB4^F!,R<AKZ&-DfTqBG%G>uD.RTpAKYo'+CT/5+Cei#DII?(E,9)oF*2M7/c~>";
        Base85.test(t2, e2, true);
        byte[] b1 = new byte[]{0, 0, 0, 0};
        String e3 = "<~z~>";
        String e4 = "z";
        Base85.testb(b1, e3, true);
        Base85.testb(b1, e4, false);
        byte[] b2 = new byte[]{0, 0, 0, 0, 18, 52, 86, 120, 0, 0, 0, 0, 18, 52, 86, 120};
        String e5 = "<~z&i<X6z&i<X6~>";
        String e6 = "z&i<X6z&i<X6";
        Base85.testb(b2, e5, true);
        Base85.testb(b2, e6, false);
        String e7 = "!!!!!";
        String e8 = "!!!!!&i<X6!!!!!&i<X6";
        Base85.testb_solace(b1, e7, 0, b1.length);
        Base85.testb_solace(b2, e8, 0, b2.length);
    }
}

