/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.common.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class Base64 {
    public static final int NO_OPTIONS = 0;
    public static final int ENCODE = 1;
    public static final int DECODE = 0;
    public static final int GZIP = 2;
    public static final int DONT_BREAK_LINES = 8;
    public static final int URL_SAFE = 16;
    private static final int MAX_LINE_LENGTH = 76;
    private static final byte EQUALS_SIGN = 61;
    private static final byte NEW_LINE = 10;
    private static final String PREFERRED_ENCODING = "UTF-8";
    private static final byte[] ALPHABET;
    private static final byte[] URLSAFE_ALPHABET;
    private static final byte[] _NATIVE_ALPHABET;
    private static final byte[] _NATIVE_URLSAFE_ALPHABET;
    private static final byte[] DECODABET;
    private static final byte[] URLSAFE_DECODABET;
    private static final byte WHITE_SPACE_ENC = -5;
    private static final byte EQUALS_SIGN_ENC = -1;

    public static String getPreferredEncoding() {
        return PREFERRED_ENCODING;
    }

    private Base64() {
    }

    private static byte[] encode3to4(byte[] b4, byte[] threeBytes, int numSigBytes, boolean urlsafe) {
        Base64.encode3to4(threeBytes, 0, numSigBytes, b4, 0, urlsafe);
        return b4;
    }

    private static byte[] encode3to4(byte[] source, int srcOffset, int numSigBytes, byte[] destination, int destOffset, boolean urlsafe) {
        byte[] bytes = urlsafe ? URLSAFE_ALPHABET : ALPHABET;
        int inBuff = (numSigBytes > 0 ? source[srcOffset] << 24 >>> 8 : 0) | (numSigBytes > 1 ? source[srcOffset + 1] << 24 >>> 16 : 0) | (numSigBytes > 2 ? source[srcOffset + 2] << 24 >>> 24 : 0);
        switch (numSigBytes) {
            case 3: {
                destination[destOffset] = bytes[inBuff >>> 18];
                destination[destOffset + 1] = bytes[inBuff >>> 12 & 0x3F];
                destination[destOffset + 2] = bytes[inBuff >>> 6 & 0x3F];
                destination[destOffset + 3] = bytes[inBuff & 0x3F];
                return destination;
            }
            case 2: {
                destination[destOffset] = bytes[inBuff >>> 18];
                destination[destOffset + 1] = bytes[inBuff >>> 12 & 0x3F];
                destination[destOffset + 2] = bytes[inBuff >>> 6 & 0x3F];
                destination[destOffset + 3] = 61;
                return destination;
            }
            case 1: {
                destination[destOffset] = bytes[inBuff >>> 18];
                destination[destOffset + 1] = bytes[inBuff >>> 12 & 0x3F];
                destination[destOffset + 2] = 61;
                destination[destOffset + 3] = 61;
                return destination;
            }
        }
        return destination;
    }

    public static String encodeObject(Serializable serializableObject) {
        return Base64.encodeObject(serializableObject, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String encodeObject(Serializable serializableObject, int options) {
        ByteArrayOutputStream baos;
        block31: {
            baos = null;
            java.io.OutputStream b64os = null;
            ObjectOutputStream oos = null;
            DeflaterOutputStream gzos = null;
            int gzip = options & 2;
            int dontBreakLines = options & 8;
            int urlsafe = options & 0x10;
            baos = new ByteArrayOutputStream();
            b64os = new OutputStream(baos, 1 | dontBreakLines | urlsafe);
            if (gzip == 2) {
                gzos = new GZIPOutputStream(b64os);
                oos = new ObjectOutputStream(gzos);
            } else {
                oos = new ObjectOutputStream(b64os);
            }
            oos.writeObject(serializableObject);
            Object var12_9 = null;
            try {
                oos.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                gzos.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                b64os.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                baos.close();
            }
            catch (Exception exception) {}
            break block31;
            {
                catch (IOException e) {
                    e.printStackTrace();
                    String string = null;
                    Object var12_10 = null;
                    try {
                        oos.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        gzos.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        b64os.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        baos.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return string;
                }
            }
            catch (Throwable throwable) {
                Object var12_11 = null;
                try {
                    oos.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    gzos.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    b64os.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    baos.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            return new String(baos.toByteArray(), PREFERRED_ENCODING);
        }
        catch (UnsupportedEncodingException uue) {
            return new String(baos.toByteArray());
        }
    }

    public static String encodeBytes(byte[] source) {
        return Base64.encodeBytes(source, 0, source.length, 0);
    }

    public static String encodeBytes(byte[] source, int options) {
        return Base64.encodeBytes(source, 0, source.length, options);
    }

    public static String encodeBytes(byte[] source, int off, int len) {
        return Base64.encodeBytes(source, off, len, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String encodeBytes(byte[] source, int off, int len, int options) {
        int urlsafe;
        int dontBreakLines;
        block28: {
            ByteArrayOutputStream baos;
            block29: {
                dontBreakLines = options & 8;
                int gzip = options & 2;
                urlsafe = options & 0x10;
                if (gzip != 2) break block28;
                baos = null;
                DeflaterOutputStream gzos = null;
                OutputStream b64os = null;
                baos = new ByteArrayOutputStream();
                b64os = new OutputStream(baos, 1 | dontBreakLines | urlsafe);
                gzos = new GZIPOutputStream(b64os);
                ((GZIPOutputStream)gzos).write(source, off, len);
                gzos.close();
                Object var13_13 = null;
                try {
                    gzos.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    b64os.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    baos.close();
                }
                catch (Exception exception) {}
                break block29;
                {
                    catch (IOException e) {
                        e.printStackTrace();
                        String string = null;
                        Object var13_14 = null;
                        try {
                            gzos.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            b64os.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            baos.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return string;
                    }
                }
                catch (Throwable throwable) {
                    Object var13_15 = null;
                    try {
                        gzos.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        b64os.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        baos.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            try {
                return new String(baos.toByteArray(), PREFERRED_ENCODING);
            }
            catch (UnsupportedEncodingException uue) {
                return new String(baos.toByteArray());
            }
        }
        boolean breakLines = dontBreakLines == 0;
        int len43 = len * 4 / 3;
        byte[] outBuff = new byte[len43 + (len % 3 > 0 ? 4 : 0) + (breakLines ? len43 / 76 : 0)];
        int d = 0;
        int e = 0;
        int len2 = len - 2;
        int lineLength = 0;
        while (d < len2) {
            Base64.encode3to4(source, d + off, 3, outBuff, e, urlsafe != 0);
            if (breakLines && (lineLength += 4) == 76) {
                outBuff[e + 4] = 10;
                ++e;
                lineLength = 0;
            }
            d += 3;
            e += 4;
        }
        if (d < len) {
            Base64.encode3to4(source, d + off, len - d, outBuff, e, urlsafe != 0);
            e += 4;
        }
        try {
            return new String(outBuff, 0, e, PREFERRED_ENCODING);
        }
        catch (UnsupportedEncodingException uue) {
            return new String(outBuff, 0, e);
        }
    }

    private static int decode4to3(byte[] source, int srcOffset, byte[] destination, int destOffset, boolean urlsafe) {
        byte[] bytes = urlsafe ? URLSAFE_DECODABET : DECODABET;
        if (source[srcOffset + 2] == 61) {
            int outBuff = (bytes[source[srcOffset]] & 0xFF) << 18 | (bytes[source[srcOffset + 1]] & 0xFF) << 12;
            destination[destOffset] = (byte)(outBuff >>> 16);
            return 1;
        }
        if (source[srcOffset + 3] == 61) {
            int outBuff = (bytes[source[srcOffset]] & 0xFF) << 18 | (bytes[source[srcOffset + 1]] & 0xFF) << 12 | (bytes[source[srcOffset + 2]] & 0xFF) << 6;
            destination[destOffset] = (byte)(outBuff >>> 16);
            destination[destOffset + 1] = (byte)(outBuff >>> 8);
            return 2;
        }
        try {
            int outBuff = (bytes[source[srcOffset]] & 0xFF) << 18 | (bytes[source[srcOffset + 1]] & 0xFF) << 12 | (bytes[source[srcOffset + 2]] & 0xFF) << 6 | bytes[source[srcOffset + 3]] & 0xFF;
            destination[destOffset] = (byte)(outBuff >> 16);
            destination[destOffset + 1] = (byte)(outBuff >> 8);
            destination[destOffset + 2] = (byte)outBuff;
            return 3;
        }
        catch (Exception e) {
            System.out.println("" + source[srcOffset] + ": " + bytes[source[srcOffset]]);
            System.out.println("" + source[srcOffset + 1] + ": " + bytes[source[srcOffset + 1]]);
            System.out.println("" + source[srcOffset + 2] + ": " + bytes[source[srcOffset + 2]]);
            System.out.println("" + source[srcOffset + 3] + ": " + bytes[source[srcOffset + 3]]);
            return -1;
        }
    }

    public static byte[] decode(byte[] source, int off, int len, boolean urlsafe) {
        int len34 = len * 3 / 4;
        byte[] outBuff = new byte[len34];
        int outBuffPosn = 0;
        byte[] b4 = new byte[4];
        int b4Posn = 0;
        int i = 0;
        byte sbiCrop = 0;
        byte sbiDecode = 0;
        for (i = off; i < off + len; ++i) {
            byte[] bytes = urlsafe ? DECODABET : URLSAFE_DECODABET;
            sbiDecode = bytes[sbiCrop = (byte)(source[i] & 0x7F)];
            if (sbiDecode >= -5) {
                if (sbiDecode < -1) continue;
                b4[b4Posn++] = sbiCrop;
                if (b4Posn <= 3) continue;
                outBuffPosn += Base64.decode4to3(b4, 0, outBuff, outBuffPosn, urlsafe);
                b4Posn = 0;
                if (sbiCrop != 61) continue;
                break;
            }
            System.err.println("Bad Base64 input character at " + i + ": " + source[i] + "(decimal)");
            return null;
        }
        byte[] out = new byte[outBuffPosn];
        System.arraycopy(outBuff, 0, out, 0, outBuffPosn);
        return out;
    }

    public static byte[] decode(String s) {
        return Base64.decode(s, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static byte[] decode(String s, boolean urlsafe) {
        byte[] bytes;
        block24: {
            int head;
            try {
                bytes = s.getBytes(PREFERRED_ENCODING);
            }
            catch (UnsupportedEncodingException uee) {
                bytes = s.getBytes();
            }
            bytes = Base64.decode(bytes, 0, bytes.length, urlsafe);
            if (bytes != null && bytes.length >= 4 && 35615 == (head = bytes[0] & 0xFF | bytes[1] << 8 & 0xFF00)) {
                ByteArrayInputStream bais = null;
                GZIPInputStream gzis = null;
                ByteArrayOutputStream baos = null;
                byte[] buffer = new byte[2048];
                int length = 0;
                baos = new ByteArrayOutputStream();
                bais = new ByteArrayInputStream(bytes);
                gzis = new GZIPInputStream(bais);
                while ((length = gzis.read(buffer)) >= 0) {
                    baos.write(buffer, 0, length);
                }
                bytes = baos.toByteArray();
                Object var11_10 = null;
                try {
                    baos.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    gzis.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    bais.close();
                }
                catch (Exception exception) {}
                break block24;
                {
                    catch (IOException iOException) {
                        Object var11_11 = null;
                        try {
                            baos.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            gzis.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            bais.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var11_12 = null;
                    try {
                        baos.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        gzis.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        bais.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object decodeToObject(String encodedObject, boolean urlsafe) throws IOException, ClassNotFoundException {
        byte[] objBytes = Base64.decode(encodedObject, urlsafe);
        ByteArrayInputStream bais = null;
        ObjectInputStream ois = null;
        Object obj = null;
        try {
            bais = new ByteArrayInputStream(objBytes);
            ois = new ObjectInputStream(bais);
            obj = ois.readObject();
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                bais.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                ois.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            bais.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ois.close();
        }
        catch (Exception exception) {}
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean encodeToFile(byte[] dataToEncode, String filename, boolean urlsafe) {
        boolean success;
        block8: {
            success = false;
            OutputStream bos = null;
            bos = new OutputStream(new FileOutputStream(filename), 17);
            bos.write(dataToEncode);
            success = true;
            Object var7_5 = null;
            try {
                bos.close();
            }
            catch (Exception exception) {}
            break block8;
            {
                catch (IOException e) {
                    success = false;
                    Object var7_6 = null;
                    try {
                        bos.close();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                try {
                    bos.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean decodeToFile(String dataToDecode, String filename, boolean urlsafe) {
        boolean success;
        block8: {
            success = false;
            OutputStream bos = null;
            bos = new OutputStream(new FileOutputStream(filename), 16);
            bos.write(dataToDecode.getBytes(PREFERRED_ENCODING));
            success = true;
            Object var7_5 = null;
            try {
                bos.close();
            }
            catch (Exception exception) {}
            break block8;
            {
                catch (IOException e) {
                    success = false;
                    Object var7_6 = null;
                    try {
                        bos.close();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                try {
                    bos.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static byte[] decodeFromFile(String filename, boolean urlsafe) {
        byte[] decodedData;
        block13: {
            int numBytes;
            int length;
            byte[] buffer;
            File file;
            FilterInputStream bis;
            block11: {
                decodedData = null;
                bis = null;
                file = new File(filename);
                buffer = null;
                length = 0;
                numBytes = 0;
                if (file.length() <= Integer.MAX_VALUE) break block11;
                System.err.println("File is too big for this convenience method (" + file.length() + " bytes).");
                byte[] byArray = null;
                Object var10_10 = null;
                try {
                    bis.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return byArray;
            }
            buffer = new byte[(int)file.length()];
            bis = new InputStream(new BufferedInputStream(new FileInputStream(file)), 16);
            while ((numBytes = ((InputStream)bis).read(buffer, length, 4096)) >= 0) {
                length += numBytes;
            }
            decodedData = new byte[length];
            System.arraycopy(buffer, 0, decodedData, 0, length);
            Object var10_11 = null;
            try {
                bis.close();
            }
            catch (Exception exception) {}
            break block13;
            {
                catch (IOException e) {
                    System.err.println("Error decoding from file " + filename);
                    Object var10_12 = null;
                    try {
                        bis.close();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                try {
                    bis.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return decodedData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String encodeFromFile(String filename, boolean urlsafe) {
        String encodedData;
        block9: {
            encodedData = null;
            FilterInputStream bis = null;
            File file = new File(filename);
            byte[] buffer = new byte[(int)((double)file.length() * 1.4)];
            int length = 0;
            int numBytes = 0;
            bis = new InputStream(new BufferedInputStream(new FileInputStream(file)), 17);
            while ((numBytes = ((InputStream)bis).read(buffer, length, 4096)) >= 0) {
                length += numBytes;
            }
            encodedData = new String(buffer, 0, length, PREFERRED_ENCODING);
            Object var9_9 = null;
            try {
                bis.close();
            }
            catch (Exception exception) {}
            break block9;
            {
                catch (IOException e) {
                    System.err.println("Error encoding from file " + filename);
                    Object var9_10 = null;
                    try {
                        bis.close();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    bis.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return encodedData;
    }

    static {
        byte[] __urlsafe_bytes;
        byte[] __bytes;
        _NATIVE_ALPHABET = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
        _NATIVE_URLSAFE_ALPHABET = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 45, 95};
        try {
            __bytes = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".getBytes(PREFERRED_ENCODING);
            __urlsafe_bytes = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_".getBytes(PREFERRED_ENCODING);
        }
        catch (UnsupportedEncodingException use) {
            __bytes = _NATIVE_ALPHABET;
            __urlsafe_bytes = _NATIVE_URLSAFE_ALPHABET;
        }
        ALPHABET = __bytes;
        URLSAFE_ALPHABET = __urlsafe_bytes;
        DECODABET = new byte[]{-9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -5, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 62, -9, -9, -9, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -9, -9, -9, -1, -9, -9, -9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -9, -9, -9, -9, -9, -9, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -9, -9, -9, -9};
        URLSAFE_DECODABET = new byte[]{-9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -5, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 62, -9, -9, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -9, -9, -9, -1, -9, -9, -9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -9, -9, -9, -9, -9, -9, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -9, -9, -9, 63};
    }

    public static class OutputStream
    extends FilterOutputStream {
        private boolean encode;
        private int position;
        private byte[] buffer;
        private int bufferLength;
        private int lineLength;
        private boolean breakLines;
        private boolean urlsafe;
        private byte[] b4;
        private boolean suspendEncoding;

        public OutputStream(java.io.OutputStream out) {
            this(out, 1);
        }

        private int _lookup(int theByte) {
            byte[] bytes = this.urlsafe ? URLSAFE_DECODABET : DECODABET;
            return bytes[theByte];
        }

        public OutputStream(java.io.OutputStream out, int options) {
            super(out);
            this.breakLines = (options & 8) != 8;
            this.encode = (options & 1) == 1;
            this.urlsafe = (options & 0x10) == 16;
            this.bufferLength = this.encode ? 3 : 4;
            this.buffer = new byte[this.bufferLength];
            this.position = 0;
            this.lineLength = 0;
            this.suspendEncoding = false;
            this.b4 = new byte[4];
        }

        public void write(int theByte) throws IOException {
            if (this.suspendEncoding) {
                this.out.write(theByte);
                return;
            }
            if (this.encode) {
                this.buffer[this.position++] = (byte)theByte;
                if (this.position >= this.bufferLength) {
                    this.out.write(Base64.encode3to4(this.b4, this.buffer, this.bufferLength, this.urlsafe));
                    this.lineLength += 4;
                    if (this.breakLines && this.lineLength >= 76) {
                        this.out.write(10);
                        this.lineLength = 0;
                    }
                    this.position = 0;
                }
            } else if (this._lookup(theByte & 0x7F) > -5) {
                this.buffer[this.position++] = (byte)theByte;
                if (this.position >= this.bufferLength) {
                    int len = Base64.decode4to3(this.buffer, 0, this.b4, 0, this.urlsafe);
                    this.out.write(this.b4, 0, len);
                    this.position = 0;
                }
            } else if (this._lookup(theByte & 0x7F) != -5) {
                throw new IOException("Invalid character in Base64 data.");
            }
        }

        public void write(byte[] theBytes, int off, int len) throws IOException {
            if (this.suspendEncoding) {
                this.out.write(theBytes, off, len);
                return;
            }
            for (int i = 0; i < len; ++i) {
                this.write(theBytes[off + i]);
            }
        }

        public void flushBase64() throws IOException {
            if (this.position > 0) {
                if (this.encode) {
                    this.out.write(Base64.encode3to4(this.b4, this.buffer, this.position, this.urlsafe));
                    this.position = 0;
                } else {
                    throw new IOException("Base64 input not properly padded.");
                }
            }
        }

        public void close() throws IOException {
            this.flushBase64();
            super.close();
            this.buffer = null;
            this.out = null;
        }

        public void suspendEncoding() throws IOException {
            this.flushBase64();
            this.suspendEncoding = true;
        }

        public void resumeEncoding() {
            this.suspendEncoding = false;
        }
    }

    public static class InputStream
    extends FilterInputStream {
        private boolean encode;
        private int position;
        private byte[] buffer;
        private int bufferLength;
        private int numSigBytes;
        private int lineLength;
        private boolean breakLines;
        private boolean urlsafe;

        public InputStream(java.io.InputStream in) {
            this(in, 0);
        }

        public InputStream(java.io.InputStream in, int options) {
            super(in);
            this.breakLines = (options & 8) != 8;
            this.encode = (options & 1) == 1;
            this.urlsafe = (options & 0x10) == 16;
            this.bufferLength = this.encode ? 4 : 3;
            this.buffer = new byte[this.bufferLength];
            this.position = -1;
            this.lineLength = 0;
        }

        private int _lookup(int theByte) {
            byte[] bytes = this.urlsafe ? URLSAFE_DECODABET : DECODABET;
            return bytes[theByte];
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int read() throws IOException {
            if (this.position < 0) {
                if (this.encode) {
                    byte[] b3 = new byte[3];
                    int numBinaryBytes = 0;
                    for (int i = 0; i < 3; ++i) {
                        try {
                            int b = this.in.read();
                            if (b < 0) continue;
                            b3[i] = (byte)b;
                            ++numBinaryBytes;
                            continue;
                        }
                        catch (IOException e) {
                            if (i != 0) continue;
                            throw e;
                        }
                    }
                    if (numBinaryBytes <= 0) return -1;
                    Base64.encode3to4(b3, 0, numBinaryBytes, this.buffer, 0, this.urlsafe);
                    this.position = 0;
                    this.numSigBytes = 4;
                } else {
                    byte[] b4 = new byte[4];
                    int i = 0;
                    for (i = 0; i < 4; ++i) {
                        int b = 0;
                        while ((b = this.in.read()) >= 0 && this._lookup(b & 0x7F) <= -5) {
                        }
                        if (b < 0) break;
                        b4[i] = (byte)b;
                    }
                    if (i == 4) {
                        this.numSigBytes = Base64.decode4to3(b4, 0, this.buffer, 0, this.urlsafe);
                        this.position = 0;
                    } else {
                        if (i != 0) throw new IOException("Improperly padded Base64 input.");
                        return -1;
                    }
                }
            }
            if (this.position < 0) throw new IOException("Error in Base64 code reading stream.");
            if (this.position >= this.numSigBytes) {
                return -1;
            }
            if (this.encode && this.breakLines && this.lineLength >= 76) {
                this.lineLength = 0;
                return 10;
            }
            ++this.lineLength;
            byte b = this.buffer[this.position++];
            if (this.position < this.bufferLength) return b & 0xFF;
            this.position = -1;
            return b & 0xFF;
        }

        public int read(byte[] dest, int off, int len) throws IOException {
            int i;
            for (i = 0; i < len; ++i) {
                int b = this.read();
                if (b < 0) {
                    if (i != 0) break;
                    return -1;
                }
                dest[off + i] = (byte)b;
            }
            return i;
        }
    }
}

