/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.nio.impl;

import com.solacesystems.jcsmp.JCSMPFactory;
import com.solacesystems.jcsmp.JCSMPStreamingPublishEventHandler;
import com.solacesystems.jcsmp.protocol.nio.Notification;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProducerNotificationDispatcher
implements Runnable {
    private static final Log log = LogFactory.getLog(ProducerNotificationDispatcher.class);
    private ArrayBlockingQueue<Notification> _dispatcherQ = new ArrayBlockingQueue(JCSMPFactory.onlyInstance().getGlobalProperties().getProducerDispatcherQueueSize());
    private Thread serviceThread = new Thread(this);

    private ProducerNotificationDispatcher(String ctxId) {
        this.serviceThread.setName(String.format("Context_%s_ProducerDispatcher", ctxId));
        this.serviceThread.setDaemon(true);
    }

    public static ProducerNotificationDispatcher create(String name) {
        ProducerNotificationDispatcher disp = new ProducerNotificationDispatcher(name);
        disp.serviceThread.start();
        return disp;
    }

    public synchronized void enqueueNotification(Notification notif) {
        block3: {
            if (this.isFull() && log.isWarnEnabled()) {
                log.warn((Object)String.format("ProducerNotificationDispatcher queue (size=%s) low space warning.", this._dispatcherQ.size()));
            }
            try {
                this._dispatcherQ.put(notif);
            }
            catch (InterruptedException e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)(Thread.currentThread().getName() + " is interrupted"));
            }
        }
    }

    public boolean isFull() {
        return this._dispatcherQ.remainingCapacity() == 0;
    }

    public int getSize() {
        return this._dispatcherQ.size();
    }

    public int getRemainingCapacity() {
        return this._dispatcherQ.remainingCapacity();
    }

    public synchronized void purgeNotifications(JCSMPStreamingPublishEventHandler handler, List<Notification> removedNotifs) {
        if (handler == null) {
            return;
        }
        Iterator<Notification> it = this._dispatcherQ.iterator();
        Notification notif = null;
        while (it.hasNext() && (notif = it.next()) != null) {
            if (!notif.usesHandler(handler)) continue;
            notif.cancel();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void eventLoop() throws InterruptedException {
        try {
            while (true) {
                Notification notif = this._dispatcherQ.take();
                try {
                    int ret = notif.handleNotification();
                    if ((ret & 1) == 0) continue;
                    return;
                }
                catch (Throwable t) {
                    log.warn((Object)"Exception occurred in message producer notification handler", t);
                    continue;
                }
                break;
            }
        }
        catch (Throwable t) {
            log.error((Object)"Unexpected exception occurred in message producer notification handler", t);
        }
    }

    @Override
    public void run() {
        block4: {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Producer dispatcher thread starts");
            }
            try {
                this.eventLoop();
            }
            catch (InterruptedException e) {
                if (!log.isDebugEnabled()) break block4;
                log.debug((Object)(Thread.currentThread().getName() + " is interrupted"));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Producer dispatcher thread [%s] exits", this.serviceThread.getName()));
        }
    }
}

