/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms;

import com.solacesystems.jms.SolConnectionIF;
import com.solacesystems.jms.SolQueueReceiver;
import com.solacesystems.jms.SolQueueSender;
import com.solacesystems.jms.SolSession;
import com.solacesystems.jms.SolSessionIF;
import com.solacesystems.jms.impl.JMSState;
import com.solacesystems.jms.impl.SolJMSErrorMessages;
import com.solacesystems.jms.impl.Validator;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SolQueueSession
extends SolSession
implements QueueSession {
    private static final Log log = LogFactory.getLog(SolQueueSession.class);
    private static final String Component = "QueueSession";

    public SolQueueSession(SolConnectionIF connection, boolean transacted, int acknowledgeMode, JMSState state) throws JMSException {
        super(connection, transacted, acknowledgeMode, state);
        if (log.isDebugEnabled()) {
            log.debug((Object)"SolQueueSession created.");
        }
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        return this.createReceiver(queue, null);
    }

    public QueueReceiver createReceiver(Queue queue, String messageSelector) throws JMSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entering createReceiver");
        }
        Validator.checkClosed(this.mState, Component);
        Validator.checkConsumerDestination((Destination)queue, this.mConnection);
        SolQueueReceiver rcvr = new SolQueueReceiver(this, queue, messageSelector, false, this.mState);
        this.mConsumers.add(rcvr);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Leaving createReceiver");
        }
        return rcvr;
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entering createSender");
        }
        Validator.checkClosed(this.mState, Component);
        Validator.checkProducerDestination(this.mSessionProps.getConnectionProperties().getRouterCapabilities().crMode(), (Destination)queue);
        SolQueueSender sender = new SolQueueSender((SolSessionIF)this, queue);
        this.mProducers.add(sender);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Leaving createSender");
        }
        return sender;
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        throw new IllegalStateException(SolJMSErrorMessages.getMessage("soljms.operation.consumer.create", "soljms.error.illegalstate", "createDurableSubscriber()"), "soljms.error.illegalstate");
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        throw new IllegalStateException(SolJMSErrorMessages.getMessage("soljms.operation.consumer.create", "soljms.error.illegalstate", "createDurableSubscriber()"), "soljms.error.illegalstate");
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        throw new IllegalStateException(SolJMSErrorMessages.getMessage("soljms.operation.topic.create", "soljms.error.illegalstate", "createTemporaryTopic()"), "soljms.error.illegalstate");
    }

    public Topic createTopic(String topicName) throws JMSException {
        throw new IllegalStateException(SolJMSErrorMessages.getMessage("soljms.operation.topic.create", "soljms.error.illegalstate", "createTopic()"), "soljms.error.illegalstate");
    }

    public void unsubscribe(String name) throws JMSException {
        throw new IllegalStateException(SolJMSErrorMessages.getMessage("soljms.operation.unsubscribe", "soljms.error.illegalstate", "unsubscribe()"), "soljms.error.illegalstate");
    }
}

