/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl;

import com.solacesystems.common.util.StringUtil;
import com.solacesystems.jcsmp.Destination;
import com.solacesystems.jcsmp.Queue;
import com.solacesystems.jcsmp.SDTException;
import com.solacesystems.jcsmp.SDTMap;
import com.solacesystems.jcsmp.SDTStream;
import com.solacesystems.jcsmp.Topic;
import com.solacesystems.jcsmp.impl.JCSMPGenericXMLMessage;
import com.solacesystems.jcsmp.impl.MapMessageImpl;
import com.solacesystems.jcsmp.impl.MessageDumpFieldProvider;
import com.solacesystems.jcsmp.impl.StreamMessageImpl;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageDumpStandardProvider {
    static final String ERROR = "ERROR";

    public static void main(String[] args) {
        byte[] data = "The quick brown fox jumps\t\t over the lazy dog.".getBytes(Charset.forName("UTF-8"));
        System.out.println(StringUtil.formatDumpBytes(data, true, 2));
        System.out.println(StringUtil.formatDumpBytes(data, false, 2));
    }

    static int countKeys(SDTMap map) throws SDTException {
        if (map == null) {
            return 0;
        }
        return map.keySet().size();
    }

    static int countItems(SDTStream stream) throws SDTException {
        if (stream == null) {
            return 0;
        }
        int cnt = 0;
        while (stream.hasRemaining()) {
            Object value = stream.read();
            ++cnt;
        }
        stream.rewind();
        return cnt;
    }

    static String printMap(SDTMap map, int indent) throws SDTException {
        if (map == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        String strIndent = StringUtil.padRight("", indent);
        Iterator<String> it = map.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next();
            Object value = map.get(key);
            String strValue = String.valueOf(value);
            String type = "NULL";
            if (value != null) {
                Class<?> valuClass = value.getClass();
                type = valuClass.getSimpleName();
                if (value instanceof SDTMap) {
                    strValue = "\n";
                    strValue = strValue + MessageDumpStandardProvider.printMap((SDTMap)value, indent + 2);
                } else if (value instanceof SDTStream) {
                    strValue = "\n";
                    strValue = strValue + MessageDumpStandardProvider.printStream((SDTStream)value, indent + 2);
                }
            }
            sb.append(strIndent);
            sb.append(String.format("Key '%s' (%s): %s", key, type, strValue));
            if (!it.hasNext()) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    static String printStream(SDTStream stream, int indent) throws SDTException {
        if (stream == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        String strIndent = StringUtil.padRight("", indent);
        while (stream.hasRemaining()) {
            Object value = stream.read();
            String strValue = String.valueOf(value);
            String type = "NULL";
            if (value != null) {
                Class<?> valuClass = value.getClass();
                type = valuClass.getSimpleName();
                if (value instanceof SDTMap) {
                    strValue = "\n";
                    strValue = strValue + MessageDumpStandardProvider.printMap((SDTMap)value, indent + 2);
                } else if (value instanceof SDTStream) {
                    strValue = "\n";
                    strValue = strValue + MessageDumpStandardProvider.printStream((SDTStream)value, indent + 2);
                }
            }
            sb.append(strIndent);
            sb.append(String.format("(%s): %s", type, strValue));
            if (!stream.hasRemaining()) continue;
            sb.append("\n");
        }
        stream.rewind();
        return sb.toString();
    }

    static String formatDate(Long time) {
        if (time == null) {
            return "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("EEE MMM dd yyyy HH:mm:ss.SSS");
        return time + " (" + sdf.format(new Date(time)) + ")";
    }

    public static Collection<MessageDumpFieldProvider<JCSMPGenericXMLMessage>> getStandardFieldProviders() {
        ArrayList<MessageDumpFieldProvider<JCSMPGenericXMLMessage>> providers = new ArrayList<MessageDumpFieldProvider<JCSMPGenericXMLMessage>>();
        providers.add(new FPDestination());
        providers.add(new FPSenderId());
        providers.add(new FPAppMsgType());
        providers.add(new FPAppMsgId());
        providers.add(new FPSequenceNumber());
        providers.add(new FPTopicSequenceNumber());
        providers.add(new FPCorrelationId());
        providers.add(new FPSendTimestamp());
        providers.add(new FPRcvTimestamp());
        providers.add(new FPPriority());
        providers.add(new FPClassOfService());
        providers.add(new FPDeliveryMode());
        providers.add(new FPMessageId());
        providers.add(new FPMessageRedelivered());
        providers.add(new FPDiscardIndication());
        providers.add(new FPDAckImmediately());
        providers.add(new FPReplyMessage());
        providers.add(new FPReplyTo());
        providers.add(new FPDeliverToOne());
        providers.add(new FPMessageFromCache());
        providers.add(new FPCacheRequestId());
        providers.add(new FPConsumerId());
        providers.add(new FPTimeToLive());
        providers.add(new FPExpiration());
        providers.add(new FPDMQEligible());
        providers.add(new FPElidingEligible());
        providers.add(new FPUserData());
        providers.add(new FPUserPropertyMap());
        providers.add(new FPSDTStream());
        providers.add(new FPSDTMap());
        providers.add(new FPHTTPContentType());
        providers.add(new FPHTTPContentEncoding());
        providers.add(new FPBinaryAttachment());
        providers.add(new FPXml());
        providers.add(new FPXmlMeta());
        return providers;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FPXmlMeta
    implements MessageDumpFieldProvider<JCSMPGenericXMLMessage> {
        FPXmlMeta() {
        }

        @Override
        public Object[] getData(JCSMPGenericXMLMessage msg, int flags) {
            String lenUserData = "";
            String detailValue = null;
            int mContentLen = msg.getMetadataContentLength();
            if (mContentLen > 0) {
                lenUserData = "len=" + mContentLen;
                if ((flags & 1) > 0) {
                    byte[] buf = new byte[mContentLen];
                    msg.readMetadataBytes(buf);
                    detailValue = StringUtil.formatDumpBytes(buf, true, 2);
                }
            }
            return new Object[]{"XML Metadata", mContentLen > 0, lenUserData, detailValue};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FPXml
    implements MessageDumpFieldProvider<JCSMPGenericXMLMessage> {
        @Override
        public Object[] getData(JCSMPGenericXMLMessage msg, int flags) {
            String lenUserData = "";
            String detailValue = null;
            int mContentLen = msg.getContentLength();
            if (mContentLen > 0) {
                lenUserData = "len=" + mContentLen;
                if ((flags & 1) > 0) {
                    byte[] buf = new byte[mContentLen];
                    msg.readContentBytes(buf);
                    detailValue = StringUtil.formatDumpBytes(buf, true, 2);
                }
            }
            return new Object[]{"XML", mContentLen > 0, lenUserData, detailValue};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FPBinaryAttachment
    implements MessageDumpFieldProvider<JCSMPGenericXMLMessage> {
        @Override
        public Object[] getData(JCSMPGenericXMLMessage msg, int flags) {
            String lenUserData = "";
            String detailValue = null;
            if (msg.getAttachmentContentLength() > 0) {
                lenUserData = "len=" + msg.getAttachmentContentLength();
                if ((flags & 1) > 0) {
                    detailValue = StringUtil.formatDumpBytes(msg.getAttachmentContent(), true, 2);
                }
            }
            return new Object[]{"Binary Attachment", msg.getAttachmentContentLength() > 0, lenUserData, detailValue};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FPSDTMap
    implements MessageDumpFieldProvider<JCSMPGenericXMLMessage> {
        FPSDTMap() {
        }

        @Override
        public Object[] getData(JCSMPGenericXMLMessage msg, int flags) {
            boolean isPresent = msg.getStructuredMsgType() == 10;
            String value = "";
            String detailValue = null;
            if (isPresent) {
                MapMessageImpl map_msg = new MapMessageImpl(msg);
                SDTMap map = map_msg.getMap();
                try {
                    value = String.format("%s entries", MessageDumpStandardProvider.countKeys(map));
                    if ((flags & 1) > 0) {
                        detailValue = MessageDumpStandardProvider.printMap(map, 2);
                    }
                }
                catch (SDTException e) {
                    detailValue = MessageDumpStandardProvider.ERROR;
                }
            }
            return new Object[]{"SDT Map", isPresent, value, detailValue};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FPSDTStream
    implements MessageDumpFieldProvider<JCSMPGenericXMLMessage> {
        FPSDTStream() {
        }

        @Override
        public Object[] getData(JCSMPGenericXMLMessage msg, int flags) {
            boolean isPresent = msg.getStructuredMsgType() == 11;
            String value = "";
            String detailValue = null;
            if (isPresent) {
                StreamMessageImpl stream_msg = new StreamMessageImpl(msg);
                SDTStream stream = stream_msg.getStream();
                try {
                    value = String.format("%s entries", MessageDumpStandardProvider.countItems(stream));
                    if ((flags & 1) > 0) {
                        detailValue = MessageDumpStandardProvider.printStream(stream, 2);
                    }
                }
                catch (SDTException e) {
                    detailValue = MessageDumpStandardProvider.ERROR;
                }
            }
            return new Object[]{"SDT Stream", isPresent, value, detailValue};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FPUserPropertyMap
    implements MessageDumpFieldProvider<JCSMPGenericXMLMessage> {
        FPUserPropertyMap() {
        }

        @Override
        public Object[] getData(JCSMPGenericXMLMessage msg, int flags) {
            SDTMap prop_map = msg.getProperties();
            boolean isPresent = prop_map != null;
            String value = "";
            String detailValue = null;
            try {
                value = String.format("%s entries", MessageDumpStandardProvider.countKeys(prop_map));
                if ((flags & 1) > 0) {
                    detailValue = MessageDumpStandardProvider.printMap(prop_map, 2);
                }
            }
            catch (SDTException ex) {
                detailValue = MessageDumpStandardProvider.ERROR;
            }
            return new Object[]{"User Property Map", isPresent, value, detailValue};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FPHTTPContentEncoding
    implements MessageDumpFieldProvider<JCSMPGenericXMLMessage> {
        FPHTTPContentEncoding() {
        }

        @Override
        public Object[] getData(JCSMPGenericXMLMessage msg, int flags) {
            return new Object[]{"HTTP Content Encoding", msg.getHTTPContentEncoding() != null, msg.getHTTPContentEncoding(), null};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FPHTTPContentType
    implements MessageDumpFieldProvider<JCSMPGenericXMLMessage> {
        FPHTTPContentType() {
        }

        @Override
        public Object[] getData(JCSMPGenericXMLMessage msg, int flags) {
            return new Object[]{"HTTP Content Type", msg.getHTTPContentType() != null, msg.getHTTPContentType(), null};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FPElidingEligible
    implements MessageDumpFieldProvider<JCSMPGenericXMLMessage> {
        FPElidingEligible() {
        }

        @Override
        public Object[] getData(JCSMPGenericXMLMessage msg, int flags) {
            return new Object[]{"Eliding Eligible", msg.isElidingEligible(), "", null};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FPDMQEligible
    implements MessageDumpFieldProvider<JCSMPGenericXMLMessage> {
        FPDMQEligible() {
        }

        @Override
        public Object[] getData(JCSMPGenericXMLMessage msg, int flags) {
            return new Object[]{"DMQ Eligible", msg.isDMQEligible(), "", null};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FPExpiration
    implements MessageDumpFieldProvider<JCSMPGenericXMLMessage> {
        FPExpiration() {
        }

        @Override
        public Object[] getData(JCSMPGenericXMLMessage msg, int flags) {
            return new Object[]{"Expiration", msg.getExpiration() > 0L, MessageDumpStandardProvider.formatDate(msg.getExpiration()), null};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FPTimeToLive
    implements MessageDumpFieldProvider<JCSMPGenericXMLMessage> {
        FPTimeToLive() {
        }

        @Override
        public Object[] getData(JCSMPGenericXMLMessage msg, int flags) {
            return new Object[]{"TimeToLive", msg.getTimeToLive() > 0L, msg.getTimeToLive(), null};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FPUserData
    implements MessageDumpFieldProvider<JCSMPGenericXMLMessage> {
        FPUserData() {
        }

        @Override
        public Object[] getData(JCSMPGenericXMLMessage msg, int flags) {
            String lenUserData = "";
            String detailValue = null;
            if (msg.getUserData() != null) {
                lenUserData = "len=" + msg.getUserData().length;
                if ((flags & 1) > 0) {
                    detailValue = StringUtil.formatDumpBytes(msg.getUserData(), true, 2);
                }
            }
            return new Object[]{"User Data", msg.getUserData() != null, lenUserData, detailValue};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FPConsumerId
    implements MessageDumpFieldProvider<JCSMPGenericXMLMessage> {
        FPConsumerId() {
        }

        @Override
        public Object[] getData(JCSMPGenericXMLMessage msg, int flags) {
            List<Long> cids = msg.getConsumerIdList();
            StringBuilder sb = null;
            if ((flags & 1) > 0) {
                sb = new StringBuilder();
                for (Long cid : cids) {
                    sb.append(cid).append(" ");
                }
            }
            return new Object[]{"ConsumerId", cids.size() > 0, cids.size(), sb == null ? null : sb.toString()};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FPCacheRequestId
    implements MessageDumpFieldProvider<JCSMPGenericXMLMessage> {
        FPCacheRequestId() {
        }

        @Override
        public Object[] getData(JCSMPGenericXMLMessage msg, int flags) {
            return new Object[]{"Cache Request Id", msg.getCacheRequestId() != null, msg.getCacheRequestId(), null};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FPMessageFromCache
    implements MessageDumpFieldProvider<JCSMPGenericXMLMessage> {
        FPMessageFromCache() {
        }

        @Override
        public Object[] getData(JCSMPGenericXMLMessage msg, int flags) {
            return new Object[]{"MessageFromCache", msg.isCacheMessage(), "", null};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FPDeliverToOne
    implements MessageDumpFieldProvider<JCSMPGenericXMLMessage> {
        FPDeliverToOne() {
        }

        @Override
        public Object[] getData(JCSMPGenericXMLMessage msg, int flags) {
            return new Object[]{"Deliver To One", msg.getDeliverToOne(), "", null};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FPReplyTo
    implements MessageDumpFieldProvider<JCSMPGenericXMLMessage> {
        FPReplyTo() {
        }

        @Override
        public Object[] getData(JCSMPGenericXMLMessage msg, int flags) {
            boolean present = null != msg.getReplyTo();
            String shortValue = null;
            if (present) {
                Destination d = msg.getReplyTo();
                shortValue = d instanceof Topic ? "Topic " : (d instanceof Queue ? "Queue " : "");
                shortValue = shortValue + "'" + d.toString() + "'";
            }
            return new Object[]{"ReplyTo", present, shortValue, null};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FPReplyMessage
    implements MessageDumpFieldProvider<JCSMPGenericXMLMessage> {
        FPReplyMessage() {
        }

        @Override
        public Object[] getData(JCSMPGenericXMLMessage msg, int flags) {
            return new Object[]{"Reply Message", msg.isReplyMessage(), "", null};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FPDAckImmediately
    implements MessageDumpFieldProvider<JCSMPGenericXMLMessage> {
        FPDAckImmediately() {
        }

        @Override
        public Object[] getData(JCSMPGenericXMLMessage msg, int flags) {
            return new Object[]{"Ack Immediately", msg.isAckImmediately(), "", null};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FPDiscardIndication
    implements MessageDumpFieldProvider<JCSMPGenericXMLMessage> {
        FPDiscardIndication() {
        }

        @Override
        public Object[] getData(JCSMPGenericXMLMessage msg, int flags) {
            return new Object[]{"Discard Indication", msg.getDiscardIndication(), "", null};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FPMessageRedelivered
    implements MessageDumpFieldProvider<JCSMPGenericXMLMessage> {
        FPMessageRedelivered() {
        }

        @Override
        public Object[] getData(JCSMPGenericXMLMessage msg, int flags) {
            return new Object[]{"Message Re-delivered", msg.getRedelivered(), "", null};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FPMessageId
    implements MessageDumpFieldProvider<JCSMPGenericXMLMessage> {
        FPMessageId() {
        }

        @Override
        public Object[] getData(JCSMPGenericXMLMessage msg, int flags) {
            return new Object[]{"Message Id", msg.getMessageId() != null, msg.getMessageId(), null};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FPDeliveryMode
    implements MessageDumpFieldProvider<JCSMPGenericXMLMessage> {
        FPDeliveryMode() {
        }

        @Override
        public Object[] getData(JCSMPGenericXMLMessage msg, int flags) {
            return new Object[]{"DeliveryMode", msg.getDeliveryMode() != null, msg.getDeliveryMode(), null};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FPClassOfService
    implements MessageDumpFieldProvider<JCSMPGenericXMLMessage> {
        FPClassOfService() {
        }

        @Override
        public Object[] getData(JCSMPGenericXMLMessage msg, int flags) {
            return new Object[]{"Class Of Service", msg.getCos() != null, msg.getCos(), null};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FPPriority
    implements MessageDumpFieldProvider<JCSMPGenericXMLMessage> {
        FPPriority() {
        }

        @Override
        public Object[] getData(JCSMPGenericXMLMessage msg, int flags) {
            return new Object[]{"Priority", msg.getPriority() != -1, msg.getPriority(), null};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FPRcvTimestamp
    implements MessageDumpFieldProvider<JCSMPGenericXMLMessage> {
        FPRcvTimestamp() {
        }

        @Override
        public Object[] getData(JCSMPGenericXMLMessage msg, int flags) {
            return new Object[]{"RcvTimestamp", msg.getReceiveTimestamp() != 0L, MessageDumpStandardProvider.formatDate(msg.getReceiveTimestamp()), null};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FPSendTimestamp
    implements MessageDumpFieldProvider<JCSMPGenericXMLMessage> {
        FPSendTimestamp() {
        }

        @Override
        public Object[] getData(JCSMPGenericXMLMessage msg, int flags) {
            return new Object[]{"SendTimestamp", msg.getSendTimestamp() != null, MessageDumpStandardProvider.formatDate(msg.getSendTimestamp()), null};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FPCorrelationId
    implements MessageDumpFieldProvider<JCSMPGenericXMLMessage> {
        FPCorrelationId() {
        }

        @Override
        public Object[] getData(JCSMPGenericXMLMessage msg, int flags) {
            return new Object[]{"CorrelationId", msg.getCorrelationId() != null, msg.getCorrelationId(), null};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FPSequenceNumber
    implements MessageDumpFieldProvider<JCSMPGenericXMLMessage> {
        FPSequenceNumber() {
        }

        @Override
        public Object[] getData(JCSMPGenericXMLMessage msg, int flags) {
            return new Object[]{"SequenceNumber", msg.getSequenceNumber() != null, msg.getSequenceNumber(), null};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FPAppMsgId
    implements MessageDumpFieldProvider<JCSMPGenericXMLMessage> {
        FPAppMsgId() {
        }

        @Override
        public Object[] getData(JCSMPGenericXMLMessage msg, int flags) {
            return new Object[]{"AppMessageID", msg.getAppMessageID() != null, msg.getAppMessageID(), null};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FPAppMsgType
    implements MessageDumpFieldProvider<JCSMPGenericXMLMessage> {
        FPAppMsgType() {
        }

        @Override
        public Object[] getData(JCSMPGenericXMLMessage msg, int flags) {
            return new Object[]{"AppMessageType", msg.getAppMessageType() != null, msg.getAppMessageType(), null};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FPSenderId
    implements MessageDumpFieldProvider<JCSMPGenericXMLMessage> {
        FPSenderId() {
        }

        @Override
        public Object[] getData(JCSMPGenericXMLMessage msg, int flags) {
            return new Object[]{"SenderId", msg.getSenderID() != null, msg.getSenderID(), null};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FPTopicSequenceNumber
    implements MessageDumpFieldProvider<JCSMPGenericXMLMessage> {
        FPTopicSequenceNumber() {
        }

        @Override
        public Object[] getData(JCSMPGenericXMLMessage msg, int flags) {
            return new Object[]{"TopicSequenceNumber", msg.getTopicSequenceNumber() != null, msg.getTopicSequenceNumber(), null};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FPDestination
    implements MessageDumpFieldProvider<JCSMPGenericXMLMessage> {
        FPDestination() {
        }

        @Override
        public Object[] getData(JCSMPGenericXMLMessage msg, int flags) {
            boolean present = msg.getDestinationSent() != null || msg.getDestination() != null;
            String shortValue = null;
            if (present) {
                Destination d = msg.getDestinationSent();
                Destination destination = d = d == null ? msg.getDestination() : d;
                if (d instanceof Topic) {
                    shortValue = "Topic ";
                } else if (d instanceof Queue) {
                    shortValue = "Queue ";
                }
                shortValue = shortValue + "'" + d.toString() + "'";
            }
            return new Object[]{"Destination", present, shortValue, null};
        }
    }
}

