/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.flow;

import com.solacesystems.common.util.NetworkByteOrderNumberUtil;
import com.solacesystems.jcsmp.CapabilityType;
import com.solacesystems.jcsmp.ConsumerFlowProperties;
import com.solacesystems.jcsmp.EndpointProperties;
import com.solacesystems.jcsmp.FlowEvent;
import com.solacesystems.jcsmp.FlowEventArgs;
import com.solacesystems.jcsmp.FlowEventHandler;
import com.solacesystems.jcsmp.JCSMPErrorResponseException;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPInterruptedException;
import com.solacesystems.jcsmp.JCSMPTransportException;
import com.solacesystems.jcsmp.Queue;
import com.solacesystems.jcsmp.ReplayStartLocation;
import com.solacesystems.jcsmp.Topic;
import com.solacesystems.jcsmp.XMLMessageListener;
import com.solacesystems.jcsmp.i18n.JCSMPRB;
import com.solacesystems.jcsmp.impl.JCSMPBasicSession;
import com.solacesystems.jcsmp.impl.JCSMPErrorResponseSubcodeMapper;
import com.solacesystems.jcsmp.impl.NonDurableTopicEndpointImpl;
import com.solacesystems.jcsmp.impl.flow.FlowEventArgsImpl;
import com.solacesystems.jcsmp.impl.flow.FlowHandleImpl;
import com.solacesystems.jcsmp.impl.flow.FlowTask;
import com.solacesystems.jcsmp.impl.flow.TaskSessionRefs;
import com.solacesystems.jcsmp.impl.transaction.BaseTransactedSessionImpl;
import com.solacesystems.jcsmp.protocol.WireMessage;
import com.solacesystems.jcsmp.protocol.impl.TcpChannel;
import com.solacesystems.jcsmp.protocol.impl.TcpClientChannel;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlEnums;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.SMFHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.SmfTLVParameter;
import com.solacesystems.jcsmp.protocol.smf.impl.TlvCoderUtil;
import com.solacesystems.jcsmp.protocol.smf.impl.TlvParameterParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BindRequestTask
extends FlowTask {
    private static final Log Trace = LogFactory.getLog(BindRequestTask.class);
    volatile FlowHandleImpl thisOldFlowHandle = null;
    XMLMessageListener listener;
    FlowHandleImpl existingFlowHandle;
    private Topic newTopic;
    private AssuredCtrlEnums.FlowType flowType;
    private EndpointProperties tmpEpCreateProperties;
    private String sqlSelector;
    private ConsumerFlowProperties consumerFlowProps;
    private final JCSMPBasicSession.InternalBindProperties internalBindProp;
    private final FlowEventHandler flowEventHandler;
    private static int counter = 0;
    private int _counter = counter++;
    private boolean isInterrupted = false;

    public BindRequestTask(TaskSessionRefs t_refs, ConsumerFlowProperties f_prop, EndpointProperties e_prop, XMLMessageListener listener, FlowHandleImpl existingFlowHandle, AssuredCtrlEnums.FlowType flowType, JCSMPBasicSession.InternalBindProperties internalBindProp, FlowEventHandler flowEventHandler) {
        super(f_prop.getEndpoint(), t_refs);
        this.consumerFlowProps = f_prop;
        this.newTopic = (Topic)f_prop.getNewSubscription();
        this.listener = listener;
        this.existingFlowHandle = existingFlowHandle;
        this.flowType = flowType;
        this.sqlSelector = f_prop.getSelector();
        this.tmpEpCreateProperties = e_prop;
        this.internalBindProp = internalBindProp;
        this.flowEventHandler = flowEventHandler;
    }

    public String toString() {
        return String.format("[BRT resource=%s existingFH=%s flowType=%s counter=%s]", new Object[]{this.bindToResource, this.existingFlowHandle, this.flowType, this._counter});
    }

    public boolean submit(int corrTag, boolean allowOnStateSub, TcpChannel.WriteBlockPolicy wpolicy) throws JCSMPException {
        TcpClientChannel tcpChannel = this.taskRefs.getChannel();
        this.initTimerFlag();
        String flowName = null;
        long lastAcked = 0L;
        long lastRecved = 0L;
        if (this.existingFlowHandle != null) {
            flowName = this.existingFlowHandle.getFlowName();
            lastAcked = this.existingFlowHandle.getLastInOrderTpMsg();
            lastRecved = this.existingFlowHandle.getLastInOrderTpMsg();
        }
        Long transactedSessionId = null;
        ReplayStartLocation startLocation = null;
        Long endpointErrorId = null;
        if (this.internalBindProp != null && this.internalBindProp.transactedSession != null) {
            transactedSessionId = this.internalBindProp.transactedSession.getTransactedSessionId();
        }
        if (this.existingFlowHandle == null) {
            startLocation = this.consumerFlowProps.getReplayStartLocation();
        } else {
            endpointErrorId = this.existingFlowHandle.getEndpointErrorId();
        }
        tcpChannel.sendBindRequest(this.bindToResource, this.newTopic, 0, corrTag, allowOnStateSub, flowName, this.flowType, lastAcked, lastRecved, this.sqlSelector, this.tmpEpCreateProperties, transactedSessionId, this.consumerFlowProps.isNoLocal(), this.consumerFlowProps.isActiveFlowIndication(), wpolicy, startLocation, endpointErrorId);
        this.startTimer();
        if (flowName != null) {
            Trace.debug((Object)("Bind request sent:" + flowName));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(Object obj) {
        Trace.debug((Object)"Executing response handler.");
        this.cancelTimer();
        assert (obj instanceof WireMessage);
        boolean isRebind = this.existingFlowHandle != null;
        WireMessage respMsg = (WireMessage)obj;
        SMFHeaderBean smfHeader = respMsg.getSmfHeader();
        assert (smfHeader.getProtocol() == 9);
        int maxUnackedMsgs = 0;
        if (smfHeader.getPm_respcode() == 507 && smfHeader.getPm_respstr().equalsIgnoreCase("ASSURED DELIVERY NOT READY")) {
            Trace.debug((Object)("Got bind response: AD not ready in task " + this.toString()));
            String networkInfoString = "";
            if (this.subFlowMgr != null && this.subFlowMgr.subChannel != null) {
                networkInfoString = this.subFlowMgr.subChannel.getNetworkInfoString();
            }
            JCSMPErrorResponseException retryableCause = new JCSMPErrorResponseException(smfHeader.getPm_respcode(), smfHeader.getPm_respstr(), "", networkInfoString, JCSMPErrorResponseSubcodeMapper.ErrorContext.CONTROL);
            this.scheduleResubmit(retryableCause);
            return null;
        }
        if (smfHeader.getPm_respcode() != 200) {
            if (this.existingFlowHandle != null && this.existingFlowHandle.tryToStartAutoRebind().booleanValue() && (smfHeader.getPm_respstr().contains("Queue Shutdown") || smfHeader.getPm_respstr().contains("Durable Topic Endpoint Shutdown") || smfHeader.getPm_respstr().contains("Service Unavailable"))) {
                String networkInfoString = "";
                if (this.subFlowMgr != null && this.subFlowMgr.subChannel != null) {
                    networkInfoString = this.subFlowMgr.subChannel.getNetworkInfoString();
                }
                JCSMPErrorResponseException retryableCause = new JCSMPErrorResponseException(smfHeader.getPm_respcode(), smfHeader.getPm_respstr(), "", networkInfoString, JCSMPErrorResponseSubcodeMapper.ErrorContext.CONTROL);
                this.submitCountReset();
                this.scheduleResubmit(retryableCause, this.existingFlowHandle.getReconnectRetryIntervalInMsecs());
                BindRequestTask bindRequestTask = this;
                synchronized (bindRequestTask) {
                    this.responseLatch.countDown();
                }
                Trace.debug((Object)("Another bind request scheduled on BIND Error Response (" + smfHeader.getPm_respcode() + ") - " + smfHeader.getPm_respstr()));
                return null;
            }
            if (this.existingFlowHandle != null) {
                this.existingFlowHandle.tryToTriggerAutoRebind(false);
                if (smfHeader.getPm_respstr().contains("Mismatched Endpoint Error ID") && this.subFlowMgr != null) {
                    this.subFlowMgr.removeManagedFlow(this.existingFlowHandle);
                }
            }
            String networkInfoString = "";
            if (this.subFlowMgr != null && this.subFlowMgr.subChannel != null) {
                networkInfoString = this.subFlowMgr.subChannel.getNetworkInfoString();
            }
            this.opEx = new JCSMPErrorResponseException(smfHeader.getPm_respcode(), smfHeader.getPm_respstr(), "", networkInfoString, JCSMPErrorResponseSubcodeMapper.ErrorContext.CONTROL);
            if (Trace.isInfoEnabled()) {
                Trace.debug((Object)("Got BIND Error Response (" + smfHeader.getPm_respcode() + ") - " + smfHeader.getPm_respstr()));
            }
        } else {
            AssuredCtrlHeaderBean assBean = (AssuredCtrlHeaderBean)respMsg.getHeaderBean();
            SmfTLVParameter tlv = (SmfTLVParameter)assBean.findFirstParameter(6);
            long respFlowId = TlvParameterParser.getAssuredFlowId(tlv);
            long respEndpointId = 0L;
            tlv = (SmfTLVParameter)assBean.findFirstParameter(44);
            if (tlv != null) {
                respEndpointId = TlvParameterParser.getEndpointId(tlv);
            }
            String respFlowName = null;
            tlv = (SmfTLVParameter)assBean.findFirstParameter(10);
            if (tlv != null) {
                respFlowName = TlvParameterParser.getAssuredFlowName(tlv);
            }
            boolean explicitlyActive = false;
            tlv = (SmfTLVParameter)assBean.findFirstParameter(32);
            if (tlv != null) {
                explicitlyActive = TlvParameterParser.getAssuredActiveFlowIndication(tlv);
            }
            AssuredCtrlEnums.QueueAccessType qat = null;
            tlv = (SmfTLVParameter)assBean.findFirstParameter(12);
            if (tlv != null) {
                qat = TlvParameterParser.getAssuredQueueAccessType(tlv);
            } else if (this.bindToResource instanceof Queue) {
                qat = AssuredCtrlEnums.QueueAccessType.EXCLUSIVE;
            }
            tlv = (SmfTLVParameter)assBean.findFirstParameter(8);
            if (this.bindToResource instanceof NonDurableTopicEndpointImpl && tlv != null) {
                String te_name = TlvCoderUtil.nullTermUtf8ToString(tlv.value);
                NonDurableTopicEndpointImpl ndte = (NonDurableTopicEndpointImpl)this.bindToResource;
                ndte.setName(te_name);
            }
            boolean isCapablePermission = this.taskRefs.getSession().isCapable(CapabilityType.ENDPOINT_MANAGEMENT);
            Long granted_perm = null;
            tlv = (SmfTLVParameter)assBean.findFirstParameter(21);
            if (tlv != null && isCapablePermission) {
                long perm_smf_val = NetworkByteOrderNumberUtil.fourByteToUInt(tlv.value);
                long perm_sdk_val = AssuredCtrlEnums.permBitfieldToSdkPermission(perm_smf_val);
                granted_perm = perm_sdk_val;
            }
            if (!isRebind) {
                BaseTransactedSessionImpl old_ts = this.internalBindProp == null ? null : this.internalBindProp.transactedSession;
                this.thisOldFlowHandle = new FlowHandleImpl(this.bindToResource, this.newTopic, this.listener, this.taskRefs.getChannel(), this.taskRefs.getSession(), true, qat, this.flowType, granted_perm, this.tmpEpCreateProperties, this.sqlSelector, this.consumerFlowProps, old_ts, this.flowEventHandler);
                if (this.newTopic != null) {
                    this.thisOldFlowHandle.setSubscription(this.newTopic);
                }
                if (this.taskRefs.getSession().isCapable(CapabilityType.REPLAY_ERRORID) && (tlv = (SmfTLVParameter)assBean.findFirstParameter(52)) != null) {
                    this.thisOldFlowHandle.setEndpointErrorId(TlvParameterParser.getEndpoinErrortId(tlv));
                }
            } else {
                this.thisOldFlowHandle = this.existingFlowHandle;
            }
            this.thisOldFlowHandle.setFlowId(respFlowId);
            this.thisOldFlowHandle.setEndpointId(respEndpointId);
            this.thisOldFlowHandle.setFlowName(respFlowName);
            this.thisOldFlowHandle.explictlyActive = explicitlyActive;
            this.thisOldFlowHandle.setBoundToResourceState(FlowHandleImpl.ResourceBoundState.BOUND);
            tlv = (SmfTLVParameter)assBean.findFirstParameter(49);
            if (tlv != null && (maxUnackedMsgs = TlvParameterParser.getMaxDeliveredUnackedMsgs(tlv)) > 0 && maxUnackedMsgs < this.thisOldFlowHandle.getSubWindowSize()) {
                int threshold = this.thisOldFlowHandle.getOriginalAckThreshold() * maxUnackedMsgs / 100;
                this.thisOldFlowHandle.setAckThreshold(threshold);
                Trace.info((Object)String.format("AD windowSize (%d) is greater than router MaxDeliveredUnackedMessagesPerFlow (%d), set AckThreshold to %d, folwId %d", this.thisOldFlowHandle.getSubWindowSize(), maxUnackedMsgs, threshold, respFlowId));
            }
            Trace.debug((Object)String.format("Got OK bindresponse, flowName=%s, flowId=%s, QueueAccessType=%s, explicitlyActive=%s", new Object[]{respFlowName, respFlowId, qat, explicitlyActive}));
            if (isRebind) {
                if (Trace.isDebugEnabled()) {
                    Trace.debug((Object)("Generate flow UP event after rebind, flowName=" + respFlowName + "; flowId=" + respFlowId));
                }
                if (this.existingFlowHandle.isAutoRebindTriggered().booleanValue()) {
                    this.existingFlowHandle.tryToTriggerAutoRebind(false);
                    WireMessage ackMsg = this.existingFlowHandle.tpCreateAck();
                    this.existingFlowHandle.tpSendAck(ackMsg, true, false);
                    if (this.subFlowMgr != null) {
                        this.subFlowMgr.generateFlowEvent(this.thisOldFlowHandle, new FlowEventArgs(FlowEvent.FLOW_RECONNECTED, "OK", null, 200));
                    }
                } else if (this.subFlowMgr != null) {
                    this.subFlowMgr.generateFlowEvent(this.thisOldFlowHandle, new FlowEventArgs(FlowEvent.FLOW_UP, "OK", null, 200));
                }
            }
            if (explicitlyActive && this.thisOldFlowHandle.getFlowEventHandler() != null) {
                Trace.debug((Object)("Send out flow active event after bind, flowId=" + respFlowId));
                this.thisOldFlowHandle.notifyFlowEventHandler(new FlowEventArgsImpl(FlowEvent.FLOW_ACTIVE, "Flow becomes active", null, 0));
            }
        }
        if (this.subFlowMgr != null && this.opEx == null) {
            this.subFlowMgr.regActiveFlow(this.thisOldFlowHandle);
            this.subFlowMgr.addManagedFlow(this.thisOldFlowHandle);
        }
        BindRequestTask bindRequestTask = this;
        synchronized (bindRequestTask) {
            this.responseLatch.countDown();
            if (this.isInterrupted) {
                Trace.debug((Object)("Flow creation interrupted, flowId=" + this.thisOldFlowHandle.getFlowId()));
                this.thisOldFlowHandle.close();
            }
        }
        if (this.opEx != null && isRebind) {
            this.existingFlowHandle.handleException(this.opEx);
        }
        return null;
    }

    public void handleTimeout() {
        boolean isRebind;
        super.handleTimeout();
        boolean bl = isRebind = this.existingFlowHandle != null;
        if (isRebind) {
            JCSMPTransportException timeout_ex = new JCSMPTransportException(JCSMPRB.BUNDLE.getStringSafely("TcpSubscriberChannel.timeoutReadingResponseToAdctrl") + " (" + this.toString() + ")");
            this.cancel(timeout_ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlowHandleImpl getFlowHandler() throws JCSMPException {
        try {
            this.responseLatch.await();
        }
        catch (InterruptedException e) {
            BindRequestTask bindRequestTask = this;
            synchronized (bindRequestTask) {
                if (this.responseLatch.getCount() == 0L && this.opEx == null) {
                    return this.thisOldFlowHandle;
                }
                this.isInterrupted = true;
            }
            Trace.debug((Object)"getFlowHandler interrupted: ");
            throw new JCSMPInterruptedException("getFlowHandler interrupted.", e);
        }
        if (this.opEx != null) {
            throw this.opEx;
        }
        return this.thisOldFlowHandle;
    }

    public FlowHandleImpl getExistingFlowHandler() {
        return this.existingFlowHandle;
    }
}

