/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.solclientj.core.impl;

import com.solacesystems.solclientj.core.i18n.SOLCLIENTJRB;
import com.solacesystems.solclientj.core.impl.AbstractDestinationImpl;
import com.solacesystems.solclientj.core.impl.ConceptConvertUtil;
import com.solacesystems.solclientj.core.resource.Endpoint;

public class EndpointImpl
extends AbstractDestinationImpl
implements Endpoint {
    private String[] jniEndpointProperties;
    private String[] userProvidedEndpointProperties = null;

    public EndpointImpl(String name) {
        this(name, null);
    }

    public EndpointImpl(String name, String[] endpointProperties) {
        super(name, false);
        if (name == null) {
            throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("Common.NullEndpointName"));
        }
        if (name.trim().equals("")) {
            throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("Common.WhitespaceEndpointName"));
        }
        this.userProvidedEndpointProperties = endpointProperties;
        this.jniEndpointProperties = ConceptConvertUtil.computeEndPointProperties(this, this.userProvidedEndpointProperties);
    }

    protected EndpointImpl(String name, boolean isDurable) {
        this(name, isDurable, null);
    }

    protected EndpointImpl(String name, boolean isDurable, String[] endpointProperties) {
        super(name, !isDurable);
        if (name == null && isDurable) {
            throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("Common.NullEndpointName"));
        }
        if (name != null && name.trim().equals("")) {
            throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("Common.WhitespaceEndpointName"));
        }
        this.userProvidedEndpointProperties = endpointProperties;
        this.jniEndpointProperties = ConceptConvertUtil.computeEndPointProperties(this, endpointProperties);
    }

    @Override
    public boolean isDurable() {
        return !this.isTemporary();
    }

    public String[] getProperties() {
        return this.jniEndpointProperties;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (this.jniEndpointProperties == null) {
            this.jniEndpointProperties = ConceptConvertUtil.computeEndPointProperties(this, this.userProvidedEndpointProperties);
        } else {
            int props = 0;
            while (props < this.jniEndpointProperties.length - 1) {
                if (this.jniEndpointProperties[props] == null) {
                    this.jniEndpointProperties[props] = "ENDPOINT_NAME";
                }
                if (this.jniEndpointProperties[props++] != "ENDPOINT_NAME") continue;
                this.jniEndpointProperties[props++] = this.getName();
                break;
            }
        }
    }
}

