/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.solclientj.core.impl;

import com.solacesystems.solclientj.core.Version;
import com.solacesystems.solclientj.core.impl.util.SolLogger;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class VersionImpl
implements Version {
    private static final ManifestReader manifestReader = new ManifestReader();
    private String version;
    private String buildDate;
    private String nativeVersion;
    private String nativeBuildDate;
    private String nativeVariant;

    public VersionImpl() {
    }

    protected VersionImpl(String nativeVersion, String nativeBuildDate, String nativeVariant) {
        this.version = manifestReader.getImplVersion();
        this.buildDate = manifestReader.getBuildTime();
        this.nativeVersion = nativeVersion;
        this.nativeBuildDate = nativeBuildDate;
        this.nativeVariant = nativeVariant;
    }

    public void readVersion() {
        this.version = manifestReader.getImplVersion();
        this.version = this.version == null ? (this.nativeVersion == null ? "" : this.nativeVersion) + "/SOLCLIENTJ" : this.version + "/SOLCLIENTJ";
        this.buildDate = manifestReader.getBuildTime();
        if (this.buildDate == null) {
            this.buildDate = this.nativeBuildDate == null ? "" : this.nativeBuildDate;
        }
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public String getBuildDate() {
        return this.buildDate;
    }

    public void setBuildDate(String buildDate) {
        this.buildDate = buildDate;
    }

    @Override
    public String getNativeVersion() {
        return this.nativeVersion;
    }

    @Override
    public String getNativeBuildDate() {
        return this.nativeBuildDate;
    }

    @Override
    public String getNativeVariant() {
        return this.nativeVariant;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getVersion());
        sb.append(", ");
        sb.append(this.getBuildDate());
        sb.append(", ");
        sb.append(this.getNativeVersion());
        sb.append(", ");
        sb.append(this.getNativeBuildDate());
        sb.append(", ");
        sb.append(this.getNativeVariant());
        return sb.toString();
    }

    private static final class ManifestReader {
        private static final SolLogger LOGGER = SolLogger.getLogger(ManifestReader.class.getName());
        private static final String API_MANIFEST_SECTION_NAME = "com.solacesystems.solclientj";
        private static final Attributes.Name BUILD_TIME = new Attributes.Name("Build-Time");
        private final Map<String, String> manifestContent = new HashMap<String, String>();

        private ManifestReader() {
            ClassLoader loader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    ClassLoader cl = null;
                    try {
                        cl = Thread.currentThread().getContextClassLoader();
                    }
                    catch (SecurityException ex) {
                        LOGGER.info("Failed to get class loader: " + ex);
                    }
                    return cl;
                }
            });
            if (loader != null) {
                try {
                    Enumeration<URL> manifestResources = loader.getResources("META-INF/MANIFEST.MF");
                    Map<String, String> manifestInfo = ManifestReader.findApiManifest(manifestResources);
                    this.manifestContent.putAll(manifestInfo);
                }
                catch (Exception e) {
                    LOGGER.critical("Failed to load manifest info: " + e);
                }
            }
        }

        String getImplVersion() {
            return this.manifestContent.get(Attributes.Name.IMPLEMENTATION_VERSION.toString());
        }

        String getImplVendor() {
            return this.manifestContent.get(Attributes.Name.IMPLEMENTATION_VENDOR.toString());
        }

        String getBuildTime() {
            return this.manifestContent.get(BUILD_TIME.toString());
        }

        String getAttributeValue(String attributeKey) {
            return this.manifestContent.get(attributeKey);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final Map<String, String> findApiManifest(Enumeration<URL> allManifests) {
            HashMap<String, String> output = new HashMap<String, String>();
            while (allManifests.hasMoreElements()) {
                URL manifestUrl = allManifests.nextElement();
                try {
                    InputStream manifestStream = manifestUrl.openStream();
                    try {
                        Manifest manifest = new Manifest(manifestStream);
                        Map<String, Attributes> entries = manifest.getEntries();
                        Attributes attributes = entries.get(API_MANIFEST_SECTION_NAME);
                        if (attributes == null || attributes.isEmpty() || !attributes.containsKey(Attributes.Name.IMPLEMENTATION_VERSION) || !attributes.containsKey(Attributes.Name.IMPLEMENTATION_VENDOR) || !attributes.containsKey(BUILD_TIME)) continue;
                        output.put(Attributes.Name.IMPLEMENTATION_VERSION.toString(), attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION));
                        output.put(Attributes.Name.IMPLEMENTATION_VENDOR.toString(), attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR));
                        output.put(BUILD_TIME.toString(), attributes.getValue(BUILD_TIME));
                        Attributes attrs = manifest.getMainAttributes();
                        for (Object key : attrs.keySet()) {
                            String value = attrs.getValue((Attributes.Name)Attributes.Name.class.cast(key));
                            output.put(key.toString(), value);
                        }
                    }
                    finally {
                        if (manifestStream == null) continue;
                        try {
                            manifestStream.close();
                        }
                        catch (IOException e) {
                            LOGGER.info("Failed to close manifest stream: " + e);
                        }
                    }
                }
                catch (Exception ex) {
                    LOGGER.debug("Failed to use manifest : " + ex);
                }
            }
            return output;
        }
    }
}

