/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.solclientj.core.impl.util;

import com.solacesystems.solclientj.core.i18n.SOLCLIENTJRB;
import com.solacesystems.solclientj.core.impl.util.DefaultGenericPoolFactory;
import com.solacesystems.solclientj.core.impl.util.GenericPoolFactory;
import com.solacesystems.solclientj.core.impl.util.SolLogger;
import com.solacesystems.solclientj.core.impl.util.TLinkable;
import com.solacesystems.solclientj.core.impl.util.TLinkedList;

public class GenericPool<T> {
    private final TLinkedList _genericQueue;
    protected static final int defaultMaxPoolSize = 10000;
    SolLogger LOGGER = SolLogger.getLogger(GenericPool.class.getName());
    private int _size = 0;
    private int _allocatedCnt = 0;
    private long waitCount = 0L;
    private GenericPoolFactory genericPoolFactory;

    public GenericPool(Class<?> clazz) {
        this._genericQueue = new TLinkedList();
        this.genericPoolFactory = new DefaultGenericPoolFactory(clazz);
        this.init(10000);
    }

    public GenericPool(Class<?> clazz, int size) {
        this._genericQueue = new TLinkedList();
        this.genericPoolFactory = new DefaultGenericPoolFactory(clazz);
        this.init(size);
    }

    public GenericPool(GenericPoolFactory genericPoolAllocator, int size) {
        this._genericQueue = new TLinkedList();
        this.genericPoolFactory = genericPoolAllocator;
        this.init(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(int size) {
        if (size == 0) {
            throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("Common.PoolZeroSize"));
        }
        TLinkedList tLinkedList = this._genericQueue;
        synchronized (tLinkedList) {
            this._size = size;
            this._allocatedCnt = this.genericPoolFactory.initial_fill(this._genericQueue, size);
        }
    }

    public long getWaitCount() {
        return this.waitCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PoolEntry<T> borrowFromPool() {
        PoolEntry item = null;
        TLinkedList tLinkedList = this._genericQueue;
        synchronized (tLinkedList) {
            while (true) {
                if (this._genericQueue.size() == 0) {
                    if (this._allocatedCnt < this._size) {
                        this.genericPoolFactory.allocateOne(this._genericQueue);
                        ++this._allocatedCnt;
                        continue;
                    }
                    try {
                        ++this.waitCount;
                        this._genericQueue.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                item = (PoolEntry)this._genericQueue.removeFirst();
                if (item != null) break;
            }
        }
        item.setIsBorrowed(true);
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnToPool(PoolEntry<T> item) {
        TLinkedList tLinkedList = this._genericQueue;
        synchronized (tLinkedList) {
            if (!item.isBorrowed()) {
                return;
            }
            item.setIsBorrowed(false);
            this._genericQueue.addFirst(item);
            if (this._genericQueue.size() == 1) {
                this._genericQueue.notifyAll();
            }
        }
    }

    public static class PoolEntry<T>
    implements TLinkable {
        T item;
        TLinkable next;
        TLinkable previous;
        boolean isBorrowed = false;
        private static final long serialVersionUID = 1L;

        PoolEntry(T item) {
            this.item = item;
            this.isBorrowed = false;
        }

        public void setIsBorrowed(boolean isBorrowed) {
            this.isBorrowed = isBorrowed;
        }

        public T getEntry() {
            return this.item;
        }

        public boolean isBorrowed() {
            return this.isBorrowed;
        }

        public TLinkable getNext() {
            return this.next;
        }

        public TLinkable getPrevious() {
            return null;
        }

        public void setNext(TLinkable next) {
            this.next = next;
        }

        public void setPrevious(TLinkable previous) {
            this.previous = previous;
        }
    }
}

