/*
 * Decompiled with CFR 0.152.
 */
package com.sonalake.utah.cli;

import com.sonalake.utah.config.Config;
import com.sonalake.utah.config.ConfigLoader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import javax.xml.bind.JAXBException;

public class CLIConfig {
    private final Format format;
    private final String pathToConfig;

    public CLIConfig(Format format, String pathToConfig) {
        this.format = format;
        this.pathToConfig = pathToConfig;
    }

    public Config loadConfig() throws FileNotFoundException, JAXBException {
        try {
            InputStreamReader reader = new InputStreamReader(new FileInputStream(this.pathToConfig));
            return new ConfigLoader().loadConfig(reader);
        }
        catch (FileNotFoundException e) {
            throw new FileNotFoundException("File not found");
        }
        catch (JAXBException jAXBException) {
            return null;
        }
    }

    Format getFormat() {
        return this.format;
    }

    String getPathToConfig() {
        return this.pathToConfig;
    }

    public String toString() {
        return String.format("Format: %s; config: %s", new Object[]{this.format, this.pathToConfig});
    }

    static enum Format {
        CSV,
        JSON;

    }
}

