/*
 * Decompiled with CFR 0.152.
 */
package com.sonalake.utah.cli;

import com.google.gson.GsonBuilder;
import com.sonalake.utah.Parser;
import com.sonalake.utah.cli.CLIConfig;
import com.sonalake.utah.config.Config;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.xml.bind.JAXBException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.lang3.StringUtils;

public class CommandLineInterface {
    private static final String FORMAT_PARAM = "o";
    private static final String CONFIG_PARAM = "f";

    public static void main(String[] args) {
        CommandLineInterface iface = new CommandLineInterface();
        InputStreamReader source = new InputStreamReader(System.in);
        PrintStream target = System.out;
        iface.processArgs(args, source, target);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void processArgs(String[] args, Reader source, PrintStream target) {
        try {
            CLIConfig cliConfig = this.parse(args);
            try (BufferedReader reader = new BufferedReader(source);){
                Parser parser = this.parseInput(cliConfig, reader);
                String format = cliConfig.getFormat().toString();
                switch (format.toUpperCase()) {
                    case "JSON": {
                        this.printToJSON(parser, target);
                        return;
                    }
                    case "CSV": {
                        this.printToCSV(parser, target);
                        return;
                    }
                }
                return;
            }
        }
        catch (Exception e) {
            HelpFormatter formatter = new HelpFormatter();
            PrintWriter pw = new PrintWriter(target);
            formatter.printHelp(pw, formatter.getWidth(), "utah", "", this.buildOptions(), formatter.getLeftPadding(), formatter.getDescPadding(), "", true);
            pw.flush();
        }
    }

    void printToJSON(Parser parser, PrintStream target) {
        Map<String, String> curr = parser.next();
        ArrayList<Map<String, String>> mapList = new ArrayList<Map<String, String>>();
        while (curr != null) {
            mapList.add(curr);
            curr = parser.next();
        }
        target.print(CommandLineInterface.mapListToJSON(mapList));
    }

    void printToCSV(Parser parser, PrintStream target) throws IOException {
        Map<String, String> curr = parser.next();
        ArrayList<Map<String, String>> mapList = new ArrayList<Map<String, String>>();
        TreeSet<String> CSV_HEADERS = new TreeSet<String>();
        while (curr != null) {
            mapList.add(curr);
            for (String str : curr.keySet()) {
                CSV_HEADERS.add(str);
            }
            curr = parser.next();
        }
        CSVFormat csvFormat = CSVFormat.DEFAULT;
        CSVPrinter printer = new CSVPrinter((Appendable)target, csvFormat);
        printer.printRecord(CSV_HEADERS);
        for (Map map : mapList) {
            ArrayList<String> values = new ArrayList<String>();
            for (String header : CSV_HEADERS) {
                String value = StringUtils.trimToEmpty((String)((String)map.get(header)));
                values.add(value);
            }
            printer.printRecord(values.toArray());
        }
    }

    static String mapListToJSON(List<Map<String, String>> mapList) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        String jsonOutput = gsonBuilder.setPrettyPrinting().create().toJson(mapList);
        return jsonOutput;
    }

    Parser parseInput(CLIConfig cliConfig, BufferedReader reader) throws FileNotFoundException, JAXBException {
        Config parserConfig = cliConfig.loadConfig();
        Parser results = Parser.parse(parserConfig, reader);
        return results;
    }

    Options buildOptions() {
        Options options = new Options();
        options.addOption(FORMAT_PARAM, true, "The output format, must be one of: " + StringUtils.join((Object[])CLIConfig.Format.values(), (String)", ").toLowerCase());
        options.addOption(CONFIG_PARAM, true, "The config file");
        options.getOption(CONFIG_PARAM).setRequired(true);
        return options;
    }

    CLIConfig parse(String[] args) throws ParseException {
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = parser.parse(this.buildOptions(), args);
        return this.deriveConfig(cmd);
    }

    CLIConfig deriveConfig(CommandLine cmd) throws ParseException {
        CLIConfig.Format format;
        String opt = cmd.getOptionValue(FORMAT_PARAM);
        String conf = cmd.getOptionValue(CONFIG_PARAM);
        if (StringUtils.isEmpty((CharSequence)conf)) {
            throw new ParseException("No configuration file supplied!");
        }
        if (StringUtils.isEmpty((CharSequence)opt)) {
            format = CLIConfig.Format.CSV;
        } else {
            switch (opt.toUpperCase()) {
                case "CSV": {
                    format = CLIConfig.Format.CSV;
                    break;
                }
                case "JSON": {
                    format = CLIConfig.Format.JSON;
                    break;
                }
                default: {
                    throw new ParseException(opt + " is not a valid format!");
                }
            }
        }
        String outputPath = cmd.getOptionValue(CONFIG_PARAM);
        return new CLIConfig(format, outputPath);
    }
}

