/*
 * Decompiled with CFR 0.152.
 */
package com.sonalake.utah.config;

import com.sonalake.utah.config.NameValue;
import com.sonalake.utah.config.SearchHelper;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlValue;
import org.apache.commons.lang3.StringUtils;

public class Delimiter {
    @XmlAttribute(name="one-record")
    boolean isOneRecord;
    @XmlAttribute(name="per-line")
    boolean isPerLine;
    @XmlAttribute(name="retain")
    boolean isRetainDelim;
    @XmlAttribute(name="at-start")
    boolean isDelimAtStartOfRecord;
    @XmlValue
    String delimiter;
    private Pattern compiledDelimiter;

    void compile(List<NameValue> searches) {
        if (null != this.delimiter && null == this.compiledDelimiter) {
            String valueText = SearchHelper.translate(this.delimiter, searches);
            this.compiledDelimiter = Pattern.compile(valueText);
        }
    }

    public boolean matches(String candidate) {
        if (this.isOneRecord) {
            return false;
        }
        if (this.isPerLine) {
            return StringUtils.isNotBlank((CharSequence)candidate);
        }
        return StringUtils.isNotBlank((CharSequence)candidate) && this.compiledDelimiter.matcher(candidate).matches();
    }

    boolean isDelimRequired() {
        return !this.isOneRecord && !this.isPerLine;
    }

    public boolean isRetainDelim() {
        return this.isRetainDelim || this.isDelimAtStartOfRecord();
    }

    public boolean isDelimAtStartOfRecord() {
        return this.isDelimAtStartOfRecord;
    }
}

