/*
 * Decompiled with CFR 0.152.
 */
package com.sonalake.utah.config;

import com.sonalake.utah.config.NameValue;
import com.sonalake.utah.config.SearchHelper;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.xml.bind.annotation.XmlAttribute;

public class ValueRegex
extends NameValue {
    @XmlAttribute
    int group;
    private Pattern compiledPattern;

    public ValueRegex() {
    }

    ValueRegex(String id, String value) {
        super(id, value);
    }

    public int getGroup() {
        return Math.max(1, this.group);
    }

    void compile(List<NameValue> searches) {
        if (null == this.compiledPattern) {
            String lineRegex = SearchHelper.translate(this.getValue(), searches);
            String regex = String.format(".*?%s.*", lineRegex);
            try {
                Pattern valuePattern = Pattern.compile(regex, 32);
                this.validatePattern(valuePattern);
                this.compiledPattern = valuePattern;
            }
            catch (PatternSyntaxException e) {
                throw new IllegalArgumentException(String.format("Pattern for '%s' is not a valid regex '%s'", this.getValue(), regex));
            }
        }
    }

    private void validatePattern(Pattern candidate) {
        int count = candidate.matcher("").groupCount();
        if (count < this.getGroup()) {
            throw new IllegalArgumentException(String.format("Pattern for '%s' should have at least %s group, not '%s'; in: %s", this, this.getGroup(), count, candidate.pattern()));
        }
    }

    Matcher buildMatcher(String recordText) {
        return this.compiledPattern.matcher(recordText);
    }
}

