/*
 * Decompiled with CFR 0.152.
 */
package com.sonalake.utah;

import com.sonalake.utah.config.Config;
import com.sonalake.utah.config.Delimiter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;

public class Parser {
    private final Config config;
    private final BufferedReader reader;
    private final TreeMap<String, String> commonRecord;
    private String previousDelim;
    private int recordNumber;

    public static Parser parse(Config config, Reader in) {
        return new Parser(config, in);
    }

    private Parser(Config config, Reader in) {
        this.config = config;
        this.reader = new BufferedReader(in);
        this.previousDelim = "";
        this.recordNumber = 0;
        this.commonRecord = new TreeMap();
        if (config.hasHeaderDelim()) {
            String header = this.getNextRecord(true);
            this.commonRecord.putAll(config.buildHeader(header));
        }
    }

    public Map<String, String> next() {
        String rawRecord = this.getNextRecord(false);
        if (null == rawRecord) {
            return null;
        }
        Map<String, String> record = this.config.buildRecord(rawRecord);
        record.putAll(this.commonRecord);
        return record;
    }

    private String getNextRecord(boolean isSelectingHeader) {
        try {
            boolean isReaderFinished = false;
            boolean isRecordLoaded = false;
            StringBuilder buffer = new StringBuilder();
            boolean wasDelimMatched = false;
            while (!isRecordLoaded) {
                String currentLine = this.reader.readLine();
                if (null == currentLine) {
                    isReaderFinished = true;
                    isRecordLoaded = true;
                } else {
                    if (StringUtils.isNotBlank((CharSequence)this.previousDelim)) {
                        buffer.append(this.previousDelim + "\n");
                        this.previousDelim = "";
                    }
                    if (isSelectingHeader && this.config.matchesHeaderDelim(currentLine)) {
                        isRecordLoaded = true;
                    } else if (!isSelectingHeader && this.config.matchesRecordDelim(currentLine)) {
                        boolean isFirstDelimOfInterest;
                        Delimiter applicableDelim = this.config.getApplicableDelim(currentLine);
                        boolean bl = isFirstDelimOfInterest = 0 == this.recordNumber && !wasDelimMatched;
                        if (applicableDelim.isDelimAtStartOfRecord() && isFirstDelimOfInterest) {
                            wasDelimMatched = true;
                        } else {
                            if (applicableDelim.isRetainDelim()) {
                                this.previousDelim = currentLine;
                            }
                            isRecordLoaded = true;
                        }
                    }
                }
                if (!StringUtils.isNotBlank((CharSequence)currentLine)) continue;
                buffer.append(currentLine + "\n");
            }
            if (isReaderFinished && buffer.length() == 0) {
                return null;
            }
            ++this.recordNumber;
            return buffer.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Problem reading source", e);
        }
    }
}

