/*
 * Decompiled with CFR 0.152.
 */
package com.sonalake.utah.config;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.sonalake.utah.config.Config;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;

public class ConfigLoader {
    public Config loadConfig(URL url) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(url.openStream());){
            Config config = this.loadConfig(reader);
            return config;
        }
    }

    public Config loadConfig(Reader reader) throws IOException {
        Config config = (Config)this.buildReader().readValue(reader, Config.class);
        this.validate(config);
        return config;
    }

    private XmlMapper buildReader() {
        XmlMapper mapper = new XmlMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, false);
        return mapper;
    }

    void validate(Config config) {
        if (!config.isDelimiterValid()) {
            throw new IllegalArgumentException(String.format("No delimited defined for config: %s ", config));
        }
        config.compilePatterns();
    }
}

