/*
 * Decompiled with CFR 0.152.
 */
package com.sonalake.utah.config;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.sonalake.utah.config.Delimiter;
import com.sonalake.utah.config.HeaderDelimiter;
import com.sonalake.utah.config.NameValue;
import com.sonalake.utah.config.ValueRegex;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

@JacksonXmlRootElement(localName="config")
public class Config {
    @JacksonXmlElementWrapper(useWrapping=false)
    @JacksonXmlProperty(localName="delim")
    protected List<Delimiter> delimiters;
    @JacksonXmlElementWrapper(localName="searches")
    @JacksonXmlProperty(localName="search")
    protected List<NameValue> searches;
    @JacksonXmlProperty(localName="header-delim")
    protected HeaderDelimiter headerDelimiter;
    @JacksonXmlProperty(localName="header")
    protected List<ValueRegex> headers;
    @JacksonXmlProperty(localName="values")
    protected List<ValueRegex> values;

    void compilePatterns() {
        this.compilePatterns(this.headers);
        this.compilePatterns(this.values);
        if (null != this.headerDelimiter) {
            this.headerDelimiter.compile(this.searches);
        }
        for (Delimiter delimiter : this.delimiters) {
            delimiter.compile(this.searches);
        }
    }

    private void compilePatterns(List<ValueRegex> sourceRegexes) {
        if (null != sourceRegexes) {
            for (ValueRegex value : sourceRegexes) {
                value.compile(this.searches);
            }
        }
    }

    public Map<String, String> buildHeader(String headerText) {
        return this.buildMap(this.headers, headerText);
    }

    public Map<String, String> buildRecord(String recordText) {
        return this.buildMap(this.values, recordText);
    }

    private Map<String, String> buildMap(List<ValueRegex> values, String text) {
        if (null != values) {
            TreeMap<String, String> result = new TreeMap<String, String>();
            for (ValueRegex valueRegex : values) {
                Matcher matcher = valueRegex.buildMatcher(text);
                if (matcher.matches()) {
                    String valueText = matcher.group(valueRegex.getGroup());
                    result.put(valueRegex.getId(), valueText);
                    continue;
                }
                if (!valueRegex.hasDefaultValue()) continue;
                result.put(valueRegex.getId(), valueRegex.getDefaultValue());
            }
            return result;
        }
        return Collections.emptyMap();
    }

    public boolean matchesHeaderDelim(String candidate) {
        return this.headerDelimiter.matches(candidate);
    }

    public boolean isDelimiterValid() {
        if (null == this.delimiters || this.delimiters.isEmpty()) {
            return false;
        }
        for (Delimiter delimiter : this.delimiters) {
            if (!delimiter.isDelimRequired() || !StringUtils.isBlank((CharSequence)delimiter.delimiter)) continue;
            return false;
        }
        return true;
    }

    public Delimiter getApplicableDelim(String candidate) {
        for (Delimiter delimiter : this.delimiters) {
            if (!delimiter.matches(candidate)) continue;
            return delimiter;
        }
        return null;
    }

    public boolean matchesRecordDelim(String candidate) {
        return null != this.getApplicableDelim(candidate);
    }

    public boolean hasHeaderDelim() {
        return null != this.headerDelimiter;
    }

    public List<String> getHeaderNames() {
        return this.values.stream().map(NameValue::getId).collect(Collectors.toList());
    }

    public String toString() {
        return String.format("CLIConfig: delim [%s], searches: [%s], values: [%s]", this.delimiters, this.searches, this.values);
    }
}

