/*
 * Decompiled with CFR 0.152.
 */
package com.sonalake.utah.config;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlText;
import com.sonalake.utah.config.NameValue;
import com.sonalake.utah.config.SearchHelper;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class Delimiter {
    @JacksonXmlProperty(isAttribute=true, localName="one-record")
    boolean isOneRecord;
    @JacksonXmlProperty(isAttribute=true, localName="per-line")
    boolean isPerLine;
    @JacksonXmlProperty(isAttribute=true, localName="retain")
    boolean isRetainDelim;
    @JacksonXmlProperty(isAttribute=true, localName="at-start")
    boolean isDelimAtStartOfRecord;
    @JacksonXmlText
    String delimiter;
    private Pattern compiledDelimiter;

    void compile(List<NameValue> searches) {
        if (null != this.delimiter && null == this.compiledDelimiter) {
            String valueText = SearchHelper.translate(this.delimiter, searches);
            this.compiledDelimiter = Pattern.compile(valueText);
        }
    }

    public boolean matches(String candidate) {
        if (this.isOneRecord) {
            return false;
        }
        if (this.isPerLine) {
            return StringUtils.isNotBlank((CharSequence)candidate);
        }
        return StringUtils.isNotBlank((CharSequence)candidate) && this.compiledDelimiter.matcher(candidate).matches();
    }

    boolean isDelimRequired() {
        return !this.isOneRecord && !this.isPerLine;
    }

    public boolean isRetainDelim() {
        return this.isRetainDelim || this.isDelimAtStartOfRecord();
    }

    public boolean isDelimAtStartOfRecord() {
        return this.isDelimAtStartOfRecord;
    }
}

