/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.command;

import com.sondertara.common.command.OSType;
import com.sondertara.common.command.ParameterProcess;
import com.sondertara.common.command.ProcessWrapper;
import com.sondertara.common.command.ResultProcessUtils;
import com.sondertara.common.model.ResultDTO;
import com.sondertara.common.util.StringFormatter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.UUID;
import org.apache.commons.io.FileUtils;

public class ExecOsCommand {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResultDTO<String> getCommandResult(ProcessWrapper command) {
        int exitValue;
        OSType osType = OSType.getOsType();
        if (osType == null) {
            return ResultDTO.fail("UNKNOWN_OS_TYPE", "\u64cd\u4f5c\u7cfb\u7edf\u65e0\u6cd5\u8bc6\u522b");
        }
        String scriptFile = null;
        if (command.isPipeline()) {
            scriptFile = ExecOsCommand.generateScriptFile(command.getCommand(), osType == OSType.WINDOWS);
            command.setCommand(scriptFile);
        }
        ParameterProcess pp = new ParameterProcess();
        Process pro = pp.parameterProcess(osType, command);
        try {
            exitValue = pro.waitFor();
        }
        catch (InterruptedException e1) {
            ResultDTO<String> resultDTO = ResultDTO.fail(StringFormatter.format("Exec command failed:{}", e1.getMessage()));
            return resultDTO;
        }
        finally {
            if (null != scriptFile) {
                FileUtils.deleteQuietly((File)new File(scriptFile));
            }
        }
        return ResultProcessUtils.process(exitValue, pro, command);
    }

    private static String generateScriptFile(String command, boolean isWindows) {
        String dirName = System.getProperty("user.dir");
        StringBuilder sb = new StringBuilder(dirName);
        String suffix = isWindows ? ".bat" : ".sh";
        try {
            File file = new File(sb.append("_").append(UUID.randomUUID()).append(suffix).toString());
            FileUtils.writeStringToFile((File)file, (String)command, (Charset)StandardCharsets.UTF_8);
            FileUtils.writeStringToFile((File)file, (String)ExecOsCommand.cleanupScript(command), (Charset)StandardCharsets.UTF_8);
            String path = file.getAbsolutePath();
            if (!isWindows) {
                ExecOsCommand.executeCommand("chmod", "u+x", path);
            }
            return path;
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private Path getScriptPath(String workingDirectory, String scriptFileName) {
        return Paths.get(workingDirectory, scriptFileName);
    }

    private void createScript(String workingDirectory, String scriptFileName, Boolean isWindows, String scriptValue) throws IOException, InterruptedException {
        Path scriptPath = this.getScriptPath(workingDirectory, scriptFileName);
        FileUtils.writeStringToFile((File)scriptPath.toFile(), (String)ExecOsCommand.cleanupScript(scriptValue), (Charset)StandardCharsets.UTF_8);
        if (!isWindows.booleanValue()) {
            ExecOsCommand.executeCommand(workingDirectory, null, "chmod", "u+x", scriptFileName);
        }
    }

    private static String cleanupScript(String scriptValue) {
        return scriptValue.replaceAll("(\\r\\n|\\n|\\r)", System.getProperty("line.separator"));
    }

    private static void executeCommand(String ... command) throws IOException, InterruptedException {
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        Process process = processBuilder.start();
        process.waitFor();
    }
}

