/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.command;

import com.sondertara.common.util.StringUtils;
import java.io.Serializable;

public class ProcessWrapper
implements Serializable {
    private String command;
    private boolean pipeline;
    private String hostName;
    private String ip;

    public ProcessWrapper(String command, String hostName, String ip) {
        this.command = command;
        this.hostName = hostName;
        this.ip = ip;
        this.pipeline = false;
        String s = StringUtils.removeWhiteLines(command);
        if (StringUtils.countLines(s) > 1) {
            this.pipeline = true;
        }
    }

    public ProcessWrapper(String command) {
        this.command = command;
        this.pipeline = false;
        String s = StringUtils.removeWhiteLines(command);
        if (StringUtils.countLines(s) > 1) {
            this.pipeline = true;
        }
    }

    public String getCommand() {
        return this.command;
    }

    public boolean isPipeline() {
        return this.pipeline;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getIp() {
        return this.ip;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public void setPipeline(boolean pipeline) {
        this.pipeline = pipeline;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProcessWrapper)) {
            return false;
        }
        ProcessWrapper other = (ProcessWrapper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$command = this.getCommand();
        String other$command = other.getCommand();
        if (this$command == null ? other$command != null : !this$command.equals(other$command)) {
            return false;
        }
        if (this.isPipeline() != other.isPipeline()) {
            return false;
        }
        String this$hostName = this.getHostName();
        String other$hostName = other.getHostName();
        if (this$hostName == null ? other$hostName != null : !this$hostName.equals(other$hostName)) {
            return false;
        }
        String this$ip = this.getIp();
        String other$ip = other.getIp();
        return !(this$ip == null ? other$ip != null : !this$ip.equals(other$ip));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProcessWrapper;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $command = this.getCommand();
        result = result * 59 + ($command == null ? 43 : $command.hashCode());
        result = result * 59 + (this.isPipeline() ? 79 : 97);
        String $hostName = this.getHostName();
        result = result * 59 + ($hostName == null ? 43 : $hostName.hashCode());
        String $ip = this.getIp();
        result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
        return result;
    }

    public String toString() {
        return "ProcessWrapper(command=" + this.getCommand() + ", pipeline=" + this.isPipeline() + ", hostName=" + this.getHostName() + ", ip=" + this.getIp() + ")";
    }
}

