/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.crypto;

import com.sondertara.common.exception.TaraException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class DESedeUtils {
    static final String DES_EDE = "DESede";

    public static byte[] initKey() {
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance(DES_EDE);
            keyGen.init(168, new SecureRandom());
            SecretKey secretKey = keyGen.generateKey();
            return secretKey.getEncoded();
        }
        catch (NoSuchAlgorithmException e) {
            throw new TaraException("DESede init key error", e);
        }
    }

    public static byte[] encrypt(byte[] data, byte[] key) {
        SecretKeySpec secretKey = new SecretKeySpec(key, DES_EDE);
        try {
            Cipher cipher = Cipher.getInstance(DES_EDE);
            cipher.init(1, secretKey);
            byte[] cipherBytes = cipher.doFinal(data);
            return cipherBytes;
        }
        catch (Exception e) {
            throw new TaraException("DESede encrypt key error", e);
        }
    }

    public static byte[] decrypt(byte[] data, byte[] key) {
        byte[] plainBytes;
        SecretKeySpec secretKey = new SecretKeySpec(key, DES_EDE);
        try {
            Cipher cipher = Cipher.getInstance(DES_EDE);
            cipher.init(2, secretKey);
            plainBytes = cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new TaraException("DESede encrypt key error", e);
        }
        return plainBytes;
    }
}

