/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.crypto;

import com.sondertara.common.crypto.SM2KeyPair;
import com.sondertara.common.exception.TaraException;
import com.sondertara.common.util.HexUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Arrays;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;

public class SM2Utils {
    private static final BigInteger A = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC", 16);
    private static final BigInteger B = new BigInteger("28E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E93", 16);
    private static final BigInteger N = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D54123", 16);
    private static final BigInteger P = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF", 16);
    private static final BigInteger GX = new BigInteger("32C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7", 16);
    private static final BigInteger GY = new BigInteger("BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0", 16);
    private static final BigInteger IV = new BigInteger("2C98EEFD718C73C9CF4925CEF2CE6A878C7AFBEF126F97B2D2938C2498397A8B", 16);
    private static final int BYTEARRAY_OUTPUT_STREAM_SIZE = 32;
    private static final int DIGEST_LENGTH = 32;
    private static final byte[] START_POSITION = new byte[]{-128};
    private static final byte[] ZERO_POSITION = new byte[]{0};
    private static final Integer TJ_15 = Integer.valueOf("79cc4519", 16);
    private static final Integer TJ_63 = Integer.valueOf("7a879d8a", 16);
    private static final ECDomainParameters ECC_DOMAIN_PARAMETERS;
    private static final SecureRandom SECURE_RANDOM;
    private static final ECCurve.Fp E_C_CURVE;
    private static final ECPoint EC_POINT;

    private static int getTjValue(int j) {
        if (j >= 0 && j <= 15) {
            return TJ_15;
        }
        if (j >= 16 && j <= 63) {
            return TJ_63;
        }
        throw new RuntimeException("\u6570\u636e\u65e0\u6548");
    }

    private static Integer gG(Integer x, Integer y, Integer z, int j) {
        if (j >= 0 && j <= 15) {
            return x ^ y ^ z;
        }
        if (j >= 16 && j <= 63) {
            return x & y | ~x.intValue() & z;
        }
        throw new RuntimeException("\u6570\u636e\u65e0\u6548");
    }

    private static Integer FF(Integer x, Integer y, Integer z, int j) {
        if (j >= 0 && j <= 15) {
            return x ^ y ^ z;
        }
        if (j >= 16 && j <= 63) {
            return x & y | x & z | y & z;
        }
        throw new RuntimeException("\u6570\u636e\u65e0\u6548");
    }

    private static byte[] toByteArray(int i) {
        byte[] byteArray = new byte[]{(byte)(i >>> 24), (byte)((i & 0xFFFFFF) >>> 16), (byte)((i & 0xFFFF) >>> 8), (byte)(i & 0xFF)};
        return byteArray;
    }

    private static byte[] toByteArray(int a, int b, int c, int d, int e, int f, int g, int h) throws IOException {
        ByteArrayOutputStream baoStream = new ByteArrayOutputStream(32);
        baoStream.write(SM2Utils.toByteArray(a));
        baoStream.write(SM2Utils.toByteArray(b));
        baoStream.write(SM2Utils.toByteArray(c));
        baoStream.write(SM2Utils.toByteArray(d));
        baoStream.write(SM2Utils.toByteArray(e));
        baoStream.write(SM2Utils.toByteArray(f));
        baoStream.write(SM2Utils.toByteArray(g));
        baoStream.write(SM2Utils.toByteArray(h));
        return baoStream.toByteArray();
    }

    private static BigInteger random(BigInteger max) {
        BigInteger r = new BigInteger(256, SECURE_RANDOM);
        while (r.compareTo(max) >= 0) {
            r = new BigInteger(128, SECURE_RANDOM);
        }
        return r;
    }

    private static boolean checkAllZero(byte[] buffer) {
        for (byte b : buffer) {
            if (b == 0) continue;
            return false;
        }
        return true;
    }

    public static byte[] encrypt(String srcStr, ECPoint publicKey, boolean newStandard) {
        byte[] C1;
        BigInteger k;
        ECPoint kpb;
        byte[] kpbBytes;
        byte[] privateKey;
        byte[] inputBuffer = srcStr.getBytes();
        do {
            ECPoint ecPoint;
            k = SM2Utils.random(N);
            ECPoint eCPoint = EC_POINT.multiply(k);
            C1 = eCPoint.getEncoded(false);
            BigInteger h = ECC_DOMAIN_PARAMETERS.getH();
            if (h == null || !(ecPoint = publicKey.multiply(h)).isInfinity()) continue;
            throw new IllegalStateException();
        } while (SM2Utils.checkAllZero(privateKey = SM2Utils.KDF(kpbBytes = (kpb = publicKey.multiply(k).normalize()).getEncoded(false), inputBuffer.length)));
        byte[] C2 = new byte[inputBuffer.length];
        for (int i = 0; i < inputBuffer.length; ++i) {
            C2[i] = (byte)(inputBuffer[i] ^ privateKey[i]);
        }
        byte[] C3 = SM2Utils.byteHash(kpb.getXCoord().toBigInteger().toByteArray(), inputBuffer, kpb.getYCoord().toBigInteger().toByteArray());
        byte[] encryptResult = new byte[C1.length + C2.length + C3.length];
        if (newStandard) {
            System.arraycopy(C1, 0, encryptResult, 0, C1.length);
            System.arraycopy(C3, 0, encryptResult, C1.length + C2.length, C3.length);
            System.arraycopy(C2, 0, encryptResult, C1.length, C2.length);
        } else {
            System.arraycopy(C1, 0, encryptResult, 0, C1.length);
            System.arraycopy(C2, 0, encryptResult, C1.length, C2.length);
            System.arraycopy(C3, 0, encryptResult, C1.length + C2.length, C3.length);
        }
        return encryptResult;
    }

    public static String decrypt(byte[] encryptData, BigInteger privateKey) {
        int klen;
        ECPoint _ecPoint;
        byte[] C1 = new byte[65];
        System.arraycopy(encryptData, 0, C1, 0, C1.length);
        ECPoint ecPoint = E_C_CURVE.decodePoint(C1).normalize();
        BigInteger h = ECC_DOMAIN_PARAMETERS.getH();
        if (h != null && (_ecPoint = ecPoint.multiply(h)).isInfinity()) {
            throw new IllegalStateException();
        }
        ECPoint dBC1 = ecPoint.multiply(privateKey).normalize();
        byte[] dBC1Bytes = dBC1.getEncoded(false);
        byte[] t = SM2Utils.KDF(dBC1Bytes, klen = encryptData.length - 65 - 32);
        if (SM2Utils.checkAllZero(t)) {
            System.err.println("\u5bc6\u94a5\u5168\u90e8\u4e3a0\uff01");
            throw new IllegalStateException();
        }
        byte[] Plaintext = new byte[klen];
        for (int i = 0; i < Plaintext.length; ++i) {
            Plaintext[i] = (byte)(encryptData[C1.length + i] ^ t[i]);
        }
        byte[] C3 = new byte[32];
        System.arraycopy(encryptData, encryptData.length - 32, C3, 0, 32);
        byte[] messageDigest = SM2Utils.byteHash(dBC1.getXCoord().toBigInteger().toByteArray(), Plaintext, dBC1.getYCoord().toBigInteger().toByteArray());
        if (Arrays.equals(messageDigest, C3)) {
            return new String(Plaintext, StandardCharsets.UTF_8);
        }
        throw new TaraException("\u6570\u5b57\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25\uff0c\u65e0\u6cd5\u89e3\u5bc6\uff01");
    }

    private static boolean between(BigInteger param, BigInteger min, BigInteger max) {
        return param.compareTo(min) >= 0 && param.compareTo(max) < 0;
    }

    private static boolean checkPublicKey(ECPoint publicKey) {
        if (!publicKey.isInfinity()) {
            BigInteger x = publicKey.getXCoord().toBigInteger();
            BigInteger y = publicKey.getYCoord().toBigInteger();
            if (SM2Utils.between(x, new BigInteger("0"), P) && SM2Utils.between(y, new BigInteger("0"), P)) {
                BigInteger xResult = x.pow(3).add(A.multiply(x)).add(B).mod(P);
                BigInteger yResult = y.pow(2).mod(P);
                return yResult.equals(xResult) && publicKey.multiply(N).isInfinity();
            }
        }
        return false;
    }

    public static SM2KeyPair initKey() {
        BigInteger d = SM2Utils.random(N.subtract(new BigInteger("1")));
        SM2KeyPair keyPair = new SM2KeyPair(EC_POINT.multiply(d).normalize(), d);
        if (SM2Utils.checkPublicKey(keyPair.getPublicKey())) {
            return keyPair;
        }
        throw new TaraException("SM2 init key error");
    }

    public static void exportPublicKey(ECPoint publicKey, String path) {
        File file = new File(path);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            byte[] buffer = publicKey.getEncoded(false);
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(buffer);
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static ECPoint importPublicKey(String keyPath) {
        File file = new File(keyPath);
        try {
            int size;
            if (!file.exists()) {
                return null;
            }
            FileInputStream fis = new FileInputStream(file);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[16];
            while ((size = fis.read(buffer)) != -1) {
                baos.write(buffer, 0, size);
            }
            fis.close();
            return E_C_CURVE.decodePoint(baos.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void exportPrivateKey(BigInteger privateKey, String keyPath) {
        File file = new File(keyPath);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(file));
            oos.writeObject(privateKey);
            oos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static BigInteger importPrivateKey(String path) {
        File file = new File(path);
        try {
            if (!file.exists()) {
                return null;
            }
            FileInputStream fis = new FileInputStream(file);
            ObjectInputStream ois = new ObjectInputStream(fis);
            BigInteger res = (BigInteger)ois.readObject();
            ois.close();
            fis.close();
            return res;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static byte[] join(byte[] ... params) {
        ByteArrayOutputStream baoStream = new ByteArrayOutputStream();
        byte[] res = null;
        try {
            for (byte[] param : params) {
                baoStream.write(param);
            }
            res = baoStream.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return res;
    }

    private static byte[] byteHash(byte[] ... params) {
        try {
            return SM2Utils.hash(SM2Utils.join(params));
        }
        catch (IOException e) {
            throw new TaraException(e);
        }
    }

    public static byte[] hash(byte[] source) throws IOException {
        byte[] m1 = SM2Utils.padding(source);
        int n = m1.length / 64;
        byte[] vi = IV.toByteArray();
        byte[] vi1 = null;
        for (int i = 0; i < n; ++i) {
            byte[] b = Arrays.copyOfRange(m1, i * 64, (i + 1) * 64);
            vi1 = SM2Utils.cF(vi, b);
            vi = vi1;
        }
        return vi1;
    }

    private static byte[] cF(byte[] vi, byte[] bi) throws IOException {
        int j;
        int a = SM2Utils.toInteger(vi, 0);
        int b = SM2Utils.toInteger(vi, 1);
        int c = SM2Utils.toInteger(vi, 2);
        int d = SM2Utils.toInteger(vi, 3);
        int e = SM2Utils.toInteger(vi, 4);
        int f = SM2Utils.toInteger(vi, 5);
        int g = SM2Utils.toInteger(vi, 6);
        int h = SM2Utils.toInteger(vi, 7);
        int[] w = new int[68];
        int[] w1 = new int[64];
        for (int i = 0; i < 16; ++i) {
            w[i] = SM2Utils.toInteger(bi, i);
        }
        for (j = 16; j < 68; ++j) {
            w[j] = SM2Utils.P1(w[j - 16] ^ w[j - 9] ^ Integer.rotateLeft(w[j - 3], 15)) ^ Integer.rotateLeft(w[j - 13], 7) ^ w[j - 6];
        }
        for (j = 0; j < 64; ++j) {
            w1[j] = w[j] ^ w[j + 4];
        }
        for (int j2 = 0; j2 < 64; ++j2) {
            int ss1 = Integer.rotateLeft(Integer.rotateLeft(a, 12) + e + Integer.rotateLeft(SM2Utils.getTjValue(j2), j2), 7);
            int ss2 = ss1 ^ Integer.rotateLeft(a, 12);
            int tt1 = SM2Utils.FF(a, b, c, j2) + d + ss2 + w1[j2];
            int tt2 = SM2Utils.gG(e, f, g, j2) + h + ss1 + w[j2];
            d = c;
            c = Integer.rotateLeft(b, 9);
            b = a;
            a = tt1;
            h = g;
            g = Integer.rotateLeft(f, 19);
            f = e;
            e = SM2Utils.P0(tt2);
        }
        byte[] v = SM2Utils.toByteArray(a, b, c, d, e, f, g, h);
        for (int i = 0; i < v.length; ++i) {
            v[i] = (byte)(v[i] ^ vi[i]);
        }
        return v;
    }

    private static Integer P0(Integer x) {
        return x ^ Integer.rotateLeft(x, 9) ^ Integer.rotateLeft(x, 17);
    }

    private static Integer P1(Integer x) {
        return x ^ Integer.rotateLeft(x, 15) ^ Integer.rotateLeft(x, 23);
    }

    private static int toInteger(byte[] source, int index) {
        StringBuilder valueStr = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            valueStr.append(HexUtils.HEX_DIGITS[(byte)((source[index * 4 + i] & 0xF0) >> 4)]);
            valueStr.append(HexUtils.HEX_DIGITS[(byte)(source[index * 4 + i] & 0xF)]);
        }
        return Long.valueOf(valueStr.toString(), 16).intValue();
    }

    private static byte[] padding(byte[] source) throws IOException {
        long l = (long)source.length * 8L;
        long k = 448L - (l + 1L) % 512L;
        if (k < 0L) {
            k += 512L;
        }
        ByteArrayOutputStream baoStream = new ByteArrayOutputStream();
        baoStream.write(source);
        baoStream.write(START_POSITION);
        for (long i = k - 7L; i > 0L; i -= 8L) {
            baoStream.write(ZERO_POSITION);
        }
        baoStream.write(HexUtils.long2bytes(l));
        return baoStream.toByteArray();
    }

    private static byte[] ZA(String IDA, ECPoint publicKey) {
        byte[] idaBytes = IDA.getBytes();
        int entlenA = idaBytes.length * 8;
        byte[] ENTLA = new byte[]{(byte)(entlenA & 0xFF00), (byte)(entlenA & 0xFF)};
        return SM2Utils.byteHash(ENTLA, idaBytes, A.toByteArray(), B.toByteArray(), GX.toByteArray(), GY.toByteArray(), publicKey.getXCoord().toBigInteger().toByteArray(), publicKey.getYCoord().toBigInteger().toByteArray());
    }

    public static Signature signature(String M, String IDA, SM2KeyPair keyPair) {
        BigInteger k;
        BigInteger r;
        byte[] ZA = SM2Utils.ZA(IDA, keyPair.getPublicKey());
        byte[] _M = SM2Utils.join(ZA, M.getBytes());
        BigInteger e = new BigInteger(1, SM2Utils.byteHash(new byte[][]{_M}));
        do {
            k = SM2Utils.random(N);
            ECPoint p1 = EC_POINT.multiply(k).normalize();
            BigInteger x1 = p1.getXCoord().toBigInteger();
            r = e.add(x1);
        } while ((r = r.mod(N)).equals(BigInteger.ZERO) || r.add(k).equals(N));
        BigInteger s = keyPair.getPrivateKey().add(BigInteger.ONE).modInverse(N).multiply(k.subtract(r.multiply(keyPair.getPrivateKey())).mod(N)).mod(N);
        return new Signature(r, s);
    }

    public static boolean verifySignature(String M, Signature signature, String IDA, ECPoint aPublicKey) {
        if (!SM2Utils.between(signature.r, BigInteger.ONE, N)) {
            return false;
        }
        if (!SM2Utils.between(signature.s, BigInteger.ONE, N)) {
            return false;
        }
        byte[] M_ = SM2Utils.join(SM2Utils.ZA(IDA, aPublicKey), M.getBytes());
        BigInteger e = new BigInteger(1, SM2Utils.byteHash(new byte[][]{M_}));
        BigInteger t = signature.r.add(signature.s).mod(N);
        if (t.equals(BigInteger.ZERO)) {
            return false;
        }
        ECPoint p1 = EC_POINT.multiply(signature.s).normalize();
        ECPoint p2 = aPublicKey.multiply(t).normalize();
        BigInteger x1 = p1.add(p2).normalize().getXCoord().toBigInteger();
        BigInteger R = e.add(x1).mod(N);
        return R.equals(signature.r);
    }

    private static byte[] KDF(byte[] bytes, int keyLen) {
        int ct = 1;
        int end = (int)Math.ceil((double)keyLen * 1.0 / 32.0);
        ByteArrayOutputStream baoStream = new ByteArrayOutputStream();
        try {
            for (int i = 1; i < end; ++i) {
                baoStream.write(SM2Utils.byteHash(bytes, SM2Utils.toByteArray(ct)));
                ++ct;
            }
            byte[] last = SM2Utils.byteHash(bytes, SM2Utils.toByteArray(ct));
            if (keyLen % 32 == 0) {
                baoStream.write(last);
            } else {
                baoStream.write(last, 0, keyLen % 32);
            }
            return baoStream.toByteArray();
        }
        catch (Exception e) {
            throw new TaraException("KDF error", e);
        }
    }

    public static ECPoint publicKeyStr2ECPoint(String publicKey) {
        byte[] _publicKeyByte = HexUtils.decodeHex(publicKey);
        return E_C_CURVE.decodePoint(_publicKeyByte);
    }

    public static String eCPoint2PublicKeyStr(ECPoint publicKey, boolean endCompression) {
        return HexUtils.encodeHexStr(publicKey.getEncoded(endCompression), false);
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        SM2KeyPair keyPair = SM2Utils.initKey();
        ECPoint publicKey = keyPair.getPublicKey();
        BigInteger privateKey = keyPair.getPrivateKey();
        SM2Utils.exportPublicKey(publicKey, "E:/publickey.pem");
        SM2Utils.exportPrivateKey(privateKey, "E:/privatekey.pem");
        String srcStr = "\u6625\u5bb5\u4e00\u523b\u503c\u5343\u91d1\uff0c\u82b1\u6709\u6e05\u9999\u6708\u6709\u9634\uff1b\u6b4c\u7ba1\u697c\u53f0\u58f0\u7ec6\u7ec6\uff0c\u79cb\u5343\u9662\u843d\u591c\u6c89\u6c89\uff01";
        ECPoint importPublicKey = SM2Utils.importPublicKey("E:/publickey.pem");
        BigInteger importPrivateKey = SM2Utils.importPrivateKey("E:/privatekey.pem");
        assert (importPublicKey != null);
        String publicKstr = SM2Utils.eCPoint2PublicKeyStr(importPublicKey, false);
        System.out.println("\u516c\u94a5\uff1a" + importPublicKey);
        System.out.println("\u516c\u94a5\u8f6c\u516c\u94a5\u5b57\u7b26\u4e32\uff1a" + publicKstr);
        System.out.println("\u516c\u94a5\u5b57\u7b26\u4e32\u8f6c\u516c\u94a5\uff1a" + SM2Utils.publicKeyStr2ECPoint(publicKstr));
        System.out.println("\u79c1\u94a5\uff1a" + privateKey);
        byte[] encryptData = SM2Utils.encrypt(srcStr, importPublicKey, false);
        System.out.println("\u539f\u59cb\u4fe1\u606f\uff08\u660e\u6587\uff09:" + srcStr);
        String encryptStr = HexUtils.encodeHexStr(encryptData);
        System.out.println("\u5229\u7528\u5bfc\u5165\u7684\u516c\u94a5\u8fdb\u884c\u52a0\u5bc6\u540e\u7684\u5bc6\u6587:");
        System.out.println(encryptStr);
        byte[] _encryptData = HexUtils.decodeHex(encryptStr);
        System.out.println("\u89e3\u5bc6\u540e\u7684\u660e\u6587:" + SM2Utils.decrypt(_encryptData, importPrivateKey));
        System.out.println("#####################\u7b7e \u540d \u4e0e \u9a8c \u8bc1###################");
        String IDA = "Sondertara";
        String signatureMessage = "\u9700\u8981\u8fdb\u884c\u7b7e\u540d\u7684\u4fe1\u606f";
        Signature signature = SM2Utils.signature(signatureMessage, IDA, new SM2KeyPair(publicKey, privateKey));
        System.out.println("\u7528\u6237\u6807\u8bc6:" + IDA);
        System.out.println("\u7b7e\u540d\u4fe1\u606f:" + signatureMessage);
        System.out.println("\u6570\u5b57\u7b7e\u540d:" + signature);
        System.out.println("\u9a8c\u8bc1\u7b7e\u540d:" + SM2Utils.verifySignature(signatureMessage, signature, IDA, publicKey));
    }

    static {
        SECURE_RANDOM = new SecureRandom();
        E_C_CURVE = new ECCurve.Fp(P, A, B, null, null);
        EC_POINT = E_C_CURVE.createPoint(GX, GY);
        ECC_DOMAIN_PARAMETERS = new ECDomainParameters((ECCurve)E_C_CURVE, EC_POINT, N);
    }

    public static class Signature {
        BigInteger r;
        BigInteger s;

        public Signature(BigInteger r, BigInteger s) {
            this.r = r;
            this.s = s;
        }

        public String toString() {
            return this.r.toString(16) + "," + this.s.toString(16);
        }
    }
}

