/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.crypto;

import com.sondertara.common.exception.TaraException;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;

public class SM3Utils {
    private static final String ENCODING = "UTF-8";

    public static String encrypt(String src) {
        return ByteUtils.toHexString((byte[])SM3Utils.getEncryptBySrcByte(src.getBytes()));
    }

    public static byte[] getEncryptBySrcByte(byte[] srcByte) {
        SM3Digest sm3 = new SM3Digest();
        sm3.update(srcByte, 0, srcByte.length);
        byte[] encryptByte = new byte[sm3.getDigestSize()];
        sm3.doFinal(encryptByte, 0);
        return encryptByte;
    }

    public static String encrypt(String src, String key) {
        return ByteUtils.toHexString((byte[])SM3Utils.getEncryptByKey(src, key));
    }

    public static byte[] getEncryptByKey(String src, String key) {
        try {
            byte[] srcByte = src.getBytes(ENCODING);
            byte[] keyByte = key.getBytes(ENCODING);
            KeyParameter keyParameter = new KeyParameter(keyByte);
            SM3Digest sm3 = new SM3Digest();
            HMac hMac = new HMac((Digest)sm3);
            hMac.init((CipherParameters)keyParameter);
            hMac.update(srcByte, 0, srcByte.length);
            byte[] result = new byte[hMac.getMacSize()];
            hMac.doFinal(result, 0);
            return result;
        }
        catch (Exception e) {
            throw new TaraException("SM3 encrypt error", e);
        }
    }

    public static boolean verify(String src, String sm3HexStr) throws Exception {
        byte[] sm3HashCode = ByteUtils.fromHexString((String)sm3HexStr);
        byte[] newHashCode = SM3Utils.getEncryptBySrcByte(src.getBytes(ENCODING));
        return Arrays.equals(newHashCode, sm3HashCode);
    }

    public static boolean verify(String src, String key, String sm3HexStr) {
        byte[] sm3HashCode = ByteUtils.fromHexString((String)sm3HexStr);
        byte[] newHashCode = SM3Utils.getEncryptByKey(src, key);
        return Arrays.equals(newHashCode, sm3HashCode);
    }

    public static void main(String[] args) throws Exception {
        String srcStr = "\u6625\u5bb5\u4e00\u523b\u503c\u5343\u91d1\uff0c\u82b1\u6709\u6e05\u9999\u6708\u6709\u9634\uff1b\u6b4c\u7ba1\u697c\u53f0\u58f0\u7ec6\u7ec6\uff0c\u79cb\u5343\u9662\u843d\u591c\u6c89\u6c89\uff01";
        String key = "\u6625\u5bb5";
        String hexStrByKey = SM3Utils.encrypt(srcStr, key);
        System.out.println("        \u5e26\u5bc6\u94a5\u52a0\u5bc6\u540e\u7684\u5bc6\u6587\uff1a" + hexStrByKey);
        System.out.println("\u660e\u6587(\u5e26\u5bc6\u94a5)\u4e0e\u5bc6\u6587\u6821\u9a8c\u7ed3\u679c\uff1a" + SM3Utils.verify(srcStr, key, hexStrByKey));
        System.out.println("++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
        String hexStrNoKey = SM3Utils.encrypt(srcStr);
        System.out.println("        \u4e0d\u5e26\u5bc6\u94a5\u52a0\u5bc6\u540e\u7684\u5bc6\u6587\uff1a" + hexStrNoKey);
        System.out.println("\u660e\u6587(\u4e0d\u5e26\u5bc6\u94a5)\u4e0e\u5bc6\u6587\u6821\u9a8c\u7ed3\u679c\uff1a" + SM3Utils.verify(srcStr, hexStrNoKey));
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

