/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.crypto;

import com.sondertara.common.exception.TaraException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;

public class SM4Utils {
    private static final String ENCODING = "UTF-8";
    private static final String ALGORITHM_NAME = "SM4";
    public static final String ALGORITHM_NAME_ECB_PADDING = "SM4/ECB/PKCS5Padding";
    public static final int DEFAULT_KEY_SIZE = 128;

    private static Cipher generateEcbCipher(String algorithmName, int mode, byte[] key) {
        try {
            Cipher cipher = Cipher.getInstance(algorithmName, "BC");
            SecretKeySpec sm4Key = new SecretKeySpec(key, ALGORITHM_NAME);
            cipher.init(mode, sm4Key);
            return cipher;
        }
        catch (Exception e) {
            throw new TaraException("SM4 generateEcbCipher error", e);
        }
    }

    public static byte[] autoGenerateKey(int keySize) {
        try {
            KeyGenerator kg = KeyGenerator.getInstance(ALGORITHM_NAME, "BC");
            kg.init(keySize, new SecureRandom());
            return kg.generateKey().getEncoded();
        }
        catch (Exception e) {
            throw new TaraException("SM4 generate key error", e);
        }
    }

    public static String encryptByEcb(String srcStr, String key) {
        try {
            byte[] keyData = ByteUtils.fromHexString((String)key);
            byte[] srcData = srcStr.getBytes(ENCODING);
            byte[] cipherArray = SM4Utils.encryptEcbPadding(keyData, srcData);
            return ByteUtils.toHexString((byte[])cipherArray);
        }
        catch (Exception e) {
            throw new TaraException("SM4 encryptByEcb error", e);
        }
    }

    public static byte[] encryptEcbPadding(byte[] key, byte[] data) throws Exception {
        Cipher cipher = SM4Utils.generateEcbCipher(ALGORITHM_NAME_ECB_PADDING, 1, key);
        return cipher.doFinal(data);
    }

    public static String decryptEcb(String hexKey, String cipherText) {
        try {
            byte[] keyData = ByteUtils.fromHexString((String)hexKey);
            byte[] cipherData = ByteUtils.fromHexString((String)cipherText);
            byte[] srcData = SM4Utils.decryptEcbPadding(keyData, cipherData);
            return new String(srcData, ENCODING);
        }
        catch (Exception e) {
            throw new TaraException("SM4 decryptEcb error", e);
        }
    }

    public static byte[] decryptEcbPadding(byte[] key, byte[] cipherText) {
        try {
            Cipher cipher = SM4Utils.generateEcbCipher(ALGORITHM_NAME_ECB_PADDING, 2, key);
            return cipher.doFinal(cipherText);
        }
        catch (Exception e) {
            throw new TaraException("SM4 decryptEcbPadding error", e);
        }
    }

    public static boolean verifyByEcb(String hexKey, String cipherText, String paramStr) {
        try {
            byte[] keyData = ByteUtils.fromHexString((String)hexKey);
            byte[] cipherData = ByteUtils.fromHexString((String)cipherText);
            byte[] decryptData = SM4Utils.decryptEcbPadding(keyData, cipherData);
            byte[] srcData = paramStr.getBytes(ENCODING);
            return Arrays.equals(decryptData, srcData);
        }
        catch (Exception e) {
            throw new TaraException("SM4 verifyByEcb error", e);
        }
    }

    public static void main(String[] args) {
        String srcStr = "\u6625\u5bb5\u4e00\u523b\u503c\u5343\u91d1\uff0c\u82b1\u6709\u6e05\u9999\u6708\u6709\u9634\uff1b\u6b4c\u7ba1\u697c\u53f0\u58f0\u7ec6\u7ec6\uff0c\u79cb\u5343\u9662\u843d\u591c\u6c89\u6c89\uff01";
        String key = ByteUtils.toHexString((byte[])SM4Utils.autoGenerateKey(128));
        String cipher = SM4Utils.encryptByEcb(srcStr, key);
        System.out.println("\u81ea\u52a8\u751f\u6210\u7684\u5bc6\u94a5\uff1a" + key);
        System.out.println("\u52a0\u5bc6\u540e\u7684\u5bc6\u6587\uff1a" + cipher);
        System.out.println("\u6821\u9a8c\u5bc6\u6587\u662f\u5426\u4e3a\u660e\u6587\u52a0\u5bc6\u6240\u5f97\uff1a" + SM4Utils.verifyByEcb(key, cipher, srcStr));
        srcStr = SM4Utils.decryptEcb(key, cipher);
        System.out.println("\u91c7\u7528\u5bc6\u94a5\uff1a" + key);
        System.out.println("\u89e3\u5bc6\u540e\u7684\u660e\u6587\uff1a" + srcStr);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

