/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.structure;

import java.util.ArrayList;
import java.util.List;

public class NodeList<E> {
    private int size;
    private final Node head = new Node(null, null);

    public int getSize() {
        return this.size;
    }

    public void add(int index, E data) {
        if (index < 0 || index > this.size) {
            throw new IllegalArgumentException("index out bounds");
        }
        Node tempNode = this.head;
        for (int i = 0; i < index; ++i) {
            tempNode = tempNode.next;
        }
        Node newNode = new Node(data);
        newNode.next = tempNode.next;
        tempNode.next = newNode;
        ++this.size;
    }

    public void addFirst(E data) {
        this.add(0, data);
    }

    public void addLast(E data) {
        this.add(this.size, data);
    }

    public E get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IllegalArgumentException("index out bounds");
        }
        Node tempNode = this.head.next;
        for (int i = 0; i < index; ++i) {
            tempNode = tempNode.next;
        }
        return tempNode.data;
    }

    public E getFirst() {
        return this.get(0);
    }

    public E getLast() {
        return this.get(this.size - 1);
    }

    public List<E> getAll() {
        ArrayList list = new ArrayList();
        Node tempNode = this.head.next;
        while (tempNode != null) {
            list.add(tempNode.data);
            tempNode = tempNode.next;
        }
        return list;
    }

    public boolean contains(E data) {
        Node node = this.head.next;
        while (node != null) {
            if (data.equals(node.data)) {
                return true;
            }
            node = node.next;
        }
        return false;
    }

    public boolean notContains(E data) {
        return !this.contains(data);
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void set(int index, E data) {
        if (index < 0 || index >= this.size) {
            throw new IllegalArgumentException("index out bounds");
        }
        Node tempNode = this.head.next;
        for (int i = 0; i < index; ++i) {
            tempNode = tempNode.next;
        }
        tempNode.data = data;
    }

    public void setFirst(E data) {
        this.set(0, data);
    }

    public void setLast(E data) {
        this.set(this.size - 1, data);
    }

    public E remove(int index) {
        if (index < 0 || index >= this.size) {
            throw new IllegalArgumentException("index out bounds");
        }
        Node tempNode = this.head;
        for (int i = 0; i < index; ++i) {
            tempNode = tempNode.next;
        }
        Node resNode = tempNode.next;
        Object data = resNode.data;
        tempNode.next = tempNode.next.next;
        resNode = null;
        --this.size;
        return data;
    }

    public E removeFirst() {
        return this.remove(0);
    }

    public E removeLast() {
        return this.remove(this.size - 1);
    }

    private class Node {
        public E data;
        public Node next;

        public Node(E data, Node next) {
            this.data = data;
            this.next = next;
        }

        public Node(E data) {
            this.data = data;
        }
    }
}

