/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.structure;

import com.google.common.collect.Lists;
import com.sondertara.common.structure.TreeNode;
import com.sondertara.common.util.CollectionUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Stack;

public class TreeUtils {
    public static <T extends TreeNode<?, T>> List<T> generateTrees(List<T> nodes) {
        ArrayList<TreeNode> roots = new ArrayList<TreeNode>();
        Iterator<T> ite = nodes.iterator();
        while (ite.hasNext()) {
            TreeNode node = (TreeNode)ite.next();
            if (!node.root()) continue;
            roots.add(node);
            ite.remove();
        }
        roots.forEach(r -> TreeUtils.setChildren(r, nodes));
        return roots;
    }

    public static <T extends TreeNode<?, T>> void setChildren(T parent, List<T> nodes) {
        ArrayList<TreeNode> children = new ArrayList<TreeNode>();
        Object parentId = parent.id();
        Iterator<T> ite = nodes.iterator();
        while (ite.hasNext()) {
            TreeNode node = (TreeNode)ite.next();
            if (!Objects.equals(node.pid(), parentId)) continue;
            children.add(node);
            ite.remove();
        }
        if (children.isEmpty()) {
            parent.markLeaf(true);
            return;
        }
        parent.markLeaf(false);
        parent.setChildren(children);
        children.forEach(m -> TreeUtils.setChildren(m, nodes));
    }

    public static <T extends TreeNode<?, T>> List<T> getLeafList(T parent) {
        ArrayList leafs = new ArrayList();
        TreeUtils.fillLeaf(parent, leafs);
        return leafs;
    }

    public static <T extends TreeNode<?, T>> void fillLeaf(T parent, List<T> leafList) {
        List<T> children = parent.getChildren();
        if (CollectionUtils.isEmpty(children)) {
            leafList.add(parent);
            return;
        }
        for (TreeNode child : children) {
            TreeUtils.fillLeaf(child, leafList);
        }
    }

    public static <T extends TreeNode<?, T>> List<List<String>> treeValueToRow(List<T> dataList, String ... keys) {
        if (CollectionUtils.isEmpty(dataList)) {
            return Collections.emptyList();
        }
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        for (TreeNode item : dataList) {
            TreeUtils.iteratorNode(item, new Stack<String>(), result, Arrays.asList(keys));
        }
        return result;
    }

    private static <T extends TreeNode<?, T>> void iteratorNode(T root, Stack<String> row, List<List<String>> result, List<String> keys) {
        try {
            Class<?> rootClass = root.getClass();
            for (String key : keys) {
                Field field = rootClass.getDeclaredField(key);
                field.setAccessible(true);
                row.push(null == field.get(root) ? "" : field.get(root).toString());
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        if (CollectionUtils.isEmpty(root.getChildren())) {
            result.add(Lists.newArrayList(row));
            return;
        }
        for (TreeNode child : root.getChildren()) {
            TreeUtils.iteratorNode(child, row, result, keys);
            for (int i = 0; i < keys.size(); ++i) {
                row.pop();
            }
        }
    }
}

