/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class CollectionUtils {
    public static <T> T[] toArray(List<T> list) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        Object[] array = new Object[list.size()];
        list.toArray(array);
        return array;
    }

    public static boolean isEmpty(Map<? extends Object, ? extends Object> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNotEmpty(Map<? extends Object, ? extends Object> map) {
        return map != null && !map.isEmpty();
    }

    public static List<? extends Object> parseMap2List(Map<? extends Object, ? extends Object> map) {
        ArrayList<Object> list = null;
        if (CollectionUtils.isNotEmpty(map)) {
            list = new ArrayList<Object>();
            for (Map.Entry<? extends Object, ? extends Object> entry : map.entrySet()) {
                list.add(entry.getValue());
            }
        }
        return list;
    }

    public static <K, V> Map<K, Object> convertMapValueToObject(Map<K, V> map) {
        HashMap<K, V> retMap = new HashMap<K, V>();
        if (CollectionUtils.isEmpty(map)) {
            return retMap;
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            retMap.put(entry.getKey(), entry.getValue());
        }
        return retMap;
    }

    public static boolean isEmpty(Collection<? extends Object> list) {
        return list == null || list.isEmpty();
    }

    public static boolean isNotEmpty(Collection<? extends Object> list) {
        return list != null && !list.isEmpty();
    }

    public static <T> String combineListToString(List<T> lists, char combineChar) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        for (T l : lists) {
            if (i > 0) {
                sb.append(combineChar);
            }
            ++i;
            sb.append(l);
        }
        return sb.toString();
    }

    public static <T> String combineListToString(List<T> lists, String combineStr) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        for (T l : lists) {
            if (i > 0) {
                sb.append(combineStr);
            }
            ++i;
            sb.append(l);
        }
        return sb.toString();
    }

    public static List<Long> strArrToLongList(String[] strArr) {
        ArrayList<Long> result = new ArrayList<Long>();
        if (strArr == null || strArr.length == 0) {
            return result;
        }
        for (String str : strArr) {
            result.add(Long.valueOf(str));
        }
        return result;
    }
}

