/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Objects;

public class FileUtils {
    public static boolean remove(File file) {
        if (!file.exists()) {
            return false;
        }
        if (file.isFile()) {
            return file.delete();
        }
        Arrays.asList((Object[])Objects.requireNonNull(file.listFiles())).forEach(FileUtils::remove);
        return file.delete();
    }

    public static boolean remove(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return false;
        }
        if (file.isFile()) {
            return file.delete();
        }
        Arrays.asList((Object[])Objects.requireNonNull(file.listFiles())).forEach(FileUtils::remove);
        return file.delete();
    }

    public static boolean removeParent(File file, int depth) throws FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getPath());
        }
        File parentFile = file.getParentFile();
        for (int i = 1; i < depth; ++i) {
            parentFile = parentFile.getParentFile();
        }
        if (null == parentFile) {
            return false;
        }
        return FileUtils.remove(parentFile);
    }

    public static BasicFileAttributes getAttributes(String filePath) throws IOException {
        return Files.readAttributes(new File(filePath).toPath(), BasicFileAttributes.class, new LinkOption[0]);
    }

    public static LocalDateTime getTimeCreate(String filePath) throws IOException {
        return LocalDateTime.ofInstant(FileUtils.getAttributes(filePath).creationTime().toInstant(), ZoneId.systemDefault());
    }

    public static LocalDateTime getTimeLastModify(String filePath) throws IOException {
        return LocalDateTime.ofInstant(FileUtils.getAttributes(filePath).lastModifiedTime().toInstant(), ZoneId.systemDefault());
    }
}

