/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.util;

import com.alibaba.fastjson.JSON;
import com.sondertara.common.exception.TaraException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static final Logger logger = LoggerFactory.getLogger(HttpUtils.class);
    private static final int CONN_TIME_OUT = 60000;
    private static final int READ_TIME_OUT = 60000;
    private static final int EXECUTION_COUNT = 3;
    private static final int RETRY_INTERVAL = 10000;
    private static final RequestConfig REQUEST_CONFIG_TIME_OUT = RequestConfig.custom().setSocketTimeout(60000).setConnectTimeout(60000).setConnectionRequestTimeout(60000).build();

    public static String doGet(String url, Map<String, Object> param) throws TaraException {
        StringBuffer buffer = new StringBuffer(url);
        if (url.endsWith("/")) {
            buffer.deleteCharAt(buffer.length() - 1);
        }
        buffer.append("?");
        buffer.append(HttpUtils.getParams(param));
        StringBuffer result = new StringBuffer();
        BufferedReader in = null;
        try {
            String line;
            logger.info("data:{}", (Object)buffer);
            URL realUrl = new URL(buffer.toString());
            HttpURLConnection connection = (HttpURLConnection)realUrl.openConnection();
            connection.setRequestProperty("accept", "*/*");
            connection.setConnectTimeout(60000);
            connection.setReadTimeout(60000);
            connection.connect();
            in = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
            while ((line = in.readLine()) != null) {
                result.append(line);
            }
        }
        catch (Exception e) {
            throw new TaraException(e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e2) {
                logger.error("\u91ca\u653e\u8d44\u6e90\u5f02\u5e38", (Throwable)e2);
            }
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doClientGet(String url, Map<String, Object> params, boolean isHttps) {
        CloseableHttpResponse response = null;
        String apiUrl = url;
        StringBuffer param = new StringBuffer();
        int i = 0;
        for (String key : params.keySet()) {
            if (i == 0) {
                param.append("?");
            } else {
                param.append("&");
            }
            param.append(key).append("=").append(params.get(key));
            ++i;
        }
        apiUrl = apiUrl + param;
        String result = null;
        CloseableHttpClient httpclient = isHttps ? HttpUtils.createSSLClientDefault() : HttpClients.createDefault();
        try {
            HttpGet httpGet = new HttpGet(apiUrl);
            response = httpclient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            }
        }
        catch (IOException e) {
            logger.error("HttpClientUtil-doGet,error:", (Throwable)e);
        }
        finally {
            if (response != null) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException e) {
                    logger.error("HttpClientUtil-doGet,error:", (Throwable)e);
                }
            }
            if (httpclient != null) {
                try {
                    httpclient.close();
                }
                catch (IOException e) {
                    logger.error("httpclient close error:", (Throwable)e);
                }
            }
        }
        return result;
    }

    public static String sendPostJson(String url, Map<String, Object> param) throws TaraException {
        System.out.println(url);
        System.out.println(JSON.toJSONString(param));
        return HttpUtils.sendPostJson(url, JSON.toJSONString(param));
    }

    public static String sendPostJson(String url, String jsonParam) throws TaraException {
        logger.info("post url ==>[{}]", (Object)url);
        logger.info("post param ==>[{}]", (Object)jsonParam);
        OutputStream out = null;
        InputStream in = null;
        HttpURLConnection conn = null;
        StringBuffer result = new StringBuffer();
        try {
            String line;
            URL realUrl = new URL(url);
            conn = (HttpURLConnection)realUrl.openConnection();
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36");
            conn.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
            conn.setConnectTimeout(60000);
            conn.setReadTimeout(60000);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.connect();
            out = conn.getOutputStream();
            out.write(jsonParam.getBytes(StandardCharsets.UTF_8));
            out.flush();
            in = conn.getResponseCode() < 400 ? conn.getInputStream() : conn.getErrorStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
            while ((line = reader.readLine()) != null) {
                result.append(line);
            }
            System.out.println(result);
            String string = result.toString();
            return string;
        }
        catch (Exception e) {
            throw new TaraException(e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                throw new TaraException(e);
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private static StringBuffer getParams(Map<String, Object> param) throws TaraException {
        StringBuffer buffer = new StringBuffer();
        try {
            if (param != null && !param.isEmpty()) {
                for (Map.Entry<String, Object> entry : param.entrySet()) {
                    buffer.append(entry.getKey()).append("=").append(URLEncoder.encode(String.valueOf(entry.getValue()), "UTF-8")).append("&");
                }
                buffer.deleteCharAt(buffer.length() - 1);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new TaraException(e);
        }
        return buffer;
    }

    public static String sendSSLPost(String url, String params, String contentType) throws TaraException {
        CloseableHttpClient httpClient = HttpUtils.createSSLClientDefault();
        HttpPost httpPost = new HttpPost(url);
        CloseableHttpResponse response = null;
        String httpStr = null;
        try {
            StringEntity jsonParams = new StringEntity(params, "utf-8");
            httpPost.addHeader("content-type", contentType);
            httpPost.setEntity((HttpEntity)jsonParams);
            RequestConfig defaultRequestConfig = RequestConfig.custom().setSocketTimeout(60000).setConnectTimeout(60000).setConnectionRequestTimeout(60000).build();
            httpPost.setConfig(defaultRequestConfig);
            response = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                httpStr = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
            }
        }
        catch (Exception e) {
            throw new TaraException(e);
        }
        finally {
            if (response != null) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException e) {
                    logger.error("HttpClientUtil-sendSSLPost,error:", (Throwable)e);
                }
            }
        }
        return httpStr;
    }

    public static String sendSSLPost2(String url, Map<String, Object> params) throws TaraException {
        CloseableHttpClient httpClient = HttpUtils.createSSLClientDefault();
        HttpPost httpPost = new HttpPost(url);
        CloseableHttpResponse response = null;
        String httpStr = null;
        try {
            ArrayList<BasicNameValuePair> paramsList = new ArrayList<BasicNameValuePair>();
            for (String key : params.keySet()) {
                paramsList.add(new BasicNameValuePair(key, String.valueOf(params.get(key))));
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(paramsList, "utf-8"));
            httpPost.setConfig(REQUEST_CONFIG_TIME_OUT);
            response = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                httpStr = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
            }
        }
        catch (Exception e) {
            throw new TaraException(e);
        }
        finally {
            if (response != null) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException e) {
                    logger.error("HttpClientUtil-sendSSLPost2,error:", (Throwable)e);
                }
            }
            if (httpClient != null) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    logger.error("httpclient close error:", (Throwable)e);
                }
            }
        }
        return httpStr;
    }

    public static String doClientGet(String url, Map<String, Object> params) throws TaraException {
        String result = "";
        CloseableHttpClient httpClient = HttpClients.createDefault();
        try {
            HttpEntity resEntity;
            HttpGet httpGet;
            CloseableHttpResponse httpResponse;
            if (params != null) {
                url = url.contains("?") ? url + "&" + HttpUtils.getParams(params) : url + "?" + HttpUtils.getParams(params);
            }
            if ((httpResponse = httpClient.execute((HttpUriRequest)(httpGet = new HttpGet(url)))).getStatusLine().getStatusCode() != 200) {
                System.out.println("GET Response Status: " + httpResponse.getStatusLine().getStatusCode());
                System.out.println("httpClient request result:" + result);
            }
            if ((resEntity = httpResponse.getEntity()) != null) {
                result = EntityUtils.toString((HttpEntity)resEntity, (String)"utf-8");
            }
            httpClient.close();
        }
        catch (Exception e) {
            logger.error("HttpClientUtil-sendClientGet,error:", (Throwable)e);
            throw new TaraException(e);
        }
        finally {
            if (httpClient != null) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    logger.error("httpclient close error:", (Throwable)e);
                }
            }
        }
        return result;
    }

    public static String doClientPost(String url, Map<String, Object> params) throws TaraException {
        String result = null;
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpPost httpPost = new HttpPost(url);
            if (params != null && !params.isEmpty()) {
                ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
                for (Map.Entry<String, Object> elem : params.entrySet()) {
                    if (elem.getValue() == null) continue;
                    list.add(new BasicNameValuePair(elem.getKey(), String.valueOf(elem.getValue())));
                }
                if (list.size() > 0) {
                    UrlEncodedFormEntity entity = new UrlEncodedFormEntity(list, "utf-8");
                    httpPost.setEntity((HttpEntity)entity);
                }
            }
            httpPost.setConfig(REQUEST_CONFIG_TIME_OUT);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            if (response != null) {
                HttpEntity resEntity = response.getEntity();
                if (resEntity != null) {
                    result = EntityUtils.toString((HttpEntity)resEntity, (String)"utf-8");
                }
                if (response.getStatusLine().getStatusCode() != 200) {
                    System.out.println("GET Response Status: " + response.getStatusLine().getStatusCode());
                    System.out.println("httpClient request result:" + result);
                }
            }
        }
        catch (Exception e) {
            logger.error("HttpClientUtil-sendClientPost,error:", (Throwable)e);
            throw new TaraException(e);
        }
        return result;
    }

    private static CloseableHttpClient getHttpClient() {
        CustomServiceUnavailableRetryStrategy serviceUnavailableRetryStrategy = new CustomServiceUnavailableRetryStrategy.Builder().executionCount(3).retryInterval(10000L).build();
        return HttpClientBuilder.create().setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)serviceUnavailableRetryStrategy).setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager()).setDefaultRequestConfig(RequestConfig.DEFAULT).setRetryHandler(HttpUtils.getHttpRequestRetryHandler()).build();
    }

    public static String postForm(String url, Map<String, Object> param) throws TaraException {
        OutputStream out = null;
        InputStream in = null;
        StringBuffer result = new StringBuffer();
        HttpURLConnection conn = null;
        try {
            String line;
            StringBuffer buffer = HttpUtils.getParams(param);
            URL realUrl = new URL(url);
            conn = (HttpURLConnection)realUrl.openConnection();
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            conn.setConnectTimeout(60000);
            conn.setReadTimeout(60000);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.connect();
            out = conn.getOutputStream();
            out.write(buffer.toString().getBytes(StandardCharsets.UTF_8));
            out.flush();
            in = conn.getResponseCode() < 400 ? conn.getInputStream() : conn.getErrorStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
            while ((line = reader.readLine()) != null) {
                result.append(line);
            }
            System.out.println(result);
            String string = result.toString();
            return string;
        }
        catch (Exception e) {
            throw new TaraException(e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
                if (conn != null) {
                    conn.disconnect();
                }
            }
            catch (IOException ex) {
                logger.error("\u91ca\u653e\u8d44\u6e90\u5f02\u5e38", (Throwable)ex);
            }
        }
    }

    private static HttpRequestRetryHandler getHttpRequestRetryHandler() {
        return new HttpRequestRetryHandler(){

            public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                if (executionCount > 3) {
                    return false;
                }
                if (exception instanceof NoHttpResponseException) {
                    logger.error("\u6ca1\u6709\u54cd\u5e94\u5f02\u5e38");
                    return true;
                }
                if (exception instanceof ConnectTimeoutException) {
                    logger.error("\u8fde\u63a5\u8d85\u65f6\uff0c\u91cd\u8bd5");
                    return true;
                }
                if (exception instanceof SSLHandshakeException) {
                    logger.error("\u672c\u5730\u8bc1\u4e66\u5f02\u5e38");
                    return false;
                }
                if (exception instanceof InterruptedIOException) {
                    logger.error("IO\u4e2d\u65ad\u5f02\u5e38");
                    return false;
                }
                if (exception instanceof UnknownHostException) {
                    logger.error("\u627e\u4e0d\u5230\u670d\u52a1\u5668\u5f02\u5e38");
                    return false;
                }
                if (exception instanceof SSLException) {
                    logger.error("SSL\u5f02\u5e38");
                    return false;
                }
                if (exception instanceof HttpHostConnectException) {
                    logger.error("\u4e3b\u673a\u8fde\u63a5\u5f02\u5e38");
                    return false;
                }
                if (exception instanceof SocketException) {
                    logger.error("socket\u5f02\u5e38");
                    return false;
                }
                logger.error("\u672a\u8bb0\u5f55\u7684\u8bf7\u6c42\u5f02\u5e38\uff1a" + exception.getClass());
                HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
                HttpRequest request = clientContext.getRequest();
                return !(request instanceof HttpEntityEnclosingRequest);
            }
        };
    }

    private static HttpRequestRetryHandler getRetryHandler() {
        return (e, retryTimes, httpContext) -> {
            if (retryTimes > 3) {
                return false;
            }
            if (e instanceof UnknownHostException || e instanceof ConnectTimeoutException || !(e instanceof SSLException) || e instanceof NoHttpResponseException) {
                return true;
            }
            HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)httpContext);
            HttpRequest request = clientContext.getRequest();
            boolean idempotent = !(request instanceof HttpEntityEnclosingRequest);
            return idempotent;
        };
    }

    private static CloseableHttpClient createSSLClientDefault() {
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext);
            return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
        }
        catch (Exception e) {
            logger.error("HttpClientUtil-createSSLClientDefault,error:", (Throwable)e);
            return HttpClients.createDefault();
        }
    }

    static class CustomServiceUnavailableRetryStrategy
    implements ServiceUnavailableRetryStrategy {
        private final int executionCount;
        private final long retryInterval;

        CustomServiceUnavailableRetryStrategy(Builder builder) {
            this.executionCount = builder.executionCount;
            this.retryInterval = builder.retryInterval;
        }

        public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
            if (response.getStatusLine().getStatusCode() != 200 && executionCount <= this.executionCount) {
                System.out.println(String.format("\u54cd\u5e94\u7801\u4e3a:%s,\u9700\u8981\u91cd\u65b0\u8bf7\u6c42", response.getStatusLine().getStatusCode()));
                return true;
            }
            return false;
        }

        public long getRetryInterval() {
            return this.retryInterval;
        }

        public static final class Builder {
            private int executionCount = 3;
            private long retryInterval = 5000L;

            public Builder executionCount(int executionCount) {
                this.executionCount = executionCount;
                return this;
            }

            public Builder retryInterval(long retryInterval) {
                this.retryInterval = retryInterval;
                return this;
            }

            public CustomServiceUnavailableRetryStrategy build() {
                return new CustomServiceUnavailableRetryStrategy(this);
            }
        }
    }
}

