/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalDateTimeUtils {
    private static final Logger log = LoggerFactory.getLogger(LocalDateTimeUtils.class);
    public static final String DATE_TIME_FORMATTER = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_TIME_MILLS_FORMATTER = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String DATE_FORMATTER = "yyyy-MM-dd";
    private static final LoadingCache<String, DateTimeFormatter> LOAD_CACHE = CacheBuilder.newBuilder().maximumSize(16L).build((CacheLoader)new CacheLoader<String, DateTimeFormatter>(){

        public DateTimeFormatter load(@Nonnull String pattern) {
            return DateTimeFormatter.ofPattern(pattern);
        }
    });

    public static String getNow() {
        return LocalDateTimeUtils.now(DATE_TIME_FORMATTER);
    }

    public static String now() {
        return LocalDateTimeUtils.getNow();
    }

    public static String now(String formatPattern) {
        LocalDateTime dateTime = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(formatPattern);
        return dateTime.format(formatter);
    }

    public static LocalDateTime convertToLocalDateTime(String dateTimeStr, String formatPattern) {
        try {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(formatPattern);
            return LocalDateTime.parse(dateTimeStr, formatter);
        }
        catch (Exception e) {
            log.error("parser date error,params=[{}],pattern=[{}]", new Object[]{dateTimeStr, formatPattern, e});
            return null;
        }
    }

    public static LocalDateTime convertToLocalDateTime(String dateTimeStr) {
        return LocalDateTimeUtils.convertToLocalDateTime(dateTimeStr, DATE_TIME_FORMATTER);
    }

    private static LocalDate convertToLocalDate(String date) {
        DateTimeFormatter formatter;
        LocalDate parse = null;
        try {
            formatter = DateTimeFormatter.ofPattern(DATE_FORMATTER);
            parse = LocalDate.parse(date, formatter);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (parse == null) {
            try {
                formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
                parse = LocalDate.parse(date, formatter);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (parse == null) {
            try {
                formatter = DateTimeFormatter.ofPattern("yyyy/MM/dd");
                parse = LocalDate.parse(date, formatter);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return parse;
    }

    public static String format(Date date, String pattern) {
        if (null == date) {
            return null;
        }
        Instant instant = date.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDateTime localDateTime = instant.atZone(zoneId).toLocalDateTime();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
        return localDateTime.format(formatter);
    }

    public static String format(Date date) {
        if (null == date) {
            return null;
        }
        return LocalDateTimeUtils.format(date, DATE_TIME_FORMATTER);
    }

    public static String formatLocalDateTime(LocalDateTime localDateTime, String pattern) {
        if (null == localDateTime) {
            return null;
        }
        try {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
            return localDateTime.format(formatter);
        }
        catch (Exception e) {
            log.error("parser date str error,pattern=[{}]", (Object)pattern, (Object)e);
            return null;
        }
    }

    public static String formatLocalDate(LocalDate localDate, String pattern) {
        if (null == localDate) {
            return null;
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
        return localDate.format(formatter);
    }

    public static String formatLocalDateTime(LocalDateTime localDateTime) {
        if (null == localDateTime) {
            return null;
        }
        return LocalDateTimeUtils.formatLocalDateTime(localDateTime, DATE_TIME_FORMATTER);
    }

    public static Date parseToDate(String dateTime) {
        return LocalDateTimeUtils.parseToDate(dateTime, DATE_TIME_FORMATTER);
    }

    public static Date parseToDate(String dateTime, String pattern) {
        if (dateTime == null) {
            return null;
        }
        Date date = null;
        try {
            LocalDateTime localDateTime = LocalDateTimeUtils.convertToLocalDateTime(dateTime, pattern);
            assert (localDateTime != null);
            date = Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
        }
        catch (Exception localDateTime) {
            // empty catch block
        }
        if (date == null) {
            try {
                LocalDate parse = LocalDateTimeUtils.convertToLocalDate(dateTime);
                date = Date.from(parse.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return date;
    }

    public static Integer getDelay(String startDate, String endDate) {
        LocalDate start = LocalDateTimeUtils.convertToLocalDate(startDate);
        LocalDate end = LocalDateTimeUtils.convertToLocalDate(endDate);
        if (start != null && end != null) {
            long l = end.toEpochDay() - start.toEpochDay();
            return (int)l;
        }
        return null;
    }

    public static String getDayStart(String dateStr) {
        LocalDate localDate = LocalDate.parse(dateStr, DateTimeFormatter.ofPattern(DATE_FORMATTER));
        LocalDateTime dateTime = LocalDateTime.of(localDate, LocalTime.MIN);
        return LocalDateTimeUtils.formatLocalDateTime(dateTime);
    }

    public static String getDayStart(LocalDate localDate) {
        LocalDateTime dateTime = LocalDateTime.of(localDate, LocalTime.MIN);
        return LocalDateTimeUtils.formatLocalDateTime(dateTime);
    }

    public static String getDayEnd(String dateStr) {
        LocalDate localDate = LocalDate.parse(dateStr, DateTimeFormatter.ofPattern(DATE_FORMATTER));
        LocalDateTime dateTime = LocalDateTime.of(localDate, LocalTime.MAX);
        return LocalDateTimeUtils.formatLocalDateTime(dateTime);
    }

    public static String getDayEnd(LocalDate localDate) {
        LocalDateTime dateTime = LocalDateTime.of(localDate, LocalTime.MAX);
        return LocalDateTimeUtils.formatLocalDateTime(dateTime);
    }

    public static Long getTimeStamp(String timeStr, String formatter) {
        try {
            LocalDateTime localDateTime = LocalDateTime.parse(timeStr, DateTimeFormatter.ofPattern(formatter));
            return localDateTime.toInstant(ZoneOffset.of("+8")).toEpochMilli();
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            try {
                LocalDate localDate = LocalDate.parse(timeStr, DateTimeFormatter.ofPattern(formatter));
                return localDate.atStartOfDay(ZoneOffset.ofHours(8)).toInstant().toEpochMilli();
            }
            catch (Exception e2) {
                log.error("", (Throwable)e2);
                return null;
            }
        }
    }

    public static Long getTimeStamp(String timeStr) {
        try {
            LocalDateTime localDateTime = LocalDateTime.parse(timeStr, DateTimeFormatter.ofPattern(DATE_TIME_MILLS_FORMATTER));
            return localDateTime.toInstant(ZoneOffset.of("+8")).toEpochMilli();
        }
        catch (Exception localDateTime) {
            try {
                LocalDateTime localDateTime2 = LocalDateTime.parse(timeStr, DateTimeFormatter.ofPattern(DATE_TIME_FORMATTER));
                return localDateTime2.toInstant(ZoneOffset.of("+8")).toEpochMilli();
            }
            catch (Exception localDateTime2) {
                try {
                    LocalDate localDate = LocalDate.parse(timeStr, DateTimeFormatter.ofPattern(DATE_FORMATTER));
                    return localDate.atStartOfDay(ZoneOffset.ofHours(8)).toInstant().toEpochMilli();
                }
                catch (Exception exception) {
                    return null;
                }
            }
        }
    }

    public static LocalDateTime getLocalDateTime(long timestamp) {
        try {
            return Instant.ofEpochMilli(timestamp).atZone(ZoneOffset.of("+8")).toLocalDateTime();
        }
        catch (Exception exception) {
            try {
                return Instant.ofEpochSecond(timestamp).atZone(ZoneOffset.of("+8")).toLocalDateTime();
            }
            catch (Exception exception2) {
                throw new RuntimeException("timestamp is invalid:" + timestamp);
            }
        }
    }

    public static LocalDate getLocalDate(long timestamp) {
        try {
            return Instant.ofEpochMilli(timestamp).atZone(ZoneOffset.of("+8")).toLocalDate();
        }
        catch (Exception exception) {
            try {
                return Instant.ofEpochSecond(timestamp).atZone(ZoneOffset.of("+8")).toLocalDate();
            }
            catch (Exception exception2) {
                throw new RuntimeException("timestamp is invalid:" + timestamp);
            }
        }
    }

    public static String getDateTimeSecondStr(long timestamp) {
        LocalDateTime localDateTime = LocalDateTimeUtils.getLocalDateTime(timestamp);
        if (null != localDateTime) {
            return localDateTime.format(DateTimeFormatter.ofPattern(DATE_TIME_FORMATTER));
        }
        throw new RuntimeException("timestamp is invalid:" + timestamp);
    }

    public static String getDateTimeMillsStr(long timestamp) {
        LocalDateTime localDateTime = LocalDateTimeUtils.getLocalDateTime(timestamp);
        if (null != localDateTime) {
            localDateTime.format(DateTimeFormatter.ofPattern(DATE_TIME_MILLS_FORMATTER));
        }
        throw new RuntimeException("timestamp is invalid:" + timestamp);
    }

    public static String getDateStr(long timestamp) {
        LocalDate localDate = LocalDateTimeUtils.getLocalDate(timestamp);
        if (null != localDate) {
            localDate.format(DateTimeFormatter.ofPattern(DATE_FORMATTER));
        }
        throw new RuntimeException("timestamp is invalid:" + timestamp);
    }
}

