/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Sets;
import com.sondertara.common.function.TaraFunction;
import com.sondertara.common.lang.Assert;
import com.sondertara.common.util.CompareUtils;
import com.sondertara.common.util.MutableObj;
import com.sondertara.common.util.PatternPool;
import com.sondertara.common.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexUtils {
    private static final LoadingCache<String, Pattern> LOAD_CACHE = CacheBuilder.newBuilder().maximumSize(30L).build((CacheLoader)new CacheLoader<String, Pattern>(){

        public Pattern load(String pattern) {
            return Pattern.compile(pattern);
        }
    });
    public static final String RE_CHINESE = "[\u4e00-\u9fff]";
    public static final String RE_CHINESES = "[\u4e00-\u9fff]+";
    public static final Set<Character> RE_KEYS = Sets.newHashSet((Object[])new Character[]{Character.valueOf('$'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('*'), Character.valueOf('+'), Character.valueOf('.'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('?'), Character.valueOf('\\'), Character.valueOf('^'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('|')});

    public static Boolean isMatch(String pattern, String value) throws ExecutionException {
        return ((Pattern)LOAD_CACHE.get((Object)pattern)).matcher(value).matches();
    }

    public static String getGroup0(String regex, CharSequence content) {
        return RegexUtils.get(regex, content, 0);
    }

    public static String getGroup1(String regex, CharSequence content) {
        return RegexUtils.get(regex, content, 1);
    }

    public static String get(String regex, CharSequence content, int groupIndex) {
        if (null == content || null == regex) {
            return null;
        }
        Pattern pattern = PatternPool.get(regex, 32);
        return RegexUtils.get(pattern, content, groupIndex);
    }

    public static String get(String regex, CharSequence content, String groupName) {
        if (null == content || null == regex) {
            return null;
        }
        Pattern pattern = PatternPool.get(regex, 32);
        return RegexUtils.get(pattern, content, groupName);
    }

    public static String getGroup0(Pattern pattern, CharSequence content) {
        return RegexUtils.get(pattern, content, 0);
    }

    public static String getGroup1(Pattern pattern, CharSequence content) {
        return RegexUtils.get(pattern, content, 1);
    }

    public static String get(Pattern pattern, CharSequence content, int groupIndex) {
        if (null == content || null == pattern) {
            return null;
        }
        MutableObj result = new MutableObj();
        RegexUtils.get(pattern, content, (Matcher matcher) -> result.set(matcher.group(groupIndex)));
        return (String)result.get();
    }

    public static String get(Pattern pattern, CharSequence content, String groupName) {
        if (null == content || null == pattern || null == groupName) {
            return null;
        }
        MutableObj result = new MutableObj();
        RegexUtils.get(pattern, content, (Matcher matcher) -> result.set(matcher.group(groupName)));
        return (String)result.get();
    }

    public static void get(Pattern pattern, CharSequence content, Consumer<Matcher> consumer) {
        if (null == content || null == pattern || null == consumer) {
            return;
        }
        Matcher m = pattern.matcher(content);
        if (m.find()) {
            consumer.accept(m);
        }
    }

    public static List<String> getAllGroups(Pattern pattern, CharSequence content) {
        return RegexUtils.getAllGroups(pattern, content, true);
    }

    public static List<String> getAllGroups(Pattern pattern, CharSequence content, boolean withGroup0) {
        if (null == content || null == pattern) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            int startGroup = withGroup0 ? 0 : 1;
            int groupCount = matcher.groupCount();
            for (int i = startGroup; i <= groupCount; ++i) {
                result.add(matcher.group(i));
            }
        }
        return result;
    }

    public static String extractMulti(Pattern pattern, CharSequence content, String template) {
        if (null == content || null == pattern || null == template) {
            return null;
        }
        TreeSet<Integer> varNums = new TreeSet<Integer>((o1, o2) -> CompareUtils.compare(o2, o1));
        Matcher matcherForTemplate = PatternPool.GROUP_VAR.matcher(template);
        while (matcherForTemplate.find()) {
            varNums.add(Integer.parseInt(matcherForTemplate.group(1)));
        }
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            for (Integer group : varNums) {
                template = template.replace("$" + group, matcher.group(group));
            }
            return template;
        }
        return null;
    }

    public static String extractMulti(String regex, CharSequence content, String template) {
        if (null == content || null == regex || null == template) {
            return null;
        }
        Pattern pattern = PatternPool.get(regex, 32);
        return RegexUtils.extractMulti(pattern, content, template);
    }

    public static String delFirst(String regex, CharSequence content) {
        if (StringUtils.hasBlank(regex, content)) {
            return StringUtils.str(content);
        }
        Pattern pattern = PatternPool.get(regex, 32);
        return RegexUtils.delFirst(pattern, content);
    }

    public static String delFirst(Pattern pattern, CharSequence content) {
        return RegexUtils.replaceFirst(pattern, content, "");
    }

    public static String replaceFirst(Pattern pattern, CharSequence content, String replacement) {
        if (null == pattern || StringUtils.isEmpty(content)) {
            return StringUtils.str(content);
        }
        return pattern.matcher(content).replaceFirst(replacement);
    }

    public static String delLast(String regex, CharSequence str) {
        if (StringUtils.hasBlank(regex, str)) {
            return StringUtils.str(str);
        }
        Pattern pattern = PatternPool.get(regex, 32);
        return RegexUtils.delLast(pattern, str);
    }

    public static String delLast(Pattern pattern, CharSequence str) {
        MatchResult matchResult;
        if (null != pattern && StringUtils.isNotEmpty(str) && null != (matchResult = RegexUtils.lastIndexOf(pattern, str))) {
            return StringUtils.subPre(str, matchResult.start()) + StringUtils.subSuf(str, matchResult.end());
        }
        return StringUtils.str(str);
    }

    public static String delAll(String regex, CharSequence content) {
        if (StringUtils.hasBlank(regex, content)) {
            return StringUtils.str(content);
        }
        Pattern pattern = PatternPool.get(regex, 32);
        return RegexUtils.delAll(pattern, content);
    }

    public static String delAll(Pattern pattern, CharSequence content) {
        if (null == pattern || StringUtils.isBlank(content)) {
            return StringUtils.str(content);
        }
        return pattern.matcher(content).replaceAll("");
    }

    public static String delPre(String regex, CharSequence content) {
        if (null == content || null == regex) {
            return StringUtils.str(content);
        }
        Pattern pattern = PatternPool.get(regex, 32);
        return RegexUtils.delPre(pattern, content);
    }

    public static String delPre(Pattern pattern, CharSequence content) {
        if (null == content || null == pattern) {
            return StringUtils.str(content);
        }
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            return StringUtils.sub(content, matcher.end(), content.length());
        }
        return StringUtils.str(content);
    }

    public static List<String> findAllGroup0(String regex, CharSequence content) {
        return RegexUtils.findAll(regex, content, 0);
    }

    public static List<String> findAllGroup1(String regex, CharSequence content) {
        return RegexUtils.findAll(regex, content, 1);
    }

    public static List<String> findAll(String regex, CharSequence content, int group) {
        return RegexUtils.findAll(regex, content, group, new ArrayList());
    }

    public static <T extends Collection<String>> T findAll(String regex, CharSequence content, int group, T collection) {
        if (null == regex) {
            return collection;
        }
        return RegexUtils.findAll(PatternPool.get(regex, 32), content, group, collection);
    }

    public static List<String> findAllGroup0(Pattern pattern, CharSequence content) {
        return RegexUtils.findAll(pattern, content, 0);
    }

    public static List<String> findAllGroup1(Pattern pattern, CharSequence content) {
        return RegexUtils.findAll(pattern, content, 1);
    }

    public static List<String> findAll(Pattern pattern, CharSequence content, int group) {
        return RegexUtils.findAll(pattern, content, group, new ArrayList());
    }

    public static <T extends Collection<String>> T findAll(Pattern pattern, CharSequence content, int group, T collection) {
        if (null == pattern || null == content) {
            return null;
        }
        Assert.notNull(collection, "Collection must be not null !", new Object[0]);
        RegexUtils.findAll(pattern, content, matcher -> collection.add(matcher.group(group)));
        return collection;
    }

    public static void findAll(Pattern pattern, CharSequence content, Consumer<Matcher> consumer) {
        if (null == pattern || null == content) {
            return;
        }
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            consumer.accept(matcher);
        }
    }

    public static int count(String regex, CharSequence content) {
        if (null == regex || null == content) {
            return 0;
        }
        Pattern pattern = PatternPool.get(regex, 32);
        return RegexUtils.count(pattern, content);
    }

    public static int count(Pattern pattern, CharSequence content) {
        if (null == pattern || null == content) {
            return 0;
        }
        int count = 0;
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            ++count;
        }
        return count;
    }

    public static boolean contains(String regex, CharSequence content) {
        if (null == regex || null == content) {
            return false;
        }
        Pattern pattern = PatternPool.get(regex, 32);
        return RegexUtils.contains(pattern, content);
    }

    public static boolean contains(Pattern pattern, CharSequence content) {
        if (null == pattern || null == content) {
            return false;
        }
        return pattern.matcher(content).find();
    }

    public static MatchResult indexOf(String regex, CharSequence content) {
        if (null == regex || null == content) {
            return null;
        }
        Pattern pattern = PatternPool.get(regex, 32);
        return RegexUtils.indexOf(pattern, content);
    }

    public static MatchResult indexOf(Pattern pattern, CharSequence content) {
        Matcher matcher;
        if (null != pattern && null != content && (matcher = pattern.matcher(content)).find()) {
            return matcher.toMatchResult();
        }
        return null;
    }

    public static MatchResult lastIndexOf(String regex, CharSequence content) {
        if (null == regex || null == content) {
            return null;
        }
        Pattern pattern = PatternPool.get(regex, 32);
        return RegexUtils.lastIndexOf(pattern, content);
    }

    public static MatchResult lastIndexOf(Pattern pattern, CharSequence content) {
        MatchResult result = null;
        if (null != pattern && null != content) {
            Matcher matcher = pattern.matcher(content);
            while (matcher.find()) {
                result = matcher.toMatchResult();
            }
        }
        return result;
    }

    public static Integer getFirstNumber(CharSequence StringWithNumber) {
        return Integer.parseInt(RegexUtils.get(PatternPool.NUMBERS, StringWithNumber, 0));
    }

    public static boolean isMatch(String regex, CharSequence content) {
        if (content == null) {
            return false;
        }
        if (StringUtils.isEmpty(regex)) {
            return true;
        }
        Pattern pattern = PatternPool.get(regex, 32);
        return RegexUtils.isMatch(pattern, content);
    }

    public static boolean isMatch(Pattern pattern, CharSequence content) {
        if (content == null || pattern == null) {
            return false;
        }
        return pattern.matcher(content).matches();
    }

    public static String replaceAll(CharSequence content, String regex, String replacementTemplate) {
        Pattern pattern = Pattern.compile(regex, 32);
        return RegexUtils.replaceAll(content, pattern, replacementTemplate);
    }

    public static String replaceAll(CharSequence content, Pattern pattern, String replacementTemplate) {
        if (StringUtils.isEmpty(content)) {
            return StringUtils.str(content);
        }
        Matcher matcher = pattern.matcher(content);
        boolean result = matcher.find();
        if (result) {
            Set varNums = RegexUtils.findAll(PatternPool.GROUP_VAR, (CharSequence)replacementTemplate, 1, new HashSet());
            StringBuffer sb = new StringBuffer();
            do {
                String replacement = replacementTemplate;
                for (String var : varNums) {
                    int group = Integer.parseInt(var);
                    replacement = replacement.replace("$" + var, matcher.group(group));
                }
                matcher.appendReplacement(sb, RegexUtils.escape(replacement));
            } while (result = matcher.find());
            matcher.appendTail(sb);
            return sb.toString();
        }
        return StringUtils.str(content);
    }

    public static String replaceAll(CharSequence str, String regex, TaraFunction<Matcher, String> replaceFun) {
        return RegexUtils.replaceAll(str, Pattern.compile(regex), replaceFun);
    }

    public static String replaceAll(CharSequence str, Pattern pattern, TaraFunction<Matcher, String> replaceFun) {
        if (StringUtils.isEmpty(str)) {
            return StringUtils.str(str);
        }
        Matcher matcher = pattern.matcher(str);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            try {
                matcher.appendReplacement(buffer, (String)replaceFun.apply(matcher));
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    public static String escape(char c) {
        StringBuilder builder = new StringBuilder();
        if (RE_KEYS.contains(Character.valueOf(c))) {
            builder.append('\\');
        }
        builder.append(c);
        return builder.toString();
    }

    public static String escape(CharSequence content) {
        if (StringUtils.isBlank(content)) {
            return StringUtils.str(content);
        }
        StringBuilder builder = new StringBuilder();
        int len = content.length();
        for (int i = 0; i < len; ++i) {
            char current = content.charAt(i);
            if (RE_KEYS.contains(Character.valueOf(current))) {
                builder.append('\\');
            }
            builder.append(current);
        }
        return builder.toString();
    }
}

