/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.bean;

import com.sondertara.common.bean.PropertyUtils;
import com.sondertara.common.bean.exception.BeanCopyException;
import com.sondertara.common.lang.reflect.ReflectUtils;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DeepCopyUtils {
    public static void copyProperties(Object source, Object target) {
        Class<?> actualEditable = target.getClass();
        PropertyDescriptor[] targetPds = PropertyUtils.getPropertyDescriptors(actualEditable);
        for (int i = 0; i < targetPds.length; ++i) {
            PropertyDescriptor sourcePd;
            PropertyDescriptor targetPd = targetPds[i];
            if (targetPd.getWriteMethod() == null || (sourcePd = PropertyUtils.getPropertyDescriptor(source, targetPd.getName())) == null || sourcePd.getReadMethod() == null) continue;
            try {
                boolean sameClass;
                Class<?> srcTrueType;
                Class<?> destTrueType;
                Field destField;
                Field srcField;
                Object srcValue;
                Method readMethod = sourcePd.getReadMethod();
                if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                    readMethod.setAccessible(true);
                }
                if (null == (srcValue = readMethod.invoke(source, new Object[0]))) continue;
                if (Collection.class.isAssignableFrom(sourcePd.getPropertyType())) {
                    srcField = source.getClass().getDeclaredField(sourcePd.getName());
                    destField = target.getClass().getDeclaredField(targetPd.getName());
                    destTrueType = DeepCopyUtils.getTrueType(destField);
                    if (!destTrueType.equals(srcTrueType = DeepCopyUtils.getTrueType(srcField))) {
                        DeepCopyUtils.copyCollection(sourcePd, targetPd, source, target);
                        continue;
                    }
                }
                if (Map.class.isAssignableFrom(sourcePd.getPropertyType())) {
                    srcField = source.getClass().getDeclaredField(sourcePd.getName());
                    destField = target.getClass().getDeclaredField(targetPd.getName());
                    destTrueType = DeepCopyUtils.getMapValueTrueType(destField);
                    if (!destTrueType.equals(srcTrueType = DeepCopyUtils.getMapValueTrueType(srcField))) {
                        DeepCopyUtils.copyMap(sourcePd, targetPd, source, target);
                        continue;
                    }
                }
                if (!(sameClass = targetPd.getPropertyType().isAssignableFrom(srcValue.getClass()))) {
                    boolean base;
                    boolean bl = base = srcValue instanceof String || srcValue instanceof Number || srcValue instanceof Boolean;
                    if (base) continue;
                    Object dstValue = ReflectUtils.newInstance(targetPd.getPropertyType(), new Object[0]);
                    DeepCopyUtils.copyProperties(srcValue, dstValue);
                    Method writeMethod = targetPd.getWriteMethod();
                    if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
                        writeMethod.setAccessible(true);
                    }
                    writeMethod.invoke(target, dstValue);
                    continue;
                }
                Method writeMethod = targetPd.getWriteMethod();
                if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
                    writeMethod.setAccessible(true);
                }
                writeMethod.invoke(target, srcValue);
                continue;
            }
            catch (Throwable ex) {
                throw new BeanCopyException("Could not copy properties from source to target", ex);
            }
        }
    }

    private static void copyMap(PropertyDescriptor sourcePd, PropertyDescriptor targetPd, Object source, Object target) throws NoSuchFieldException {
        Field srcField = source.getClass().getDeclaredField(sourcePd.getName());
        Field destField = target.getClass().getDeclaredField(targetPd.getName());
        srcField.setAccessible(true);
        destField.setAccessible(true);
        try {
            Class<?> destTrueField = DeepCopyUtils.getMapValueTrueType(destField);
            HashMap srcMap = (HashMap)srcField.get(source);
            HashMap destMap = new HashMap();
            for (Map.Entry entry : srcMap.entrySet()) {
                Object destObj = ReflectUtils.newInstance(destTrueField, new Object[0]);
                DeepCopyUtils.copyProperties(entry.getValue(), destObj);
                destMap.put(entry.getKey(), destObj);
            }
            destField.set(target, destMap);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static void copyCollection(PropertyDescriptor sourcePd, PropertyDescriptor targetPd, Object source, Object target) throws Exception {
        Field srcField = source.getClass().getDeclaredField(sourcePd.getName());
        Field destField = target.getClass().getDeclaredField(targetPd.getName());
        srcField.setAccessible(true);
        destField.setAccessible(true);
        try {
            Class destTrueField = DeepCopyUtils.getTrueType(destField);
            Collection srcList = (Collection)srcField.get(source);
            AbstractCollection destCollec = null;
            if (List.class.isAssignableFrom(destField.getType())) {
                destCollec = new ArrayList();
            } else if (Set.class.isAssignableFrom(destField.getType())) {
                destCollec = new HashSet();
            } else {
                throw new Exception("don not support type");
            }
            for (Object srcObj : srcList) {
                Object destObj = ReflectUtils.newInstance(destTrueField, new Object[0]);
                DeepCopyUtils.copyProperties(srcObj, destObj);
                destCollec.add(destObj);
            }
            destField.set(target, destCollec);
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
    }

    private static Class getTrueType(Field srcField) {
        Type genericType = srcField.getGenericType();
        ParameterizedType pt = (ParameterizedType)genericType;
        Class actualClass = (Class)pt.getActualTypeArguments()[0];
        return actualClass;
    }

    private static Class<?> getMapValueTrueType(Field srcField) {
        Type genericType = srcField.getGenericType();
        ParameterizedType pt = (ParameterizedType)genericType;
        Class actualClass = (Class)pt.getActualTypeArguments()[1];
        return actualClass;
    }

    public static void copyList(String srcFieldStr, String destFieldStr, Object source, Object target) throws NoSuchFieldException {
        Field srcField = source.getClass().getDeclaredField(srcFieldStr);
        Field destField = target.getClass().getDeclaredField(destFieldStr);
        srcField.setAccessible(true);
        destField.setAccessible(true);
        try {
            Class destTrueField = DeepCopyUtils.getTrueType(destField);
            List srcList = (List)srcField.get(source);
            ArrayList destList = new ArrayList();
            for (int j = 0; j < srcList.size(); ++j) {
                Object srcObj = srcList.get(j);
                Object destObj = ReflectUtils.newInstance(destTrueField, new Object[0]);
                DeepCopyUtils.copyProperties(srcObj, destObj);
                destList.add(destObj);
            }
            destField.set(target, destList);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }
}

