/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.bean.copier;

import com.sondertara.common.bean.copier.AbstractCopier;
import com.sondertara.common.bean.copier.BeanCopierRegistry;
import com.sondertara.common.bean.copier.CollectionCopier;
import com.sondertara.common.bean.copier.ConverterRegistry;
import com.sondertara.common.bean.copier.Copier;
import com.sondertara.common.bean.copier.MapCopier;
import com.sondertara.common.bean.copier.SingleCopier;
import com.sondertara.common.bean.copier.Utils;
import com.sondertara.common.bean.exception.BeanAnalysisException;
import com.sondertara.common.bean.exception.BeanCopyException;
import com.sondertara.common.convert.TypeConverter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class BeanCopier
extends AbstractCopier {
    private final Class<?> fromCls;
    private final Class<?> toCls;
    private Constructor<?> constructor;
    private volatile List<Copier> copiers = null;

    BeanCopier(Class<?> fromCls, Class<?> toCls) {
        super(null, null);
        this.fromCls = fromCls;
        this.toCls = toCls;
        this.converter = ConverterRegistry.find(fromCls.getName(), toCls.getName());
        if (this.converter == null) {
            try {
                this.constructor = toCls.getDeclaredConstructor(new Class[0]);
                this.constructor.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                throw new BeanAnalysisException(e);
            }
        }
    }

    BeanCopier(Field fromField, Field toField) {
        super(fromField, toField);
        this.fromCls = fromField.getType();
        this.toCls = toField.getType();
        fromField.setAccessible(true);
        toField.setAccessible(true);
        this.converter = ConverterRegistry.find(this.fromCls.getName(), this.toCls.getName());
        if (this.converter == null) {
            try {
                this.constructor = this.toCls.getDeclaredConstructor(new Class[0]);
                this.constructor.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                throw new BeanAnalysisException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureAnalyzed() {
        if (this.converter != null) {
            return;
        }
        if (this.copiers == null) {
            BeanCopier beanCopier = this;
            synchronized (beanCopier) {
                if (this.copiers == null) {
                    this.copiers = BeanCopier.analyze(this.fromCls, this.toCls);
                }
            }
        }
    }

    Object topCopyWithoutTopConverter(Object source) {
        Object target;
        if (this.converter != null) {
            return this.converter.convert(source, null);
        }
        try {
            target = this.constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new BeanCopyException(e);
        }
        this.topCopyWithoutTopConverter(source, target);
        return target;
    }

    Object copyConvert(Object source, Object defaultValue) {
        Object target;
        if (this.converter != null) {
            return this.converter.convert(source, null);
        }
        try {
            target = this.constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new BeanCopyException(e);
        }
        this.topCopyWithoutTopConverter(source, target);
        return target;
    }

    void topCopyWithoutTopConverter(Object source, Object target) {
        this.ensureAnalyzed();
        for (Copier copier : this.copiers) {
            copier.copy(source, target);
        }
    }

    @Override
    public void copy(Object source, Object target) {
        Object to;
        Object from;
        try {
            from = this.fromField.get(source);
            to = this.toField.get(target);
            if (from == null) {
                if (this.ignoreNull) {
                    return;
                }
                this.toField.set(target, null);
                return;
            }
            if (this.converter != null) {
                this.toField.set(target, this.converter.convert(from, null));
                return;
            }
            if (to == null) {
                to = this.constructor.newInstance(new Object[0]);
                this.toField.set(target, to);
            }
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new BeanCopyException(e);
        }
        this.ensureAnalyzed();
        for (Copier copier : this.copiers) {
            copier.copy(from, to);
        }
    }

    private static List<Copier> analyze(Class<?> sourceCls, Class<?> targetCls) {
        HashMap<String, Field> fromFieldsMap = new HashMap<String, Field>(8);
        for (Field field : BeanCopier.allNonStaticFields(sourceCls)) {
            fromFieldsMap.put(field.getName(), field);
        }
        if (fromFieldsMap.isEmpty()) {
            throw new BeanAnalysisException(sourceCls.getName() + " has no copyable field!");
        }
        List<Field> targetFields = BeanCopier.allNonStaticFields(targetCls);
        if (targetFields.isEmpty()) {
            throw new BeanAnalysisException(targetCls.getName() + " has no copyable field!");
        }
        ArrayList<Copier> copiers = new ArrayList<Copier>();
        for (Field toField : targetFields) {
            Field fromField = (Field)fromFieldsMap.get(toField.getName());
            if (fromField == null) continue;
            Type toFieldGType = toField.getGenericType();
            if (toFieldGType instanceof ParameterizedType) {
                Type[] toEtlTypes = ((ParameterizedType)toFieldGType).getActualTypeArguments();
                Type[] fromEtlTypes = ((ParameterizedType)fromField.getGenericType()).getActualTypeArguments();
                Class<?> fieldCls = toField.getType();
                if (Set.class.isAssignableFrom(fieldCls)) {
                    copiers.add(new CollectionCopier(fromField, toField, Utils.nameOf(fromEtlTypes[0]), Utils.nameOf(toEtlTypes[0]), true));
                    continue;
                }
                if (Collection.class.isAssignableFrom(fieldCls)) {
                    copiers.add(new CollectionCopier(fromField, toField, Utils.nameOf(fromEtlTypes[0]), Utils.nameOf(toEtlTypes[0]), false));
                    continue;
                }
                if (Map.class.isAssignableFrom(fieldCls)) {
                    try {
                        if (!toEtlTypes[0].equals(fromEtlTypes[0]) && !Class.forName(Utils.nameOf(toEtlTypes[0])).isAssignableFrom(Class.forName(Utils.nameOf(fromEtlTypes[0])))) {
                            throw new BeanAnalysisException("Key types mismatch: " + fromField + " <-> " + toField);
                        }
                    }
                    catch (ClassNotFoundException e) {
                        throw new BeanAnalysisException(e);
                    }
                    copiers.add(new MapCopier(fromField, toField, Utils.nameOf(fromEtlTypes[1]), Utils.nameOf(toEtlTypes[1])));
                    continue;
                }
                TypeConverter<?> converter = ConverterRegistry.find(fromField.getType().getName(), toField.getType().getName());
                if (converter != null) {
                    copiers.add(new SingleCopier(fromField, toField));
                    continue;
                }
                throw new BeanAnalysisException("Custom generic type requires converter, otherwise is not supported!");
            }
            if (Utils.isBuiltin(fromField.getType()) || Utils.isBuiltin(toField.getType())) {
                copiers.add(new SingleCopier(fromField, toField));
                continue;
            }
            copiers.add(BeanCopierRegistry.findOrCreate(fromField, toField));
        }
        if (copiers.isEmpty()) {
            throw new BeanAnalysisException(sourceCls.getName() + " & " + targetCls.getName() + " have no common fields to copy!");
        }
        return copiers;
    }

    private static List<Field> allNonStaticFields(Class<?> cls) {
        ArrayList<Field> all = new ArrayList<Field>();
        Class<?> cur = cls;
        do {
            for (Field each : cur.getDeclaredFields()) {
                if (Modifier.isStatic(each.getModifiers())) continue;
                all.add(each);
            }
        } while ((cur = cur.getSuperclass()) != null);
        return all;
    }

    public String toString() {
        this.ensureAnalyzed();
        return "BeanCopier{fromField=`" + this.fromField + "`, toField=`" + this.toField + "`, fromCls=`" + this.fromCls + "`, toCls=`" + this.toCls + "`, converter=" + this.converter + ", copiers=" + this.join(this.copiers) + "}";
    }

    private String join(Collection<Copier> items) {
        if (items == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder("[");
        for (Copier item : items) {
            sb.append("\n  ");
            String str = item instanceof BeanCopier ? item.getClass().getSimpleName() : item.toString();
            sb.append(str);
        }
        return sb.append("]").toString();
    }
}

