/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.bean.copier;

import com.sondertara.common.bean.copier.BeanCopier;
import com.sondertara.common.bean.copier.BeanCopierRegistry;
import com.sondertara.common.bean.exception.BeanAnalysisException;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;

public class BeanCopy {
    public static <R> R copy(Object source, Class<R> targetCls) {
        return (R)BeanCopierRegistry.prepare(source.getClass(), targetCls).topCopyWithoutTopConverter(source);
    }

    public static <R> R copyIgnoreNull(Object source, Class<R> targetCls) {
        BeanCopier beanCopier = BeanCopierRegistry.prepare(source.getClass(), targetCls);
        beanCopier.setIgnoreNull(true);
        return (R)beanCopier.topCopyWithoutTopConverter(source);
    }

    public static void copyTo(Object source, Object target) {
        BeanCopierRegistry.prepare(source.getClass(), target.getClass()).topCopyWithoutTopConverter(source, target);
    }

    public static void copyToIgnoreNull(Object source, Object target) {
        BeanCopier copier = BeanCopierRegistry.prepare(source.getClass(), target.getClass());
        copier.setIgnoreNull(true);
        copier.topCopyWithoutTopConverter(source, target);
    }

    public static void copy(Collection<?> sources, Collection<?> targets, Class<?> targetCls) {
        Collection<?> results = targets;
        Object sourceObj = sources.stream().filter(Objects::nonNull).findFirst().orElseThrow(() -> new BeanAnalysisException("The source collection is empty"));
        BeanCopier elemCopier = BeanCopierRegistry.prepare(sourceObj.getClass(), targetCls);
        for (Object source : sources) {
            results.add(elemCopier.topCopyWithoutTopConverter(source));
        }
    }

    public static <K> void copy(Map<K, ?> sources, Map<K, ?> targets, Class<?> sourceCls, Class<?> targetCls) {
        Map<K, ?> results = targets;
        BeanCopier elemCopier = BeanCopierRegistry.prepare(sourceCls, targetCls);
        for (Map.Entry<K, ?> source : sources.entrySet()) {
            results.put(source.getKey(), elemCopier.topCopyWithoutTopConverter(source.getValue()));
        }
    }
}

