/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.bean.copier;

import com.sondertara.common.bean.copier.AbstractCopier;
import com.sondertara.common.bean.copier.Utils;
import com.sondertara.common.bean.exception.BeanCopyException;
import java.lang.reflect.Field;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

class CollectionCopier
extends AbstractCopier {
    private final boolean isSet;

    CollectionCopier(Field fromField, Field toField, String fromEtlType, String toEtlType, boolean isSet) {
        super(fromField, toField);
        this.isSet = isSet;
        fromField.setAccessible(true);
        toField.setAccessible(true);
        this.converter = Utils.findOrCreateConverter(fromEtlType, toEtlType);
    }

    @Override
    public void copy(Object source, Object target) {
        try {
            Collection fromColl = (Collection)this.fromField.get(source);
            if (fromColl == null) {
                if (this.ignoreNull) {
                    return;
                }
                this.toField.set(target, null);
                return;
            }
            AbstractCollection toColl = (HashSet)this.toField.get(target);
            if (toColl == null) {
                toColl = this.isSet ? new HashSet() : new ArrayList();
                this.toField.set(target, toColl);
            }
            if (this.converter == null) {
                toColl.addAll(fromColl);
            } else {
                for (Object elem : fromColl) {
                    toColl.add(this.converter.convert(elem, null));
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new BeanCopyException(e);
        }
    }

    public String toString() {
        return "CollectionCopier{fromField=" + this.fromField + ", toField=" + this.toField + ", converter=" + this.converter + ", isSet=" + this.isSet + '}';
    }
}

