/*
 * Decompiled with CFR 0.152.
 */
package com.sondertara.common.bean.copier;

import com.sondertara.common.bean.copier.AbstractCopier;
import com.sondertara.common.bean.copier.Utils;
import com.sondertara.common.bean.exception.BeanCopyException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class MapCopier
extends AbstractCopier {
    MapCopier(Field fromField, Field toField, String fromEtlType, String toEtlType) {
        super(fromField, toField);
        fromField.setAccessible(true);
        toField.setAccessible(true);
        this.converter = Utils.findOrCreateConverter(fromEtlType, toEtlType);
    }

    @Override
    public void copy(Object source, Object target) {
        try {
            Map fromMap = (Map)this.fromField.get(source);
            if (fromMap == null) {
                if (this.ignoreNull) {
                    return;
                }
                this.toField.set(target, null);
                return;
            }
            HashMap toMap = (HashMap)this.toField.get(target);
            if (toMap == null) {
                toMap = new HashMap(8);
                this.toField.set(target, toMap);
            }
            if (this.converter == null) {
                toMap.putAll(fromMap);
            } else {
                Iterator iterator = fromMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entryObj;
                    Map.Entry entry = entryObj = iterator.next();
                    toMap.put(entry.getKey(), this.converter.convert(entry.getValue(), null));
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new BeanCopyException(e);
        }
    }
}

